/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.lang.UCharacter;
import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.CharUtil;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.font.opentype.OTSelectors;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.FontStyle;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.fontengine.inlineformatting.LigatureLevel;
import com.adobe.fontengine.inlineformatting.infontformatting.BaseFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.LookupsCache;

final class HanKanaFormatter
extends BaseFormatter {
    private static final int[] gsubFeatures = new int[]{Tag.feature_ccmp, Tag.feature_locl, Tag.feature_rtla, Tag.feature_rlig, Tag.feature_liga, Tag.feature_clig, Tag.feature_ital, Tag.feature_dlig, Tag.feature_hlig};
    private static final int[] gposFeatures = new int[]{Tag.feature_mark, Tag.feature_mkmk};
    private static final OTSelector italSelector = new OTSelector(){

        @Override
        public boolean isApplied(AttributedRun run, int position) {
            Object v = run.getElementStyle(position, ElementAttribute.fontStyle);
            return v == FontStyle.ITALIC || v == FontStyle.OBLIQUE;
        }
    };

    HanKanaFormatter() {
    }

    protected int setGlyphs(AttributedRun run, int start, int limit) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        Font font = (Font)run.getElementStyle(start, ElementAttribute.font);
        FontData fontData = ((FontImpl)font).getFontData();
        while (start < limit) {
            int usvc;
            int gid;
            int i;
            int graphemeLimit;
            if (run.getElementStyle(start, ElementAttribute.isGlyph) == Boolean.TRUE) {
                ++start;
                continue;
            }
            int usv = run.elementAt(start);
            if (usv == 8205) {
                run.remove(start);
                --limit;
                run.setInterElementStyleBefore(start, InterElementAttribute.ligatureLevel, LigatureLevel.COMMON);
                continue;
            }
            if (usv == 8204) {
                run.remove(start);
                --limit;
                run.setInterElementStyleBefore(start, InterElementAttribute.ligatureLevel, LigatureLevel.NONE);
                continue;
            }
            if (CharUtil.isControl(usv)) {
                run.remove(start);
                --limit;
                continue;
            }
            if ((Integer)run.getElementStyle(start, ElementAttribute.bidiLevel) % 2 == 1) {
                usv = UCharacter.getMirror(usv);
            }
            if (!CharUtil.isBase(usv) || start + 1 == limit || run.getElementStyle(start + 1, ElementAttribute.isGlyph) == Boolean.TRUE || !CharUtil.isCombining(run.elementAt(start + 1))) {
                int gid2 = fontData.getGlyphForChar(usv);
                run.replace(start, gid2);
                run.setElementStyle(start, ElementAttribute.isGlyph, Boolean.TRUE);
                ++start;
                continue;
            }
            for (graphemeLimit = start + 1; graphemeLimit < limit && run.getElementStyle(graphemeLimit, ElementAttribute.isGlyph) != Boolean.TRUE && CharUtil.isCombining(run.elementAt(graphemeLimit)); ++graphemeLimit) {
            }
            boolean directMappingHasNotdef = false;
            int[] usvs = new int[graphemeLimit - start];
            int[] gids = new int[graphemeLimit - start];
            for (i = start; i < graphemeLimit; ++i) {
                usvs[i - start] = run.elementAt(i);
                gid = fontData.getGlyphForChar(usvs[i - start]);
                if (gid == 0) {
                    directMappingHasNotdef = true;
                }
                gids[i - start] = gid;
            }
            if (directMappingHasNotdef && (usvc = CharUtil.compose(usvs, 0, graphemeLimit - start)) != -1 && (gid = fontData.getGlyphForChar(usvc)) != 0) {
                run.replace(start, graphemeLimit, gid);
                run.setElementStyle(start, ElementAttribute.isGlyph, Boolean.TRUE);
                limit -= graphemeLimit - start - 1;
                ++start;
                continue;
            }
            for (i = start; i < graphemeLimit; ++i) {
                run.replace(i, gids[i - start]);
                run.setElementStyle(start, ElementAttribute.isGlyph, Boolean.TRUE);
            }
            start = graphemeLimit;
        }
        return limit;
    }

    @Override
    protected boolean canFormatOT() {
        return true;
    }

    @Override
    protected int formatOT(OpenTypeFont otFont, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        Integer bidiLevel = (Integer)run.getElementStyle(start, ElementAttribute.bidiLevel);
        int scriptTag = HanKanaFormatter.getOTScriptTag((Integer)run.getElementStyle(start, InFontFormatter.scriptAttribute));
        int langTag = HanKanaFormatter.getOTLanguageTag((ULocale)run.getElementStyle(start, ElementAttribute.locale));
        limit = this.setGlyphs(run, start, limit);
        if (otFont.gsub != null) {
            int[][] gsubLookups = LookupsCache.resolveFeatureTag(otFont.gsub, scriptTag, langTag, gsubFeatures);
            limit = otFont.gsub.applyLookups(gsubLookups[0], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[1], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            if (bidiLevel % 2 == 1) {
                limit = otFont.gsub.applyLookups(gsubLookups[2], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            }
            limit = otFont.gsub.applyLookups(gsubLookups[6], run, start, limit, italSelector, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[3], run, start, limit, OTSelectors.minimumLigatures, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[4], run, start, limit, OTSelectors.commonLigatures, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[5], run, start, limit, OTSelectors.commonLigatures, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[7], run, start, limit, OTSelectors.uncommonLigatures, otFont.gdef);
            limit = otFont.gsub.applyLookups(gsubLookups[8], run, start, limit, OTSelectors.exoticLigatures, otFont.gdef);
        }
        this.posFromAdvanceWidth(run, otFont, start, limit);
        if (otFont.gpos != null) {
            int[][] gposLookups = LookupsCache.resolveFeatureTag(otFont.gpos, scriptTag, langTag, gposFeatures);
            limit = otFont.gpos.applyLookups(gposLookups[0], run, start, limit, OTSelectors.everywhere, otFont.gdef);
            limit = otFont.gpos.applyLookups(gposLookups[1], run, start, limit, OTSelectors.everywhere, otFont.gdef);
        } else if (shouldKern && otFont.kern != null) {
            this.applyKernTable(otFont, run, start, limit);
        }
        return limit;
    }

    @Override
    protected boolean canFormatTT() {
        return true;
    }

    @Override
    protected int formatTT(OpenTypeFont otFont, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        limit = this.setGlyphs(run, start, limit);
        this.posFromAdvanceWidth(run, otFont, start, limit);
        return limit;
    }

    @Override
    protected boolean canFormatT1() {
        return true;
    }

    @Override
    protected int formatT1(Type1Font t1Font, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        limit = this.setGlyphs(run, start, limit);
        this.posFromAdvanceWidth(run, t1Font, start, limit);
        return limit;
    }

    @Override
    protected boolean canFormatGeneric() {
        return true;
    }

    @Override
    protected int formatGeneric(FontData fontData, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        limit = this.setGlyphs(run, start, limit);
        this.posFromAdvanceWidth(run, fontData, start, limit);
        return limit;
    }
}

