/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTableSubsetter;
import com.adobe.fontengine.font.opentype.OTByteArray;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

abstract class SetGenerator
implements LayoutTable.CoverageConsumer,
LookupTableSubsetter.LookupSubtableGenerator {
    protected final Subset subset;
    protected final OTByteArray.OTByteArrayBuilder builder;
    protected final LayoutTable origTable;
    protected final int newSTOffset;
    protected final int origSTOffset;
    protected int subtableSize;
    protected int thisSet = 0;
    protected final int origSetCountDelta;
    protected final boolean preserveRuleSetIndexing;
    private int[] subsetGIDToOrigSetOffset;
    private Map origSetOffsetToNewSetOffset;
    private final boolean setElementsHaveOffsets;

    SetGenerator(LayoutTable origTable, Subset subset, OTByteArray.OTByteArrayBuilder newData, int newSTOffset, int origSTOffset, int setCount, int origSetCountDelta, boolean preserveRuleSetIndexing, boolean setElementsHaveOffsets) throws InvalidFontException {
        this.subset = subset;
        this.builder = newData;
        this.newSTOffset = newSTOffset;
        this.origSTOffset = origSTOffset;
        this.subtableSize = origSetCountDelta + 2 + 2 * setCount;
        this.origSetCountDelta = origSetCountDelta;
        this.preserveRuleSetIndexing = preserveRuleSetIndexing;
        this.origTable = origTable;
        this.setElementsHaveOffsets = setElementsHaveOffsets;
        this.origSetOffsetToNewSetOffset = new HashMap();
        if (preserveRuleSetIndexing) {
            setCount = origTable.data.getuint16(origSTOffset + origSetCountDelta);
        } else {
            this.subsetGIDToOrigSetOffset = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetGIDToOrigSetOffset, -1);
        }
        this.builder.ensureCapacity(newSTOffset + origSetCountDelta + 2 + 2 * setCount);
        for (int i = 0; i < setCount; ++i) {
            this.builder.setuint16(newSTOffset + origSetCountDelta + 2 + 2 * i, 0);
        }
    }

    @Override
    public boolean glyphInfo(int gid, int coverageIndex) throws InvalidFontException, UnsupportedFontException {
        int ruleSetIndex = this.whichRuleSetIndexApplies(gid, coverageIndex);
        int origSetOffset = this.origTable.data.getOffset(this.origSTOffset, this.origSetCountDelta + 2 + 2 * ruleSetIndex);
        if (this.preserveRuleSetIndexing) {
            this.writeSubtableEntry(ruleSetIndex, origSetOffset);
        } else {
            this.subsetGIDToOrigSetOffset[this.subset.getExistingSubsetGid((int)gid)] = origSetOffset;
        }
        return true;
    }

    @Override
    public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
        if (this.preserveRuleSetIndexing) {
            return this.subtableSize;
        }
        int j = 0;
        for (int i = 0; i < this.subsetGIDToOrigSetOffset.length; ++i) {
            if (this.subsetGIDToOrigSetOffset[i] == -1) continue;
            this.writeSubtableEntry(j, this.subsetGIDToOrigSetOffset[i]);
            ++j;
        }
        return this.subtableSize;
    }

    private void writeSubtableEntry(int ruleSetIndex, int origSetOffset) throws InvalidFontException, UnsupportedFontException {
        if (this.builder.getuint16(this.newSTOffset + this.origSetCountDelta + 2 + 2 * ruleSetIndex) != 0) {
            return;
        }
        if (origSetOffset != 0) {
            Integer newOffset = (Integer)this.origSetOffsetToNewSetOffset.get(new Integer(origSetOffset));
            if (newOffset == null) {
                this.origSetOffsetToNewSetOffset.put(new Integer(origSetOffset), new Integer(this.subtableSize));
                this.builder.setuint16(this.newSTOffset + this.origSetCountDelta + 2 + 2 * ruleSetIndex, this.subtableSize);
                this.subtableSize += this.writeSet(this.newSTOffset + this.subtableSize, origSetOffset);
            } else {
                this.builder.setuint16(this.newSTOffset + this.origSetCountDelta + 2 + 2 * ruleSetIndex, newOffset);
            }
        }
    }

    private int writeSet(int newSetOffset, int origSetOffset) throws InvalidFontException, UnsupportedFontException {
        boolean[] keepMember = this.computeMembersToKeep(newSetOffset, origSetOffset);
        int newMemberCount = 0;
        for (int i = 0; i < keepMember.length; ++i) {
            if (!keepMember[i]) continue;
            ++newMemberCount;
        }
        int setSize = this.setElementsHaveOffsets ? 2 + 2 * newMemberCount : 2;
        this.builder.ensureCapacity(newSetOffset + setSize);
        this.builder.setuint16(newSetOffset, newMemberCount);
        int j = 0;
        for (int i = 0; i < keepMember.length; ++i) {
            int origOffset;
            if (!keepMember[i]) continue;
            if (this.setElementsHaveOffsets) {
                this.builder.setuint16(newSetOffset + 2 + 2 * j, setSize);
                origOffset = this.origTable.data.getOffset(origSetOffset, 2 + 2 * i);
            } else {
                origOffset = origSetOffset + 2 + this.getOrigRecordSize() * i;
            }
            setSize += this.writeMember(newSetOffset + setSize, origOffset);
            ++j;
        }
        return setSize;
    }

    protected int writeByteArrayAtOffset(int newOffset, OTByteArray byteArrayToWrite) throws InvalidFontException {
        this.builder.replace(newOffset, byteArrayToWrite, 0, byteArrayToWrite.getSize());
        return byteArrayToWrite.getSize();
    }

    abstract int whichRuleSetIndexApplies(int var1, int var2) throws InvalidFontException;

    abstract boolean[] computeMembersToKeep(int var1, int var2) throws InvalidFontException, UnsupportedFontException;

    abstract int writeMember(int var1, int var2) throws InvalidFontException, UnsupportedFontException;

    abstract int getOrigRecordSize();
}

