/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.CodePage;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OrigFontType;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.SubsetSimpleType1;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CFFFont;
import com.adobe.fontengine.font.cff.CFFSubrize;
import com.adobe.fontengine.font.cff.CIDComponentFont;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Charset;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.Encoding;
import com.adobe.fontengine.font.cff.FdSelect;
import com.adobe.fontengine.font.cff.Header;
import com.adobe.fontengine.font.cff.Index;
import com.adobe.fontengine.font.cff.NameIndex;
import com.adobe.fontengine.font.cff.NameKeyedSubset;
import com.adobe.fontengine.font.cff.StringIndex;
import com.adobe.fontengine.font.cff.Type2ConsumerDefaultImpl;
import com.adobe.fontengine.font.cff.Type2OutlineParser;
import com.adobe.fontengine.font.cff.Type2Parser;
import com.adobe.fontengine.font.postscript.GlyphNamesAccessor;
import com.adobe.fontengine.font.postscript.NameHeuristics;
import com.adobe.fontengine.font.postscript.PostscriptTokenParser;
import com.adobe.fontengine.font.postscript.UnicodeCmap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public final class NameKeyedFont
extends CFFFont {
    protected final Dict privateDict;
    protected final Charset charset;
    protected final Encoding encoding;
    protected final CharStrings charStrings;
    protected final CharStrings localSubrs;
    private final XDCFontDescription xdcDescription;
    UnicodeCmap cmap = null;
    Object cmapMutex = new Object();
    static final Dict.Key[] topDictKeysForSubset = new Dict.Key[]{Dict.Key.Notice, Dict.Key.FullName, Dict.Key.FamilyName, Dict.Key.FontName, Dict.Key.BaseFontName, Dict.Key.BaseFontBlend, Dict.Key.Weight, Dict.Key.FontBBox, Dict.Key.Copyright, Dict.Key.isFixedPitch, Dict.Key.ItalicAngle, Dict.Key.UnderlinePosition, Dict.Key.UnderlineThickness, Dict.Key.PaintType, Dict.Key.CharstringType, Dict.Key.StrokeWidth, Dict.Key.UniqueID, Dict.Key.XUID, Dict.Key.UIDBase, Dict.Key.FontMatrix};
    static final Dict.Key[] privateDictKeysForSubset = new Dict.Key[]{Dict.Key.BlueValues, Dict.Key.OtherBlues, Dict.Key.FamilyBlues, Dict.Key.FamilyOtherBlues, Dict.Key.StdHW, Dict.Key.StdVW, Dict.Key.defaultWidthX, Dict.Key.nominalWidthX, Dict.Key.BlueScale, Dict.Key.BlueShift, Dict.Key.BlueFuzz, Dict.Key.StemSnapH, Dict.Key.StemSnapV, Dict.Key.ForceBold, Dict.Key.ForceBoldThreshold, Dict.Key.LanguageGroup, Dict.Key.ExpansionFactor, Dict.Key.initialRandomSeed};
    private static final int MAX_CFF_SIZE_FOR_SUBRIZE = 614400;

    public NameKeyedFont(StringIndex stringIndex, CharStrings globalSubrs, String name, Dict topDict, CFFByteArray data, byte[] digest) throws IOException, InvalidFontException, UnsupportedFontException {
        super(stringIndex, globalSubrs, topDict, name, digest);
        Dict.OffsetValue o2;
        this.xdcDescription = new NameKeyedFontXDCFontDescription();
        Dict.OffsetValue o = topDict.get(Dict.Key.CharStrings, false);
        if (o == null) {
            throw new InvalidFontException("missing TopDICT/CharStrings");
        }
        this.charStrings = new CharStrings(data, o.offset);
        int numGlyphs = this.charStrings.getCount();
        Dict.OffsetValue o3 = topDict.get(Dict.Key.charset, true);
        this.charset = new Charset(data, o3.offset, numGlyphs);
        o = topDict.get(Dict.Key.Encoding, true);
        this.encoding = new Encoding(data, o.offset);
        Dict privateDict = null;
        CharStrings localSubrs = null;
        Dict.OffsetSizeValue o4 = topDict.get(Dict.Key.Private, false);
        if (o4 != null && (o2 = (privateDict = new Dict(data, o4.offset, o4.size, stringIndex)).get(Dict.Key.Subrs, false)) != null) {
            localSubrs = new CharStrings(data, o4.offset + o2.offset);
        }
        this.privateDict = privateDict;
        this.localSubrs = localSubrs;
    }

    public NameKeyedFont(String fontName, Dict topDict, CharStrings charStrings, Dict privateDict) throws InvalidFontException, UnsupportedFontException {
        super(null, CharStrings.createEmptyCharstrings(), topDict, fontName, null);
        this.xdcDescription = new NameKeyedFontXDCFontDescription();
        this.charStrings = charStrings;
        this.privateDict = privateDict;
        this.localSubrs = null;
        this.encoding = null;
        this.charset = null;
    }

    public NameKeyedFont(String fontName, Dict topDict, CharStrings charStrings, Dict privateDict, CharStrings lSubrs, CharStrings gSubrs) throws InvalidFontException, UnsupportedFontException {
        super(null, gSubrs != null ? gSubrs : CharStrings.createEmptyCharstrings(), topDict, fontName, null);
        this.xdcDescription = new NameKeyedFontXDCFontDescription();
        this.charStrings = charStrings;
        this.privateDict = privateDict;
        this.localSubrs = lSubrs;
        this.encoding = null;
        this.charset = null;
    }

    @Override
    public int getNumGlyphs() {
        return this.charStrings.getCount();
    }

    public int glyphName2gid(String glyphName) throws InvalidFontException, UnsupportedFontException {
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            if (!glyphName.equals(this.stringIndex.getString(this.charset.gid2sid(i)))) continue;
            return i;
        }
        return 0;
    }

    public int charCode2gid(int charCode) throws InvalidFontException, UnsupportedFontException {
        return this.encoding.charCode2gid(charCode, this.charset);
    }

    @Override
    public String getGlyphName(int gid) throws InvalidFontException, UnsupportedFontException {
        return this.stringIndex.getString(this.charset.gid2sid(gid));
    }

    @Override
    public ROS getROS() {
        return null;
    }

    @Override
    public int getGlyphCid(int glyphID) {
        return -1;
    }

    @Override
    public void getGlyphOutline(int gid, OutlineConsumer consumer) throws InvalidFontException, UnsupportedFontException {
        this.getOutline(gid, new Type2OutlineParser(false), consumer);
    }

    @Override
    public void getOutline(int gid, Type2OutlineParser parser, OutlineConsumer consumer) throws InvalidFontException, UnsupportedFontException {
        parser.parse(this.charStrings, gid, this.localSubrs, this.globalSubrs, consumer, this.getFontMatrix(), this);
    }

    @Override
    public double getStemVForGlyph(int gid) {
        Dict.NumbersValue value = this.privateDict.get(Dict.NumbersKey.StdVW, false);
        if (value != null) {
            return value.getFirstValueAsDouble();
        }
        value = this.privateDict.get(Dict.NumbersKey.StemSnapV, false);
        if (value != null) {
            return value.getFirstValueAsDouble();
        }
        return 0.0;
    }

    @Override
    public double getHorizontalAdvance(int gid) throws InvalidFontException, UnsupportedFontException {
        Type2Parser parser = new Type2Parser();
        WidthConsumer consumer = new WidthConsumer();
        parser.parse(this.charStrings, gid, this.localSubrs, this.globalSubrs, consumer, this);
        if (consumer.widthSeen) {
            Dict.NumbersValue v = this.privateDict.get(Dict.Key.nominalWidthX, true);
            return v.getFirstValueAsDouble() + consumer.width;
        }
        Dict.NumbersValue v = this.privateDict.get(Dict.Key.defaultWidthX, true);
        return v.getFirstValueAsDouble();
    }

    @Override
    public Matrix getFontMatrix() {
        return new Matrix(this.topDict.get(Dict.Key.FontMatrix, true).getValuesAsDouble());
    }

    private Matrix getFontToMetricsMatrix() throws InvalidFontException, UnsupportedFontException {
        Matrix m = this.getFontMatrix();
        double x = this.getUnitsPerEmX();
        double y = this.getUnitsPerEmY();
        return new Matrix(x * m.a, y * m.b, x * m.c, y * m.d, x * m.tx, y * m.ty);
    }

    @Override
    double getItalicAngle() {
        Dict.NumbersValue k = this.topDict.get(Dict.NumbersKey.ItalicAngle, false);
        if (k != null) {
            return k.getFirstValueAsDouble();
        }
        return 0.0;
    }

    @Override
    Rect getRawFontBBox() {
        Dict.NumbersValue v = this.topDict.get(Dict.NumbersKey.FontBBox, false);
        if (v != null && v.values.length == 4) {
            return new Rect(v.getValuesAsDouble());
        }
        return null;
    }

    @Override
    public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
        Rect rawBBox = this.getRawFontBBox();
        if (rawBBox == null) {
            return null;
        }
        return rawBBox.applyMatrix(this.getFontToMetricsMatrix());
    }

    @Override
    public Rect getCoolTypeRawFontBBox() throws InvalidFontException, UnsupportedFontException {
        return this.getFontBBox();
    }

    @Override
    public LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException {
        return this.getCoolTypeLineMetricsFromFontBbox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFirstChar() throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getFirstSupportedChar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLastChar() throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getLastSupportedChar();
        }
    }

    boolean isDingbat() {
        Dict.StringValue v = this.topDict.get(Dict.StringKey.FullName, true);
        return NameHeuristics.fullNameIndicatesDingbats(v != null ? v.value : null);
    }

    private void initCmap() throws InvalidFontException, UnsupportedFontException {
        if (this.cmap == null) {
            this.cmap = UnicodeCmap.computeCmapFromGlyphNames(this.getNumGlyphs(), this.isDingbat(), new GlyphNamesAccessor(){

                @Override
                public String getAGlyphName(int gid) throws UnsupportedFontException, InvalidFontException {
                    return NameKeyedFont.this.getGlyphName(gid);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getGlyphForChar(int usv) throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getGlyphForChar(usv);
        }
    }

    @Override
    int[] getXUID() {
        Dict.NumbersValue v = this.topDict.get(Dict.Key.XUID, true);
        return v == null ? null : v.getValuesAsInt();
    }

    @Override
    String getNotice() {
        Dict.StringValue value = this.topDict.get(Dict.Key.Notice, true);
        return value == null ? null : value.value;
    }

    @Override
    String getCopyright() {
        Dict.StringValue value = this.topDict.get(Dict.Key.Copyright, true);
        return value == null ? null : value.value;
    }

    @Override
    String getFullName() {
        Dict.StringValue value = this.topDict.get(Dict.Key.FullName, true);
        return value == null ? null : value.value;
    }

    @Override
    Integer getFSType() {
        return this.topDict.getFSType();
    }

    @Override
    OrigFontType getOrigFontType() {
        return this.topDict.getOrigFontType();
    }

    @Override
    double getDefaultWidthForFD(int fd) {
        return this.privateDict.get(Dict.Key.defaultWidthX, true).getFirstValueAsDouble();
    }

    @Override
    double getNominalWidthForFD(int fd) {
        return this.privateDict.get(Dict.Key.nominalWidthX, true).getFirstValueAsDouble();
    }

    @Override
    int getFDForGlyph(int fullGid) throws InvalidFontException {
        return 0;
    }

    @Override
    CharStrings getLocalSubrsForFD(int fd) {
        return this.localSubrs;
    }

    @Override
    int getNumFDs() {
        return 1;
    }

    @Override
    CharStrings getCharStrings() {
        return this.charStrings;
    }

    @Override
    public Permission getEmbeddingPermission(boolean wasEmbedded) {
        return this.getEmbeddingPermissionGivenFT(wasEmbedded, OrigFontType.kTYPE1);
    }

    CIDKeyedFont toCID(Subset subset) throws InvalidFontException, UnsupportedFontException {
        Dict.NumbersValue nv;
        LinkedHashMap<Dict.Key, Dict.Value> m = new LinkedHashMap<Dict.Key, Dict.Value>(20, 1.0f);
        m.put(Dict.Key.ROS, new Dict.ROSValue("Adobe", "Identity", 0));
        m.put(Dict.Key.CIDCount, new Dict.IntegerValue(subset.getNumGlyphs()));
        Dict.StringValue sv = this.topDict.get(Dict.Key.Notice, false);
        if (sv != null) {
            m.put(Dict.Key.Notice, sv);
        }
        if ((sv = this.topDict.get(Dict.Key.FullName, false)) != null) {
            m.put(Dict.Key.FullName, sv);
        }
        m.put(Dict.Key.FontName, new Dict.StringValue(this.getName()));
        sv = this.topDict.get(Dict.Key.FamilyName, false);
        if (sv != null) {
            m.put(Dict.Key.FamilyName, sv);
        }
        if ((sv = this.topDict.get(Dict.Key.Weight, false)) != null) {
            m.put(Dict.Key.Weight, sv);
        }
        if ((nv = this.topDict.get(Dict.Key.FontBBox, false)) != null) {
            m.put(Dict.Key.FontBBox, nv);
        }
        if ((sv = this.topDict.get(Dict.Key.Copyright, false)) != null) {
            m.put(Dict.Key.Copyright, sv);
        }
        if ((nv = this.topDict.get(Dict.Key.isFixedPitch, false)) != null) {
            m.put(Dict.Key.isFixedPitch, nv);
        }
        if ((nv = this.topDict.get(Dict.Key.ItalicAngle, false)) != null) {
            m.put(Dict.Key.ItalicAngle, nv);
        }
        if ((nv = this.topDict.get(Dict.Key.UnderlinePosition, false)) != null) {
            m.put(Dict.Key.UnderlinePosition, nv);
        }
        if ((nv = this.topDict.get(Dict.Key.UnderlineThickness, false)) != null) {
            m.put(Dict.Key.UnderlineThickness, nv);
        }
        if ((nv = this.topDict.get(Dict.Key.PaintType, false)) != null) {
            m.put(Dict.Key.PaintType, nv);
        }
        if ((nv = this.topDict.get(Dict.Key.CharstringType, false)) != null) {
            m.put(Dict.Key.CharstringType, nv);
        }
        if ((nv = this.topDict.get(Dict.Key.StrokeWidth, false)) != null) {
            m.put(Dict.Key.StrokeWidth, nv);
        }
        if ((sv = this.topDict.get(Dict.Key.PostScript, false)) != null) {
            OrigFontType oft = PostscriptTokenParser.getOrigFontType(sv.value);
            if (oft != null) {
                m.put(Dict.Key.PostScript, sv);
            } else {
                m.put(Dict.Key.PostScript, new Dict.StringValue("/OrigFontType /Type1 def " + sv.value));
            }
        } else {
            m.put(Dict.Key.PostScript, new Dict.StringValue("/OrigFontType /Type1 def"));
        }
        nv = this.topDict.get(Dict.Key.CIDFontType, false);
        if (nv != null) {
            m.put(Dict.Key.CIDFontType, nv);
        }
        if ((nv = this.topDict.get(Dict.Key.UIDBase, false)) != null) {
            m.put(Dict.Key.UIDBase, nv);
        }
        Dict CIDtopDict = new Dict(m);
        m = new LinkedHashMap();
        nv = this.topDict.get(Dict.Key.FontMatrix, false);
        if (nv != null) {
            m.put(Dict.Key.FontMatrix, nv);
        }
        Dict CIDfontDict = new Dict(m);
        CIDComponentFont[] components = new CIDComponentFont[]{new CIDComponentFont(CIDfontDict, this.privateDict, null)};
        return new CIDKeyedFont(null, null, this.name, CIDtopDict, this.createSubsetCharstringIndex(subset, false), Charset.identityCharset(subset.getNumGlyphs()), components, FdSelect.singleFont(subset.getNumGlyphs()));
    }

    @Override
    public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS, Integer fsType) throws InvalidFontException, UnsupportedFontException, IOException {
        this.toCID(subset).subsetAndStream(new SubsetDefaultImpl(subset.getNumGlyphs(), false), out, false, fsType);
    }

    public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS, Integer fsType, boolean enableSubrizer) throws InvalidFontException, UnsupportedFontException, IOException {
        this.toCID(subset).subsetAndStream(new SubsetDefaultImpl(subset.getNumGlyphs(), false), out, false, fsType, enableSubrizer);
    }

    private void setPSString(CFFByteArray.CFFByteArrayBuilder bb, Integer fsType, List strings) {
        OrigFontType oft;
        String psString = null;
        if (fsType == null) {
            fsType = this.topDict.getFSType();
        }
        if (fsType != null) {
            psString = "/FSType " + fsType.toString() + " def ";
        }
        if ((oft = this.topDict.getOrigFontType()) != null) {
            psString = psString != null ? psString + " /OrigFontType /" + oft.toString() + " def" : "/OrigFontType /" + oft.toString() + " def";
        }
        if (psString != null) {
            if (strings.indexOf(psString) == -1) {
                strings.add(psString);
            }
            Dict.streamKeyVal(bb, Dict.Key.PostScript, psString, strings);
        }
    }

    @Override
    public void stream(OutputStream out, Integer fsType) throws InvalidFontException, UnsupportedFontException, IOException {
        SubsetDefaultImpl subset = new SubsetDefaultImpl(this.getNumGlyphs(), false);
        this.subsetAndStream((Subset)subset, out, fsType, false, null);
    }

    public void stream(OutputStream out, Integer fsType, GlyphNameFetcher fetcher) throws InvalidFontException, UnsupportedFontException, IOException {
        SubsetDefaultImpl subset = new SubsetDefaultImpl(this.getNumGlyphs(), false);
        this.subsetAndStream((Subset)subset, out, fsType, false, fetcher);
    }

    private int[] buildCharsetData(Subset subset, GlyphNameFetcher fetcher, List strings) throws InvalidFontException, UnsupportedFontException {
        int[] glyphSids = null;
        glyphSids = new int[subset.getNumGlyphs()];
        for (int i = 0; i < glyphSids.length; ++i) {
            String glyphName;
            if (fetcher == null) {
                int fullGid = subset.getFullGid(i);
                glyphName = this.getGlyphName(fullGid);
            } else {
                glyphName = fetcher.getGlyphName(subset, i);
            }
            int sid = strings.indexOf(glyphName);
            if (sid < 0) {
                strings.add(glyphName);
                sid = strings.size() - 1;
            }
            glyphSids[i] = sid;
        }
        return glyphSids;
    }

    private boolean checkSubrizeLimit(Subset subset) throws InvalidFontException, UnsupportedFontException {
        int cffSize = this.charStrings.data.getSize();
        if (cffSize <= 614400) {
            return true;
        }
        if (subset == null) {
            return false;
        }
        return (double)cffSize * (double)subset.getNumGlyphs() <= 614400.0 * (double)this.getNumGlyphs();
    }

    public void subsetAndStream(Subset subset, OutputStream out, Integer fsType, boolean rebuildCharstrings, GlyphNameFetcher fetcher) throws InvalidFontException, UnsupportedFontException, IOException {
        this.subsetAndStream(subset, out, fsType, rebuildCharstrings, fetcher, false);
    }

    public void subsetAndStream(Subset subset, OutputStream out, Integer fsType, boolean rebuildCharstrings, GlyphNameFetcher fetcher, boolean enableSubrizer) throws InvalidFontException, UnsupportedFontException, IOException {
        List strings = StringIndex.collectPredefinedStrings();
        int[] glyphSids = null;
        glyphSids = this.buildCharsetData(subset, fetcher, strings);
        this.topDict.collectStrings(strings);
        Dict.StringValue val = this.topDict.get(Dict.StringKey.PostScript, false);
        if (val != null) {
            strings.remove(strings.indexOf(val.value));
        }
        CFFByteArray.CFFByteArrayBuilder bb = CFFByteArray.getCFFByteArrayBuilderInstance();
        Header.toBinary(bb);
        NameIndex.toBinary(bb, this.name);
        Index.Cursor cursor = Index.startIndex(bb, 1);
        this.topDict.stream(bb, strings, topDictKeysForSubset);
        this.setPSString(bb, fsType, strings);
        int charsetMarker = Dict.Key.charset.streamDummyValue(bb);
        int charStringsMarker = Dict.Key.CharStrings.streamDummyValue(bb);
        int privateMarker = Dict.Key.Private.streamDummyValue(bb);
        cursor = Index.elementEntered(bb, cursor);
        StringIndex.toBinary(bb, strings);
        CharStrings subsetCharstrings = null;
        CharStrings lSubrStrings = null;
        CharStrings gSubrStrings = null;
        if (rebuildCharstrings) {
            if (enableSubrizer) {
                enableSubrizer = this.checkSubrizeLimit(subset);
            }
            subsetCharstrings = this.createSubsetCharstringIndex(subset, enableSubrizer);
            if (enableSubrizer) {
                CFFSubrize subrizer = new CFFSubrize();
                subsetCharstrings = subrizer.subrize(subsetCharstrings);
                lSubrStrings = subrizer.getLSubrs();
                gSubrStrings = subrizer.getGSubrs();
                if (gSubrStrings == null) {
                    gSubrStrings = CharStrings.createEmptyCharstrings();
                }
                gSubrStrings.stream(bb);
            } else {
                bb.addCard16(0);
            }
        } else {
            subsetCharstrings = this.charStrings;
            this.globalSubrs.stream(bb);
        }
        Dict.Key.charset.fixOffset(bb, charsetMarker, bb.getSize());
        Charset.streamCharSet(bb, glyphSids);
        Dict.Key.CharStrings.fixOffset(bb, charStringsMarker, bb.getSize());
        subsetCharstrings.stream(bb);
        int start = bb.getSize();
        Dict.Key.Private.fixOffset(bb, privateMarker, start);
        this.privateDict.stream(bb, strings, privateDictKeysForSubset);
        int localSubrsMarker = 0;
        if (rebuildCharstrings && lSubrStrings != null || !rebuildCharstrings && this.localSubrs != null) {
            localSubrsMarker = Dict.Key.Subrs.streamDummyValue(bb);
        }
        Dict.Key.Private.fixSize(bb, privateMarker, bb.getSize() - start);
        if (rebuildCharstrings && lSubrStrings != null || !rebuildCharstrings && this.localSubrs != null) {
            Dict.Key.Subrs.fixOffset(bb, localSubrsMarker, bb.getSize() - start);
            if (rebuildCharstrings) {
                lSubrStrings.stream(bb);
            } else {
                this.localSubrs.stream(bb);
            }
        }
        CFFByteArray byteArray = bb.toCFFByteArray();
        byteArray.write(out);
    }

    @Override
    public PDFFontDescription getPDFFontDescription(Font font) throws UnsupportedFontException, InvalidFontException {
        return this.xdcDescription;
    }

    @Override
    public XDCFontDescription getXDCFontDescription(Font font) throws UnsupportedFontException, InvalidFontException {
        return this.xdcDescription;
    }

    @Override
    public Subset createSubset() throws InvalidFontException, UnsupportedFontException {
        NameKeyedSubset s = new NameKeyedSubset(this.getNumGlyphs(), true);
        s.getSubsetGid(0);
        return s;
    }

    private class NameKeyedFontXDCFontDescription
    extends CFFFont.CFFFontXDCFontDescription {
        private NameKeyedFontXDCFontDescription() {
        }

        @Override
        public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS) throws InvalidFontException, UnsupportedFontException, IOException {
            NameKeyedFont.this.subsetAndStream(subset, out, preserveROS);
        }

        @Override
        public void subsetAndStream(SubsetSimpleType1 t1Subset, OutputStream out) throws InvalidFontException, UnsupportedFontException, IOException {
            NameKeyedSubset subset = (NameKeyedSubset)NameKeyedFont.this.createSubset();
            subset.addGlyphs(NameKeyedFont.this, t1Subset.getGlyphNames());
            NameKeyedFont.this.subsetAndStream((Subset)subset, out, NameKeyedFont.this.getFSType(), true, null);
        }

        @Override
        public void subsetAndStream(SubsetSimpleTrueType ttSubset, OutputStream out) throws UnsupportedFontException {
            throw new UnsupportedFontException("Not a TrueType font");
        }

        @Override
        public void stream(OutputStream out, boolean openTypeOK) throws InvalidFontException, UnsupportedFontException, IOException {
            NameKeyedFont.this.stream(out, null);
        }

        @Override
        public CodePage[] getXDCCodePages() throws InvalidFontException, UnsupportedFontException {
            HashSet<CodePage> codePageSet = new HashSet<CodePage>();
            if (NameKeyedFont.this.glyphName2gid("ecircumflex") > 0) {
                codePageSet.add(CodePage.ROMAN1);
            }
            if (NameKeyedFont.this.glyphName2gid("Ccaron") > 0 || NameKeyedFont.this.glyphName2gid("ncaron") > 0) {
                codePageSet.add(CodePage.ROMAN2);
            }
            if (NameKeyedFont.this.glyphName2gid("akatakana") > 0) {
                codePageSet.add(CodePage.JAPANESE);
            }
            CodePage[] retVal = new CodePage[codePageSet.size()];
            Iterator iter = codePageSet.iterator();
            int index = 0;
            while (iter.hasNext()) {
                retVal[index++] = (CodePage)iter.next();
            }
            return retVal;
        }

        @Override
        public int getCIDCount() {
            return -1;
        }
    }

    public static abstract class GlyphNameFetcher {
        public abstract String getGlyphName(Subset var1, int var2);
    }

    static class WidthConsumer
    extends Type2ConsumerDefaultImpl {
        public double width;
        public boolean widthSeen = false;

        WidthConsumer() {
        }

        @Override
        public boolean width(double w) {
            this.widthSeen = true;
            this.width = w;
            return false;
        }
    }
}

