/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

public final class LineMetrics {
    public final double ascender;
    public final double descender;
    public final double linegap;

    public LineMetrics(double ascender, double descender, double linegap) {
        this.ascender = ascender;
        this.descender = descender;
        this.linegap = linegap;
    }

    public LineMetrics toEmSpace(double unitsPerEmX, double unitsPerEmY) {
        return new LineMetrics(this.ascender / unitsPerEmY, this.descender / unitsPerEmY, this.linegap / unitsPerEmY);
    }

    public LineMetrics toDesignSpace(double unitsPerEmX, double unitsPerEmY) {
        return new LineMetrics(this.ascender * unitsPerEmY, this.descender * unitsPerEmY, this.linegap * unitsPerEmY);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineMetrics)) {
            return false;
        }
        LineMetrics vm = (LineMetrics)o;
        return vm.ascender == this.ascender && vm.descender == this.descender && vm.linegap == this.linegap;
    }

    public int hashCode() {
        return (int)this.ascender ^ (int)this.descender ^ (int)this.linegap;
    }

    public String toString() {
        return "[a=" + this.ascender + " d=" + this.descender + " lg=" + this.linegap + "]";
    }
}

