/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.text;

import com.adobe.agl.text.Replaceable;
import com.adobe.agl.text.Transliterator;
import com.adobe.agl.text.UnicodeReplacer;
import com.adobe.agl.text.UnicodeSet;

class FunctionReplacer
implements UnicodeReplacer {
    private Transliterator translit;
    private UnicodeReplacer replacer;

    public FunctionReplacer(Transliterator theTranslit, UnicodeReplacer theReplacer) {
        this.translit = theTranslit;
        this.replacer = theReplacer;
    }

    public int replace(Replaceable text, int start, int limit, int[] cursor) {
        int len = this.replacer.replace(text, start, limit, cursor);
        limit = start + len;
        limit = this.translit.transliterate(text, start, limit);
        return limit - start;
    }

    public String toReplacerPattern(boolean escapeUnprintable) {
        StringBuffer rule = new StringBuffer("&");
        rule.append(this.translit.getID());
        rule.append("( ");
        rule.append(this.replacer.toReplacerPattern(escapeUnprintable));
        rule.append(" )");
        return rule.toString();
    }

    public void addReplacementSetTo(UnicodeSet toUnionTo) {
        toUnionTo.addAll(this.translit.getTargetSet());
    }
}

