/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sns.model.SnsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetSubscriptionAttributesRequest
extends SnsRequest
implements ToCopyableBuilder<Builder, SetSubscriptionAttributesRequest> {
    private static final SdkField<String> SUBSCRIPTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetSubscriptionAttributesRequest.getter(SetSubscriptionAttributesRequest::subscriptionArn)).setter(SetSubscriptionAttributesRequest.setter(Builder::subscriptionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionArn").build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetSubscriptionAttributesRequest.getter(SetSubscriptionAttributesRequest::attributeName)).setter(SetSubscriptionAttributesRequest.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetSubscriptionAttributesRequest.getter(SetSubscriptionAttributesRequest::attributeValue)).setter(SetSubscriptionAttributesRequest.setter(Builder::attributeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ARN_FIELD, ATTRIBUTE_NAME_FIELD, ATTRIBUTE_VALUE_FIELD));
    private final String subscriptionArn;
    private final String attributeName;
    private final String attributeValue;

    private SetSubscriptionAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionArn = builder.subscriptionArn;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
    }

    public String subscriptionArn() {
        return this.subscriptionArn;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public String attributeValue() {
        return this.attributeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSubscriptionAttributesRequest)) {
            return false;
        }
        SetSubscriptionAttributesRequest other = (SetSubscriptionAttributesRequest)((Object)obj);
        return Objects.equals(this.subscriptionArn(), other.subscriptionArn()) && Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.attributeValue(), other.attributeValue());
    }

    public String toString() {
        return ToString.builder((String)"SetSubscriptionAttributesRequest").add("SubscriptionArn", (Object)this.subscriptionArn()).add("AttributeName", (Object)this.attributeName()).add("AttributeValue", (Object)this.attributeValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionArn": {
                return Optional.ofNullable(clazz.cast(this.subscriptionArn()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "AttributeValue": {
                return Optional.ofNullable(clazz.cast(this.attributeValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetSubscriptionAttributesRequest, T> g) {
        return obj -> g.apply((SetSubscriptionAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsRequest.BuilderImpl
    implements Builder {
        private String subscriptionArn;
        private String attributeName;
        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSubscriptionAttributesRequest model) {
            super(model);
            this.subscriptionArn(model.subscriptionArn);
            this.attributeName(model.attributeName);
            this.attributeValue(model.attributeValue);
        }

        public final String getSubscriptionArn() {
            return this.subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeValue() {
            return this.attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetSubscriptionAttributesRequest build() {
            return new SetSubscriptionAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetSubscriptionAttributesRequest> {
        public Builder subscriptionArn(String var1);

        public Builder attributeName(String var1);

        public Builder attributeValue(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

