/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.document;

import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.document.AuthenticationFailedException;
import coldfusion.document.CFDocument;
import coldfusion.document.DefaultPageNoCallbackHandler;
import coldfusion.document.DocumentExporter;
import coldfusion.document.DocumentFileExistsException;
import coldfusion.document.DocumentFontMapper;
import coldfusion.document.DocumentInvalidEncryptionPermission;
import coldfusion.document.DocumentInvalidEncryptionStrength;
import coldfusion.document.DocumentInvalidFontembedOption;
import coldfusion.document.DocumentInvalidHeaderFooterSizeException;
import coldfusion.document.DocumentInvalidMarginSizeException;
import coldfusion.document.DocumentInvalidMimeTypeException;
import coldfusion.document.DocumentInvalidOrientationException;
import coldfusion.document.DocumentInvalidPageSizeException;
import coldfusion.document.DocumentInvalidParentTagException;
import coldfusion.document.DocumentInvalidSrcException;
import coldfusion.document.DocumentInvalidUnitException;
import coldfusion.document.DocumentInvalidWaterMarkFileException;
import coldfusion.document.DocumentMargin;
import coldfusion.document.DocumentMissingEncryptionAttribute;
import coldfusion.document.DocumentMissingPageSizeException;
import coldfusion.document.DocumentNotAllowedEncryptionPermission;
import coldfusion.document.DocumentPageLayout;
import coldfusion.document.DocumentProcessTimeOutException;
import coldfusion.document.DocumentProcessor;
import coldfusion.document.DocumentRenderException;
import coldfusion.document.DocumentScope;
import coldfusion.document.DocumentSection;
import coldfusion.document.DocumentUnknownFormatException;
import coldfusion.document.OpenOfficeUNOHelper;
import coldfusion.document.pdf.InvalidEncryptionPermission;
import coldfusion.document.pdf.PdfDocumentProperties;
import coldfusion.document.pdf.core.PdfPermissions;
import coldfusion.document.spi.DocumentProperties;
import coldfusion.document.spi.DocumentSectionProperties;
import coldfusion.document.spi.Exporter;
import coldfusion.document.spi.HeaderFooterContentProvider;
import coldfusion.document.spi.PageNoCallbackHandler;
import coldfusion.document.spi.core.URLConnectionSettings;
import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.jsp.JspWriterIncludeResponse;
import coldfusion.pdf.core.PDFFormException;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFOutput;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.NotSupportedFormatException;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.server.DocumentService;
import coldfusion.server.LicenseService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.document.DocumentItemTag;
import coldfusion.tagext.document.DocumentSectionTag;
import coldfusion.tagext.lang.DocumentTagException;
import coldfusion.tagext.net.ResolvePage;
import coldfusion.util.CFFileServlet;
import coldfusion.util.RB;
import coldfusion.util.Semaphore;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFile;
import com.icesoft.util.PageDecorator.HeaderFooterDecoration;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import ice.util.unit.PointUnit;
import ice.util.unit.Unit;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import javax.swing.JFileChooser;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.http.HttpFileObject;
import org.apache.commons.vfs2.provider.url.UrlFileObject;

public class DocumentTag
extends GenericTag
implements BodyTag {
    private static final long serialVersionUID = 1L;
    private static final GenericTagPermission tp = new GenericTagPermission("cfdocument");
    private String filename = null;
    private boolean overwrite = false;
    private String name = null;
    private Integer format = DocumentService.UNKNOWN_FORMAT;
    private String pagetype = "LETTER";
    private double pagewidth;
    private double pageheight;
    private String orientation = "portrait";
    private double margintop = -1.0;
    private double marginbottom = -1.0;
    private double marginleft = -1.0;
    private double marginright = -1.0;
    private String unit = "in";
    private String content = null;
    private ByteArrayOutputStream byteOut = null;
    private DocumentProperties docProperties;
    private CFDocument document = null;
    private boolean bHaveSectionTag = false;
    private String charset = null;
    private URL baseurl = null;
    private DocumentMargin margin = new DocumentMargin();
    private DocumentPageLayout pagelayout = new DocumentPageLayout();
    private String http_agent = "";
    private List docSections = null;
    private boolean backgroundvisible = true;
    private String fontembed = "yes";
    private double scale = 0.0;
    private String encryption = "none";
    private String ownerpassword = null;
    private String userpassword = null;
    private String permissions = null;
    private String src;
    private URL srcUrl;
    private File sourceFile;
    private String srcfile;
    private String mimetype;
    private boolean bookmark;
    private boolean printAllFrames;
    private String saveAsName;
    private boolean localUrl = false;
    private String proxyHost;
    private int proxyPort = 80;
    private String proxyUser;
    private String proxyPassword;
    private String authUser;
    private String authPassword;
    private String userAgent;
    private boolean childPDFFormTag = false;
    private Object pdfCFDocumentProcessor;
    private int pdfFormPageCount = 0;
    private boolean bSingleThreadInUse = false;
    private static Semaphore taskwaiter = new Semaphore(1);
    private PdfPermissions pdfPermissions;
    private PageNoCallbackHandler pageNoCallbackHandler;
    private Exporter exporter;
    private URLConnectionSettings urlConnSettings;
    private HeaderFooterContentProvider header;
    private HeaderFooterContentProvider footer;
    private boolean scaleToFit;
    DocumentSectionProperties docSectionProps = null;
    private static boolean initialized = false;
    private static DocumentService documentService = null;
    private File htmlDir;
    private static final String TEMP_FOLDER = "CFFileServlet/htmlfiles";
    private int pptheight;
    private int pptwidth;
    private boolean bPPTProcessed = false;
    private boolean tagged = false;
    private boolean pdfa = false;
    private boolean formfields = true;
    private String formsType = "FDF";
    private String permissionsPassword = null;
    private String openPassword = "";

    public Integer getFormat() {
        return this.format;
    }

    protected Permission getPermission() {
        return tp;
    }

    public void setFormat(String format_str) {
        if (!format_str.equalsIgnoreCase("pdf")) {
            if (format_str.equalsIgnoreCase("flashpaper")) {
                throw new NotSupportedFormatException(format_str);
            }
            throw new DocumentUnknownFormatException(format_str);
        }
        this.format = DocumentService.PDF_FORMAT;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = Utils.getFileFullPath((String)filename, (PageContext)this.pageContext, (boolean)true);
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOpenPassword(String password) {
        this.openPassword = password;
    }

    public String getPagetype() {
        return this.pagetype;
    }

    public void setPagetype(String pagetype) {
        this.pagetype = pagetype;
        try {
            this.pagelayout.setPagetype(pagetype);
        }
        catch (IllegalArgumentException e) {
            throw new DocumentInvalidPageTypeException(pagetype);
        }
    }

    public double getPagewidth() {
        return this.pagewidth;
    }

    public void setPagewidth(double pw) {
        this.pagewidth = pw;
    }

    public double getPageheight() {
        return this.pageheight;
    }

    public void setPageheight(double ph) {
        this.pageheight = ph;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        if (orientation.equalsIgnoreCase("landscape")) {
            this.orientation = "landscape";
        } else if (orientation.equalsIgnoreCase("portrait")) {
            this.orientation = "portrait";
        } else {
            throw new DocumentInvalidOrientationException(orientation);
        }
        this.pagelayout.setOrientation(this.orientation);
    }

    public double getMargintop() {
        return this.margintop;
    }

    public void setMargintop(double m) {
        this.margintop = m;
    }

    public double getMarginbottom() {
        return this.marginbottom;
    }

    public void setMarginbottom(double m) {
        this.marginbottom = m;
    }

    public double getMarginleft() {
        return this.marginleft;
    }

    public void setMarginleft(double m) {
        this.marginleft = m;
    }

    public double getMarginright() {
        return this.marginright;
    }

    public void setMarginright(double m) {
        this.marginright = m;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        if (!unit.equalsIgnoreCase("in") && !unit.equalsIgnoreCase("cm")) {
            throw new DocumentInvalidUnitException(unit);
        }
        this.unit = unit;
    }

    public boolean isBackgroundvisible() {
        return this.backgroundvisible;
    }

    public void setBackgroundvisible(boolean backgroundvisible) {
        this.backgroundvisible = backgroundvisible;
    }

    public String getFontembed() {
        return this.fontembed;
    }

    public void setFontembed(String fontembed) {
        this.fontembed = fontembed.trim();
        if (!this.fontembed.equalsIgnoreCase("selective")) {
            try {
                Cast._boolean((String)this.fontembed);
            }
            catch (Cast.BooleanStringConversionException e) {
                throw new DocumentInvalidFontembedOption(fontembed);
            }
        }
    }

    public String getEncryption() {
        return this.encryption;
    }

    public void setEncryption(String encryption) {
        if (!((encryption = encryption.trim()).equalsIgnoreCase("128-bit") || encryption.equalsIgnoreCase("40-bit") || encryption.equalsIgnoreCase("none"))) {
            throw new DocumentInvalidEncryptionStrength(encryption);
        }
        this.encryption = encryption.trim();
    }

    public void setOwnerpassword(String ownerpassword) {
        this.ownerpassword = ownerpassword;
    }

    public void setUserpassword(String userpassword) {
        this.userpassword = userpassword;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
        if (permissions == null || permissions.trim().length() == 0) {
            throw new DocumentInvalidEncryptionPermission(permissions);
        }
        this.pdfPermissions = new PdfPermissions();
        String[] permArr = permissions.split(",");
        for (int i = 0; i < permArr.length; ++i) {
            String perm = permArr[i].trim();
            if (perm.equalsIgnoreCase("AllowPrinting")) {
                this.pdfPermissions.allowPrinting();
                continue;
            }
            if (perm.equalsIgnoreCase("AllowModifyContents")) {
                this.pdfPermissions.allowModifyContents();
                continue;
            }
            if (perm.equalsIgnoreCase("AllowCopy")) {
                this.pdfPermissions.allowCopy();
                continue;
            }
            if (perm.equalsIgnoreCase("AllowModifyAnnotations")) {
                this.pdfPermissions.allowModifyAnnotations();
                continue;
            }
            if (perm.equalsIgnoreCase("AllowFillIn")) {
                this.pdfPermissions.allowFillIn();
                continue;
            }
            if (perm.equalsIgnoreCase("AllowAssembly")) {
                this.pdfPermissions.allowAssembly();
                continue;
            }
            if (perm.equalsIgnoreCase("AllowScreenReaders")) {
                this.pdfPermissions.allowScreenReaders();
                continue;
            }
            if (perm.equalsIgnoreCase("AllowDegradedPrinting")) {
                this.pdfPermissions.allowDegradePrinting();
                continue;
            }
            if (perm.length() <= 0) continue;
            throw new DocumentInvalidEncryptionPermission(permissions);
        }
    }

    public void setTagged(boolean tagged) {
        this.tagged = tagged;
    }

    public void setPdfa(boolean pdfa) {
        this.pdfa = pdfa;
    }

    public void setFormFields(boolean formfields) {
        this.formfields = formfields;
    }

    public void setFormsType(String formstype) {
        this.formsType = formstype;
    }

    public void setPermissionsPassword(String password) {
        this.permissionsPassword = password;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setScaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
    }

    public boolean getScaleToFit() {
        return this.scaleToFit;
    }

    public boolean isBookmark() {
        return this.bookmark;
    }

    public void setBookmark(boolean bookmark) {
        this.bookmark = bookmark;
    }

    public boolean isPrintAllFrames() {
        return this.printAllFrames;
    }

    public void setPrintAllFrames(boolean printAllFrames) {
        this.printAllFrames = printAllFrames;
    }

    public String getSaveAsName() {
        return this.saveAsName;
    }

    public void setSaveAsName(String saveAsName) {
        this.saveAsName = saveAsName;
    }

    public void setSrc(String src) {
        if (src == null || src.trim().length() == 0) {
            throw new DocumentInvalidSrcException(src);
        }
        File f = VFSFileFactory.getFileObject((String)(src = src.trim()));
        if (!this.isURL(f) && f.isAbsolute() && f.exists()) {
            this.sourceFile = f;
        } else {
            try {
                this.srcUrl = new URL(this.resolveURL(src));
            }
            catch (MalformedURLException e) {
                throw new DocumentInvalidSrcException(src);
            }
        }
        this.src = src;
    }

    private boolean isURL(File f) {
        if (f instanceof VFile) {
            FileObject fo = ((VFile)f).getFileObject();
            return fo instanceof HttpFileObject || fo instanceof UrlFileObject;
        }
        return false;
    }

    private boolean isPPT() {
        String filename = this.sourceFile.getName().toLowerCase();
        return filename.endsWith(".ppt") || filename.endsWith(".pps");
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrcfile(String file) {
        if (file == null || file.trim().length() == 0) {
            throw new DocumentInvalidSrcException(file);
        }
        File f = VFSFileFactory.getFileObject((String)(file = file.trim()));
        if (!f.isAbsolute() || !f.exists()) {
            throw new DocumentInvalidSrcException(file);
        }
        this.sourceFile = f;
        this.srcfile = file;
    }

    public String getSrcfile() {
        return this.srcfile;
    }

    public void setMimetype(String mimeType) {
        if (mimeType == null || mimeType.trim().length() == 0 || mimeType.indexOf("/") == -1) {
            throw new DocumentInvalidMimeTypeException(mimeType);
        }
        this.mimetype = mimeType.trim();
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean isLocalUrl() {
        return this.localUrl;
    }

    public void setLocalUrl(boolean localUrl) {
        this.localUrl = localUrl;
    }

    public synchronized void setHaveSectionTag() {
        if (!this.bHaveSectionTag) {
            this.bHaveSectionTag = true;
            this.setSectionQueue(new ArrayList());
        }
    }

    public synchronized boolean isHaveSectionTag() {
        return this.bHaveSectionTag;
    }

    public URL getBaseURL() throws MalformedURLException {
        if (this.baseurl == null) {
            if (this.localUrl) {
                String basePath = Utils.getBaseTemplatePath((PageContext)this.pageContext);
                this.baseurl = new File(basePath).toURL();
                return this.baseurl;
            }
            if (this.request instanceof DummyHttpServletRequest) {
                String url = this.request.getPathTranslated();
                this.baseurl = new File(url).toURL();
            } else {
                String url = HttpUtils.getRequestURL((HttpServletRequest)this.request).toString();
                this.baseurl = new URL(url);
            }
        }
        return this.baseurl;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setSectionQueue(List sections) {
        this.docSections = sections;
    }

    public List getSectionQueue() {
        return this.docSections;
    }

    public DocumentProperties getDocumentProperties() {
        return this.docProperties;
    }

    public PageNoCallbackHandler getPageNoCallbackHandler() {
        return this.pageNoCallbackHandler;
    }

    public DocumentMargin getMargin() {
        return this.margin;
    }

    public Exporter getExporter() {
        return this.exporter;
    }

    private String resolveURL(String src) {
        ResolvePage rp = new ResolvePage();
        String baseUrlStr = null;
        try {
            baseUrlStr = this.getBaseURL().toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String parentUrl = rp.prepareUrl(baseUrlStr);
        String actualBaseUrl = rp.baseUrl(baseUrlStr);
        String contextUrl = actualBaseUrl + this.request.getContextPath();
        String resolvedUrl = rp.resolveUrl(src, parentUrl, contextUrl);
        return resolvedUrl == null ? src : resolvedUrl;
    }

    public int doStartTag() throws DocumentTagException {
        DocumentScope docScope;
        Tag parentTag;
        this.onTagStart();
        FeatureRouter.getInstance().allowFeature(EFRConstants.pdf_generation.intValue(), this.tagNameFromClass(), null);
        if (this.srcfile != null && this.isOfficeDoc(this.srcfile) && this.isOpenOfficeAvailable()) {
            this.exportWithOpenOffice();
            return 0;
        }
        if (this.srcfile != null && this.isOOOnlyOfficeDoc(this.srcfile)) {
            throw new OpenOfficeNotFoundException(this.getFileType(this.srcfile));
        }
        String conttype = this.request.getHeader("User-Agent");
        if (conttype != null && conttype.equalsIgnoreCase("contype")) {
            if (this.format == DocumentService.PDF_FORMAT) {
                this.response.setContentType("application/pdf");
            } else {
                this.response.setContentType("application/x-shockwave-flash");
            }
            throw new AbortException();
        }
        boolean bHasDocParent = false;
        for (parentTag = this.getParent(); parentTag != null; parentTag = parentTag.getParent()) {
            if (!(parentTag instanceof DocumentSectionTag) && !(parentTag instanceof DocumentTag) && !(parentTag instanceof DocumentItemTag)) continue;
            bHasDocParent = true;
            break;
        }
        if (bHasDocParent) {
            throw new DocumentInvalidParentTagException(parentTag.getClass().getName());
        }
        if (this.ownerpassword != null) {
            if (this.ownerpassword.equals(this.userpassword)) {
                throw new DocumentInvalidPasswordException();
            }
        } else {
            this.ownerpassword = this.userpassword;
        }
        if (this.encryption.equalsIgnoreCase("none") && (this.userpassword != null || this.ownerpassword != null || this.permissions != null)) {
            throw new DocumentMissingEncryptionAttribute();
        }
        this.http_agent = System.getProperty("http.agent");
        if (this.filename != null && !this.isOverwrite() && this.fileExists(this.filename)) {
            throw new DocumentFileExistsException(this.filename);
        }
        this.charset = this.request.getCharacterEncoding();
        if (this.charset == null) {
            this.charset = RuntimeServiceImpl.getDefaultCharset();
        }
        if ((docScope = (DocumentScope)((Object)this.fContext.hiddenScope.get((Object)"CFDOCUMENT"))) == null) {
            docScope = new DocumentScope();
            this.fContext.hiddenScope.put((Object)"CFDOCUMENT", (Object)docScope);
        }
        this.pageNoCallbackHandler = new DefaultPageNoCallbackHandler(docScope);
        this.exporter = new DocumentExporter();
        try {
            this.setupDocument();
            this.document = this.docProperties.getDocument();
            this.docProperties.setBookmarkEnabled(this.bookmark);
            this.docProperties.setPrintAllFrames(this.printAllFrames);
            this.docProperties.setBackgroundVisible(this.backgroundvisible);
            this.docProperties.setScale(this.scale);
            this.docProperties.setScaleToFit(this.scaleToFit);
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new DocumentTagException((Throwable)e);
        }
        this.initURLConnectionSettings();
        return 2;
    }

    private void initURLConnectionSettings() {
        if (this.proxyHost != null) {
            try {
                Socket sock = new Socket(this.proxyHost, this.proxyPort);
                sock.close();
            }
            catch (IOException e) {
                throw new ProxyConnectionException(this.proxyHost, this.proxyPort, e);
            }
        }
        this.urlConnSettings = new URLConnectionSettings();
        this.urlConnSettings.setProxyHost(this.proxyHost);
        this.urlConnSettings.setProxyPort(this.proxyPort);
        this.urlConnSettings.setProxyUser(this.proxyUser);
        this.urlConnSettings.setProxyPassword(this.proxyPassword);
        this.urlConnSettings.setAuthUserName(this.authUser);
        this.urlConnSettings.setAuthPassword(this.authPassword);
        this.urlConnSettings.setUserAgent(this.userAgent);
    }

    public URLConnectionSettings getURLConnectionSettings() {
        return this.urlConnSettings;
    }

    private boolean deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            String[] filelist = dir.list();
            boolean success = true;
            for (int i = 0; i < filelist.length; ++i) {
                File tmpfile = VFSFileFactory.getFileObject((String)dir.getAbsolutePath(), (String)filelist[i]);
                success = tmpfile.isDirectory() ? this.deleteDirectory(tmpfile) : tmpfile.delete();
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private void _deleteDirectory(final File htmldir) {
        if (System.getSecurityManager() == null) {
            this.deleteDirectory(htmldir);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DocumentTag.this.deleteDirectory(htmldir);
                    return null;
                }
            });
        }
    }

    private void cleanupTempOutputDir() {
        this._deleteDirectory(this.htmlDir);
    }

    private void createTempOutputDir(String name) {
        File tempDir = new File(ServiceFactory.getRuntimeService().getTempCacheDirectory(), TEMP_FOLDER);
        Random r = null;
        if (!initialized) {
            documentService = ServiceFactory.getDocumentService();
            CFFileServlet.cleanupTempCache((File)tempDir, (int)documentService.getPresentationExpiryTime());
            r = new Random();
            initialized = true;
        }
        do {
            if (r == null) {
                r = new Random();
            }
            String htmlFolder = name + (r.nextInt(1000000) + 1);
            this.htmlDir = new File(tempDir, htmlFolder);
        } while (this.htmlDir.exists());
        this.htmlDir.mkdirs();
    }

    private boolean fileExists(final String filename) {
        if (System.getSecurityManager() == null) {
            return VFSFileFactory.getFileObject((String)filename).exists();
        }
        Boolean bExists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return VFSFileFactory.getFileObject((String)filename).exists();
            }
        });
        return bExists;
    }

    private Image getWaterMarkImage() {
        if (System.getSecurityManager() == null) {
            return ServiceFactory.getDocumentService().getWmimage();
        }
        return (Image)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ServiceFactory.getDocumentService().getWmimage();
            }
        });
    }

    private void _createSections() {
        if (System.getSecurityManager() == null) {
            this.createSections();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DocumentTag.this.createSections();
                    return null;
                }
            });
        }
    }

    public void createSections() {
        String[] contents = this.convertPowerPoint();
        BufferedWriter htmlout = null;
        if (contents.length == 0) {
            throw new EmptyPPTException(this.sourceFile.getName());
        }
        this.bPPTProcessed = true;
        this.adjustDocumentDimension();
        for (int i = 0; i < contents.length; ++i) {
            this.docSectionProps = this.docProperties.createDocumentSection(this.margin, this.name, 0);
            String temphtml = this.htmlDir + File.separator + "slidetemp_" + i + ".html";
            try {
                htmlout = new BufferedWriter(new FileWriter(temphtml));
                htmlout.write(contents[i]);
            }
            catch (Exception e) {
                throw new DocumentTagException((Throwable)e);
            }
            finally {
                try {
                    if (htmlout != null) {
                        htmlout.close();
                    }
                }
                catch (Exception exception) {}
            }
            this.sourceFile = VFSFileFactory.getFileObject((String)temphtml);
            this.setHaveSectionTag();
            try {
                this._processContent();
                continue;
            }
            catch (DocumentProcessor.TimeOutException te) {
                throw new DocumentProcessTimeOutException(te.getTimeout());
            }
            catch (DocumentProcessor.RenderException ex) {
                throw new DocumentRenderException(ex.getMessage());
            }
            catch (DocumentProcessor.AuthenticationFailedException ex) {
                throw new AuthenticationFailedException(ex.getURL());
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (Throwable e) {
                throw new DocumentTagException(e);
            }
        }
        this.sourceFile = null;
        this.content = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doAfterBody() throws DocumentTagException {
        block33: {
            boolean hasContent;
            if (this.sourceFile != null && this.isPPT()) {
                if (this.htmlDir != null && System.getSecurityManager() != null) {
                    AccessController.checkPermission(new FilePermission(this.htmlDir.getAbsolutePath(), "write"));
                }
                this._createSections();
            } else if (this.bodyContent != null) {
                this.content = this.bodyContent.getString().trim();
                this.bodyContent.clearBody();
            } else {
                this.content = this.mobileContent;
            }
            boolean bl = hasContent = this.content != null && this.content.length() > 0;
            if (!this.isHaveSectionTag() && this.childPDFFormTag) {
                throw new PDFFormException(RB.getString(PDFFormException.class, (String)"cfpdfform.NoDocumentSectionWithPDFForm"));
            }
            try {
                this.setupEncrytion();
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new DocumentTagException((Throwable)e);
            }
            try {
                if (ServiceFactory.getLicenseService().isStandard() && !this.bSingleThreadInUse) {
                    taskwaiter.acquire();
                    this.bSingleThreadInUse = true;
                }
                if (this.isHaveSectionTag() || this.childPDFFormTag) {
                    if (this.docSections == null || this.docSections.isEmpty()) break block33;
                    try {
                        int totalPageNumber = 0;
                        for (DocumentSection section : this.docSections) {
                            totalPageNumber += section.getSectiontotalpagecount();
                        }
                        if (this.childPDFFormTag) {
                            totalPageNumber += ServiceFactory.getPDFService().getNumPagesInPDFForm(this.getPdfCFDocumentProcessor());
                        }
                        this.document.setTotalPageCount(totalPageNumber);
                        Iterator it = this.docSections.iterator();
                        while (it.hasNext()) {
                            DocumentSection section;
                            section = (DocumentSection)it.next();
                            try {
                                this.printSection(section);
                            }
                            finally {
                                section.releaseStormBase();
                                it.remove();
                            }
                        }
                        this._closeDocument();
                        break block33;
                    }
                    catch (ApplicationException ae) {
                        throw ae;
                    }
                    catch (Throwable e) {
                        throw new DocumentTagException(e);
                    }
                }
                if (hasContent || this.srcUrl != null || this.sourceFile != null) {
                    try {
                        this._processContent();
                        break block33;
                    }
                    catch (DocumentProcessor.TimeOutException te) {
                        throw new DocumentProcessTimeOutException(te.getTimeout());
                    }
                    catch (DocumentProcessor.RenderException ex) {
                        throw new DocumentRenderException(ex.getMessage());
                    }
                    catch (DocumentProcessor.AuthenticationFailedException ex) {
                        throw new AuthenticationFailedException(ex.getURL());
                    }
                    catch (ApplicationException ae) {
                        throw ae;
                    }
                    catch (Throwable e) {
                        Throwable cause = e.getCause();
                        if (cause != null && cause instanceof HeaderFooterDecoration.InvalidHeaderFooterSizeException) {
                            HeaderFooterDecoration.InvalidHeaderFooterSizeException hfEx = (HeaderFooterDecoration.InvalidHeaderFooterSizeException)cause;
                            throw new DocumentInvalidHeaderFooterSizeException(hfEx.getType(), hfEx.getSize());
                        }
                        throw new DocumentTagException(e);
                    }
                }
                throw new EmptyBodyException();
            }
            finally {
                if (this.bSingleThreadInUse) {
                    taskwaiter.release();
                    this.bSingleThreadInUse = false;
                }
                if (this.bPPTProcessed) {
                    this.cleanupTempOutputDir();
                }
            }
        }
        return 0;
    }

    private void _closeDocument() {
        if (System.getSecurityManager() == null) {
            this.closeDocument();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DocumentTag.this.closeDocument();
                    return null;
                }
            });
        }
    }

    private void closeDocument() {
        this.document.close();
    }

    private void _processContent() throws Exception {
        if (System.getSecurityManager() == null) {
            this.processContent();
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        DocumentTag.this.processContent();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
    }

    private void printSection(final DocumentSection section) throws Exception {
        if (System.getSecurityManager() == null) {
            section.print();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        section.print();
                    }
                    catch (Exception e) {
                        throw new DocumentTagException((Throwable)e);
                    }
                    return null;
                }
            });
        }
    }

    public void setHeaderContentProvider(HeaderFooterContentProvider header) {
        this.header = header;
    }

    public void setFooterContentProvider(HeaderFooterContentProvider footer) {
        this.footer = footer;
    }

    public HeaderFooterContentProvider getHeaderProvider() {
        return this.header;
    }

    public HeaderFooterContentProvider getFooterProvider() {
        return this.footer;
    }

    private void processContent() throws Exception {
        URL baseUrl;
        DocumentProcessor dr = new DocumentProcessor(this.urlConnSettings);
        if (ServiceFactory.getRuntimeService().timeoutRequests()) {
            long requestTimeOut = ServiceFactory.getRuntimeService().getRequestTimeoutLimit() * 1000L;
            dr.setRequestTimeOut(requestTimeOut);
        }
        if (this.docSectionProps != null) {
            dr.setDocSectionProps(this.docSectionProps);
        }
        dr.setDocumentProperties(this.docProperties);
        dr.setPageNoCallbackHandler(this.pageNoCallbackHandler);
        dr.setExporter(this.exporter);
        dr.setHeaderContentProvider(this.header);
        dr.setFooterContentProvider(this.footer);
        try {
            baseUrl = this.getBaseURL();
        }
        catch (Exception e) {
            throw new DocumentTagException((Throwable)e);
        }
        if (this.content != null && this.content.length() > 0) {
            dr.processContent(this.content, baseUrl, this.charset, this.docSections);
        } else if (this.srcUrl != null) {
            dr.processContent(this.srcUrl, null, this.mimetype, baseUrl, this.docSections);
        } else {
            dr.processContent(this.sourceFile, null, this.mimetype, baseUrl, this.docSections);
        }
    }

    public int doEndTag() throws DocumentTagException {
        this.runGcIfRequired();
        OutputStream os = null;
        if (this.http_agent == null) {
            System.setProperty("http.agent", "");
        } else {
            System.setProperty("http.agent", this.http_agent);
        }
        if (this.byteOut != null) {
            if (this.filename != null) {
                try {
                    os = this.getFileOutputStream(this.filename);
                    this.createDoc(os, this.byteOut);
                }
                catch (Throwable e) {
                    throw new DocumentTagException(e);
                }
                finally {
                    if (os != null) {
                        this.close(os);
                    }
                }
                if (this.name != null) {
                    this.pageContext.setAttribute(this.name, (Object)this.byteOut.toByteArray());
                }
            } else {
                try {
                    if (this.name == null) {
                        HttpServletResponse res = (HttpServletResponse)this.pageContext.getResponse();
                        res.setHeader("Expires", "0");
                        res.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                        res.setHeader("Pragma", "public");
                        HttpServletResponse resp = res;
                        while (resp instanceof JspWriterIncludeResponse) {
                            resp = ((JspWriterIncludeResponse)resp).getResponse();
                        }
                        if (this.out instanceof CFOutput) {
                            ((CFOutput)this.out).clearAll();
                        }
                        if (this.pageContext instanceof NeoPageContext) {
                            ((NeoPageContext)this.pageContext).setFlushOutput(false);
                        }
                        if (this.saveAsName != null) {
                            res.setHeader("Content-disposition", "inline; filename=" + this.saveAsName);
                        }
                        if (this.format == DocumentService.PDF_FORMAT) {
                            resp.setContentType("application/pdf");
                        } else if (this.format == DocumentService.FLASHPAPER_FORMAT) {
                            resp.setContentType("application/x-shockwave-flash");
                        }
                        os = resp.getOutputStream();
                        this.createDoc(os, this.byteOut);
                        os.flush();
                        this.onTagEnd();
                        throw new AbortException();
                    }
                    this.pageContext.setAttribute(this.name, (Object)this.byteOut.toByteArray());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.onTagEnd();
        return 6;
    }

    private String[] convertPowerPoint() {
        String basename = ServiceFactory.getPresentationService().getBaseName(this.sourceFile);
        this.createTempOutputDir(basename);
        Object[] ary = ServiceFactory.getPresentationService().getPageContents(this.sourceFile, this.htmlDir);
        this.pptheight = (Integer)ary[0];
        this.pptwidth = (Integer)ary[1];
        return (String[])ary[2];
    }

    private OutputStream getFileOutputStream(String filename) throws FileNotFoundException {
        return VFSFileFactory.getOutputStream((String)filename);
    }

    private void runGcIfRequired() {
        String rungc = System.getProperty("coldfusion.forcegc", "false");
        if (rungc.equals("true")) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Runtime runtime = Runtime.getRuntime();
                    if (runtime.totalMemory() > 0xC800000L) {
                        runtime.gc();
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDoc(OutputStream os, ByteArrayOutputStream result) throws IOException {
        try {
            int size = result.size();
            byte[] mergedPDF = null;
            if (this.childPDFFormTag) {
                mergedPDF = ServiceFactory.getPDFService().mergePDF(result.toByteArray(), this.getPdfCFDocumentProcessor(), this.encryption, this.ownerpassword, this.userpassword, this.pdfPermissions);
                size = mergedPDF.length;
            }
            if (this.filename == null) {
                this.response.setContentLength(size);
            }
            if (this.childPDFFormTag) {
                os.write(mergedPDF);
            } else {
                result.writeTo(os);
            }
        }
        finally {
            this.close(this.byteOut);
        }
    }

    private void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable e) {
            this.warning(e.getMessage());
        }
    }

    private void setupDocument() throws Exception {
        boolean bInch = this.unit.equalsIgnoreCase("in");
        if (this.pagetype.equalsIgnoreCase("CUSTOM")) {
            double width;
            if (this.pageheight == 0.0 || this.pagewidth == 0.0) {
                throw new DocumentMissingPageSizeException();
            }
            double height = bInch ? this.pageheight : this.pageheight / 2.54;
            double d = width = bInch ? this.pagewidth : this.pagewidth / 2.54;
            if (height < 2.0) {
                throw new DocumentInvalidPageSizeException("" + this.pageheight);
            }
            if (width < 2.0) {
                throw new DocumentInvalidPageSizeException("" + this.pagewidth);
            }
            this.pagelayout.setPageheight(height);
            this.pagelayout.setPagewidth(width);
        }
        if (this.margintop != -1.0) {
            this.margin.setTop(bInch ? this.margintop : this.margintop / 2.54);
        }
        if (this.marginbottom != -1.0) {
            this.margin.setBottom(bInch ? this.marginbottom : this.marginbottom / 2.54);
        }
        if (this.marginleft != -1.0) {
            this.margin.setLeft(bInch ? this.marginleft : this.marginleft / 2.54);
        }
        if (this.marginright != -1.0) {
            this.margin.setRight(bInch ? this.marginright : this.marginright / 2.54);
        }
        this.pagelayout.setMargin(this.margin);
        try {
            LicenseService licenseService;
            this.byteOut = new ByteArrayOutputStream();
            if (this.format == DocumentService.PDF_FORMAT) {
                boolean embed;
                this.docProperties = new PdfDocumentProperties(this.pagelayout, this.byteOut);
                Properties awtFontMapper = ServiceFactory.getDocumentService().getAwtFontMapper();
                Properties backupFontMapper = ServiceFactory.getDocumentService().getAwtFontMapperBak();
                DocumentFontMapper fontMapper = this.fontembed.equals("selective") ? new DocumentFontMapper(2, awtFontMapper, backupFontMapper) : ((embed = Cast._boolean((String)this.fontembed)) ? new DocumentFontMapper(0, awtFontMapper, backupFontMapper) : new DocumentFontMapper(1, awtFontMapper, backupFontMapper));
                ((PdfDocumentProperties)this.docProperties).setFontMapper((FontMapper)fontMapper);
            }
            if ((licenseService = ServiceFactory.getLicenseService()).isDeveloper()) {
                Image waterMarkImage = this.getWaterMarkImage();
                if (waterMarkImage == null) {
                    throw new DocumentInvalidWaterMarkFileException();
                }
                this.docProperties.setWatermarkImage(waterMarkImage);
            }
        }
        catch (DocumentMargin.InvalidMarginException e) {
            throw new DocumentInvalidMarginSizeException(e);
        }
        catch (DocumentPageLayout.MissingPageSizeException dme) {
            throw new DocumentMissingPageSizeException();
        }
    }

    private void adjustDocumentDimension() {
        if (!this.pagetype.equalsIgnoreCase("CUSTOM")) {
            this.margin.setLeft(0.0);
            this.margin.setRight(0.0);
            if (this.header == null && this.footer == null) {
                this.docProperties.getStormPageFormat().setPageSize((Unit)new PointUnit((double)this.pptwidth), (Unit)new PointUnit((double)this.pptheight));
                this.docProperties.getStormPageFormat().setMargin((Unit)new PointUnit(0.0), 1);
                this.docProperties.getStormPageFormat().setMargin((Unit)new PointUnit(0.0), 3);
                Rectangle rect = new Rectangle((float)this.pptwidth, (float)this.pptheight);
                this.docProperties.getDocument().setPageSize(rect);
            }
        }
    }

    public boolean isOfficeDoc(String filename) {
        String[] extensions;
        for (String e : extensions = new String[]{".doc", ".ppt", ".xls", ".docx", ".pptx", ".xlsx", ".rtf", ".txt"}) {
            if (!filename.endsWith(e)) continue;
            return true;
        }
        return false;
    }

    public boolean isOOOnlyOfficeDoc(String filename) {
        String[] extensions;
        for (String e : extensions = new String[]{".doc", ".xls", ".docx", ".xlsx", ".rtf", ".pptx"}) {
            if (!filename.endsWith(e)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getByteOut() {
        BufferedInputStream bis = null;
        InputStream fis = null;
        try {
            fis = VFSFileFactory.getInputStream((File)new File(this.filename));
            bis = new BufferedInputStream(fis);
            this.byteOut = new ByteArrayOutputStream();
            byte[] buffer = new byte[bis.available()];
            bis.read(buffer);
            this.byteOut.write(buffer);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (this.byteOut != null) {
                    this.byteOut.close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void setOOPDFExportProperties(OpenOfficeUNOHelper helper) {
        if (this.openPassword != null) {
            helper.setOpenPassword(this.openPassword);
        }
        if (this.pdfa) {
            helper.setPdfVersion(1);
        } else {
            helper.setExportFormFields(this.formfields);
            helper.setTaggedPDF(this.tagged);
            if (this.formsType.equalsIgnoreCase("FDF")) {
                helper.setFormsType(0L);
            } else if (this.formsType.equalsIgnoreCase("PDF")) {
                helper.setFormsType(1L);
            } else if (this.formsType.equalsIgnoreCase("HTML")) {
                helper.setFormsType(2L);
            } else if (this.formsType.equalsIgnoreCase("XML")) {
                helper.setFormsType(3L);
            } else {
                throw new InvalidFormsTypeException(this.formsType);
            }
            if (this.userpassword != null) {
                helper.setEncryptFile(true);
                helper.setDocumentOpenPassword(this.userpassword);
            }
            boolean bPermissions = false;
            if (this.permissionsPassword != null) {
                helper.setRestrictPermissions(true);
                helper.setPermissionPassword(this.permissionsPassword);
                bPermissions = true;
            }
            if (bPermissions && this.permissions != null) {
                int print = 0;
                int changes = 0;
                Boolean allowcopy = false;
                Boolean accessibility = false;
                String[] permArr = this.permissions.split(",");
                for (int i = 0; i < permArr.length; ++i) {
                    String perm = permArr[i].trim();
                    if (perm.equalsIgnoreCase("AllowPrinting")) {
                        print = 2;
                    } else if (perm.equalsIgnoreCase("AllowModifyContents")) {
                        changes = 4;
                    } else if (perm.equalsIgnoreCase("AllowCopy")) {
                        allowcopy = true;
                    } else if (perm.equalsIgnoreCase("AllowModifyAnnotations")) {
                        changes = 3;
                    } else if (perm.equalsIgnoreCase("AllowFillIn")) {
                        changes = 2;
                    } else if (perm.equalsIgnoreCase("AllowAssembly")) {
                        changes = 1;
                    } else if (perm.equalsIgnoreCase("AllowScreenReaders")) {
                        accessibility = true;
                    } else if (perm.equalsIgnoreCase("AllowDegradedPrinting")) {
                        print = 1;
                    }
                    helper.setPrinting(print);
                    helper.setChanges(changes);
                    helper.setEnableCopyingOfContent(allowcopy);
                    helper.setEnableTextAccessForAccessibilityTools(accessibility);
                }
            }
        }
    }

    private String getFileType(String filename) {
        String extension = "";
        try {
            JFileChooser fc = new JFileChooser();
            extension = fc.getTypeDescription(new File(filename));
        }
        catch (Exception e) {
            extension = filename.substring(filename.lastIndexOf(46) + 1, filename.length());
        }
        return extension;
    }

    private boolean isOpenOfficeAvailable() {
        return OpenOfficeUNOHelper.isOOAvailable();
    }

    private void exportWithOpenOffice() {
        if (this.format != DocumentService.PDF_FORMAT) {
            String filetype = this.getFileType(this.srcfile);
            throw new FlashPaperNotSupportedException(filetype);
        }
        boolean deleteTemp = false;
        String conttype = this.request.getHeader("User-Agent");
        if (conttype != null && conttype.equalsIgnoreCase("contype")) {
            this.response.setContentType("application/pdf");
            throw new AbortException();
        }
        if (this.filename != null && !this.isOverwrite() && this.fileExists(this.filename)) {
            throw new DocumentFileExistsException(this.filename);
        }
        if (this.filename == null) {
            deleteTemp = true;
            Random r = new Random();
            this.filename = ServiceFactory.getRuntimeService().getTempCacheDirectory() + "/documentTag_" + (r.nextInt(1000000) + 1) + ".pdf";
        }
        OpenOfficeUNOHelper officehelper = new OpenOfficeUNOHelper(this.srcfile, this.filename);
        officehelper.setIsPDF(true);
        this.setOOPDFExportProperties(officehelper);
        officehelper.doExport();
        if (this.filename == null || !new File(this.filename).exists()) {
            throw new CouldNotCreatePDFException(this.srcfile);
        }
        if (this.name != null) {
            this.getByteOut();
            this.pageContext.setAttribute(this.name, (Object)this.byteOut.toByteArray());
        } else if (deleteTemp) {
            ServletOutputStream os = null;
            this.getByteOut();
            new File(this.filename).delete();
            this.filename = null;
            HttpServletResponse res = (HttpServletResponse)this.pageContext.getResponse();
            res.setHeader("Expires", "0");
            res.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            res.setHeader("Pragma", "public");
            HttpServletResponse resp = res;
            while (resp instanceof JspWriterIncludeResponse) {
                resp = ((JspWriterIncludeResponse)resp).getResponse();
            }
            if (this.out instanceof CFOutput) {
                ((CFOutput)this.out).clearAll();
            }
            if (this.pageContext instanceof NeoPageContext) {
                ((NeoPageContext)this.pageContext).setFlushOutput(false);
            }
            if (this.saveAsName != null) {
                res.setHeader("Content-disposition", "inline; filename=" + this.saveAsName);
            }
            resp.setContentType("application/pdf");
            try {
                os = resp.getOutputStream();
                this.createDoc((OutputStream)os, this.byteOut);
                os.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.onTagEnd();
            throw new AbortException();
        }
    }

    public void release() {
        this.cleanup();
        super.release();
    }

    private void cleanup() {
        if (this.docSections != null && this.docSections.size() != 0) {
            for (int i = 0; i < this.docSections.size(); ++i) {
                DocumentSection section = (DocumentSection)this.docSections.get(i);
                section.releaseStormBase();
            }
            this.docSections = null;
        }
        this.sourceFile = null;
        this.mimetype = null;
        this.proxyHost = null;
        this.proxyPort = 80;
        this.proxyUser = null;
        this.proxyPassword = null;
        this.authUser = null;
        this.authPassword = null;
        this.filename = null;
        this.overwrite = false;
        this.name = null;
        this.format = DocumentService.PDF_FORMAT;
        this.baseurl = null;
        this.charset = null;
        this.pagetype = "LETTER";
        this.pagewidth = -1.0;
        this.pageheight = -1.0;
        this.orientation = "portrait";
        this.margintop = -1.0;
        this.marginbottom = -1.0;
        this.marginleft = -1.0;
        this.marginright = -1.0;
        this.unit = "in";
        this.content = null;
        this.byteOut = null;
        this.document = null;
        this.bHaveSectionTag = false;
        this.docSections = null;
        this.backgroundvisible = true;
        this.fontembed = "yes";
        this.encryption = "none";
        this.ownerpassword = null;
        this.userpassword = null;
        this.permissions = null;
        this.bSingleThreadInUse = false;
        this.src = null;
        this.srcUrl = null;
        this.srcfile = null;
        this.bookmark = false;
        this.printAllFrames = false;
        this.saveAsName = null;
        this.footer = null;
        this.header = null;
        this.childPDFFormTag = false;
        this.pdfCFDocumentProcessor = null;
        this.pdfFormPageCount = 0;
        this.pageNoCallbackHandler = null;
        this.tagged = false;
        this.pdfa = false;
        this.formfields = true;
        this.formsType = "FDF";
        this.permissionsPassword = null;
        this.openPassword = "";
        this.localUrl = false;
        this.userAgent = null;
        this.scaleToFit = false;
        this.htmlDir = null;
    }

    public void doFinally() {
        this.cleanup();
    }

    public boolean hasChildPDFFormTag() {
        return this.childPDFFormTag;
    }

    public void setChildPDFFormTag(boolean childPDFFormTag) {
        this.childPDFFormTag = childPDFFormTag;
    }

    public Object getPdfCFDocumentProcessor() {
        if (this.pdfCFDocumentProcessor == null) {
            this.pdfCFDocumentProcessor = ServiceFactory.getPDFService().getPDFFormCFDocProcessor((Object)this.document);
        }
        return this.pdfCFDocumentProcessor;
    }

    public int getPdfFormPageCount() {
        return this.pdfFormPageCount;
    }

    public void setPdfFormPageCount(int pdfFormPageCount) {
        this.pdfFormPageCount = pdfFormPageCount;
    }

    private void setupEncrytion() throws Exception {
        if (!this.childPDFFormTag && this.format == DocumentService.PDF_FORMAT && !this.encryption.equalsIgnoreCase("none")) {
            PdfDocumentProperties pdfDocProperties = (PdfDocumentProperties)this.docProperties;
            pdfDocProperties.setPdfPermission(this.pdfPermissions);
            pdfDocProperties.setUserPassword(this.userpassword);
            pdfDocProperties.setOwnerPassword(this.ownerpassword);
            try {
                pdfDocProperties.setEncryption(this.encryption);
            }
            catch (InvalidEncryptionPermission invalidEncryptionPermission) {
                throw new DocumentNotAllowedEncryptionPermission();
            }
        }
    }

    public static class ProxyConnectionException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String host;
        public int port;

        public ProxyConnectionException(String host, int port, Throwable e) {
            super(e);
            this.host = host;
            this.port = port;
        }
    }

    public static class DocumentInvalidPasswordException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class DocumentInvalidPageTypeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String pagetype;

        public DocumentInvalidPageTypeException(String pagetype) {
            this.pagetype = pagetype;
        }
    }

    public static class EmptyBodyException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class InvalidFormsTypeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String formstype;

        public InvalidFormsTypeException(String formstype) {
            this.formstype = formstype;
        }
    }

    public static class EmptyPPTException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String filename;

        public EmptyPPTException(String filename) {
            this.filename = filename;
        }
    }

    public static class OpenOfficeNotFoundException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String format;

        public OpenOfficeNotFoundException(String format) {
            this.format = format;
        }
    }

    public static class CouldNotCreatePDFException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String srcfile;

        public CouldNotCreatePDFException(String srcFile) {
            this.srcfile = srcFile;
        }
    }

    public static class FlashPaperNotSupportedException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String format;

        public FlashPaperNotSupportedException(String format) {
            this.format = format;
        }
    }
}

