/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.bmp;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.bmp.BmpHeaderDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BmpHeaderDescriptor
extends TagDescriptor<BmpHeaderDirectory> {
    public BmpHeaderDescriptor(@NotNull BmpHeaderDirectory bmpHeaderDirectory) {
        super(bmpHeaderDirectory);
    }

    @Override
    public String getDescription(int n) {
        switch (n) {
            case 5: {
                return this.getCompressionDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getCompressionDescription() {
        try {
            Integer n = ((BmpHeaderDirectory)this._directory).getInteger(5);
            if (n == null) {
                return null;
            }
            Integer n2 = ((BmpHeaderDirectory)this._directory).getInteger(-1);
            if (n2 == null) {
                return null;
            }
            switch (n) {
                case 0: {
                    return "None";
                }
                case 1: {
                    return "RLE 8-bit/pixel";
                }
                case 2: {
                    return "RLE 4-bit/pixel";
                }
                case 3: {
                    return n2 == 64 ? "Bit field" : "Huffman 1D";
                }
                case 4: {
                    return n2 == 64 ? "JPEG" : "RLE-24";
                }
                case 5: {
                    return "PNG";
                }
                case 6: {
                    return "Bit field";
                }
            }
            return super.getDescription(5);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

