/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.orm;

import coldfusion.orm.CFCMetadata;
import coldfusion.orm.ORMConfiguration;
import coldfusion.orm.ORMProvider;
import coldfusion.orm.ORMUtils;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyWrapper;
import coldfusion.util.Key;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class PersistentTemplateProxy
extends TemplateProxy {
    private List<String> pkFieldList = null;

    public PersistentTemplateProxy() {
    }

    public PersistentTemplateProxy(boolean dummy) {
        super(dummy);
    }

    public PersistentTemplateProxy(HashMap tempThisScopeMap, HashMap tempVarScopeMap, String cfcFullyQualifiedName) {
        super(tempThisScopeMap, tempVarScopeMap, cfcFullyQualifiedName);
    }

    public void initCompleted() {
        CFCMetadata cfcMetadata;
        ORMConfiguration currentConfiguration;
        Object[] props = (Object[])((AttributeCollection)this.getMetadata()).get(Key.PROPERTIES);
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                AttributeCollection property = (AttributeCollection)props[i];
                String propName = (String)property.get(Key.NAME);
                String defaultVal = (String)property.get(Key.DEFAULT);
                if (defaultVal == null) continue;
                this.varScope.bind(propName, (Object)defaultVal);
            }
        }
        if ((currentConfiguration = ORMProvider.getDefault().getCurrentConfiguration()) != null && (cfcMetadata = currentConfiguration.getCFCMetadata(this.cfcFullyQualifiedName)) != null) {
            this.pkFieldList = cfcMetadata.getPKFieldNames();
        }
    }

    public List<String> getPkFieldList() {
        return this.pkFieldList;
    }

    public Object getProperty(String propertyName) {
        return this.varScope.get((Object)propertyName);
    }

    public void setProperty(String propertyName, Object value) {
        this.varScope.bind(propertyName, value);
    }

    public Serializable getIdentifier() {
        if (this.pkFieldList == null) {
            return null;
        }
        HashMap<String, Object> compositeId = new HashMap<String, Object>();
        ORMConfiguration currentConfiguration = ORMProvider.getDefault().getCurrentConfiguration();
        CFCMetadata cfcMetadata = currentConfiguration == null ? null : currentConfiguration.getCFCMetadata(this.cfcFullyQualifiedName);
        for (String field : this.pkFieldList) {
            Object value = this.getProperty(field);
            if (cfcMetadata != null) {
                Class type = cfcMetadata.getPropertyType(field);
                value = ORMUtils.getTypedValue(value, type);
            }
            compositeId.put(field, value);
        }
        return compositeId;
    }

    protected TemplateProxy newInstance() {
        return new PersistentTemplateProxy();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersistentTemplateProxy)) {
            return false;
        }
        PersistentTemplateProxy t = (PersistentTemplateProxy)((Object)o);
        if (!this.cfcFullyQualifiedName.equals(t.cfcFullyQualifiedName)) {
            return false;
        }
        if (this.pkFieldList == null) {
            return super.equals((Object)t);
        }
        for (String field : this.pkFieldList) {
            Object thatVal;
            Object thisVal;
            try {
                thisVal = this.getProperty(field);
            }
            catch (Throwable throwable) {
                thisVal = this.varScope.get((Object)field);
            }
            try {
                thatVal = t.getProperty(field);
            }
            catch (Throwable throwable) {
                thatVal = this.varScope.get((Object)field);
            }
            if (thisVal == null && thatVal != null) {
                return false;
            }
            if (thisVal == null || thisVal.equals(thatVal)) continue;
            return false;
        }
        return true;
    }

    public boolean cfcEquals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        if (this.pkFieldList == null) {
            return super.hashCode();
        }
        int h = 0;
        for (String fieldName : this.pkFieldList) {
            Object val;
            try {
                val = this.getProperty(fieldName);
            }
            catch (Throwable throwable) {
                val = this.varScope.get((Object)fieldName);
            }
            h = h * 29 + (val == null ? 0 : val.hashCode());
        }
        if (h == 0) {
            return super.hashCode();
        }
        return h;
    }

    public Object writeReplace() throws NotSerializableException {
        TemplateProxyWrapper obj = (TemplateProxyWrapper)super.writeReplace();
        obj.setPersistent(true);
        return obj;
    }

    public static class PropertyGetterSetterException
    extends NeoException {
        public String getset;
        public String property;

        public PropertyGetterSetterException(String getset, String property, Throwable ex) {
            super(ex);
            this.getset = getset;
            this.property = property;
        }
    }
}

