/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.loader;

import com.sun.star.lib.loader.WinRegKey;
import com.sun.star.lib.loader.WinRegKeyException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

final class InstallationFinder {
    private static final String SYSPROP_NAME = "com.sun.star.lib.loader.unopath";
    private static final String ENVVAR_NAME = "UNO_PATH";
    private static final String SOFFICE = "soffice";

    private InstallationFinder() {
    }

    public static String getPath() {
        String string = null;
        string = InstallationFinder.getPathFromProperty(SYSPROP_NAME);
        if (string == null && (string = InstallationFinder.getPathFromEnvVar(ENVVAR_NAME)) == null) {
            String string2 = null;
            try {
                string2 = System.getProperty("os.name");
            }
            catch (SecurityException securityException) {
                return null;
            }
            if (string2 != null) {
                if (string2.startsWith("Windows")) {
                    string = InstallationFinder.getPathFromWindowsRegistry();
                } else {
                    string = InstallationFinder.getPathFromPathEnvVar();
                    if (string == null && (string = InstallationFinder.getPathFromWhich()) == null) {
                        string = InstallationFinder.getPathFromSVersionFile();
                    }
                }
            }
        }
        return string;
    }

    private static String getPathFromProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string2;
    }

    private static String getPathFromEnvVar(String string) {
        String string2 = null;
        try {
            string2 = System.getenv(string);
        }
        catch (SecurityException securityException) {
        }
        catch (Error error) {
            // empty catch block
        }
        return string2;
    }

    private static String getPathFromWindowsRegistry() {
        String string = null;
        try {
            WinRegKey winRegKey = new WinRegKey("HKEY_CURRENT_USER", "Software\\OpenOffice.org\\UNO\\InstallPath");
            string = winRegKey.getStringValue("");
        }
        catch (WinRegKeyException winRegKeyException) {
            try {
                WinRegKey winRegKey = new WinRegKey("HKEY_LOCAL_MACHINE", "Software\\OpenOffice.org\\UNO\\InstallPath");
                string = winRegKey.getStringValue("");
            }
            catch (WinRegKeyException winRegKeyException2) {
                System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromWindowsRegistry: reading key from Windows Registry failed: " + winRegKeyException2);
            }
        }
        return string;
    }

    private static String getPathFromPathEnvVar() {
        String string = null;
        String string2 = null;
        try {
            string2 = System.getenv("PATH");
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (Error error) {
            return null;
        }
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken(), SOFFICE);
                try {
                    if (!file.exists()) continue;
                    try {
                        string = file.getCanonicalFile().getParent();
                        if (string == null) continue;
                        break;
                    }
                    catch (IOException iOException) {
                        System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromEnvVar: bad path: " + iOException);
                    }
                }
                catch (SecurityException securityException) {}
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPathFromWhich() {
        String string = null;
        String[] stringArray = new String[]{"which", SOFFICE};
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(stringArray);
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (IOException iOException) {
            System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromWhich: which command failed: " + iOException);
            return null;
        }
        StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
        streamGobbler.start();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string2 = null;
        try {
            block21: while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                if (string != null || (n = string2.lastIndexOf(SOFFICE)) == -1) continue;
                int n2 = n + SOFFICE.length();
                for (int i = 0; i <= n; ++i) {
                    File file = new File(string2.substring(i, n2));
                    try {
                        if (!file.exists() || (string = file.getCanonicalFile().getParent()) == null) continue;
                        continue block21;
                    }
                    catch (SecurityException securityException) {
                        String string3 = null;
                        if (bufferedReader == null) return string3;
                        try {
                            bufferedReader.close();
                            return string3;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return string3;
                    }
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromWhich: reading which command output failed: " + iOException);
            String string4 = null;
            return string4;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            process.waitFor();
            return string;
        }
        catch (InterruptedException interruptedException) {
            process.destroy();
            Thread.currentThread().interrupt();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPathFromSVersionFile() {
        String string;
        block18: {
            string = null;
            try {
                File file = new File(System.getProperty("user.home"), ".sversionrc");
                if (!file.exists()) break block18;
                Vector<String> vector = new Vector<String>();
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    String string2 = null;
                    while ((string2 = bufferedReader.readLine()) != null && !string2.equals("[Versions]")) {
                    }
                    while ((string2 = bufferedReader.readLine()) != null && string2.length() != 0) {
                        if (string2.startsWith(";")) continue;
                        vector.add(string2);
                    }
                }
                catch (IOException iOException) {
                    System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromSVersionFile: reading .sversionrc file failed: " + iOException);
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                for (int i = vector.size() - 1; i >= 0; --i) {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)vector.elementAt(i), "=");
                    if (stringTokenizer.countTokens() != 2) continue;
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    string = InstallationFinder.getCanonicalPathFromFileURL(string4);
                    if (string == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        return string;
    }

    private static String getCanonicalPathFromFileURL(String string) {
        String string2;
        block23: {
            URL uRL;
            Object object;
            Object object2;
            String string3;
            String string4 = "file://";
            if (string.length() < string4.length() || !string.substring(0, string4.length()).toLowerCase().equals(string4)) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(string4);
            int n = string.indexOf(47, string4.length());
            if (n < 0) {
                n = string.length();
            }
            if ((string3 = string.substring(string4.length(), n)).length() != 0 && !string3.toLowerCase().equals("localhost")) {
                return null;
            }
            stringBuffer.append(string3);
            if (n == string.length()) {
                stringBuffer.append('/');
            } else {
                block12: while (n < string.length()) {
                    stringBuffer.append('/');
                    int n2 = string.indexOf(47, ++n);
                    if (n2 < 0) {
                        n2 = string.length();
                    }
                    while (n < n2) {
                        char c = string.charAt(n);
                        switch (c) {
                            case '%': {
                                object2 = new byte[(n2 - n) / 3];
                                int n3 = 0;
                                while (string.length() - n > 2 && string.charAt(n) == '%') {
                                    int n4 = Character.digit(string.charAt(n + 1), 16);
                                    int n5 = Character.digit(string.charAt(n + 2), 16);
                                    if (n4 < 0 || n5 < 0) break;
                                    int n6 = 16 * n4 + n5;
                                    if (n6 == 47) {
                                        return null;
                                    }
                                    object2[n3++] = (byte)n6;
                                    n += 3;
                                }
                                try {
                                    object = new String((byte[])object2, 0, n3, "UTF-8");
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    return null;
                                }
                                stringBuffer.append((String)object);
                                break;
                            }
                            case '#': {
                                break block12;
                            }
                            default: {
                                stringBuffer.append(c);
                                ++n;
                                break;
                            }
                        }
                    }
                }
            }
            try {
                uRL = new URL(stringBuffer.toString());
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            String string5 = uRL.getFile();
            object2 = uRL.getRef();
            if (object2 != null) {
                string5 = string5 + '#' + (String)object2;
            }
            string2 = null;
            object = new File(string5, SOFFICE);
            try {
                if (!((File)object).isAbsolute() || !((File)object).exists()) break block23;
                try {
                    string2 = ((File)object).getCanonicalFile().getParent();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        return string2;
    }

    private static final class StreamGobbler
    extends Thread {
        InputStream m_istream;

        StreamGobbler(InputStream inputStream) {
            this.m_istream = inputStream;
        }

        public void run() {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.m_istream));
                while (bufferedReader.readLine() != null) {
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

