/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.excel;

import coldfusion.excel.Excel;
import coldfusion.excel.ExcelInfo;
import coldfusion.log.CFLogs;
import coldfusion.osgi.services.ExcelService;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import coldfusion.sql.imq.Row;
import coldfusion.tagext.lang.SpreadSheetTag;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.jsp.PageContext;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;

public class ExcelServiceImpl
implements ExcelService {
    private static final String linesep = System.getProperty("line.separator");

    public Map<String, String> readXLSX(File xlsxfile) {
        String content = "";
        String author = "";
        String mime = "";
        String title = "";
        String subject = "";
        String keywords = "";
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            XSSFExcelExtractor extractor = new XSSFExcelExtractor(OPCPackage.open((InputStream)new FileInputStream(xlsxfile)));
            content = extractor.getText();
            author = extractor.getCoreProperties().getCreator();
            title = extractor.getCoreProperties().getTitle();
            subject = extractor.getCoreProperties().getSubject();
            keywords = "";
            metadata.put("Subject", subject != null ? subject : "");
            metadata.put("Keywords", keywords != null ? keywords : "");
            metadata.put("content", content);
            metadata.put("author", author != null ? author : "");
            metadata.put("mime", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            metadata.put("title", title != null ? title : "");
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.warn((Object)RB.getString((Object)new Object(), (String)"Search.LucenePDFDocumentWarn", (Object)xlsxfile.getAbsolutePath(), (Object)e.getMessage()));
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> readXLS(File xlsfile) {
        String content = "";
        String author = "";
        String mime = "";
        String title = "";
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            FileInputStream inp = new FileInputStream(xlsfile);
            ExcelExtractor extractor = new ExcelExtractor(new POIFSFileSystem((InputStream)inp));
            content = extractor.getText();
            author = extractor.getSummaryInformation().getAuthor();
            title = extractor.getSummaryInformation().getTitle();
            String subject = extractor.getSummaryInformation().getSubject();
            String keywords = extractor.getSummaryInformation().getKeywords();
            metadata.put("Subject", subject != null ? subject : "");
            metadata.put("Keywords", keywords != null ? keywords : "");
            metadata.put("content", content);
            metadata.put("author", author != null ? author : "");
            metadata.put("mime", "application/vnd.ms-excel");
            metadata.put("title", title != null ? title : "");
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.warn((Object)RB.getString((Object)new Object(), (String)"Search.LucenePDFDocumentWarn", (Object)xlsfile.getAbsolutePath(), (Object)e.getMessage()));
        }
        finally {
            return metadata;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(PageContext pageContext, String filename, String sheetname, String name, String format, String query, boolean update, String password, Object autosize, boolean overWrite, int sheet) {
        Object o;
        if (filename != null) {
            File destFile = VFSFileFactory.getFileObject((String)filename);
            if (!this.isOverWrite(update, overWrite) && destFile.exists()) {
                throw new SpreadSheetTag.FileAlreadyExistsException(destFile.getAbsolutePath());
            }
        }
        if (sheetname == null && (name == null || format != null)) {
            sheetname = "Sheet" + (sheet + 1);
        }
        if (filename == null) {
            throw new SpreadSheetTag.ExcelMissingAttributeException("write", "filename");
        }
        if (name == null && query == null) {
            throw new SpreadSheetTag.ExcelMissingAttributeException("write", "name");
        }
        if (name != null) {
            o = pageContext.findAttribute(name);
            if (o == null) throw new SpreadSheetTag.ExcelInvalidVariableException(name);
            if (o instanceof ExcelInfo) {
                ExcelInfo info = (ExcelInfo)o;
                this.writeToExcel(info, update, filename, sheetname, password, autosize);
                return;
            } else {
                if (!(o instanceof String) || !format.equalsIgnoreCase("csv")) throw new SpreadSheetTag.ExcelIllegalValueException(name, "name");
                String csv = (String)o;
                this.writeCSVToExcel(filename, csv, sheetname, password, update, autosize);
            }
            return;
        } else {
            if (query == null) return;
            o = pageContext.findAttribute(query);
            if (!(o instanceof QueryTable) || o == null) throw new SpreadSheetTag.ExcelIllegalValueException(query, "query");
            QueryTable query2 = (QueryTable)o;
            this.writeToExcel(query2, update, filename, sheetname, password, autosize, sheet);
        }
    }

    public boolean isOverWrite(boolean update, boolean overWrite) {
        return update || overWrite;
    }

    public void writeCSVToExcel(String filename, String csv, String sheetname, String password, boolean update, Object autosize) {
        Excel.writeCSVToExcel(filename, csv, sheetname, password, update, autosize);
    }

    public void writeToExcel(QueryTable q, boolean update, String filename, String sheetname, String password, Object autosize, int sheet) {
        ArrayList<String[]> values = new ArrayList<String[]>();
        String[] cols = q.getColumnList();
        values.add(cols);
        while (!q.isLast()) {
            Row r = q.getRow(q.getCurrentRow());
            int len = cols.length;
            String[] s = new String[len];
            for (int j = 0; j < cols.length; ++j) {
                Object colValue = r.getColumn(j);
                s[j] = colValue == null ? "" : colValue.toString();
            }
            values.add(s);
            q.next();
        }
        q.close();
        if (sheetname != null) {
            Excel.writeExcel(filename, values, sheetname, password, update, autosize);
        } else {
            sheetname = "Sheet" + (sheet + 1);
            Excel.writeExcel(filename, values, sheetname, password, update, autosize);
        }
    }

    public void writeToExcel(ExcelInfo in, boolean update, String filename, String sheetname, String password, Object autosize) {
        if (sheetname != null) {
            Excel.writeExcel(filename, in, sheetname, password, update, autosize);
        } else {
            Excel.writeExcel(filename, in, password, update, autosize);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(PageContext pageContext, String query, String format, String name, String src, int headerrow, String columnnames, String columns, int sheet, int maxcolcount, boolean excludeHeaderRow, String rows, String sheetname, boolean sheetNoProvided) {
        if (query != null) {
            this.readExcelToQuery(pageContext, src, headerrow, columnnames, columns, sheet, maxcolcount, excludeHeaderRow, rows, sheetname, query);
            return;
        } else if (format != null && name != null) {
            if (format.equalsIgnoreCase("csv")) {
                this.readExcelToCSV(pageContext, src, headerrow, columnnames, columns, sheet, maxcolcount, excludeHeaderRow, rows, sheetname, name);
                return;
            } else {
                if (!format.equalsIgnoreCase("html")) throw new SpreadSheetTag.ExcelIllegalValueException(format, "format");
                this.readExcelToHTML(pageContext, src, headerrow, columnnames, columns, sheet, maxcolcount, excludeHeaderRow, rows, sheetname, name);
            }
            return;
        } else {
            if (format != null || name == null) throw new SpreadSheetTag.ExcelMissingAttributeException("read", "query/name");
            this.saveToVar(pageContext, src, sheetname, sheet, name, sheetNoProvided);
        }
    }

    public void saveToVar(PageContext pageContext, String src, String sheetname, int sheet, String name, boolean sheetNoProvided) {
        try {
            this.verifyFile(pageContext, src);
            InputStream inp = VFSFileFactory.getInputStream((String)src);
            Excel excel = new Excel(inp);
            if (sheetname != null) {
                sheet = excel.getSheetIndex(sheetname);
                if (sheet == -1) {
                    throw new SpreadSheetTag.ExcelInvalidSheetNameException2(sheetname);
                }
            } else {
                try {
                    ExcelInfo excelInfo = excel.getExcelInfo(sheet);
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new SpreadSheetTag.ExcelInvalidSheetNumberException(sheet + 1);
                }
            }
            ExcelInfo info = excel.getExcelInfo(sheet);
            Workbook book = info.getWorkbook();
            if (sheetNoProvided) {
                for (int x = book.getNumberOfSheets() - 1; x >= 0; --x) {
                    if (sheet == x) continue;
                    book.removeSheetAt(x);
                }
                info.setSheetNoProvided(sheetNoProvided);
            }
            pageContext.setAttribute(name, (Object)info);
        }
        catch (IOException e) {
            throw new SpreadSheetTag.ExcelTagException((Throwable)e);
        }
    }

    public ArrayList<String[]> readExcel(Excel excel, String src, int headerrow, String columnnames, String columns, int sheet, boolean excludeHeaderRow, String rows, String sheetname) {
        ArrayList<String[]> values = null;
        if (sheetname != null && (sheet = excel.getSheetIndex(sheetname)) == -1) {
            throw new SpreadSheetTag.ExcelInvalidSheetNameException2(sheetname);
        }
        if (excel != null) {
            values = rows != null ? (columns != null ? (excludeHeaderRow ? excel.readXLS(sheet, rows, columns, headerrow - 1) : excel.readXLS(sheet, rows, columns, -1)) : (excludeHeaderRow ? excel.readXLS(sheet, rows, headerrow - 1) : excel.readXLS(sheet, rows, -1))) : (columns != null ? (excludeHeaderRow ? excel.readXLS(sheet, "", columns, headerrow - 1) : excel.readXLS(sheet, "", columns, -1)) : (excludeHeaderRow ? excel.readXLS(sheet, headerrow - 1) : excel.readXLS(sheet, -1)));
        }
        return values;
    }

    public Class<?> getExcelClass() {
        return ExcelInfo.class;
    }

    public void readExcelToHTML(PageContext pageContext, String src, int headerrow, String columnnames, String columns, int sheet, int maxcolcount, boolean excludeHeaderRow, String rows, String sheetname, String name) {
        String htmlString = "";
        try {
            this.verifyFile(pageContext, src);
            InputStream inp = VFSFileFactory.getInputStream((String)src);
            Excel excel = new Excel(inp);
            ArrayList<String[]> values = this.readExcel(excel, src, headerrow, columnnames, columns, sheet, excludeHeaderRow, rows, sheetname);
            String[] header = new String[]{};
            if (headerrow != -1) {
                if (columns != null) {
                    if (columns.contains(",")) {
                        Integer[] cols = new Integer[]{};
                        cols = Excel.doProcessList(columns);
                        Sheet hssfsheet = excel.getWorkbook().getSheetAt(sheet);
                        header = excel.getValuesAt(hssfsheet, headerrow - 1, cols);
                    } else {
                        int[] cols = Excel.doProcessRange(columns);
                        int startcol = cols[0] - 1;
                        int endcol = cols[1];
                        Sheet hssfsheet = excel.getWorkbook().getSheetAt(sheet);
                        header = excel.getValuesAt(hssfsheet, headerrow - 1, startcol, endcol);
                    }
                } else {
                    header = excel.getValuesAt(sheet, headerrow - 1);
                }
            }
            if (values != null) {
                htmlString = this.populateTable(values, header);
            }
            pageContext.setAttribute(name, (Object)htmlString);
        }
        catch (IOException e) {
            throw new SpreadSheetTag.ExcelTagException((Throwable)e);
        }
    }

    public void readExcelToCSV(PageContext pageContext, String src, int headerrow, String columnnames, String columns, int sheet, int maxcolcount, boolean excludeHeaderRow, String rows, String sheetname, String name) {
        String csvString = "";
        try {
            this.verifyFile(pageContext, src);
            InputStream inp = VFSFileFactory.getInputStream((String)src);
            Excel excel = new Excel(inp);
            ArrayList<String[]> values = this.readExcel(excel, src, headerrow, columnnames, columns, sheet, excludeHeaderRow, rows, sheetname);
            if (values != null) {
                csvString = excel.populateCSV(values);
            }
            pageContext.setAttribute(name, (Object)csvString);
        }
        catch (IOException e) {
            throw new SpreadSheetTag.ExcelTagException((Throwable)e);
        }
    }

    private String verifyFile(PageContext pageContext, String filename) throws FileNotFoundException {
        if (filename.trim().length() == 0) {
            throw new FileNotFoundException(filename);
        }
        File file = VFSFileFactory.getFileObject((String)(filename = Utils.getFileFullPath((String)filename, (PageContext)pageContext, (boolean)true)));
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        return filename;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readExcelToQuery(PageContext pageContext, String src, int headerrow, String columnnames, String columns, int sheet, int maxcolcount, boolean excludeHeaderRow, String rows, String sheetname, String query) {
        try {
            this.verifyFile(pageContext, src);
            InputStream inp = VFSFileFactory.getInputStream((String)src);
            Excel excel = new Excel(inp);
            ArrayList<String[]> values = this.readExcel(excel, src, headerrow, columnnames, columns, sheet, excludeHeaderRow, rows, sheetname);
            if (sheetname != null) {
                sheet = excel.getSheetIndex(sheetname);
            }
            maxcolcount = Excel.getColumnCount(excel.getWorkbook().getSheetAt(sheet));
            if (values == null) return;
            if (headerrow != -1 && columnnames == null) {
                String[] header = null;
                if (columns != null) {
                    if (columns.contains(",")) {
                        Integer[] cols = new Integer[]{};
                        cols = Excel.doProcessList(columns);
                        Sheet hssfsheet = excel.getWorkbook().getSheetAt(sheet);
                        header = excel.getValuesAt(hssfsheet, headerrow - 1, cols);
                    } else {
                        int[] cols = Excel.doProcessRange(columns);
                        int startcol = cols[0] - 1;
                        int endcol = cols[1];
                        Sheet hssfsheet = excel.getWorkbook().getSheetAt(sheet);
                        header = excel.getValuesAt(hssfsheet, headerrow - 1, startcol, endcol);
                    }
                } else {
                    header = excel.getValuesAt(sheet, headerrow - 1);
                }
                if (header == null) throw new SpreadSheetTag.ExcelInvalidHeaderRowException(headerrow);
                this.populateQuery(pageContext, values, header, maxcolcount, query);
                return;
            } else {
                this.populateQuery(pageContext, values, maxcolcount, columnnames, query);
            }
            return;
        }
        catch (IOException e) {
            throw new SpreadSheetTag.ExcelTagException((Throwable)e);
        }
    }

    private void populateQuery(PageContext pageContext, ArrayList<String[]> values, int maxcolcount, String columnnames, String query) {
        StringTokenizer stringTokenizer = null;
        if (columnnames != null) {
            stringTokenizer = new StringTokenizer(columnnames, "\t\n,");
            int count = stringTokenizer.countTokens();
            String[] colnames = new String[count];
            int index = 0;
            if (stringTokenizer != null) {
                while (stringTokenizer.hasMoreTokens()) {
                    String columnname;
                    colnames[index] = columnname = stringTokenizer.nextToken().trim();
                    ++index;
                }
            }
            this.populateQuery(pageContext, values, colnames, maxcolcount, query);
        } else {
            this.populateQuery(pageContext, values, new String[0], maxcolcount, query);
        }
    }

    private void populateQuery(PageContext pageContext, ArrayList<String[]> values, String[] colnames, int maxcolcount, String query) {
        QueryTable resultQuery = new QueryTable();
        String colname = "col";
        ListIterator<String[]> iter = values.listIterator();
        int start = 0;
        while (iter.hasNext()) {
            String[] row = iter.next();
            int rowlength = maxcolcount;
            if (start == 0) {
                String[] columnTypeNames;
                int[] columnTypes;
                String[] QueryColumns;
                if (rowlength > 0) {
                    QueryColumns = new String[rowlength];
                    columnTypes = new int[rowlength];
                    columnTypeNames = new String[rowlength];
                } else {
                    QueryColumns = new String[1];
                    columnTypes = new int[1];
                    columnTypeNames = new String[1];
                    columnTypes[0] = 12;
                    columnTypeNames[0] = "VARCHAR";
                    QueryColumns[0] = 0 < colnames.length ? colnames[0] : "col_1";
                }
                for (int i = 0; i < rowlength; ++i) {
                    columnTypes[i] = 12;
                    columnTypeNames[i] = "VARCHAR";
                    QueryColumns[i] = i < colnames.length && colnames[i] != null && !colnames[i].equalsIgnoreCase("") ? colnames[i] : colname + "_" + (i + 1);
                }
                resultQuery = new QueryTable(0, QueryColumns, columnTypeNames, columnTypes);
            }
            resultQuery.addRows(1);
            if (row.length == 0) {
                resultQuery.setField(start + 1, 1, (Object)"");
            }
            for (int index = 0; index < row.length; ++index) {
                resultQuery.setField(start + 1, index + 1, (Object)row[index]);
            }
            ++start;
        }
        pageContext.setAttribute(query, (Object)resultQuery);
    }

    public Object read(Object source, Object sheetName_SheetNumber) {
        int sheetnumber = 0;
        int sheetindex = 0;
        try {
            InputStream inp = null;
            if (source instanceof String) {
                if (VFSFileFactory.checkIfVFile((String)((String)source))) {
                    try {
                        inp = VFSFileFactory.getInputStream((String)((String)source));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        inp = new FileInputStream((String)source);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            } else if (source instanceof byte[]) {
                inp = new ByteArrayInputStream((byte[])source);
            }
            Excel excel = new Excel(inp);
            String sSheet = Cast._String((Object)sheetName_SheetNumber);
            if (CFPage.IsNumeric((Object)sheetName_SheetNumber)) {
                sheetnumber = Cast._int((Object)sheetName_SheetNumber, (boolean)false);
                --sheetnumber;
                sheetindex = excel.getSheetIndex(sSheet);
            } else {
                sheetindex = sheetnumber = excel.getSheetIndex(sSheet);
            }
            if (sheetnumber == -1 && !sSheet.equals("all")) {
                throw new SpreadSheetTag.ExcelInvalidSheetNameException(sSheet);
            }
            if ("all".equals(sSheet)) {
                sheetnumber = 0;
            }
            ExcelInfo info = excel.getExcelInfo(sheetnumber);
            Workbook book = info.getWorkbook();
            if (!"all".equals(sSheet)) {
                for (int x = book.getNumberOfSheets() - 1; x >= 0; --x) {
                    if (sheetnumber == x || sheetindex == x) continue;
                    book.removeSheetAt(x);
                }
                info.setSheetNoProvided(true);
            }
            if (info.getExcelSheetNumber() == -1) {
                throw new SpreadSheetTag.ExcelInvalidSheetException(sheetnumber + 1);
            }
            if (inp != null) {
                try {
                    inp.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return info;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetnumber + 1);
        }
        catch (IllegalArgumentException ex) {
            throw new SpreadSheetTag.ExcelInvalidSheetException(sheetnumber + 1);
        }
    }

    public boolean isExcelObject(Object o) {
        return o instanceof ExcelInfo;
    }

    public void write(String filePath, Object spreadsheet, String password, boolean overwrite, Object autosize) {
        File destFile = VFSFileFactory.getFileObject((String)filePath);
        if (!overwrite && destFile.exists()) {
            throw new SpreadSheetTag.FileAlreadyExistsException(destFile.getAbsolutePath());
        }
        Excel.writeExcel(filePath, (ExcelInfo)spreadsheet, password, false, autosize);
    }

    public byte[] readBinary(Object spreadsheet) {
        return Excel.readBinary((ExcelInfo)spreadsheet);
    }

    public void addRow(Object spreadsheet, String data, int row, int column, boolean insert, String datatype) {
        Excel.addRow((ExcelInfo)spreadsheet, data, row, column, insert, datatype);
    }

    public void addRows(Object obj, Object data, int startRow, int startColumn, boolean insert, Object datatypes, boolean insertColumnHeader) {
        ExcelInfo spreadsheet = (ExcelInfo)obj;
        String[] ds = null;
        Array d = null;
        if (null != datatypes) {
            if (datatypes instanceof Array) {
                d = (Array)datatypes;
            } else {
                throw new SpreadSheetTag.ExcelInvalidDatatypeTypeException();
            }
        }
        if (data instanceof QueryTable) {
            if (d != null) {
                ds = (String[])d.toArray((Object[])new String[((QueryTable)data).getRowCount()]);
            }
            Excel.addRows(spreadsheet, (QueryTable)data, startRow, startColumn, insert, ds, insertColumnHeader);
        } else if (data instanceof Array) {
            Array a = (Array)data;
            Object first = a.get(0);
            if (first instanceof Array) {
                int start = startRow;
                Iterator iter = a.iterator();
                int actualindex = 0;
                int sheetContaingRows = Excel.isSheetContaingRows(spreadsheet);
                while (iter.hasNext()) {
                    String datatype;
                    Integer[] datatypes_identifier;
                    Object o = iter.next();
                    if (!(o instanceof Array)) continue;
                    Array oArr = (Array)o;
                    for (Object innerarr : oArr) {
                        if (!(innerarr instanceof Array)) continue;
                        throw new SpreadSheetTag.InvalidDataException();
                    }
                    String[] s = ExcelServiceImpl.handleCFPrimitivesToString(oArr);
                    Integer[] lastdatatype = new Integer[oArr.size()];
                    if (d != null && d.size() > actualindex && (datatypes_identifier = Excel.getParsedDatatypes(datatype = (String)d.get(actualindex++), oArr.size())) != null) {
                        lastdatatype = datatypes_identifier;
                    }
                    if (start == -1) {
                        start = 1;
                    }
                    if (sheetContaingRows > 0) {
                        start = sheetContaingRows + 2;
                    }
                    Excel.addRow(spreadsheet, s, start, startColumn, insert, lastdatatype);
                    ++start;
                    sheetContaingRows = -1;
                }
            } else {
                if (d != null) {
                    ds = (String[])d.toArray((Object[])new String[a.size()]);
                }
                String[] s = (String[])a.toArray((Object[])new String[a.size()]);
                Excel.addRows(spreadsheet, s, startRow, startColumn, insert, ds);
            }
        } else {
            throw new SpreadSheetTag.InvalidInputException();
        }
    }

    public Struct getInfo(Object spreadsheet) {
        Struct result = Excel.info((ExcelInfo)spreadsheet);
        return result;
    }

    public void addInfo(Object spreadsheet, Struct properties) {
        Excel.addInfo((ExcelInfo)spreadsheet, properties);
    }

    public void applyAutofilter(Object o, String rowbreaks, String columnbreaks) {
        ExcelInfo spreadsheet = (ExcelInfo)o;
        Sheet sheet = spreadsheet.getWorkbook().getSheet(spreadsheet.getExcelSheetName());
        Excel.applyRowbreaks(rowbreaks, sheet);
        Excel.applyColumnbreaks(columnbreaks, sheet);
    }

    public void applyAutofilter(Object spreadsheet, String autofilter) {
        Excel.applyAutofilter(autofilter, ((ExcelInfo)spreadsheet).getWorkbook().getSheet(((ExcelInfo)spreadsheet).getExcelSheetName()));
    }

    public boolean isSpreadsheetFile(String value) {
        boolean bSpreadSheet = false;
        try {
            FileInputStream inp = new FileInputStream(value);
            new Excel(inp);
            bSpreadSheet = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bSpreadSheet;
    }

    public void createSheet(Object spreadsheet, String sheetName) {
        if (sheetName.isEmpty()) {
            Excel.createSheet((ExcelInfo)spreadsheet);
        } else {
            Excel.createSheet((ExcelInfo)spreadsheet, sheetName);
        }
    }

    public void setActiveSheet(Object spreadsheet, int sheetNumber) {
        Excel.setActiveSheet((ExcelInfo)spreadsheet, sheetNumber);
    }

    public void setActiveSheet(Object spreadsheet, String sheetName) {
        Excel.setActiveSheet((ExcelInfo)spreadsheet, sheetName);
    }

    public void removeSheet(Object spreadsheet, String sheetName) {
        Excel.removeSheet((ExcelInfo)spreadsheet, sheetName);
    }

    public Object createNewSpreadsheet(Boolean xmlformat) {
        boolean isXSSF = xmlformat;
        Excel excel = null;
        excel = isXSSF ? new Excel("XSSF") : new Excel("HSSF");
        ExcelInfo info = excel.getExcelInfo();
        return info;
    }

    public void addColumn(Object spreadsheet, String data, int startRow, int startColumn, boolean insert, String datatype) {
        Excel.addColumn((ExcelInfo)spreadsheet, data, startRow, startColumn, insert, datatype);
    }

    public void shiftRows(Object spreadsheet, int start, int end, int rows) {
        Excel.shiftRows((ExcelInfo)spreadsheet, start, end, rows);
    }

    public void shiftColumns(Object spreadsheet, int start, int columns) {
        Excel.shiftColumns((ExcelInfo)spreadsheet, start, columns);
    }

    public ArrayList<Struct> getCellComment(Object spreadsheet) {
        return Excel.getCellComment((ExcelInfo)spreadsheet);
    }

    public void deleteColumn(Object spreadsheet, int column) {
        new Excel().deleteColumn((ExcelInfo)spreadsheet, column);
    }

    public void deleteColumns(Object spreadsheet, String columns) {
        new Excel().deleteColumns((ExcelInfo)spreadsheet, columns);
    }

    public void mergeCells(Object spreadsheet, int startRow, int endRow, int startColumn, int endColumn) {
        new Excel().mergeCells((ExcelInfo)spreadsheet, startRow, endRow, startColumn, endColumn);
    }

    public void setFooter(Object spreadsheet, String leftFooter, String centerFooter, String rightFooter) {
        Excel.setFooter((ExcelInfo)spreadsheet, leftFooter, centerFooter, rightFooter);
    }

    public void setHeader(Object spreadsheet, String leftHeader, String centerHeader, String rightHeader) {
        Excel.setHeader((ExcelInfo)spreadsheet, leftHeader, centerHeader, rightHeader);
    }

    public int getColumnCount(Object spreadsheet) {
        return ((ExcelInfo)spreadsheet).getColumnCount();
    }

    public void addImage(Object spreadsheet, String imagePath, String anchor) {
        Excel.addImage((ExcelInfo)spreadsheet, imagePath, anchor);
    }

    public void setRowHeight(Object spreadsheet, int row, int height) {
        Excel.setRowHeight((ExcelInfo)spreadsheet, row, height);
    }

    public void setColumnWidth(Object o, int column, int width) {
        ExcelInfo spreadsheet = (ExcelInfo)o;
        spreadsheet.addIgnoreColumnsForAutoResize(column);
        Excel.setColumnWidth(spreadsheet, column, width);
    }

    public void addImage(Object spreadsheet, byte[] imageData, String imageType, String anchor) {
        Excel.addImage((ExcelInfo)spreadsheet, imageData, imageType, anchor);
    }

    public int getColumnCount(Object o, Object sheetName_SheetNumber) {
        ExcelInfo spreadsheet = (ExcelInfo)o;
        int columnCount = sheetName_SheetNumber == null ? spreadsheet.getColumnCount() : spreadsheet.getColumnCount(sheetName_SheetNumber);
        return columnCount;
    }

    public String getCellValue(Object spreadsheet, int row, int column) {
        return Excel.getCellValue((ExcelInfo)spreadsheet, row, column);
    }

    public void deleteRow(Object spreadsheet, int row) {
        new Excel().deleteRow((ExcelInfo)spreadsheet, row);
    }

    public void deleteRows(Object spreadsheet, String rows) {
        new Excel().deleteRows((ExcelInfo)spreadsheet, rows);
    }

    public void setCellValue(Object spreadsheet, String value, int row, int column, String datatype) {
        Excel.setCellValue((ExcelInfo)spreadsheet, value, row, column, datatype);
    }

    public Struct getCellComment(Object spreadsheet, int row, int column) {
        return Excel.getCellComment((ExcelInfo)spreadsheet, row, column);
    }

    public void setCellFormula(Object spreadsheet, String formula, int row, int column) {
        new Excel().setCellFormula((ExcelInfo)spreadsheet, formula, row, column);
    }

    public void setCellComment(Object spreadsheet, Struct comment, int row, int column) {
        new Excel().setCellComment((ExcelInfo)spreadsheet, comment, row, column);
    }

    public ArrayList<Struct> getCellFormula(Object spreadsheet) {
        return new Excel().getCellFormula((ExcelInfo)spreadsheet);
    }

    public String getCellFormula(Object spreadsheet, int row, int column) {
        return new Excel().getCellFormula((ExcelInfo)spreadsheet, row, column);
    }

    public void formatCellRange(Object spreadsheet, Struct format, int startRow, int startColumn, int endRow, int endColumn) {
        Excel.formatCellRange((ExcelInfo)spreadsheet, format, startRow, startColumn, endRow, endColumn);
    }

    public void addColumn(Object spreadsheet, String data, String datatype) {
        Excel.addColumn((ExcelInfo)spreadsheet, data, datatype);
    }

    public void formatColumn(Object spreadsheet, Struct format, int column) {
        Excel.formatColumn((ExcelInfo)spreadsheet, format, column);
    }

    public void formatColumns(Object spreadsheet, Struct format, String columns) {
        Excel.formatColumns((ExcelInfo)spreadsheet, format, columns);
    }

    public void formatCell(Object spreadsheet, Struct format, int row, int column) {
        Excel.formatCell((ExcelInfo)spreadsheet, format, row, column);
    }

    public void shiftColumns(Object spreadsheet, int start, int end, int columns) {
        Excel.shiftColumns((ExcelInfo)spreadsheet, start, end, columns);
    }

    public void shiftRows(Object spreadsheet, int start, int rows) {
        Excel.shiftRows((ExcelInfo)spreadsheet, start, rows);
    }

    public void formatRow(Object spreadsheet, Struct format, int row) {
        Excel.formatRow((ExcelInfo)spreadsheet, format, row);
    }

    public void formatRows(Object spreadsheet, Struct format, String rows) {
        Excel.formatRows((ExcelInfo)spreadsheet, format, rows);
    }

    public void addFreezePane(Object spreadsheet, int freezeColumn, int freezeRow, int column, int row) {
        Excel.addFreezePane((ExcelInfo)spreadsheet, freezeColumn, freezeRow, column, row);
    }

    public void addSplitPane(Object spreadsheet, int col, int row, int splitColumn, int splitRow, String position) {
        Excel.addSplitPane((ExcelInfo)spreadsheet, col, row, splitColumn, splitRow, position);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object createNewSpreadsheet(String sheetname, Object isXmlformat) {
        Excel excel = null;
        if (CFPage.IsBoolean((Object)isXmlformat)) {
            boolean isXSSF = Cast._boolean((Object)isXmlformat);
            excel = isXSSF ? new Excel(sheetname, "XSSF") : new Excel(sheetname, "HSSF");
            return excel.getExcelInfo();
        } else {
            if (!(isXmlformat instanceof String)) throw new SpreadSheetTag.InvalidExcelFormatException();
            if (((String)isXmlformat).equalsIgnoreCase("XSSF")) {
                excel = new Excel(sheetname, "XSSF");
                return excel.getExcelInfo();
            } else {
                if (!((String)isXmlformat).equalsIgnoreCase("HSSF")) throw new SpreadSheetTag.InvalidExcelFormatException();
                excel = new Excel(sheetname, "HSSF");
            }
        }
        return excel.getExcelInfo();
    }

    private static String[] handleCFPrimitivesToString(Array arr) {
        String[] strArray = new String[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            Object value = arr.get(i);
            strArray[i] = value instanceof Number || value instanceof Boolean || value instanceof CFBoolean ? Cast._String((Object)value) : (String)value;
        }
        return strArray;
    }

    private String populateTable(ArrayList<String[]> values, String[] header) {
        ListIterator<String[]> iter = values.listIterator();
        String htmlString = "";
        if (header != null && header.length > 0) {
            for (String s : header) {
                if (s.equalsIgnoreCase("")) continue;
                htmlString = htmlString + linesep + "<TH>" + s + "</TH>" + linesep;
            }
        }
        while (iter.hasNext()) {
            String[] row = iter.next();
            htmlString = htmlString + "<TR>" + linesep;
            for (int index = 0; index < row.length; ++index) {
                String val = row[index];
                if (val == null || val.equalsIgnoreCase("")) {
                    val = "&nbsp;";
                }
                htmlString = htmlString + "<TD>" + linesep + val + linesep + "</TD>" + linesep;
            }
            htmlString = htmlString + "</TR>" + linesep;
        }
        return htmlString;
    }
}

