/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graph.osgi.cache;

import coldfusion.graph.cache.InvalidCacheDirectoryException;
import coldfusion.graph.osgi.cache.ChartCacheEventListener;
import java.io.File;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.event.CacheEventListener;

public class InteractiveChartCacheManager {
    private static CacheManager cacheMgr = null;
    private String cachePath;
    private int cacheSize;
    private int timeToLive;
    private int cacheType;
    private static InteractiveChartCacheManager interactiveChartCacheManager = new InteractiveChartCacheManager();

    private InteractiveChartCacheManager() {
    }

    public static InteractiveChartCacheManager getInstance() {
        return interactiveChartCacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ehcache getChartsCache(String cacheName) {
        if (cacheMgr == null) {
            InteractiveChartCacheManager interactiveChartCacheManager = this;
            synchronized (interactiveChartCacheManager) {
                if (cacheMgr == null) {
                    Configuration cacheManagerConfig = new Configuration();
                    CacheConfiguration config = new CacheConfiguration();
                    cacheManagerConfig.setName(cacheName);
                    config.setName(cacheName);
                    config.setOverflowToDisk(true);
                    config.setDiskPersistent(true);
                    DiskStoreConfiguration diskStoreConfig = cacheManagerConfig.getDiskStoreConfiguration();
                    if (diskStoreConfig == null) {
                        diskStoreConfig = new DiskStoreConfiguration();
                        cacheManagerConfig.diskStore(diskStoreConfig);
                    }
                    diskStoreConfig.path(this.cachePath);
                    config.setMaxEntriesLocalHeap(1L);
                    config.setMaxEntriesLocalDisk((long)this.cacheSize);
                    config.setTimeToLiveSeconds((long)this.timeToLive);
                    cacheManagerConfig.addCache(config);
                    cacheMgr = new CacheManager(cacheManagerConfig);
                }
            }
        }
        Ehcache cache = null;
        if (cacheMgr != null) {
            cache = cacheMgr.getEhcache(cacheName);
            cache.getCacheEventNotificationService().registerListener((CacheEventListener)new ChartCacheEventListener());
        }
        return cache;
    }

    public void closeCacheMgr() {
        if (cacheMgr != null) {
            cacheMgr.shutdown();
        }
    }

    public void setCachePath(String cacheDir) {
        File f = new File(cacheDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!f.exists() || !f.isDirectory()) {
            throw new InvalidCacheDirectoryException(cacheDir);
        }
        this.cachePath = cacheDir;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(int cacheType) {
        this.cacheType = cacheType;
    }
}

