/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.azure.servicebus.metadata;

import coldfusion.cloud.azure.servicebus.metadata.SBSubscriptionProperties;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.CFBooleanValidator;
import coldfusion.cloud.validator.DurationFormatValidator;
import coldfusion.cloud.validator.EnumValidator;
import coldfusion.cloud.validator.IntegerRangeValidator;
import coldfusion.cloud.validator.NonEmptyStringValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.runtime.Cast;
import coldfusion.runtime.JSONUtils;
import com.microsoft.azure.servicebus.management.EntityStatus;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SBSubscriptionMetadata {
    static SBSubscriptionMetadata instance = null;
    ConsumerMap<SBSubscriptionProperties> consumerMap = new ConsumerMap();
    String[] allowedValues = new String[]{"Active", "Disabled", "SendDisabled", "ReceiveDisabled", "Unknown"};
    Set<String> allowedEntityStatusValues = new HashSet<String>(Arrays.asList(this.allowedValues));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SBSubscriptionMetadata getInstance() {
        if (instance != null) return instance;
        Class<SBSubscriptionMetadata> clazz = SBSubscriptionMetadata.class;
        synchronized (SBSubscriptionMetadata.class) {
            instance = new SBSubscriptionMetadata();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SBSubscriptionMetadata() {
        this.consumerMap.put((Object)"entityStatus", new ConsumerValidator((filler, val) -> {
            String status;
            switch (status = FieldTypecastUtil.INSTANCE.getStringProperty(val)) {
                case "Active": {
                    filler.setEntityStatus(EntityStatus.Active);
                    break;
                }
                case "Disabled": {
                    filler.setEntityStatus(EntityStatus.Disabled);
                    break;
                }
                case "SendDisabled": {
                    filler.setEntityStatus(EntityStatus.SendDisabled);
                    break;
                }
                case "ReceiveDisabled": {
                    filler.setEntityStatus(EntityStatus.ReceiveDisabled);
                    break;
                }
                case "Unknown": {
                    filler.setEntityStatus(EntityStatus.Unknown);
                    break;
                }
            }
        }, Arrays.asList(new EnumValidator(this.allowedEntityStatusValues, "entityStatus"))));
        this.consumerMap.put((Object)"autoDeleteOnIdle", new ConsumerValidator((filler, val) -> filler.setAutoDeleteOnIdle(FieldTypecastUtil.INSTANCE.getDurationProperty(val)), Arrays.asList(DurationFormatValidator.INSTANCE)));
        this.consumerMap.put((Object)"defaultMessageTimeToLive", new ConsumerValidator((filler, val) -> filler.setDefaultMessageTimeToLive(FieldTypecastUtil.INSTANCE.getDurationProperty(val)), Arrays.asList(DurationFormatValidator.INSTANCE)));
        this.consumerMap.put((Object)"enableBatchedOperations", new ConsumerValidator((filler, val) -> filler.setEnableBatchedOperations(FieldTypecastUtil.INSTANCE.getBooleanProperty(val)), Arrays.asList(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"enableDeadLetteringOnMessageExpiration", new ConsumerValidator((filler, val) -> filler.setEnableDeadletteringOnMessageExpiration(FieldTypecastUtil.INSTANCE.getBooleanProperty(val)), Arrays.asList(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"enableDeadLetteringOnFilterEvaluationException", new ConsumerValidator((filler, val) -> filler.setEnableDeadletteringOnFilterEvaluationException(FieldTypecastUtil.INSTANCE.getBooleanProperty(val)), Arrays.asList(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"forwardTo", new ConsumerValidator((filler, val) -> filler.setForwardTo(FieldTypecastUtil.INSTANCE.getStringProperty(val)), Arrays.asList(NonEmptyStringValidator.INSTANCE)));
        this.consumerMap.put((Object)"forwardDeadLetteredMessagesTo", new ConsumerValidator((filler, val) -> filler.setForwardDeadLetteredMessagesTo(FieldTypecastUtil.INSTANCE.getStringProperty(val)), Arrays.asList(NonEmptyStringValidator.INSTANCE)));
        this.consumerMap.put((Object)"lockDuration", new ConsumerValidator((filler, val) -> filler.setLockDuration(FieldTypecastUtil.INSTANCE.getDurationProperty(val)), Arrays.asList(DurationFormatValidator.INSTANCE)));
        this.consumerMap.put((Object)"maxDeliveryCount", new ConsumerValidator((filler, val) -> filler.setMaxDeliveryCount(FieldTypecastUtil.INSTANCE.getIntegerProperty(val)), Arrays.asList(new IntegerRangeValidator("maxDeliveryCount", Integer.valueOf(1), null))));
        this.consumerMap.put((Object)"userMetadata", new ConsumerValidator((filler, val) -> {
            if (this.isStruct(val)) {
                filler.setUserMetadata(JSONUtils.serializeJSON((Object)val));
            } else {
                filler.setUserMetadata(FieldTypecastUtil.INSTANCE.getStringProperty(val));
            }
        }, null));
        this.consumerMap.put((Object)"subscriptionName", new ConsumerValidator((filler, val) -> filler.setSubscriptionName(FieldTypecastUtil.INSTANCE.getStringProperty(val)), Arrays.asList(NotNullValidator.INSTANCE, NonEmptyStringValidator.INSTANCE)));
    }

    public ConsumerMap<SBSubscriptionProperties> getConsumerMap() {
        return this.consumerMap;
    }

    public void setConsumerMap(ConsumerMap<SBSubscriptionProperties> consumerMap) {
        this.consumerMap = consumerMap;
    }

    private boolean isStruct(Object obj) {
        try {
            Cast._Map((Object)obj);
        }
        catch (Throwable ex) {
            return false;
        }
        return true;
    }
}

