/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.zip;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ExpressionException;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.io.InvalidCharsetException;
import coldfusion.tagext.zip.ZipEntryTable;
import coldfusion.tagext.zip.ZipFilter;
import coldfusion.tagext.zip.ZipParam;
import coldfusion.util.IOUtils;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTag;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.io.ZipOutputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;

public class ZipTag
extends GenericTag
implements BodyTag {
    public static final String LIST = "list";
    public static final String ZIP = "zip";
    public static final String UNZIP = "unzip";
    public static final String DELETE = "delete";
    public static final String READ = "read";
    public static final String READBINARY = "readBinary";
    public static final String ENC_AES_256 = "aes-256";
    public static final String ENC_AES_128 = "aes-128";
    public static final String ENC_STANDARD = "standard";
    public static final String DEFAULT_ENC = "aes-256";
    private String action = "zip";
    private String file;
    private String name;
    private String source;
    private String destination;
    private String filter;
    private boolean recurse = true;
    private String prefix;
    private String entrypath;
    private boolean showDirectory = false;
    private boolean overwrite = false;
    private List zipParams;
    private ZipParameters zipParameters = new ZipParameters();
    private ZipFilter zipFilter;
    private String variable;
    private String charset = RuntimeService.defaultFileCharset;
    private boolean storepath = true;
    private String password;
    private String encryptionAlgorithm;
    private int maxUnzipRatio = -1;

    public void setAction(String action) {
        this.action = action.trim();
    }

    public String getAction() {
        return this.action;
    }

    public void setFile(String file) {
        if ((file = file.trim()).length() == 0) {
            throw new InvalidFileException(file);
        }
        this.file = Utils.getFileFullPath((String)file, (PageContext)this.pageContext);
    }

    public String getFile() {
        return this.file;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setSource(String source) {
        if (!VFSFileFactory.getFileObject((String)(source = source.trim())).exists()) {
            throw new InvalidSourceException(source);
        }
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setDestination(String destination) {
        this.destination = Utils.getFileFullPath((String)destination.trim(), (PageContext)this.pageContext);
    }

    public String getDestination() {
        return this.destination;
    }

    public void setFilter(String filter) {
        this.filter = filter.trim();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix.trim();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setEntrypath(String entrypath) {
        this.entrypath = entrypath.trim();
    }

    public String getEntrypath() {
        return this.entrypath;
    }

    public void setShowDirectory(boolean showDirectory) {
        this.showDirectory = showDirectory;
    }

    public boolean isShowDirectory() {
        return this.showDirectory;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable.trim();
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        if ((charset = charset.trim()).length() > 0) {
            try {
                Charset.forName(charset);
            }
            catch (Exception e) {
                throw new InvalidCharsetException(charset);
            }
            this.charset = charset;
        }
    }

    public boolean isStorepath() {
        return this.storepath;
    }

    public void setStorepath(boolean storepath) {
        this.storepath = storepath;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public int getMaxUnzipRatio() {
        return this.maxUnzipRatio;
    }

    public void setMaxUnzipRatio(int maxUnzipRatio) {
        if (maxUnzipRatio < 1) {
            throw new InvalidUnzipRatioException();
        }
        this.maxUnzipRatio = maxUnzipRatio;
    }

    public void addZipParams(ZipParam zipParam) {
        if (this.zipParams == null) {
            this.zipParams = new ArrayList();
        }
        this.zipParams.add(zipParam);
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        if (this.entryOperation()) {
            if (READ.equalsIgnoreCase(this.action)) {
                this.read();
            } else if (READBINARY.equalsIgnoreCase(this.action)) {
                this.readBinary();
            }
            return 0;
        }
        this.zipFilter = new ZipFilter(this.filter, this.entrypath, this.recurse);
        return 2;
    }

    private boolean entryOperation() {
        return READ.equalsIgnoreCase(this.action) || READBINARY.equalsIgnoreCase(this.action);
    }

    public int doEndTag() throws JspException {
        if (LIST.equalsIgnoreCase(this.action)) {
            this.listZip();
        } else if (ZIP.equalsIgnoreCase(this.action)) {
            File zipFile = VFSFileFactory.getFileObject((String)this.file);
            if (!this.overwrite && zipFile.exists()) {
                this.updateZip();
            } else {
                this.createZip();
            }
        } else if (UNZIP.equalsIgnoreCase(this.action)) {
            this.extract();
        } else if (DELETE.equalsIgnoreCase(this.action)) {
            this.deleteEntries();
        }
        this.onTagEnd();
        return 6;
    }

    private boolean isZipFile() {
        boolean isSupported;
        block3: {
            isSupported = true;
            if (!VFSFileFactory.checkIfVFile((String)this.file)) {
                try {
                    new ZipFile(this.file);
                }
                catch (Exception e) {
                    if (!(e instanceof net.lingala.zip4j.exception.ZipException)) break block3;
                    isSupported = false;
                }
            }
        }
        return isSupported;
    }

    private void listZip() {
        if (!this.isZipFile()) {
            throw new ZipUnsupportedFormatException(this.action, this.file);
        }
        ZipEntryTable zipEntryTable = new ZipEntryTable(false);
        try {
            List fileHeaderList = this.createZipFileObject(this.file).getFileHeaders();
            for (FileHeader entry : fileHeaderList) {
                if (entry.isDirectory() && !this.isShowDirectory() || this.matchesFilter(entry) == null) continue;
                zipEntryTable.addEntry(entry);
            }
            this.pageContext.setAttribute(this.name, (Object)zipEntryTable);
        }
        catch (Exception e) {
            throw new ZipException(e, LIST, this.file);
        }
    }

    private ZipFile createZipFileObject(String filePath) {
        File file = VFSFileFactory.getFileObject((String)filePath);
        return this.createZipFileObject(file);
    }

    private ZipFile createZipFileObject(File file) {
        try {
            if (file instanceof VFile) {
                return new ZipFile((File)new net.lingala.zip4j.io.VFile(((VFile)file).getFileObject()));
            }
            return new ZipFile(file);
        }
        catch (net.lingala.zip4j.exception.ZipException e) {
            throw new ZipException((Exception)((Object)e), this.action, file.getPath());
        }
    }

    private void createZip() {
        File parent;
        ZipOutputStream zos = null;
        File zipFile = VFSFileFactory.getFileObject((String)this.file);
        if (zipFile.exists()) {
            zipFile.delete();
        }
        if ((parent = zipFile.getParentFile()) == null || !parent.exists()) {
            throw new InvalidFileException(this.file);
        }
        try {
            Map entriesVsFileMap = this.getEntriesVsFileMap();
            if (entriesVsFileMap.size() == 0) {
                throw new EmptyZipFileException();
            }
            zos = new ZipOutputStream(VFSFileFactory.getOutputStream((String)this.file));
            this.writeEntriesToZip(entriesVsFileMap, zos);
            zos.finish();
        }
        catch (IOException ioe) {
            throw new ZipException(ioe, ZIP, this.file);
        }
        catch (net.lingala.zip4j.exception.ZipException e) {
            throw new ZipException((Exception)((Object)e), ZIP, this.file);
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void updateZip() {
        if (!this.isZipFile()) {
            throw new ZipUnsupportedFormatException(this.action, this.file);
        }
        try {
            Map entriesVsFileMap = this.getEntriesVsFileMap();
            ZipFile sourceZipFile = this.createZipFileObject(this.file);
            this.writeEntriesToZip(entriesVsFileMap, sourceZipFile);
        }
        catch (IOException e) {
            throw new ZipException(e, ZIP, this.file);
        }
        catch (net.lingala.zip4j.exception.ZipException e) {
            throw new ZipException((Exception)((Object)e), ZIP, this.file);
        }
    }

    private OutputStream getTempOutputStream(final File tempFile) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return VFSFileFactory.getOutputStream((File)tempFile);
        }
        try {
            return (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return VFSFileFactory.getOutputStream((File)tempFile);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    private void extract() {
        if (!this.isZipFile()) {
            throw new ZipUnsupportedFormatException(this.action, this.file);
        }
        File destDir = VFSFileFactory.getFileObject((String)this.destination);
        if (!destDir.exists() || destDir.isFile()) {
            throw new InvalidDestinationException(destDir.getAbsolutePath());
        }
        try {
            ZipFile sourceZipFile = this.createZipFileObject(this.file);
            List fileHeaderList = sourceZipFile.getFileHeaders();
            ArrayList<Exception> extractExceptions = new ArrayList<Exception>();
            String canonicalDestinationDirPath = destDir.getCanonicalPath();
            long permissibleFileSize = this.getPermissibleFileSize(VFSFileFactory.getFileObject((String)this.file).length());
            long currentSize = 0L;
            String parentDir = null;
            ArrayList<File> extractedFileList = new ArrayList<File>();
            for (FileHeader entry : fileHeaderList) {
                String canonicalDestinationFile;
                ZipParam zipParam = this.matchesFilter(entry);
                if (zipParam == null) continue;
                String name = entry.getFileName();
                File dest = VFSFileFactory.getFileObject((File)destDir, (String)name);
                if (!this.storepath) {
                    dest = VFSFileFactory.getFileObject((File)destDir, (String)dest.getName());
                }
                if (!(canonicalDestinationFile = dest.getCanonicalPath()).startsWith(canonicalDestinationDirPath + File.separator)) {
                    throw new InvalidZipEntryException(name);
                }
                if (parentDir == null) {
                    parentDir = dest.getCanonicalPath();
                }
                if (!this.overwrite && dest.exists()) continue;
                if (entry.isDirectory()) {
                    dest.mkdirs();
                    continue;
                }
                File parent = dest.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                if (zipParam.getPassword() != null) {
                    entry.setPassword(zipParam.getPassword().toCharArray());
                }
                if (destDir instanceof VFile) {
                    destDir = new net.lingala.zip4j.io.VFile(((VFile)destDir).getFileObject());
                }
                try {
                    if (this.storepath) {
                        sourceZipFile.extractFile(entry, destDir);
                    } else {
                        sourceZipFile.extractFile(entry, destDir, null, dest.getName());
                    }
                    extractedFileList.add(dest);
                    if ((currentSize += dest.length()) <= permissibleFileSize) continue;
                    break;
                }
                catch (Exception e) {
                    extractExceptions.add(e);
                }
            }
            if (currentSize > permissibleFileSize) {
                for (File f : extractedFileList) {
                    if (!f.exists()) continue;
                    f.delete();
                }
                this.deleteEmptyFolders(parentDir);
                throw new ZipLimitException(this.file, permissibleFileSize);
            }
            if (extractExceptions.size() > 0) {
                throw new ZipExtractException(this.file, extractExceptions);
            }
        }
        catch (IOException | net.lingala.zip4j.exception.ZipException e) {
            throw new ZipException((Exception)e, UNZIP, this.file);
        }
    }

    private void deleteEmptyFolders(String directory) throws IOException {
        File f = new File(directory);
        if (f.exists()) {
            File[] children;
            for (File child : children = f.listFiles()) {
                if (!child.isDirectory()) continue;
                this.deleteEmptyFolders(child.getCanonicalPath());
            }
            if (f.isDirectory()) {
                f.delete();
            }
        }
    }

    private long getPermissibleFileSize(long length) {
        if (this.getMaxUnzipRatio() > 0) {
            return (long)this.getMaxUnzipRatio() * length;
        }
        if (FusionContext.getApplicationSettings() != null) {
            return (long)FusionContext.getApplicationSettings().getMaxUnzipRatio() * length;
        }
        return (long)ServiceFactory.getRuntimeService().getMaxUnzipRatio() * length;
    }

    private void read() {
        byte[] bytes = this.readZipEntry();
        try {
            String content = new String(bytes, this.charset);
            this.pageContext.setAttribute(this.variable, (Object)content);
        }
        catch (UnsupportedEncodingException e) {
            throw new ZipException(e, this.action, this.file);
        }
    }

    private byte[] readZipEntry() {
        if (VFSFileFactory.checkIfVFile((String)this.file)) {
            return this.readZipEntryFromVFile();
        }
        ZipFile zip = null;
        InputStream in = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            zip = new ZipFile(this.file);
            String pathStr = this.entrypath.replace('\\', '/');
            FileHeader entry = zip.getFileHeader(pathStr);
            if (entry == null) {
                throw new ZipEntryNotFoundException(this.entrypath);
            }
            if (this.password != null) {
                entry.setPassword(this.password.toCharArray());
            }
            in = zip.getInputStream(entry);
            IOUtils.write((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new ZipException(e, this.action, this.file);
        }
        catch (net.lingala.zip4j.exception.ZipException e) {
            throw new ZipException((Exception)((Object)e), this.action, this.file);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return out.toByteArray();
    }

    private byte[] readZipEntryFromVFile() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ZipFile sourceZipFile = this.createZipFileObject(this.file);
            List fileHeaderList = sourceZipFile.getFileHeaders();
            String pathStr = this.entrypath.replace('\\', '/');
            boolean found = false;
            for (FileHeader entry : fileHeaderList) {
                if (!entry.getFileName().equals(pathStr)) continue;
                found = true;
                if (this.password != null) {
                    entry.setPassword(this.password.toCharArray());
                }
                IOUtils.write((InputStream)sourceZipFile.getInputStream(entry), (OutputStream)out);
            }
            if (!found) {
                throw new ZipEntryNotFoundException(this.entrypath);
            }
        }
        catch (IOException e) {
            throw new ZipException(e, this.action, this.file);
        }
        catch (net.lingala.zip4j.exception.ZipException e) {
            throw new ZipException((Exception)((Object)e), this.action, this.file);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
        return out.toByteArray();
    }

    private void readBinary() {
        byte[] content = this.readZipEntry();
        this.pageContext.setAttribute(this.variable, (Object)content);
    }

    private void deleteEntries() {
        if (!this.isZipFile()) {
            throw new ZipUnsupportedFormatException(this.action, this.file);
        }
        try {
            ZipFile sourceZipFile = this.createZipFileObject(this.file);
            List fileHeaderList = sourceZipFile.getFileHeaders();
            int entryCount = 0;
            ArrayList<FileHeader> deleteFileHeaderList = new ArrayList<FileHeader>();
            for (FileHeader entry : fileHeaderList) {
                if (this.matchesFilter(entry) != null) {
                    deleteFileHeaderList.add(entry);
                    continue;
                }
                ++entryCount;
            }
            if (entryCount == 0) {
                throw new DeleteAllEntriesException();
            }
            sourceZipFile.removeFiles(deleteFileHeaderList);
        }
        catch (net.lingala.zip4j.exception.ZipException e) {
            throw new ZipException((Exception)((Object)e), DELETE, this.file);
        }
    }

    private void writeEntriesToZip(Map entriesVsFileMap, Object zos) throws IOException, net.lingala.zip4j.exception.ZipException {
        ArrayList fileList = new ArrayList(entriesVsFileMap.size());
        ArrayList parametersList = new ArrayList(entriesVsFileMap.size());
        ArrayList<File> filesToBeDeleted = new ArrayList<File>();
        for (String entryName : entriesVsFileMap.keySet()) {
            ZipParam entry = (ZipParam)entriesVsFileMap.get(entryName);
            File entryFile = entry.getFile();
            if (entryFile != null) {
                if (entryFile.isDirectory()) {
                    ZipParameters zipParams = new ZipParameters();
                    int lastSlashIndex = entryName.substring(0, entryName.length() - 1).lastIndexOf("/");
                    if (lastSlashIndex != -1) {
                        String folderPathInZip = entryName.substring(0, lastSlashIndex);
                        zipParams.setRootFolderInZip(folderPathInZip);
                    }
                    this.writeEntryToZip(zos, entryFile, zipParams, fileList, parametersList);
                    continue;
                }
                this.writeEntryToZip(zos, entryFile, this.getEntryParameters(entryName, entry), fileList, parametersList);
                continue;
            }
            byte[] content = entry.getContentBytes();
            File tempFile = this.getTempFile();
            OutputStream outputStream = this.getTempOutputStream(tempFile);
            outputStream.write(content);
            outputStream.close();
            ZipParameters zipParams = this.getEntryParameters(entryName, entry);
            zipParams.setSourceExternalStream(true);
            zipParams.setFileNameInZip(entryName);
            this.writeEntryToZip(zos, tempFile, zipParams, fileList, parametersList);
            filesToBeDeleted.add(tempFile);
        }
        if (zos instanceof ZipFile) {
            ((ZipFile)zos).addFiles(fileList, parametersList);
        }
        this.deleteTempFiles(filesToBeDeleted);
    }

    private void writeEntryToZip(Object zos, File entryFile, ZipParameters zipParams, ArrayList fileList, ArrayList parametersList) {
        try {
            Object inputStream = null;
            if (zos instanceof ZipFile) {
                fileList.add(entryFile);
                parametersList.add(zipParams);
            } else if (zos instanceof ZipOutputStream) {
                ((ZipOutputStream)zos).putNextEntry(entryFile, zipParams);
                this.writeZipEntry(entryFile, (ZipOutputStream)zos);
                ((ZipOutputStream)zos).closeEntry();
            }
        }
        catch (net.lingala.zip4j.exception.ZipException e) {
            throw new ZipException((Exception)((Object)e), ZIP, this.file);
        }
        catch (Exception e) {
            throw new ZipException(e, ZIP, this.file);
        }
    }

    private ZipParameters getEntryParameters(String entryName, ZipParam entry) {
        ZipParameters zipParams = new ZipParameters();
        File entryFile = entry.getFile();
        if (entryFile != null) {
            int lastSlashIndex = entryName.lastIndexOf("/");
            if (lastSlashIndex != -1) {
                String folderPathInZip = entryName.substring(0, lastSlashIndex);
                zipParams.setRootFolderInZip(folderPathInZip);
                if (entryName.length() > lastSlashIndex + 1) {
                    zipParams.setFileNameInZip(entryName.substring(lastSlashIndex + 1));
                }
            } else {
                zipParams.setFileNameInZip(entryName);
            }
        }
        zipParams.setCompressionMethod(8);
        zipParams.setCompressionLevel(5);
        String password = entry.getPassword();
        if (password != null && !password.equals("")) {
            zipParams.setPassword(entry.getPassword());
            zipParams.setEncryptFiles(true);
            String encryptionMethod = entry.getEncryptionAlgorithm();
            this.setEncryptionEntryParameters(zipParams, encryptionMethod);
        }
        return zipParams;
    }

    private void setEncryptionEntryParameters(ZipParameters zipParams, String encryptionMethod) {
        if (encryptionMethod == null) {
            encryptionMethod = "aes-256";
        }
        if (encryptionMethod.equalsIgnoreCase(ENC_STANDARD)) {
            zipParams.setEncryptionMethod(0);
        } else if (encryptionMethod.equalsIgnoreCase(ENC_AES_128)) {
            zipParams.setEncryptionMethod(99);
            zipParams.setAesKeyStrength(1);
        } else if (encryptionMethod.equalsIgnoreCase("aes-256")) {
            zipParams.setEncryptionMethod(99);
            zipParams.setAesKeyStrength(3);
        } else {
            throw new InvalidEncryptionAlgorithm(encryptionMethod);
        }
    }

    private Map getEntriesVsFileMap() throws UnsupportedEncodingException {
        if (this.prefix != null && this.prefix.length() > 0) {
            this.prefix = this.prefix.replace('\\', '/');
            if (this.prefix.charAt(this.prefix.length() - 1) != '/') {
                this.prefix = this.prefix + "/";
            }
        }
        HashMap<String, ZipParam> entriesFileMap = new HashMap<String, ZipParam>();
        if (this.zipParams == null) {
            if (this.source == null) {
                throw new NoSourceSpecifiedException();
            }
            if (this.source.length() == 0 || !VFSFileFactory.getFileObject((String)this.source).exists()) {
                throw new InvalidSourceException(this.source);
            }
            this.populateEntriesFileMap(this.source, null, this.prefix, this.password, this.encryptionAlgorithm, this.zipFilter, entriesFileMap);
            return entriesFileMap;
        }
        for (int i = 0; i < this.zipParams.size(); ++i) {
            ZipParam zipParam = (ZipParam)this.zipParams.get(i);
            if (zipParam.getContent() != null) {
                ZipParam zipEntry = new ZipParam();
                zipEntry.setContent(zipParam.getContentBytes());
                zipEntry.setPassword(zipParam.getPassword());
                zipEntry.setEncryptionAlgorithm(zipParam.getEncryptionAlgorithm());
                entriesFileMap.put(zipParam.getEntrypath(), zipEntry);
                continue;
            }
            this.populateEntriesFileMap(zipParam.getSource(), zipParam.getEntrypath(), zipParam.getPrefix(), zipParam.getPassword(), zipParam.getEncryptionAlgorithm(), zipParam.getZipFilter(), entriesFileMap);
        }
        return entriesFileMap;
    }

    private void populateEntriesFileMap(String file, String path, String prefix, String password, String encryptionAlgorithm, ZipFilter zipFilter, Map entriesFileMap) {
        File srcFile = VFSFileFactory.getFileObject((String)file);
        if (srcFile.isFile()) {
            String entryName = this.storepath ? (path != null ? path : (prefix == null ? srcFile.getName() : prefix + srcFile.getName())) : srcFile.getName();
            entryName = entryName.replace('\\', '/');
            ZipParam zipEntry = new ZipParam();
            zipEntry.setFile(srcFile);
            zipEntry.setPassword(password);
            zipEntry.setEncryptionAlgorithm(encryptionAlgorithm);
            entriesFileMap.put(entryName, zipEntry);
            return;
        }
        this.listFiles(srcFile, srcFile, prefix, password, encryptionAlgorithm, entriesFileMap, zipFilter);
    }

    private String getEntryName(File file, File rootFile, String prefix) {
        String root;
        String filePath = file.getAbsolutePath();
        String entryName = filePath.substring((root = rootFile.getAbsolutePath()).length());
        if (entryName.charAt(0) == File.separatorChar) {
            entryName = entryName.substring(1);
        }
        if (prefix != null) {
            entryName = prefix + entryName;
        }
        entryName = entryName.replace('\\', '/');
        return entryName;
    }

    private void listFiles(File dir, File rootFile, String prefix, String password, String encryptionAlgorithm, Map entriesFileMap, ZipFilter filter) {
        File[] files = dir.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            File file1 = files[i];
            ZipParam zipEntry = new ZipParam();
            zipEntry.setFile(file1);
            if (file1.isFile()) {
                zipEntry.setPassword(password);
                zipEntry.setEncryptionAlgorithm(encryptionAlgorithm);
                if (this.storepath) {
                    entriesFileMap.put(this.getEntryName(file1, rootFile, prefix), zipEntry);
                    continue;
                }
                entriesFileMap.put(file1.getName(), zipEntry);
                continue;
            }
            if (this.storepath) {
                String entryName = this.getEntryName(file1, rootFile, prefix);
                if (!entryName.endsWith("/")) {
                    entryName = entryName + "/";
                }
                entriesFileMap.put(entryName, zipEntry);
                this.listFiles(file1, rootFile, prefix, password, encryptionAlgorithm, entriesFileMap, filter);
                continue;
            }
            if (!file1.isDirectory() || this.storepath) continue;
            entriesFileMap.put(file1.getName(), zipEntry);
            this.listFiles(file1, rootFile, prefix, password, encryptionAlgorithm, entriesFileMap, filter);
        }
    }

    private File getTempFile() {
        final String tmpDir = Utils.getTempDir((PageContext)this.pageContext);
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    return new File(ZipTag.this._getTempFile(tmpDir, "~zip"));
                }
            }, null, new FilePermission(tmpDir + "-", "read,write"));
        }
        return new File(this._getTempFile(tmpDir, "~zip"));
    }

    private String _getTempFile(String dir, String prefix) {
        File tmpDir = new File(dir);
        try {
            if (prefix == null) {
                prefix = "cftmp";
            } else if (prefix.length() < 3) {
                prefix = prefix + "tmp";
            }
            return File.createTempFile(prefix, null, tmpDir).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new RuntimeWrapper((Throwable)ex);
        }
    }

    private void writeZipEntry(final File entryFile, final ZipOutputStream zos) throws Exception {
        if (System.getSecurityManager() == null) {
            if (!entryFile.isDirectory()) {
                this._writeZipEntry(entryFile, zos);
            }
        } else {
            String tmpDir = Utils.getTempDir((PageContext)this.pageContext);
            if (AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return entryFile.isDirectory();
                }
            }).booleanValue()) {
                return;
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws FileNotFoundException, IOException {
                        ZipTag.this._writeZipEntry(entryFile, zos);
                        return null;
                    }
                }, null, new FilePermission(tmpDir + "-", "read,write"));
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
    }

    private void _writeZipEntry(File entryFile, ZipOutputStream zos) throws FileNotFoundException, IOException {
        try (InputStream inputStream = VFSFileFactory.getInputStream((File)entryFile);){
            byte[] readBuff = new byte[4096];
            int readLen = -1;
            while ((readLen = inputStream.read(readBuff)) != -1) {
                zos.write(readBuff, 0, readLen);
            }
        }
    }

    private void deleteTempFiles(final List filesToBeDeleted) {
        if (System.getSecurityManager() == null) {
            for (Object tempFile : filesToBeDeleted) {
                ((File)tempFile).delete();
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    for (Object tempFile : filesToBeDeleted) {
                        ((File)tempFile).delete();
                    }
                    return null;
                }
            });
        }
    }

    private ZipParam matchesFilter(FileHeader zipEntry) {
        if (this.zipParams == null) {
            if (this.zipFilter.accept(zipEntry)) {
                ZipParam zipParam = new ZipParam();
                zipParam.setPassword(this.password);
                zipParam.setEncryptionAlgorithm(this.encryptionAlgorithm);
                return zipParam;
            }
            return null;
        }
        for (int i = 0; i < this.zipParams.size(); ++i) {
            ZipParam zipParam = (ZipParam)this.zipParams.get(i);
            if (!zipParam.getZipFilter().accept(zipEntry)) continue;
            return zipParam;
        }
        return null;
    }

    public void release() {
        this.action = ZIP;
        this.file = null;
        this.name = null;
        this.source = null;
        this.destination = null;
        this.filter = null;
        this.recurse = true;
        this.prefix = null;
        this.entrypath = null;
        this.showDirectory = false;
        this.overwrite = false;
        this.zipParams = null;
        this.zipParameters = null;
        this.zipFilter = null;
        this.variable = null;
        this.password = null;
        this.encryptionAlgorithm = null;
        super.release();
    }

    public static class InvalidZipEntryException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private final String entry;

        public InvalidZipEntryException(String entry) {
            this.entry = entry;
        }

        public String getEntry() {
            return this.entry;
        }
    }

    public static class DeleteAllEntriesException
    extends ApplicationException {
    }

    public static class EmptyZipFileException
    extends ApplicationException {
    }

    public static class InvalidFileException
    extends ApplicationException {
        private String file;

        public InvalidFileException(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }

    public static class ZipEntryNotFoundException
    extends ApplicationException {
        private String path;

        public ZipEntryNotFoundException(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static class InvalidDestinationException
    extends ApplicationException {
        private String destination;

        public InvalidDestinationException(String destination) {
            this.destination = destination;
        }

        public String getDestination() {
            return this.destination;
        }
    }

    public static class NoSourceSpecifiedException
    extends ApplicationException {
    }

    public static class InvalidSourceException
    extends ApplicationException {
        private String source;

        public InvalidSourceException(String source) {
            this.source = source;
        }

        public String getSource() {
            return this.source;
        }
    }

    public static class ZipExtractException
    extends ApplicationException {
        private String zipFile;
        private List<Exception> exceptions;

        public ZipExtractException(String zipFile, List<Exception> exceptions) {
            this.zipFile = zipFile;
            this.exceptions = exceptions;
        }

        public String getDetail() {
            StringBuilder detail = new StringBuilder();
            detail.append("<ul>");
            for (Exception exception : this.exceptions) {
                Throwable cause = exception.getCause();
                if (cause == null) continue;
                detail.append("<li>").append(cause.getMessage()).append("</li>");
            }
            detail.append("</ul>");
            return detail.toString();
        }

        public String getZipFile() {
            return this.zipFile;
        }
    }

    public static class InvalidUnzipRatioException
    extends ApplicationException {
    }

    public static class ZipLimitException
    extends ApplicationException {
        private String zipFile;
        private double fileSizeLimit;
        private String unit;

        public ZipLimitException(String zipFile, long limit) {
            this.zipFile = zipFile;
            this.unit = "KB";
            this.fileSizeLimit = (double)limit / 1024.0;
            if ((int)limit / 1024 / 1024 > 1) {
                this.fileSizeLimit = (double)limit / 1024.0 / 1024.0;
                this.unit = "MB";
            }
            if ((int)limit / 1024 / 1024 / 1024 > 1) {
                this.fileSizeLimit = (double)limit / 1024.0 / 1024.0 / 1024.0;
                this.unit = "GB";
            }
        }

        public String getZipFile() {
            return this.zipFile;
        }

        public double getFileSizeLimit() {
            return this.fileSizeLimit;
        }

        public String getUnit() {
            return this.unit;
        }
    }

    public static class ZipUnsupportedFormatException
    extends ApplicationException {
        private String action;
        private String file;

        public ZipUnsupportedFormatException(String action, String file) {
            this.action = action;
            this.file = file;
        }

        public ZipUnsupportedFormatException(Exception e, String action, String file) {
            super((Throwable)e);
            this.action = action;
            this.file = file;
        }

        public String getAction() {
            return this.action;
        }

        public String getFile() {
            return this.file;
        }
    }

    public static class ZipException
    extends ApplicationException {
        private String action;
        private String file;

        public ZipException(Exception e, String action, String file) {
            super((Throwable)e);
            this.action = action;
            this.file = file;
        }

        public String getAction() {
            return this.action;
        }

        public String getFile() {
            return this.file;
        }
    }

    public class InvalidEncryptionAlgorithm
    extends ExpressionException {
        public String algo = null;

        InvalidEncryptionAlgorithm(String algo) {
            this.algo = algo;
        }
    }
}

