/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import java.util.StringTokenizer;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.parser.text.GlyphData;
import org.jpedal.parser.text.TD;
import org.jpedal.utils.NumberUtils;

final class Leading {
    static final float THOUSAND = 1000.0f;

    private Leading() {
    }

    private static float getLeading(byte[] stream, int ptr, int leadingStart, boolean isMultipleValues) {
        float value;
        int strt = leadingStart;
        strt = StreamReaderUtils.skipSpaces(stream, strt);
        if (isMultipleValues) {
            StringTokenizer values = new StringTokenizer(TD.getString(strt, strt + ptr - 1, stream));
            value = 0.0f;
            while (values.hasMoreTokens()) {
                value += Float.parseFloat(values.nextToken());
            }
            value = -value / 1000.0f;
        } else {
            value = -NumberUtils.parseFloat(strt, strt + ptr, stream) / 1000.0f;
        }
        return value;
    }

    static int readLeading(int i, byte[] stream, GlyphData glyphData) {
        float value = 0.0f;
        ++i;
        i = StreamReaderUtils.skipSpaces(stream, i);
        char nc = (char)stream[i];
        char rc = ' ';
        if (nc == '(' || nc == '<') {
            --i;
        } else if (nc != '\'' && nc != '\"' && nc != ']') {
            int ptr = 0;
            int leadingStart = i;
            boolean failed = false;
            boolean isMultipleValues = false;
            boolean isLastValue = false;
            while (!failed) {
                rc = nc;
                if (rc != '\n' && rc != '\r') {
                    ++ptr;
                }
                if ((nc = (char)stream[i + 1]) == ' ') {
                    isMultipleValues = true;
                }
                if (nc == ']') {
                    isLastValue = true;
                }
                if (nc == 40 || nc == 60 || nc == 93 || nc == '\n') break;
                if (nc != '-' && nc != '.' && nc != ' ' && (nc < '0' || nc > '9')) {
                    failed = true;
                }
                ++i;
            }
            if (failed) {
                i = leadingStart;
            } else if (isMultipleValues || ptr > 0) {
                value = Leading.getLeading(stream, ptr, leadingStart, isMultipleValues);
            }
            if (isLastValue && value == -glyphData.getWidth()) {
                glyphData.subtractLeading(value);
            }
        }
        glyphData.updateGlyphSettings(value, rc);
        return i;
    }
}

