/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.exception.PdfException;
import org.jpedal.io.EncryptionUsed;
import org.jpedal.io.ImageInputStreamFileBuffer;
import org.jpedal.io.NameLookup;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PageLabels;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.RandomAccessDataBuffer;
import org.jpedal.io.RandomAccessFileBuffer;
import org.jpedal.io.security.DecryptionFactory;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PageLookup;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class PdfObjectReader {
    private PdfFileReader objectReader = new PdfFileReader();
    private final Map<Integer, String> pagesReferences = new HashMap<Integer, String>();
    private PageLookup pageLookup = new PageLookup();
    private String tempFileName;
    private NameLookup nameLookup;
    private PageLabels pageLabels;
    private RandomAccessBuffer pdf_datafile;
    private PdfObject collectionObj;
    private PdfObject pageObj;
    private ObjectStore objectStore;
    public float[][] xobjectStartTM;
    private Javascript javascript;

    public PdfObjectReader() {
    }

    public PdfObjectReader(String password) {
        if (password == null) {
            password = "";
        }
        this.objectReader.setPassword(password);
    }

    public PdfObjectReader(Certificate certificate, PrivateKey key) {
        this.objectReader.setCertificate(certificate, key);
    }

    public String getReferenceforPage(int page) {
        return this.pagesReferences.get(page);
    }

    public final void closePdfFile() {
        try {
            this.objectReader.closeFile();
            if (this.pdf_datafile != null) {
                this.pdf_datafile.close();
            }
            if (this.tempFileName != null) {
                File fileToDelete = new File(this.tempFileName);
                fileToDelete.delete();
                this.tempFileName = null;
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " closing file");
        }
    }

    public PdfObject getPDFObject(int key) {
        switch (key) {
            case 1113489015: {
                return this.objectReader.encyptionObj;
            }
            case -2139781200: {
                return this.collectionObj;
            }
        }
        throw new RuntimeException("Access to " + key + " not supported");
    }

    public PdfFileReader getObjectReader() {
        return this.objectReader;
    }

    public String convertPageNumberToLabel(int pageNumber) {
        if (this.pageLabels == null) {
            return null;
        }
        return (String)this.pageLabels.get(pageNumber);
    }

    public String convertNameToRef(String value) {
        if (this.nameLookup == null) {
            return null;
        }
        return (String)this.nameLookup.get(value);
    }

    public NameLookup getNamesLookup() {
        if (this.nameLookup == null) {
            return null;
        }
        return this.nameLookup;
    }

    public int convertObjectToPageNumber(String ref) {
        return this.pageLookup.convertObjectToPageNumber(ref);
    }

    public void setLookup(String currentPageOffset, int tempPageCount) {
        this.pageLookup.put(currentPageOffset, tempPageCount);
        this.pagesReferences.put(tempPageCount, currentPageOffset);
    }

    public void dispose() {
        this.collectionObj = null;
        this.pageLabels = null;
        this.nameLookup = null;
        if (this.objectReader != null) {
            this.objectReader.dispose();
        }
        this.objectReader = null;
        if (this.pageLookup != null) {
            this.pageLookup.dispose();
        }
        this.pageLookup = null;
    }

    public final void openPdfFile(InputStream in) throws PdfException {
        try {
            byte[] password = this.objectReader.getEncHash();
            this.pdf_datafile = password == null ? new RandomAccessFileBuffer(in) : new RandomAccessFileBuffer(in, password);
            this.tempFileName = this.pdf_datafile.getTempFileName();
            this.objectReader.init(this.pdf_datafile);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing file");
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    public final void openPdfFile(ImageInputStream iis) throws PdfException {
        try {
            ImageInputStreamFileBuffer pdf_datafile = new ImageInputStreamFileBuffer(iis);
            this.objectReader.init(pdf_datafile);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing file");
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    public void checkParentForResources(PdfObject pdfObject) {
        String parent;
        if (pdfObject.getDictionary(2004251818) == null && (parent = pdfObject.getStringKey(1110793845)) != null) {
            PageObject parentObj = new PageObject(parent);
            this.readObject(parentObj);
            PdfObject resObj = ((PdfObject)parentObj).getDictionary(2004251818);
            if (resObj != null) {
                pdfObject.setDictionary(2004251818, resObj);
            }
        }
    }

    public final void openPdfFile(String filename, boolean supportLinearized) throws PdfException {
        try {
            byte[] IDRPassword = null;
            if (this.objectStore != null) {
                IDRPassword = this.objectStore.getIdrPassword();
            }
            byte[] password = this.objectReader.getEncHash();
            RandomAccessFileBuffer pdf_datafile = IDRPassword != null ? new RandomAccessFileBuffer(filename, IDRPassword) : (password == null || !supportLinearized ? new RandomAccessFileBuffer(filename, "r") : new RandomAccessFileBuffer(filename, password));
            this.objectReader.init(pdf_datafile);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing file");
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    public final void openPdfFile(byte[] data) throws PdfException {
        try {
            RandomAccessBuffer pdf_datafile;
            if (PdfFileReader.alwaysCacheInMemory == -1 || data.length < PdfFileReader.alwaysCacheInMemory) {
                pdf_datafile = new RandomAccessDataBuffer(data);
            } else {
                try {
                    byte[] password = this.objectReader.getEncHash();
                    pdf_datafile = new RandomAccessFileBuffer(data, password);
                    this.tempFileName = pdf_datafile.getTempFileName();
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create temporary file in " + ObjectStore.temp_dir + ' ' + e);
                }
            }
            this.objectReader.init(pdf_datafile);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " accessing file");
            throw new PdfException("Exception " + e + " accessing file");
        }
    }

    public void setJavaScriptObject(Javascript javascript) {
        this.javascript = javascript;
    }

    public void checkResolved(PdfObject pdfObject) {
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(pdfObject);
    }

    public void setJavascriptForObject(FormObject formObject, int parentType, int actionType) {
        PdfObject additionalObject = formObject.getDictionary(parentType);
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(additionalObject);
        if (additionalObject == null) {
            return;
        }
        PdfObject actionObj = actionType == parentType ? additionalObject : (actionType == 4866 ? additionalObject.getDictionary(19) : additionalObject.getDictionary(actionType));
        if (actionObj != null) {
            String JSscript;
            objectDecoder.checkResolved(actionObj);
            PdfObject JSobj = actionObj.getDictionary(6691);
            if (JSobj != null) {
                byte[] data = JSobj.getDecodedStream();
                JSscript = StringUtils.getTextString(data, true);
            } else {
                JSscript = actionObj.getTextStreamValue(6691);
            }
            if (JSscript != null) {
                String name = formObject.getTextStreamValue(36);
                if (name == null) {
                    name = formObject.getObjectRefAsString();
                }
                this.javascript.storeJavascript(name, JSscript, actionType);
            }
        }
    }

    public byte[] readStream(PdfObject obj, boolean cacheValue, boolean decompress, boolean keepRaw, boolean isMetaData, boolean isCompressedStream, String cacheFile) {
        return this.objectReader.readStream(obj, cacheValue, decompress, keepRaw, isMetaData, isCompressedStream, cacheFile);
    }

    public void readObject(PdfObject pdfObject) {
        this.objectReader.readObject(pdfObject);
    }

    public EncryptionUsed getEncryptionType() {
        PdfFileReader objectReader = this.objectReader;
        DecryptionFactory decryption = objectReader.getDecryptionObject();
        if (decryption == null) {
            return EncryptionUsed.NO_ENCRYPTION;
        }
        if (decryption.hasPassword()) {
            return EncryptionUsed.PASSWORD;
        }
        return EncryptionUsed.CERTIFICATE;
    }

    public void readDocumentMetaData(PdfObject pdfObject, Javascript jsHandler) {
        PdfObject nameObj = pdfObject.getDictionary(826094945);
        if (nameObj != null) {
            this.nameLookup = new NameLookup(this.objectReader);
            this.nameLookup.readNames(nameObj, jsHandler, false);
        } else {
            nameObj = pdfObject.getDictionary(893600855);
            if (nameObj != null) {
                this.nameLookup = new NameLookup(this.objectReader);
                this.nameLookup.readNames(nameObj, jsHandler, false);
            }
        }
        this.pageObj = pdfObject.getDictionary(1768585381);
        this.collectionObj = pdfObject.getDictionary(-2139781200);
    }

    public void readPageLabels(int pageCount) {
        String ignoreLabel = System.getProperty("org.jpedal.ignorePageLabels");
        if (!"true".equalsIgnoreCase(ignoreLabel) && this.pageObj != null) {
            this.pageLabels = new PageLabels(this.objectReader, pageCount);
            try {
                this.pageLabels.readLabels(this.pageObj);
            }
            catch (Exception e) {
                this.pageLabels = null;
                LogWriter.writeLog(e);
            }
        }
    }

    public PageLabels getPageLabels() {
        return this.pageLabels;
    }

    public String getTempFileName() {
        return this.tempFileName;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }
}

