/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Rectangle;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.fonts.utils.FontLoader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class TrueType
extends PdfFont {
    private boolean subfontAlreadyLoaded;
    private final Map<String, PdfJavaGlyphs> fontsLoaded;

    public TrueType() {
        this.fontsLoaded = new HashMap<String, PdfJavaGlyphs>();
        this.init(null);
    }

    private void readFontData(byte[] fontDataAsArray, FontData fontData) {
        if (this.subfontAlreadyLoaded) {
            this.glyphs = this.fontsLoaded.get(this.substituteFont + '_' + this.glyphs.getBaseFontName() + ' ' + fontDataAsArray.length);
            this.fontTypes = this.glyphs.getType();
        } else {
            if (!this.isCIDFont && fontDataAsArray != null) {
                this.fontsLoaded.put(this.substituteFont + '_' + this.glyphs.getBaseFontName() + ' ' + fontDataAsArray.length, this.glyphs);
            }
            this.fontTypes = this.glyphs.readEmbeddedFont(this.TTstreamisCID, fontDataAsArray, fontData);
            if (this.fontTypes == 6) {
                this.FontMatrix = this.glyphs.getFontMatrix();
            }
        }
    }

    void substituteFontUsed(String substituteFontFile) {
        this.readFontData(FontLoader.getBytes(substituteFontFile, this.loader), null);
        this.glyphs.setEncodingToUse(this.hasEncoding, this.getFontEncoding(false));
        this.isFontEmbedded = true;
    }

    public TrueType(PdfObjectReader current_pdf_file, String substituteFont, Map<String, PdfJavaGlyphs> substitutedFonts) {
        this.glyphs = new TTGlyphs();
        this.fontsLoaded = substitutedFonts;
        this.init(current_pdf_file);
        this.substituteFont = substituteFont;
    }

    @Override
    public void createFont(PdfObject pdfObject, String fontID, boolean renderPage) {
        this.fontTypes = 1217103210;
        this.init(fontID, renderPage);
        PdfObject pdfFontDescriptor = pdfObject.getDictionary(-1044665361);
        this.setBoundsAndMatrix(pdfFontDescriptor);
        this.setName(pdfObject);
        this.setEncoding(pdfObject, pdfFontDescriptor);
        if (renderPage) {
            if (pdfFontDescriptor != null && this.substituteFont == null) {
                byte[] stream = null;
                PdfObject FontFile22 = pdfFontDescriptor.getDictionary(2021292334);
                if (FontFile22 == null && (FontFile22 = pdfFontDescriptor.getDictionary(746093177)) == null) {
                    FontFile22 = pdfFontDescriptor.getDictionary(2021292335);
                }
                if (FontFile22 != null) {
                    stream = this.currentPdfFile.readStream(FontFile22, true, true, false, false, false, FontFile22.getCacheName(this.currentPdfFile.getObjectReader()));
                }
                if (stream != null) {
                    this.readEmbeddedFont(stream, null, this.hasEncoding);
                }
            }
            if (!this.isFontEmbedded && this.substituteFont != null) {
                this.subfontAlreadyLoaded = !this.isCIDFont && this.fontsLoaded.containsKey(this.substituteFont + '_' + this.glyphs.getBaseFontName());
                FontData fontData = null;
                int objSize = 0;
                if (!this.subfontAlreadyLoaded) {
                    File fontFile = new File(this.substituteFont);
                    objSize = (int)fontFile.length();
                }
                if (FontData.maxSizeAllowedInMemory >= 0 && objSize > FontData.maxSizeAllowedInMemory) {
                    if (!this.subfontAlreadyLoaded) {
                        fontData = new FontData(this.substituteFont);
                    }
                    this.readEmbeddedFont(null, fontData, false);
                } else if (this.subfontAlreadyLoaded) {
                    this.readEmbeddedFont(null, null, false);
                } else {
                    this.readEmbeddedFont(FontLoader.getBytes(this.substituteFont, this.loader), null, false);
                }
                this.isFontSubstituted = true;
            }
        }
        this.readWidths(pdfObject, true);
        if (renderPage) {
            this.setFont(this.glyphs.fontName, 1);
        }
    }

    final void readEmbeddedFont(byte[] fontDataAsArray, FontData fontDataAsObject, boolean hasEncoding) {
        try {
            this.readFontData(fontDataAsArray, fontDataAsObject);
            this.isFontEmbedded = true;
            this.glyphs.setFontEmbedded(true);
            this.glyphs.setEncodingToUse(hasEncoding, this.getFontEncoding(false));
        }
        catch (Exception e) {
            this.isFontEmbedded = false;
            LogWriter.writeLog("Exception " + e + " processing TrueType font");
        }
    }

    @Override
    public Rectangle getBoundingBox() {
        Rectangle BBox = this.isFontEmbedded && !this.isFontSubstituted ? new Rectangle((int)this.FontBBox[0], (int)this.FontBBox[1], (int)(this.FontBBox[2] - this.FontBBox[0]), (int)(this.FontBBox[3] - this.FontBBox[1])) : super.getBoundingBox();
        return BBox;
    }
}

