/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.rds.handler;

import coldfusion.bootstrap.ClassloaderHelper;
import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.rds.handler.DebuggerPortException;
import coldfusion.debugger.rds.handler.DebuggerServerTimeOutException;
import coldfusion.debugger.rds.handler.DebuggerStartFailedException;
import coldfusion.log.CFLogs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class DebuggerLaunchHelper {
    Thread debuggerThread = null;
    boolean debugStarted = false;
    boolean shutdownHookAdded = false;
    int serverPort = 0;
    String rootPath;
    String cfHost;
    String ctxRoot;
    int debugPort;
    int cfPort;
    int maxSessions;
    private static final Object serverStartCheckMutex = new Object();
    static final String serverStartMsgMatch = "oejs.Server:main: Started ";
    static final long waitTimeForServerStart = 15000L;
    boolean serverStarted = false;
    boolean traceDebugger = false;
    private static DebuggerLaunchHelper instance = new DebuggerLaunchHelper();
    Thread shutDownHandlerThread = new Thread(){

        @Override
        public void run() {
            DebuggerLaunchHelper.this.stopDebugger(true);
        }
    };

    private DebuggerLaunchHelper() {
    }

    public static DebuggerLaunchHelper getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkServerStarted(final InputStream inStream, final long timeout) {
        Thread th = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader rd = new BufferedReader(new InputStreamReader(inStream));
                String msgs = null;
                long currMillis1 = System.currentTimeMillis();
                long currMillis2 = 0L;
                Object object = serverStartCheckMutex;
                synchronized (object) {
                    try {
                        while ((msgs = rd.readLine()) != null) {
                            if (msgs.indexOf(DebuggerLaunchHelper.serverStartMsgMatch) >= 0) {
                                DebuggerLaunchHelper.this.serverStarted = true;
                                break;
                            }
                            currMillis2 = System.currentTimeMillis();
                            if (currMillis2 - currMillis1 < timeout) continue;
                            DebuggerLaunchHelper.this.serverStarted = false;
                            throw new DebuggerServerTimeOutException();
                        }
                    }
                    catch (Exception e) {
                        CFDebuggerLogger.log(e);
                        DebuggerLaunchHelper.this.serverStarted = false;
                        throw new DebuggerStartFailedException(e.getMessage());
                    }
                    serverStartCheckMutex.notifyAll();
                }
            }
        };
        Object object = serverStartCheckMutex;
        synchronized (object) {
            th.start();
            try {
                serverStartCheckMutex.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.serverStarted;
    }

    private void readInputStream(final InputStream inStream) {
        Thread th = new Thread(){

            @Override
            public void run() {
                BufferedReader rd = new BufferedReader(new InputStreamReader(inStream));
                String msgs = null;
                try {
                    while ((msgs = rd.readLine()) != null) {
                        CFDebuggerLogger.log("New VM : " + msgs);
                    }
                }
                catch (Exception e) {
                    CFDebuggerLogger.log(e);
                }
            }
        };
        th.start();
    }

    public synchronized int launchDebugger(String rootPath, String ctxRoot, int debugPort, int cfPort, String cfHost, int maxSessions) throws Exception {
        this.rootPath = rootPath;
        this.debugPort = debugPort;
        this.cfPort = cfPort;
        this.cfHost = cfHost;
        this.maxSessions = maxSessions;
        this.ctxRoot = ctxRoot;
        return this.startDebugger();
    }

    public static synchronized int getFreeSocketPort() throws Throwable {
        return DebuggerLaunchHelper.getFreeSocketPort(0);
    }

    public static synchronized int getFreeSocketPort(final int portToTry) throws Throwable {
        if (System.getSecurityManager() == null) {
            ServerSocket soc = new ServerSocket(portToTry);
            int serverPort = soc.getLocalPort();
            soc.close();
            return serverPort;
        }
        try {
            return (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ServerSocket soc = new ServerSocket(portToTry);
                    int serverPort = soc.getLocalPort();
                    soc.close();
                    return new Integer(serverPort);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
    }

    public static synchronized boolean isPortActive(final int portToTry) {
        if (System.getSecurityManager() == null) {
            try {
                ServerSocket soc = new ServerSocket(portToTry);
                soc.close();
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        ServerSocket soc = new ServerSocket(portToTry);
                        soc.close();
                    }
                    catch (IOException e) {
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            CFDebuggerLogger.log(ex);
            throw new DebuggerPortException(ex.getMessage());
        }
    }

    private synchronized Process executeDebuggerStartCommand(final String[] startCommand) throws Throwable {
        if (System.getSecurityManager() == null) {
            return Runtime.getRuntime().exec(startCommand);
        }
        try {
            return (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Runtime.getRuntime().exec(startCommand);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
    }

    public synchronized int startDebugger() throws Exception {
        if (this.debuggerThread != null) {
            try {
                this.debuggerThread.destroy();
            }
            catch (IllegalThreadStateException tse) {
                return this.serverPort;
            }
            this.debuggerThread = null;
        }
        this.serverPort = -1;
        try {
            int userSpecifiedPort = 0;
            String userPortString = System.getProperty("DEBUGGER_SERVER_PORT");
            if (userPortString != null) {
                userSpecifiedPort = Integer.valueOf(userPortString);
            }
            this.serverPort = DebuggerLaunchHelper.getFreeSocketPort(userSpecifiedPort);
        }
        catch (Throwable t) {
            CFDebuggerLogger.log(t);
            throw new DebuggerPortException(t.getMessage());
        }
        boolean serverStarted = false;
        this.debuggerThread = new Thread(){

            @Override
            public void run() {
                try {
                    DebuggerLaunchHelper.this.execute();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.debuggerThread.start();
        if (DebuggerLaunchHelper.isPortActive(this.debugPort)) {
            serverStarted = true;
        }
        return this.serverPort;
    }

    private void execute() throws Exception {
        File ctxRootFile;
        Server server = new Server();
        ServerConnector serverConnector = new ServerConnector(server);
        serverConnector.setPort(this.serverPort);
        serverConnector.setIdleTimeout(90000000L);
        server.addConnector((Connector)serverConnector);
        ServletHandler handler = new ServletHandler();
        server.setHandler((Handler)handler);
        handler.addServletWithMapping("coldfusion.debugger.rds.RdsFrontEndServlet", "/CFIDE/main/ide.cfm");
        ServletHolder[] holders = handler.getServlets();
        ServletHolder aHolder = holders[0];
        String traceValue = System.getProperty("DEBUGGER_TRACE");
        String canonicalCtxRoot = null;
        if (this.ctxRoot != null && (ctxRootFile = new File(this.ctxRoot)).exists()) {
            try {
                canonicalCtxRoot = ctxRootFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.cfHost != null) {
            aHolder.setInitParameter("DEBUG_HOST", this.cfHost);
        }
        if (this.debugPort > 0) {
            aHolder.setInitParameter("DEBUG_PORT", String.valueOf(this.debugPort));
        }
        if (this.maxSessions != 0) {
            aHolder.setInitParameter("MAX_DEBUG_SESSIONS", "" + this.maxSessions);
        }
        if (this.ctxRoot != null) {
            aHolder.setInitParameter("CTX_ROOT", this.ctxRoot);
        }
        if (canonicalCtxRoot != null) {
            aHolder.setInitParameter("CANONICAL_CTX_ROOT", canonicalCtxRoot);
        }
        aHolder.setInitParameter("DEBUGGER_TRACE", traceValue);
        server.start();
        Thread.sleep(100L);
        this.debugStarted = true;
        server.join();
    }

    private String stringArrayToString(String[] strArray) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < strArray.length; ++i) {
            buf.append(strArray[i]);
            buf.append(" ");
        }
        return buf.toString().trim();
    }

    public synchronized void stopDebugger() {
        this.stopDebugger(false);
    }

    public synchronized void stopDebugger(boolean cfShuttingDown) {
        if (this.debuggerThread == null) {
            return;
        }
        CFLogs.SERVER_LOG.info((Object)"ColdFusion debugger is stopped");
        this.debuggerThread = null;
    }

    private String[] createArgs(String rootPath, String ctxRoot, int debugPort, int serverPort, int cfPort, String cfHost, int maxSessions) {
        String fileSep = System.getProperty("file.separator");
        String javaHome = System.getProperty("java.home");
        String javaPath = javaHome + fileSep + "bin" + fileSep + "java";
        ArrayList<String> args = new ArrayList<String>();
        String cfLibPath = rootPath + fileSep + "lib" + fileSep;
        String cfUpdatesFolderPath = cfLibPath + fileSep + "updates" + fileSep;
        String debuggerLibPath = cfLibPath + "etc" + fileSep;
        String pathSep = System.getProperty("path.separator");
        StringBuffer cpBuf = new StringBuffer(cfLibPath);
        cpBuf.append("tools.jar");
        cpBuf.append(pathSep);
        this.addUpdatesFolderToClassPath(cpBuf, cfUpdatesFolderPath, pathSep);
        cpBuf.append(cfLibPath);
        cpBuf.append("cfusion.jar");
        cpBuf.append(pathSep);
        List<String> jarsToInclude = this.getAllJarsToInclude(cfLibPath);
        if (jarsToInclude != null && !jarsToInclude.isEmpty()) {
            for (String jarToInclude : jarsToInclude) {
                cpBuf.append(cfLibPath);
                cpBuf.append(jarToInclude);
                cpBuf.append(pathSep);
            }
        }
        cpBuf.append(cfLibPath).append("xercesImpl.jar").append(pathSep);
        cpBuf.append(cfLibPath).append("xml-apis.jar").append(pathSep);
        cpBuf.append(cfLibPath).append("closure-compiler.jar").append(pathSep);
        cpBuf.append(debuggerLibPath);
        cpBuf.append("servlet-api-3.1.jar");
        cpBuf.append(pathSep);
        String mainClass = "coldfusion.debugger.server.jetty.CFJettyDebugServer";
        String traceOption = " ";
        String traceValue = System.getProperty("DEBUGGER_TRACE");
        if (traceValue != null && traceValue.toLowerCase().equals("true")) {
            traceOption = "-DDEBUGGER_TRACE=true";
            this.traceDebugger = true;
        }
        CFDebuggerLogger.setEnabled(this.traceDebugger);
        args.add(javaPath);
        args.add("-cp");
        args.add(cpBuf.toString().trim());
        if (traceOption != null && traceOption.trim().length() > 0) {
            args.add(traceOption);
        }
        args.add(mainClass.trim());
        args.add(cfHost);
        args.add(String.valueOf(debugPort));
        args.add(String.valueOf(serverPort));
        args.add(String.valueOf(maxSessions));
        String canonicalCtxRoot = null;
        if (ctxRoot != null) {
            args.add(ctxRoot);
            File ctxRootFile = new File(ctxRoot);
            if (ctxRootFile.exists()) {
                try {
                    canonicalCtxRoot = ctxRootFile.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (canonicalCtxRoot != null) {
                args.add(canonicalCtxRoot);
            }
        }
        return args.toArray(new String[args.size()]);
    }

    private void addUpdatesFolderToClassPath(StringBuffer cpBuf, String folderPath, String pathSeperator) {
        File updatesDir = new File(folderPath);
        if (updatesDir.exists() && updatesDir.isDirectory()) {
            List filePathsCpList = ClassloaderHelper.getFilePathsInUpdates((File)updatesDir);
            Iterator it = filePathsCpList.iterator();
            while (it.hasNext()) {
                cpBuf.append(it.next());
                cpBuf.append(pathSeperator);
            }
        }
    }

    private List<String> getAllJarsToInclude(String cfLibPath) {
        File libDir = new File(cfLibPath);
        String[] fileNames = libDir.list();
        if (fileNames == null) {
            return null;
        }
        ArrayList<String> jars = new ArrayList<String>();
        for (int i = 0; i < fileNames.length; ++i) {
            if (!fileNames[i].startsWith("log4j") && !fileNames[i].startsWith("jetty") || !fileNames[i].endsWith(".jar")) continue;
            jars.add(fileNames[i]);
        }
        return jars;
    }

    public boolean isDebugProcessRunning() {
        return this.debuggerThread != null;
    }
}

