/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.pdf;

import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.pdf.FDFDataGenerator;
import coldfusion.pdf.PDFDocOperation;
import coldfusion.pdf.PDFDocWrapper;
import coldfusion.pdf.PDFForm;
import coldfusion.pdf.PDFFormCFDocProcessor;
import coldfusion.pdf.PDFFormException;
import coldfusion.pdf.PDFXMLDataObject;
import coldfusion.pdf.XFADataXMLGenerator;
import coldfusion.pdf.XFAXMLtoCFStruct;
import coldfusion.pdf.XFDFDataXMLGenerator;
import coldfusion.pdf.XFDFXMLtoCFStruct;
import coldfusion.pdf.core.PDFException;
import coldfusion.runtime.CFVariableLexer;
import coldfusion.runtime.Struct;
import coldfusion.server.DocumentService;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.document.DocumentItemTag;
import coldfusion.tagext.document.DocumentSectionTag;
import coldfusion.tagext.document.DocumentTag;
import coldfusion.tagext.pdf.PDFFormParamTag;
import coldfusion.tagext.pdf.PDFSubformTag;
import coldfusion.util.RB;
import coldfusion.util.Utils;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.io.IOException;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class PDFFormTag
extends GenericTag {
    private PDFXMLDataObject pdfDataObject;
    private PDFForm pdfform;
    private String destination;
    private String action;
    private String result;
    private Object datafile;
    private boolean overwritedata = false;
    private Object source;
    private boolean overwrite = false;
    private Logger logger = CFLogs.APPLICATION_LOG;
    private boolean CFDocumentParent = false;
    private DocumentTag parentDocumentTag;
    private static final String POPULATE = "POPULATE";
    private String fdfData;
    private boolean fdf = false;
    private String name = null;

    public void setName(String name) {
        this.name = name;
    }

    public void setFdfData(String fdfData) {
        if (fdfData == null || "".equals(fdfData.trim())) {
            throw new PDFException.EmptyAttributeForTagException("fdfdata", "cfpdfform");
        }
        this.fdfData = fdfData = Utils.getFileFullPath((String)fdfData, (PageContext)this.pageContext, (boolean)true);
    }

    public void setFdf(boolean fdf) {
        this.fdf = fdf;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setOverwritedata(boolean overwritedata) {
        this.overwritedata = overwritedata;
    }

    public void setXmlData(Object datafile) {
        if (datafile instanceof String && (datafile == null || "".equals(((String)datafile).trim()))) {
            throw new PDFException.EmptyAttributeForTagException("xmldata", "cfpdfform");
        }
        this.datafile = datafile;
    }

    public void setDestination(String destination) {
        if (destination == null || "".equals(destination.trim())) {
            throw new PDFException.EmptyAttributeForTagException("destination", "cfpdfform");
        }
        this.destination = destination;
    }

    public void setResult(String result) {
        if (result == null || "".equals(result.trim())) {
            throw new PDFException.EmptyAttributeForTagException("result", "cfpdfform");
        }
        this.result = result;
    }

    public void setSource(Object source) {
        if (source instanceof String && (source == null || "".equals(((String)source).trim()))) {
            throw new PDFException.EmptyAttributeForTagException("source", "cfpdfform");
        }
        if (source instanceof String) {
            Object value = null;
            try {
                value = this.pageContext.findAttribute((String)source);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.source = value != null ? value : source;
        } else {
            this.source = source;
        }
    }

    public void release() {
        this.destination = null;
        this.name = null;
        this.action = null;
        this.result = null;
        this.datafile = null;
        this.source = null;
        this.pdfDataObject = null;
        this.pdfform = null;
        this.overwrite = false;
        this.CFDocumentParent = false;
        this.parentDocumentTag = null;
        this.fdfData = null;
        super.release();
    }

    public int doStartTag() throws JspException {
        block14: {
            this.onTagStart();
            try {
                Tag parentTag;
                if (parentTag instanceof DocumentTag) {
                    DocumentTag documentTag = (DocumentTag)parentTag;
                    PDFFormCFDocProcessor pdfCFDocumentProcessor = (PDFFormCFDocProcessor)documentTag.getPdfCFDocumentProcessor();
                    documentTag.setChildPDFFormTag(true);
                    pdfCFDocumentProcessor.calculatePagesInCFDocB4PDFForm(documentTag.getSectionQueue());
                    pdfCFDocumentProcessor.addNumPDFTagsInCfDocument();
                    this.CFDocumentParent = true;
                    this.parentDocumentTag = (DocumentTag)parentTag;
                } else {
                    for (parentTag = this.getParent(); parentTag != null; parentTag = parentTag.getParent()) {
                        if (!(parentTag instanceof PDFSubformTag) && !(parentTag instanceof PDFFormParamTag) && !(parentTag instanceof DocumentSectionTag) && !(parentTag instanceof DocumentItemTag) && !(parentTag instanceof PDFFormTag)) continue;
                        throw new PDFException.InvalidUseException();
                    }
                }
                if (this.CFDocumentParent && (!this.action.equalsIgnoreCase(POPULATE) || this.destination != null)) {
                    throw new PDFException.InvalidActionAttributeException2();
                }
                if (this.action.equalsIgnoreCase(POPULATE) && this.destination != null && this.name != null) {
                    throw new PDFException.PDFDestNameException();
                }
                if (this.source instanceof PDFDocWrapper && this.name != null) {
                    this.source = PDFDocWrapper.deepCopy((PDFDocWrapper)this.source, null);
                }
                if (this.CFDocumentParent && this.parentDocumentTag.getFormat() == DocumentService.FLASHPAPER_FORMAT) {
                    throw new PDFFormException(RB.getString(PDFFormException.class, (String)"cfpdfform.FlashPaperPDFFormIncompatibleException"));
                }
                this.pdfform = new PDFForm(this);
                if (this.action.equalsIgnoreCase(POPULATE)) {
                    int formType = this.pdfform.determineFormType(this.source, this.fContext);
                    this.pdfDataObject = this.fdf || this.fdfData != null ? new FDFDataGenerator() : (formType == 2 ? new XFADataXMLGenerator(this.pdfform.getDoc()) : new XFDFDataXMLGenerator(this.pdfform.getDoc()));
                    break block14;
                }
                return 0;
            }
            catch (PDFInvalidDocumentException pdfInvaliddocex) {
                throw new PDFFormException(pdfInvaliddocex, RB.getString(PDFFormException.class, (String)"cfpdfform.PDFInvalidDocumentException"));
            }
            catch (PDFSecurityException pdfSecurityex) {
                throw new PDFFormException(pdfSecurityex, RB.getString(PDFFormException.class, (String)"cfpdfform.PDFSecurityException"));
            }
            catch (IOException ioex) {
                throw new PDFFormException(ioex, RB.getString(PDFFormException.class, (String)"cfpdfform.IOException"));
            }
            catch (PDFIOException pdfioex) {
                throw new PDFFormException(pdfioex, RB.getString(PDFFormException.class, (String)"cfpdfform.PDFIOException"));
            }
            catch (PDFException pdfex) {
                throw new PDFFormException(pdfex, RB.getString(PDFFormException.class, (String)"cfpdfform.generalPDFFormException"));
            }
        }
        FeatureRouter.getInstance().allowFeature(EFRConstants.pdf_form_processing.intValue(), this.tagNameFromClass(), null);
        return 1;
    }

    public int doEndTag() throws JspException {
        block24: {
            try {
                if (this.action.equalsIgnoreCase(POPULATE)) {
                    try {
                        if (this.datafile == null || "".equals(this.datafile) || this.fdfData == null) {
                            this.pdfDataObject.createFormXMLData(this.overwritedata);
                        }
                    }
                    catch (Exception ex) {
                        throw new PDFFormException(ex);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)this.pdfDataObject.toString());
                    }
                    PDFDocument pdf = null;
                    pdf = this.fdf || this.fdfData != null ? this.pdfform.populateFDFFields(this.source, this.destination, this.pdfDataObject, this.out, this.fContext, this.overwrite, this.fdfData, this.name) : this.pdfform.populateFields(this.source, this.destination, this.pdfDataObject, this.out, this.fContext, this.overwrite, this.datafile, this.name);
                    if (pdf != null) {
                        this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(pdf, null, new PDFDocOperation()));
                    }
                    if (this.parentDocumentTag != null && this.parentDocumentTag instanceof DocumentTag) {
                        this.parentDocumentTag.setPdfFormPageCount(((PDFFormCFDocProcessor)this.parentDocumentTag.getPdfCFDocumentProcessor()).getNumPagesInPDFForm());
                    }
                    break block24;
                }
                if (this.fdfData != null) {
                    this.pdfform.exportFDF(this.source, this.fdfData, this.fContext);
                    break block24;
                }
                String dataXML = this.pdfform.extractFields(this.source, this.fContext);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)dataXML);
                }
                if (this.datafile != null) {
                    String datafileStr = null;
                    try {
                        datafileStr = (String)this.datafile;
                    }
                    catch (Exception ex) {
                        throw new PDFException.InvalidXmlDataAttributeValueException((Throwable)ex);
                    }
                    if (!CFVariableLexer.isValidVariableName((String)datafileStr)) {
                        throw new PDFException.InvalidVariableException("xmldata");
                    }
                    if (this.pdfform.getFormType() == 2) {
                        this.pageContext.setAttribute(datafileStr, (Object)this.pdfform.addXMLNode("xfa:datasets", dataXML, "<xfa:datasets xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\">", "</xfa:datasets>"));
                    } else {
                        this.pageContext.setAttribute(datafileStr, (Object)dataXML);
                    }
                }
                if (this.result != null) {
                    Map data = null;
                    int formType = this.pdfform.determineFormType(this.source, this.fContext);
                    data = formType == 2 ? XFAXMLtoCFStruct.parseXMLtoCF(dataXML) : XFDFXMLtoCFStruct.parseXMLtoCF(dataXML);
                    Struct cfstruct = new Struct();
                    cfstruct.putAll(data);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)cfstruct);
                    }
                    if (!CFVariableLexer.isValidVariableName((String)this.result)) {
                        throw new PDFException.InvalidVariableException("result");
                    }
                    this.pageContext.setAttribute(this.result, (Object)cfstruct);
                }
            }
            catch (PDFInvalidDocumentException pdfInvaliddocex) {
                throw new PDFFormException(pdfInvaliddocex, RB.getString(PDFFormException.class, (String)"cfpdfform.PDFInvalidDocumentException"));
            }
            catch (PDFSecurityException pdfSecurityex) {
                throw new PDFFormException(pdfSecurityex, RB.getString(PDFFormException.class, (String)"cfpdfform.PDFSecurityException"));
            }
            catch (IOException ioex) {
                throw new PDFFormException(ioex, RB.getString(PDFFormException.class, (String)"cfpdfform.IOException"));
            }
            catch (PDFIOException pdfioex) {
                throw new PDFFormException(pdfioex, RB.getString(PDFFormException.class, (String)"cfpdfform.PDFIOException"));
            }
            catch (PDFException pdfex) {
                throw new PDFFormException(pdfex, RB.getString(PDFFormException.class, (String)"cfpdfform.generalPDFFormException"));
            }
        }
        this.onTagEnd();
        return 6;
    }

    public PDFXMLDataObject getPdfDataObject() {
        return this.pdfDataObject;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isCFDocumentParent() {
        return this.CFDocumentParent;
    }

    public DocumentTag getParentDocumentTag() {
        return this.parentDocumentTag;
    }

    String getAction() {
        return this.action;
    }

    public boolean isOverwritedata() {
        return this.overwritedata;
    }
}

