/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.nio.AbstractNioChannelSink;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannel;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.SelectorUtil;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.jboss.netty.util.internal.DeadLockProofWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioClientSocketPipelineSink
extends AbstractNioChannelSink {
    private static final AtomicInteger nextId = new AtomicInteger();
    static final InternalLogger logger = InternalLoggerFactory.getInstance(NioClientSocketPipelineSink.class);
    final Executor bossExecutor;
    final int id = nextId.incrementAndGet();
    private final Boss[] bosses;
    private final AtomicInteger bossIndex = new AtomicInteger();
    private final WorkerPool<NioWorker> workerPool;
    private final Timer timer;

    NioClientSocketPipelineSink(Executor bossExecutor, int bossCount, WorkerPool<NioWorker> workerPool, Timer timer) {
        this.bossExecutor = bossExecutor;
        this.timer = timer;
        this.bosses = new Boss[bossCount];
        for (int i = 0; i < this.bosses.length; ++i) {
            this.bosses[i] = new Boss(i);
        }
        this.workerPool = workerPool;
    }

    @Override
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            NioClientSocketChannel channel = (NioClientSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        NioClientSocketPipelineSink.bind(channel, future, (SocketAddress)value);
                        break;
                    }
                    channel.worker.close(channel, future);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        this.connect(channel, future, (SocketAddress)value);
                        break;
                    }
                    channel.worker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }

    private static void bind(NioClientSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        try {
            ((SocketChannel)channel.channel).socket().bind(localAddress);
            channel.boundManually = true;
            channel.setBound();
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private void connect(NioClientSocketChannel channel, final ChannelFuture cf, SocketAddress remoteAddress) {
        try {
            if (((SocketChannel)channel.channel).connect(remoteAddress)) {
                channel.worker.register(channel, cf);
            } else {
                channel.getCloseFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) throws Exception {
                        if (!cf.isDone()) {
                            cf.setFailure(new ClosedChannelException());
                        }
                    }
                });
                cf.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
                channel.connectFuture = cf;
                this.nextBoss().register(channel);
            }
        }
        catch (Throwable t) {
            cf.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
            channel.worker.close(channel, Channels.succeededFuture(channel));
        }
    }

    Boss nextBoss() {
        return this.bosses[Math.abs(this.bossIndex.getAndIncrement() % this.bosses.length)];
    }

    NioWorker nextWorker() {
        return this.workerPool.nextWorker();
    }

    private static final class RegisterTask
    implements Runnable {
        private final Boss boss;
        private final NioClientSocketChannel channel;

        RegisterTask(Boss boss, NioClientSocketChannel channel) {
            this.boss = boss;
            this.channel = channel;
        }

        public void run() {
            try {
                ((SocketChannel)this.channel.channel).register(this.boss.selector, 8, this.channel);
            }
            catch (ClosedChannelException e) {
                this.channel.worker.close(this.channel, Channels.succeededFuture(this.channel));
            }
            int connectTimeout = this.channel.getConfig().getConnectTimeoutMillis();
            if (connectTimeout > 0) {
                this.channel.connectDeadlineNanos = System.nanoTime() + (long)connectTimeout * 1000000L;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Boss
    implements Runnable {
        volatile Selector selector;
        private boolean started;
        private final AtomicBoolean wakenUp = new AtomicBoolean();
        private final Object startStopLock = new Object();
        private final Queue<Runnable> registerTaskQueue = new ConcurrentLinkedQueue<Runnable>();
        private final int subId;
        private final TimerTask wakeupTask = new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (Boss.this.selector != null && Boss.this.wakenUp.compareAndSet(false, true)) {
                    Boss.this.selector.wakeup();
                }
            }
        };

        Boss(int subId) {
            this.subId = subId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register(NioClientSocketChannel channel) {
            Selector selector;
            RegisterTask registerTask = new RegisterTask(this, channel);
            Object object = this.startStopLock;
            synchronized (object) {
                block16: {
                    if (!this.started) {
                        block17: {
                            try {
                                this.selector = selector = Selector.open();
                            }
                            catch (Throwable t) {
                                throw new ChannelException("Failed to create a selector.", t);
                            }
                            boolean success = false;
                            try {
                                DeadLockProofWorker.start(NioClientSocketPipelineSink.this.bossExecutor, new ThreadRenamingRunnable(this, "New I/O client boss #" + NioClientSocketPipelineSink.this.id + '-' + this.subId));
                                success = true;
                                Object var7_8 = null;
                                if (success) break block16;
                            }
                            catch (Throwable throwable) {
                                Object var7_9 = null;
                                if (!success) {
                                    block18: {
                                        try {
                                            selector.close();
                                        }
                                        catch (Throwable t) {
                                            if (!logger.isWarnEnabled()) break block18;
                                            logger.warn("Failed to close a selector.", t);
                                        }
                                    }
                                    selector = null;
                                    this.selector = null;
                                }
                                throw throwable;
                            }
                            try {
                                selector.close();
                            }
                            catch (Throwable t) {
                                if (!logger.isWarnEnabled()) break block17;
                                logger.warn("Failed to close a selector.", t);
                            }
                        }
                        selector = null;
                        this.selector = null;
                        {
                            break block16;
                        }
                    }
                    selector = this.selector;
                }
                assert (selector != null && selector.isOpen());
                this.started = true;
                boolean offered = this.registerTaskQueue.offer(registerTask);
                assert (offered);
            }
            int timeout = channel.getConfig().getConnectTimeoutMillis();
            if (timeout > 0 && !channel.isConnected()) {
                channel.timoutTimer = NioClientSocketPipelineSink.this.timer.newTimeout(this.wakeupTask, timeout, TimeUnit.MILLISECONDS);
            }
            if (this.wakenUp.compareAndSet(false, true)) {
                selector.wakeup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean shutdown = false;
            int selectReturnsImmediately = 0;
            Selector selector = this.selector;
            long minSelectTimeout = SelectorUtil.SELECT_TIMEOUT_NANOS * 80L / 100L;
            boolean wakenupFromLoop = false;
            while (true) {
                this.wakenUp.set(false);
                try {
                    long beforeSelect = System.nanoTime();
                    int selected = SelectorUtil.select(selector);
                    if (SelectorUtil.EPOLL_BUG_WORKAROUND && selected == 0 && !wakenupFromLoop && !this.wakenUp.get()) {
                        long timeBlocked = System.nanoTime() - beforeSelect;
                        if (timeBlocked < minSelectTimeout) {
                            boolean notConnected = false;
                            for (SelectionKey key : selector.keys()) {
                                SelectableChannel ch = key.channel();
                                try {
                                    if (!(ch instanceof SocketChannel) || ((SocketChannel)ch).isConnected()) continue;
                                    notConnected = true;
                                    key.cancel();
                                }
                                catch (CancelledKeyException e) {}
                            }
                            selectReturnsImmediately = notConnected ? 0 : ++selectReturnsImmediately;
                        } else {
                            selectReturnsImmediately = 0;
                        }
                        if (selectReturnsImmediately == 1024) {
                            selector = this.recreateSelector();
                            selectReturnsImmediately = 0;
                            wakenupFromLoop = false;
                            continue;
                        }
                    } else {
                        selectReturnsImmediately = 0;
                    }
                    if (this.wakenUp.get()) {
                        wakenupFromLoop = true;
                        selector.wakeup();
                    } else {
                        wakenupFromLoop = false;
                    }
                    this.processRegisterTaskQueue();
                    this.processSelectedKeys(selector.selectedKeys());
                    long currentTimeNanos = System.nanoTime();
                    this.processConnectTimeout(selector.keys(), currentTimeNanos);
                    if (selector.keys().isEmpty()) {
                        if (shutdown || NioClientSocketPipelineSink.this.bossExecutor instanceof ExecutorService && ((ExecutorService)NioClientSocketPipelineSink.this.bossExecutor).isShutdown()) {
                            Object object = this.startStopLock;
                            synchronized (object) {
                                if (this.registerTaskQueue.isEmpty() && selector.keys().isEmpty()) {
                                    this.started = false;
                                    try {
                                        try {
                                            selector.close();
                                        }
                                        catch (IOException e) {
                                            if (logger.isWarnEnabled()) {
                                                logger.warn("Failed to close a selector.", e);
                                            }
                                            Object var18_19 = null;
                                            this.selector = null;
                                        }
                                        Object var18_18 = null;
                                        this.selector = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var18_20 = null;
                                        this.selector = null;
                                        throw throwable;
                                    }
                                    break;
                                }
                                shutdown = false;
                                continue;
                            }
                        }
                        shutdown = true;
                        continue;
                    }
                    shutdown = false;
                }
                catch (Throwable t) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Unexpected exception in the selector loop.", t);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }

        private void processRegisterTaskQueue() {
            Runnable task;
            while ((task = this.registerTaskQueue.poll()) != null) {
                task.run();
            }
        }

        private void processSelectedKeys(Set<SelectionKey> selectedKeys) {
            if (selectedKeys.isEmpty()) {
                return;
            }
            Iterator<SelectionKey> i = selectedKeys.iterator();
            while (i.hasNext()) {
                SelectionKey k = i.next();
                i.remove();
                if (!k.isValid()) {
                    this.close(k);
                    continue;
                }
                try {
                    if (!k.isConnectable()) continue;
                    this.connect(k);
                }
                catch (Throwable t) {
                    NioClientSocketChannel ch = (NioClientSocketChannel)k.attachment();
                    ch.connectFuture.setFailure(t);
                    Channels.fireExceptionCaught(ch, t);
                    k.cancel();
                    ch.worker.close(ch, Channels.succeededFuture(ch));
                }
            }
        }

        private void processConnectTimeout(Set<SelectionKey> keys, long currentTimeNanos) {
            ConnectException cause = null;
            for (SelectionKey k : keys) {
                if (!k.isValid()) continue;
                NioClientSocketChannel ch = (NioClientSocketChannel)k.attachment();
                if (ch.connectDeadlineNanos <= 0L || currentTimeNanos < ch.connectDeadlineNanos) continue;
                if (cause == null) {
                    cause = new ConnectException("connection timed out");
                }
                ch.connectFuture.setFailure(cause);
                Channels.fireExceptionCaught(ch, (Throwable)cause);
                ch.worker.close(ch, Channels.succeededFuture(ch));
            }
        }

        private void connect(SelectionKey k) throws IOException {
            NioClientSocketChannel ch = (NioClientSocketChannel)k.attachment();
            if (((SocketChannel)ch.channel).finishConnect()) {
                k.cancel();
                if (ch.timoutTimer != null) {
                    ch.timoutTimer.cancel();
                }
                ch.worker.register(ch, ch.connectFuture);
            }
        }

        private void close(SelectionKey k) {
            NioClientSocketChannel ch = (NioClientSocketChannel)k.attachment();
            ch.worker.close(ch, Channels.succeededFuture(ch));
        }

        private Selector recreateSelector() throws IOException {
            Selector newSelector;
            block6: {
                newSelector = Selector.open();
                Selector selector = this.selector;
                this.selector = newSelector;
                for (SelectionKey key : selector.keys()) {
                    SelectableChannel ch = key.channel();
                    int ops = key.interestOps();
                    Object att = key.attachment();
                    key.cancel();
                    try {
                        ch.register(newSelector, ops, att);
                    }
                    catch (ClosedChannelException e) {
                        this.close(key);
                    }
                }
                try {
                    selector.close();
                }
                catch (Throwable t) {
                    if (!logger.isWarnEnabled()) break block6;
                    logger.warn("Failed to close a selector.", t);
                }
            }
            if (logger.isWarnEnabled()) {
                logger.warn("Recreated Selector because of possible jdk epoll(..) bug");
            }
            return newSelector;
        }
    }
}

