/*
 * Decompiled with CFR 0.152.
 */
package ice.storm.print.jdk12;

import ice.debug.Debug;
import ice.storm.StormPrinter;
import ice.storm.print.jdk12.PageFormatConverter;
import ice.storm.print.jdk12.PrintablePage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;

public class PageableDocument {
    StormPrinter stormPrinter;
    PageFormat pageFormat;
    private String documentName = "StormPrinter";
    private boolean isPrintDialogVisible = false;
    private boolean isPageDialogVisible = false;

    public PageableDocument(StormPrinter stormPrinter) {
        this.stormPrinter = stormPrinter;
        this.pageFormat = PageFormatConverter.getPageFormat(stormPrinter.getStormPageFormat());
    }

    public void setStormPrinter(StormPrinter stormPrinter) {
        this.stormPrinter = stormPrinter;
        this.pageFormat = PageFormatConverter.getPageFormat(stormPrinter.getStormPageFormat());
    }

    public void setPrintDialogVisible(boolean isPrintDialogVisible) {
        this.isPrintDialogVisible = isPrintDialogVisible;
    }

    public void setPageDialogVisible(boolean isPageDialogVisible) {
        this.isPageDialogVisible = isPageDialogVisible;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public void setDocumentName(String parName) {
        this.documentName = parName;
    }

    public boolean print() {
        return this.print(0, this.stormPrinter.getPageCount() - 1);
    }

    public boolean print(int startPage, int endPage) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setJobName(this.documentName);
        boolean notCancelled = true;
        if (this.isPageDialogVisible) {
            this.pageFormat = printJob.pageDialog(new PageFormat());
            this.stormPrinter.setStormPageFormat(PageFormatConverter.getStormPageFormat(this.pageFormat));
            endPage = this.stormPrinter.getPageCount() - 1;
        }
        if (endPage > this.stormPrinter.getPageCount() - 1 || startPage < 0 || endPage < startPage) {
            throw new IndexOutOfBoundsException("start " + startPage + " end " + endPage);
        }
        Book book = new Book();
        for (int i = startPage; i <= endPage; ++i) {
            PrintablePage page = new PrintablePage(this.stormPrinter, i);
            book.append(page, this.pageFormat);
        }
        printJob.setPageable(book);
        try {
            if (this.isPrintDialogVisible) {
                notCancelled = printJob.printDialog();
                if (notCancelled) {
                    printJob.print();
                }
            } else {
                printJob.print();
            }
        }
        catch (Exception PrintException) {
            Debug.ex((Throwable)PrintException);
        }
        return notCancelled;
    }
}

