/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.PilotFactory;
import ice.storm.PilotInfo;
import ice.storm.Scripter;
import ice.storm.ScripterInfo;
import ice.storm.StormPropertiesLoader;
import ice.storm.URLClassLoaderFactory;
import ice.util.Defs;
import ice.util.security.SecurityKit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DefaultFactory
implements PilotFactory,
URLClassLoaderFactory {
    private static final String propFileName = "storm";
    private Vector pilotInfos = new Vector();
    private Vector scripterInfos = new Vector();
    private Hashtable hashByScripterAlias = new Hashtable();
    private Hashtable fileExtToContentType = new Hashtable();

    public void addPilotInfo(PilotInfo pi) {
        this.pilotInfos.addElement(pi);
    }

    public void removePilotInfo(PilotInfo pi) {
        this.pilotInfos.removeElement(pi);
    }

    public void addScripterInfo(ScripterInfo s) {
        if (s.aliases != null && s.aliases.length > 0) {
            this.scripterInfos.addElement(s);
            for (int j = 0; j < s.aliases.length; ++j) {
                this.hashByScripterAlias.put(s.aliases[j], s);
            }
        }
    }

    public void removeScripterInfo(ScripterInfo s) {
        if (this.scripterInfos.removeElement(s)) {
            for (int j = 0; j < s.aliases.length; ++j) {
                this.hashByScripterAlias.remove(s.aliases[j]);
            }
        }
    }

    public Enumeration getAllPilotInfos() {
        return this.pilotInfos.elements();
    }

    public Enumeration getAllScripterInfos() {
        return this.scripterInfos.elements();
    }

    public Scripter createScripter(String scriptName) {
        ScripterInfo s = this.getScripterInfo(scriptName);
        if (s == null) {
            return null;
        }
        Scripter scripter = (Scripter)Defs.newClassInstance((String)s.className);
        if (scripter == null) {
            if (Debug.trace) {
                Debug.trace((String)("Failed to load scripter for " + scriptName));
            }
            this.removeScripterInfo(s);
            return null;
        }
        s.loaded = true;
        return scripter;
    }

    public ScripterInfo getScripterInfo(String name) {
        ScripterInfo si = (ScripterInfo)this.hashByScripterAlias.get(name.toLowerCase());
        if (si != null && !si.enabled) {
            si = null;
        }
        return si;
    }

    public Pilot createPilot(String contentType) {
        int t = contentType.indexOf(59);
        if (t > 0) {
            contentType = contentType.substring(0, t);
        }
        Pilot pilot = null;
        block0: for (int j = 0; j < this.pilotInfos.size(); ++j) {
            PilotInfo p = (PilotInfo)this.pilotInfos.elementAt(j);
            if (!p.enabled) continue;
            for (int i = 0; i < p.supportedContentTypes.length; ++i) {
                String sup = p.supportedContentTypes[i];
                if (this.matchContentType(sup, contentType) && (pilot = this.createPilot(p)) != null) break block0;
            }
        }
        return pilot;
    }

    public Pilot createPilot(ContentLoader l) {
        String contentType = this.extractContentType(l);
        return this.createPilot(contentType);
    }

    private Pilot createPilot(PilotInfo p) {
        Pilot pilot;
        block6: {
            pilot = null;
            try {
                if (p.cl == null && p.codeBaseURLs != null && p.codeBaseURLs.length > 0) {
                    p.cl = this.createURLClassLoader(p.codeBaseURLs);
                }
                Class<?> pilotClass = p.cl != null ? p.cl.loadClass(p.className) : Class.forName(p.className);
                pilot = (Pilot)Defs.newClassInstance(pilotClass);
            }
            catch (Throwable ex) {
                if (!Debug.ex) break block6;
                Debug.ex((Throwable)ex);
            }
        }
        if (pilot != null) {
            p.loaded = true;
        } else {
            if (Debug.trace) {
                Debug.trace((String)("Could not load " + p.className));
            }
            this.removePilotInfo(p);
        }
        return pilot;
    }

    public boolean isContentTypeSupported(Pilot pilot, ContentLoader l, String contentType) {
        String pname = pilot.getClass().getName();
        if (contentType == null) {
            contentType = this.extractContentType(l);
        }
        int n = this.pilotInfos.size() - 1;
        for (int j = 0; j != n; ++j) {
            PilotInfo p = (PilotInfo)this.pilotInfos.elementAt(j);
            if (!p.enabled || !pname.equals(p.className)) continue;
            String[] types = p.supportedContentTypes;
            int count = types.length;
            for (int i = 0; i != count; ++i) {
                if (!this.matchContentType(types[i], contentType)) continue;
                return true;
            }
        }
        return false;
    }

    public ClassLoader createURLClassLoader(URL[] urls) {
        return SecurityKit.newURLClassLoader((URL[])urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDefaultResources() {
        boolean done;
        block15: {
            InputStream in;
            block14: {
                String defaultUrl = Defs.sysProperty((String)"ice.storm.storm");
                done = false;
                if (defaultUrl != null) {
                    try {
                        URL urlObj = new URL(defaultUrl);
                        InputStream in2 = urlObj.openStream();
                        try {
                            this.loadInfos(in2);
                            done = true;
                        }
                        finally {
                            in2.close();
                        }
                    }
                    catch (IOException ex) {
                        if (Debug.ex) {
                            Debug.ex((Throwable)ex);
                        }
                        if (!Debug.trace) break block14;
                        Debug.trace((String)("ERROR: failed to load properties from " + defaultUrl + ", trying built-in."));
                    }
                }
            }
            if (!done && (in = this.getClass().getResourceAsStream(propFileName)) != null) {
                try {
                    try {
                        this.loadInfos(in);
                        done = true;
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    if (!Debug.ex) break block15;
                    Debug.ex((Throwable)ex);
                }
            }
        }
        if (!done && Debug.trace) {
            Debug.trace((String)"ERROR: Could not load default storm properties file");
        }
    }

    private void loadInfos(InputStream in) throws IOException {
        int i;
        StormPropertiesLoader pl = new StormPropertiesLoader();
        pl.loadProperties(in, this.fileExtToContentType);
        Object notsup = null;
        int tmp = this.pilotInfos.size();
        if (tmp > 0) {
            notsup = this.pilotInfos.elementAt(tmp - 1);
            this.pilotInfos.removeElementAt(tmp - 1);
        }
        for (i = 0; i < pl.infos.size(); ++i) {
            this.pilotInfos.addElement(pl.infos.elementAt(i));
        }
        if (notsup != null) {
            this.pilotInfos.addElement(notsup);
        }
        for (i = 0; i < pl.scripters.size(); ++i) {
            ScripterInfo s = (ScripterInfo)pl.scripters.elementAt(i);
            this.addScripterInfo(s);
        }
    }

    protected String extractContentType(ContentLoader l) {
        String contentType = l.getContentType();
        String guessedType = null;
        if (contentType == null) {
            guessedType = this.getExtensionBasedType(l.getLocation());
        } else {
            int semicolon = (contentType = contentType.toLowerCase()).indexOf(59);
            if (semicolon >= 0) {
                contentType = contentType.substring(0, semicolon).trim();
            } else if (contentType.indexOf("unknown") >= 0) {
                guessedType = this.getExtensionBasedType(l.getLocation());
            } else if (contentType.equalsIgnoreCase("text/html") || contentType.equalsIgnoreCase("text/plain")) {
                // empty if block
            }
        }
        if (guessedType != null) {
            contentType = guessedType;
            l.setContentType(guessedType);
        }
        return contentType;
    }

    private String getExtensionBasedType(String location) {
        String s;
        int lastSlash;
        String type = "content/unknown";
        String ext = null;
        if (location != null && (lastSlash = location.lastIndexOf(47)) >= 0) {
            int hash = location.indexOf(35, lastSlash + 1);
            int question = location.indexOf(63, lastSlash + 1);
            int end = hash < 0 || question < 0 ? location.length() : (hash < 0 || hash > question ? question : hash);
            int dotPos = location.lastIndexOf(46, end - 1);
            if (dotPos > lastSlash && dotPos != end - 1) {
                ext = location.substring(dotPos, end);
            }
        }
        if (ext != null && (s = (String)this.fileExtToContentType.get(ext)) != null) {
            type = s;
        }
        return type;
    }

    private boolean matchContentType(String sup, String type) {
        if (sup.indexOf(42) < 0) {
            return sup.equals(type);
        }
        int idx = sup.indexOf(47);
        if (idx < 0) {
            return sup.length() == 1;
        }
        String major = sup.substring(0, idx);
        String minor = sup.substring(idx + 1);
        return !(!major.equals("*") && !type.startsWith(major) || !minor.equals("*") && !type.endsWith(minor));
    }
}

