/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing.dnd;

import ice.debug.Debug;
import ice.pilots.html4.ICEDragClient;
import ice.pilots.html4.swing.dnd.StringTransferable;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;

public class DragSourceAgent {
    private DragSource dragSource;
    private DragGestureListener dgListener;
    private DragSourceListener dsListener;
    private final ICEDragClient client;

    public DragSourceAgent(ICEDragClient client, Component visualComponent) {
        if (client == null) {
            throw new IllegalArgumentException("ICEDragClient cannot be null");
        }
        if (visualComponent == null) {
            throw new IllegalArgumentException("Drag and Drop visual component cannot be null");
        }
        this.client = client;
        this.dragSource = DragSource.getDefaultDragSource();
        this.dgListener = new DragGestureListener(){

            public void dragGestureRecognized(DragGestureEvent e) {
                if (DragSourceAgent.this.client.isGestureListeningEnabled()) {
                    try {
                        String payload = DragSourceAgent.this.client.getDragPayload();
                        if (payload != null) {
                            StringTransferable st = new StringTransferable(payload);
                            e.startDrag(DragSource.DefaultCopyDrop, st, DragSourceAgent.this.dsListener);
                        }
                    }
                    catch (InvalidDnDOperationException idoe) {
                        Debug.trace((String)("Invalid DND operation exception: " + idoe));
                    }
                }
            }
        };
        this.dsListener = new DragSourceListener(){
            private Cursor defaultCursor;

            public void dragOver(DragSourceDragEvent dsde) {
                DragSourceContext dsc = dsde.getDragSourceContext();
                if (this.defaultCursor == null) {
                    this.defaultCursor = dsc.getCursor();
                    dsc.setCursor(DragSource.DefaultCopyNoDrop);
                }
            }

            public void dragEnter(DragSourceDragEvent dsde) {
                DragSourceContext dsc = dsde.getDragSourceContext();
                if (this.defaultCursor == null) {
                    this.defaultCursor = dsc.getCursor();
                    dsc.setCursor(DragSource.DefaultCopyDrop);
                }
            }

            public void dropActionChanged(DragSourceDragEvent dsde) {
            }

            public void dragDropEnd(DragSourceDropEvent e) {
                DragSourceContext dsc = e.getDragSourceContext();
                if (this.defaultCursor == null) {
                    this.defaultCursor = dsc.getCursor();
                    dsc.setCursor(DragSource.DefaultCopyNoDrop);
                }
            }

            public void dragExit(DragSourceEvent dsde) {
                DragSourceContext dsc = dsde.getDragSourceContext();
                dsc.setCursor(this.defaultCursor);
                this.defaultCursor = null;
            }
        };
        this.dragSource.createDefaultDragGestureRecognizer(visualComponent, 3, this.dgListener);
    }
}

