/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.debug.Debug;
import ice.pilots.html4.ComponentFactory;
import ice.pilots.html4.FocusManager;
import ice.pilots.html4.Html4DocumentAccess;
import ice.pilots.html4.ICEDropClient;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ScrollPositionChangeCallback;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.FormInputText;
import ice.pilots.html4.awt.FormTextArea;
import ice.pilots.html4.awt.Movable;
import ice.util.Defs;
import ice.util.JavaVersion;
import ice.util.awt.AWTEventListenerCallback;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class DocPanel
extends Panel
implements AWTEventListenerCallback {
    private static final boolean isMacOS = Defs.sysProperty((String)"os.name").startsWith("Mac OS");
    private DocView docView;
    private int sx = 0;
    private int sy = 0;
    int nsx = 0;
    int nsy = 0;
    private Image offscreenBuffer = null;
    boolean reflow_req = false;
    private boolean clear_req = false;
    private boolean childrenHidden = false;
    private int vScrollDistance;
    private int hScrollDistance;
    private int scrollTimeout;
    private int lastDraggedY;
    private int scrollMouseX = -1;
    private int scrollMouseY = -1;
    private int selectMouseX = -1;
    private int selectMouseY = -1;
    private int selectButton = 0;
    private int scrollButton = 1;
    private boolean reclaimFocusOnScroll = false;
    private long scrollTimestamp = 0L;
    private boolean mouseGestureListeningEnabled;
    private ICEDropClient dropClient;
    private boolean childrenValidated;
    private Object v14FocusKeyListener;
    boolean preventOptimisedPaintOnce = false;

    DocPanel(DocView docView) {
        this.docView = docView;
        this.enableEvents(60L);
        this.setLayout(null);
        this.vScrollDistance = Defs.sysPropertyInt((String)"ice.pilots.html4.vScrollDistance", (int)0);
        this.hScrollDistance = Defs.sysPropertyInt((String)"ice.pilots.html4.hScrollDistance", (int)0);
        this.scrollTimeout = Defs.sysPropertyInt((String)"ice.pilots.html4.scrollTimeout", (int)30);
        this.reclaimFocusOnScroll = Defs.sysPropertyBoolean((String)"ice.pilots.html4.awt.reclaimFocus");
        String value = Defs.sysProperty((String)"ice.pilots.html4.selectButton");
        if (!docView.enableTextSelection) {
            value = "none";
        }
        this.selectButton = ComponentFactory.parseButton(value, this.selectButton);
        value = Defs.sysProperty((String)"ice.pilots.html4.scrollButton");
        this.scrollButton = ComponentFactory.parseButton(value, this.scrollButton);
        if (JavaVersion.isV14orGreater()) {
            this.addEventListenerReflectively();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Component add(Component c) {
        c.setVisible(false);
        if (!isMacOS || !JavaVersion.isV12orGreater()) {
            super.add(c);
            return c;
        }
        if (c instanceof FormInputText || c instanceof FormTextArea) {
            try {
                Class<?> targetClass = c.getClass();
                Class[] params = new Class[]{Boolean.TYPE};
                Method meth = targetClass.getMethod("enableInputMethods", params);
                Object[] trueArray = new Object[]{Boolean.TRUE};
                Object[] falseArray = new Object[]{Boolean.FALSE};
                meth.invoke((Object)c, falseArray);
                super.add(c);
                meth.invoke((Object)c, trueArray);
            }
            catch (Exception e) {
                Debug.ex((Throwable)e);
            }
        } else {
            super.add(c);
        }
        return c;
    }

    public void removeNotify() {
        if (this.offscreenBuffer != null) {
            this.offscreenBuffer.flush();
            this.offscreenBuffer = null;
        }
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideChildren() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.childrenHidden) {
                return;
            }
            this.childrenHidden = true;
            int count = this.getComponentCount();
            try {
                for (int i = 0; i < count; ++i) {
                    Component component = this.getComponent(i);
                    if (!component.isVisible()) continue;
                    component.setVisible(false);
                }
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showChildren() {
        FocusManager focusManager;
        long time = System.currentTimeMillis();
        if (time - this.scrollTimestamp < this.docView.repaintTimeout) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!this.childrenHidden) {
                return;
            }
            this.childrenHidden = false;
            int count = this.getComponentCount();
            try {
                for (int i = 0; i < count; ++i) {
                    Movable movable;
                    ObjectBox box;
                    Component component = this.getComponent(i);
                    if (!(component instanceof Movable) || (box = (movable = (Movable)((Object)component)).getBox()) == null) continue;
                    Point p = new Point(0, 0);
                    box.findAbsolutePosition(p);
                    movable.syncDom(p.x - this.sx, p.y - this.sy, box.checkIfVisible());
                }
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                return;
            }
        }
        if (this.reclaimFocusOnScroll && !(focusManager = this.docView.getPilot().getView().getFocusManager()).requestFocus()) {
            this.requestFocus();
        }
        this.childrenValidated = true;
    }

    public void doLayout() {
        int height;
        int width;
        block19: {
            if (this.docView.isPilotDisposed()) {
                return;
            }
            Dimension sz = this.getSize();
            width = sz.width;
            height = sz.height;
            if (this.offscreenBuffer != null && (this.offscreenBuffer.getWidth(null) != width || this.offscreenBuffer.getHeight(null) != height)) {
                this.offscreenBuffer.flush();
                this.offscreenBuffer = null;
            }
            try {
                this.docView.docLayout(width, height);
            }
            catch (Exception ex) {
                if (Debug.ex) {
                    Debug.ex((Throwable)ex);
                }
                if (!Debug.trace) break block19;
                Debug.trace((String)("Layout exception: " + ex));
            }
        }
        Scrollbar vbar = this.docView.vbar;
        Scrollbar hbar = this.docView.hbar;
        if (vbar != null && this.isVisible()) {
            int y = vbar.getValue();
            int newHeight = height;
            int maxy = this.docView.getDocHeight();
            if (newHeight > maxy) {
                newHeight = maxy;
            }
            if (y + newHeight > maxy) {
                this.nsy = y = maxy - newHeight;
            }
            vbar.setValues(y, newHeight, 0, maxy);
            vbar.setBlockIncrement(newHeight);
            vbar.setUnitIncrement(20);
            int x = hbar.getValue();
            int maxx = this.docView.getDocWidth();
            int newWidth = width;
            if (newWidth > maxx) {
                newWidth = maxx;
            }
            if (x + newWidth > maxx) {
                this.nsx = x = maxx - newWidth;
            }
            hbar.setValues(x, newWidth, 0, maxx);
            hbar.setBlockIncrement(newWidth);
            hbar.setUnitIncrement(20);
            boolean scrollbarVisibilityChange = false;
            if (maxy <= newHeight) {
                if (vbar.isVisible() && this.docView.validateTreeNesting <= 1) {
                    vbar.setVisible(false);
                    scrollbarVisibilityChange = true;
                }
            } else if (!vbar.isVisible()) {
                vbar.setVisible(true);
                scrollbarVisibilityChange = true;
            }
            if (maxx <= newWidth) {
                if (hbar.isVisible() && this.docView.validateTreeNesting <= 1) {
                    hbar.setVisible(false);
                    scrollbarVisibilityChange = true;
                }
            } else if (!hbar.isVisible()) {
                hbar.setVisible(true);
                scrollbarVisibilityChange = true;
            }
            if (scrollbarVisibilityChange) {
                this.setScrollPosition(this.nsx, this.nsy);
                this.docView._panePanel.validateTree();
                return;
            }
        }
        this.docView.docPostLayout();
        this.setScrollPosition(this.nsx, this.nsy);
        this.childrenHidden = true;
        this.scrollTimestamp = 0L;
        this.showChildren();
    }

    void setScrollPosition(int x, int y) {
        if (this.sx != x || this.sy != y) {
            int oldX = this.sx;
            int oldY = this.sy;
            this.sx = x;
            this.sy = y;
            ScrollPositionChangeCallback callback = this.docView.getScrollPositionChangeCallback();
            if (callback != null) {
                callback.setScrollPositionChanged(x, oldX, y, oldY);
            }
        }
    }

    int getScrollX() {
        return this.sx;
    }

    int getScrollY() {
        return this.sy;
    }

    void scroll(int x, int y) {
        if (this.docView.canScroll(x, y)) {
            this.nsx = x;
            this.nsy = y;
            this.hideChildren();
            this.repaint();
            this.scrollTimestamp = System.currentTimeMillis();
            this.docView.postShowChildren(this);
            this.docView.docScrollChanged(x, y);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        if (w < 0 || h < 0) {
            if (Debug.trace) {
                Debug.trace((String)("Error: negative dimension: w=" + w + " h=" + h));
            }
            if (w < 0) {
                w = 0;
            }
            if (h < 0) {
                h = 0;
            }
        }
        super.setBounds(x, y, w, h);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Graphics gg;
        if (this.docView.isPilotDisposed()) {
            return;
        }
        if (!this.docView.doesAutoRepaint()) {
            return;
        }
        if (g == null) {
            return;
        }
        Rectangle r = g.getClipBounds();
        Dimension sz = this.getSize();
        if (r != null) {
            if (r.x >= sz.width) {
                return;
            }
            if (r.y >= sz.height) {
                return;
            }
            if (r.x + r.width < 0) {
                return;
            }
            if (r.y + r.height < 0) {
                return;
            }
        }
        if (this.offscreenBuffer == null) {
            try {
                this.offscreenBuffer = this.createImage(sz.width, sz.height);
            }
            catch (Exception ex) {
                return;
            }
        }
        if ((gg = this.offscreenBuffer.getGraphics()) == null) {
            if (this.offscreenBuffer != null) {
                this.offscreenBuffer.flush();
            }
            this.offscreenBuffer = null;
            return;
        }
        if (this.preventOptimisedPaintOnce || this.docView.docContainsFixedBoxes() || this.nsx != this.sx && this.nsy != this.sy) {
            this.setScrollPosition(this.nsx, this.nsy);
        } else if (r == null || r.width == sz.width && r.height == sz.height) {
            if (this.nsy < this.sy) {
                if (this.sy - this.nsy < sz.height) {
                    g.copyArea(0, 0, sz.width, sz.height - (this.sy - this.nsy), 0, this.sy - this.nsy);
                    g.setClip(0, 0, sz.width, this.sy - this.nsy);
                }
            } else if (this.nsy > this.sy) {
                if (this.nsy - this.sy < sz.height) {
                    g.copyArea(0, this.nsy - this.sy, sz.width, sz.height - (this.nsy - this.sy), 0, this.sy - this.nsy);
                    g.setClip(0, sz.height - (this.nsy - this.sy), sz.width, this.nsy - this.sy);
                }
            } else if (this.nsx < this.sx) {
                if (this.sx - this.nsx < sz.width) {
                    g.copyArea(0, 0, sz.width - (this.sx - this.nsx), sz.height, this.sx - this.nsx, 0);
                    g.setClip(0, 0, this.sx - this.nsx, sz.height);
                }
            } else if (this.nsx > this.sx && this.nsx - this.sx < sz.width) {
                g.copyArea(this.nsx - this.sx, 0, sz.width - (this.nsx - this.sx), sz.height, this.sx - this.nsx, 0);
                g.setClip(sz.width - (this.nsx - this.sx), 0, this.nsx - this.sx, sz.height);
            }
            r = g.getClipBounds();
            this.setScrollPosition(this.nsx, this.nsy);
        }
        if (r == null) {
            g.setClip(0, 0, sz.width, sz.height);
            r = g.getClipBounds();
        }
        gg.setClip(r);
        this.childrenValidated = false;
        this.paintInto(gg, r);
        if (!this.childrenValidated) {
            this.childrenHidden = true;
            this.showChildren();
        }
        gg.dispose();
        if (this.offscreenBuffer != null) {
            g.drawImage(this.offscreenBuffer, r.x, r.y, r.x + r.width, r.y + r.height, r.x, r.y, r.x + r.width, r.y + r.height, null);
        }
        this.preventOptimisedPaintOnce = false;
    }

    private void paintInto(Graphics g, Rectangle r) {
        g.translate(-this.sx, -this.sy);
        g.setClip(r.x + this.sx, r.y + this.sy, r.width, r.height);
        this.docView.docPaint(g);
        g.translate(this.sx, this.sy);
        this.docView.docPaintFixed(g);
    }

    private boolean isButtonDown(int whichButton, InputEvent e) {
        if (whichButton < 0) {
            return false;
        }
        int m = e.getModifiers();
        if (whichButton == 0 && (m == 0 || (m & 0x10) != 0)) {
            return true;
        }
        return whichButton == 1 && (m & 4) != 0;
    }

    private void mouseDragged(MouseEvent e) {
        this.lastDraggedY = e.getY();
        if (this.isButtonDown(this.scrollButton, e)) {
            if (this.scrollMouseX >= 0) {
                int dx = this.scrollMouseX - e.getX();
                int dy = this.scrollMouseY - e.getY();
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0;
                } else {
                    dx = 0;
                }
                this.docView.setScrollPosition(this.sx + dx, this.sy + dy);
            }
            this.scrollMouseX = e.getX();
            this.scrollMouseY = e.getY();
        } else if (this.isButtonDown(this.selectButton, e)) {
            if (this.selectMouseX >= 0) {
                int scrollUpDown = 0;
                int scrollLeftRight = 0;
                Dimension d = this.getSize();
                int itemp = e.getY();
                if (itemp > d.height) {
                    scrollUpDown = this.vScrollDistance > 0 ? this.vScrollDistance : itemp - d.height;
                } else if (itemp < 0) {
                    scrollUpDown = this.vScrollDistance > 0 ? -this.vScrollDistance : itemp;
                }
                itemp = e.getX();
                if (itemp > d.width) {
                    scrollLeftRight = this.hScrollDistance > 0 ? this.hScrollDistance : itemp - d.width;
                } else if (itemp < 0) {
                    scrollLeftRight = this.hScrollDistance > 0 ? -this.hScrollDistance : itemp;
                }
                this.scrollAndSelect(scrollUpDown, scrollLeftRight, e.getX(), e.getY());
            } else {
                this.selectMouseX = e.getX();
                this.selectMouseY = e.getY();
            }
        }
    }

    private void scrollAndSelect(int scrollUpDown, int scrollLeftRight, int ex, int ey) {
        if (scrollUpDown != 0 || scrollLeftRight != 0) {
            long tmp = System.currentTimeMillis();
            if (tmp - this.scrollTimestamp > (long)this.scrollTimeout) {
                int max = this.docView.vbar.getMaximum();
                int vis = this.docView.vbar.getVisibleAmount();
                int val = this.docView.vbar.getValue();
                if (scrollUpDown > 0 && val + vis == max) {
                    return;
                }
                if (scrollUpDown < 0 && val == 0) {
                    return;
                }
                if (scrollLeftRight > 0 && this.docView.hbar.getValue() + this.docView.hbar.getVisibleAmount() == this.docView.hbar.getMaximum()) {
                    return;
                }
                if (scrollLeftRight < 0 && this.docView.hbar.getValue() == 0) {
                    return;
                }
                this.docView.setScrollPosition(this.sx + scrollLeftRight, this.sy + scrollUpDown);
                this.scrollTimestamp = tmp;
                this.selectMouseY -= scrollUpDown;
                this.selectMouseX -= scrollLeftRight;
            }
            DelayedScroll t = new DelayedScroll(this, ex, ey, scrollUpDown, scrollLeftRight);
            this.docView.getPilot().getStorm().runOnEventThreadLater(t, this.scrollTimeout + 10);
        }
        this.docView.docSetSelection(this.selectMouseX, this.selectMouseY, ex + scrollLeftRight, ey + scrollUpDown);
    }

    private void performDelayedScroll(DelayedScroll ds) {
        if (this.selectMouseX != -1 && ds.selY == this.lastDraggedY) {
            this.scrollAndSelect(ds.scrollUpDown, ds.scrollLeftRight, ds.selX, ds.selY);
        }
    }

    private void mousePressed(MouseEvent e) {
        this.requestFocus();
        if (this.isButtonDown(this.selectButton, e) && !e.isPopupTrigger()) {
            this.docView.docClearSelection();
            this.docView.docMarkDocument(e.getX(), e.getY());
        }
    }

    private void mouseReleased(MouseEvent e) {
        this.scrollMouseX = -1;
        this.selectMouseX = -1;
        this.docView.postSelectedToClipboard();
    }

    private void mouseExited(MouseEvent e) {
        this.scrollMouseX = -1;
    }

    private void mouseClicked(MouseEvent event) {
        if (this.isButtonDown(this.selectButton, event)) {
            int clickCount = event.getClickCount();
            int mouseX = event.getX();
            int mouseY = event.getY();
            Html4DocumentAccess access = new Html4DocumentAccess(this.docView.getPilot());
            switch (clickCount) {
                case 4: {
                    access.setSelection(0, mouseX, mouseY);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    access.setSelection(2, mouseX, mouseY);
                }
            }
        }
    }

    protected void processEvent(AWTEvent e) {
        if (this.docView.onComponentEvent(this, e)) {
            super.processEvent(e);
            switch (e.getID()) {
                case 506: {
                    this.mouseDragged((MouseEvent)e);
                    break;
                }
                case 501: {
                    this.mousePressed((MouseEvent)e);
                    break;
                }
                case 502: {
                    this.mouseReleased((MouseEvent)e);
                    break;
                }
                case 505: {
                    this.mouseExited((MouseEvent)e);
                    break;
                }
                case 500: {
                    this.mouseClicked((MouseEvent)e);
                }
            }
        }
    }

    private void addEventListenerReflectively() {
        block4: {
            try {
                String className = "ice.util.awt.jdk12.AWTEventListener";
                Constructor<?> constr = Class.forName(className).getConstructors()[0];
                Object[] args = new Object[]{this};
                this.v14FocusKeyListener = constr.newInstance(args);
                if (Debug.trace) {
                    Debug.trace((String)"Custom AWTEventListener constructed.");
                }
            }
            catch (Throwable t1) {
                if (Debug.trace) {
                    Debug.trace((String)"Problem constructing custom AWTEventListener.");
                }
                if (!Debug.ex) break block4;
                Debug.ex((Throwable)t1);
            }
        }
    }

    public void receiveEvent(AWTEvent awtEvent) {
        if (this.equals(awtEvent.getSource())) {
            this.processEvent(awtEvent);
        }
    }

    public void dispose() {
        if (this.v14FocusKeyListener != null) {
            this.disposeEventListenerReflectively();
        }
    }

    private void disposeEventListenerReflectively() {
        block3: {
            try {
                Method disposeMethod = this.v14FocusKeyListener.getClass().getDeclaredMethod("dispose", null);
                disposeMethod.invoke(this.v14FocusKeyListener, null);
                if (Debug.trace) {
                    Debug.trace((String)"Custom AWTEventListener disposed.");
                }
            }
            catch (Throwable t1) {
                if (!Debug.ex) break block3;
                Debug.ex((Throwable)t1);
            }
        }
    }

    private static class DelayedScroll
    implements Runnable {
        private final DocPanel owner;
        private final int selY;
        private final int selX;
        private final int scrollUpDown;
        private final int scrollLeftRight;

        DelayedScroll(DocPanel owner, int selX, int selY, int scrollUpDown, int scrollLeftRight) {
            this.owner = owner;
            this.selY = selY;
            this.selX = selX;
            this.scrollUpDown = scrollUpDown;
            this.scrollLeftRight = scrollLeftRight;
        }

        public void run() {
            this.owner.performDelayedScroll(this);
        }
    }
}

