/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.dombase.NamesBase;
import ice.pilots.html4.StormData;
import ice.storm.StormBase;
import ice.util.alg.CharKit;
import java.util.Hashtable;

public class Names
extends NamesBase {
    public static final int NS_GLOBAL = 0;
    public static final int NS_XML = 1;
    public static final int NS_XMLNS = 2;
    public static final int NS_HTML = 3;
    public static final int NS_XSL = 4;
    public static final int NS_MSIE_PLANET = 5;
    private Hashtable nsHash;
    private Namespace[] nsArray;
    private int numNamespaces = 0;
    private int[] tagNS = new int[16];
    private static String[] tagName = new String[16];
    private int[] attrNS = new int[16];
    private String[] attrName = new String[16];
    private int numTags = 0;
    private int numAttrs = 0;

    public Names() {
        this.nsHash = new Hashtable();
        this.nsArray = new Namespace[16];
        Namespace sp = new Namespace("", 0);
        this.nsHash.put(sp.name, sp);
        this.nsArray[this.numNamespaces++] = sp;
        sp = new Namespace("http://www.w3.org/XML/1998/namespace", 1);
        this.nsHash.put(sp.name, sp);
        this.nsArray[this.numNamespaces++] = sp;
        sp = new Namespace("http://www.w3.org/2000/xmlns/", 2);
        this.nsHash.put(sp.name, sp);
        this.nsArray[this.numNamespaces++] = sp;
        sp = new Namespace("http://www.w3.org/TR/REC-html40", 3);
        this.nsHash.put(sp.name, sp);
        this.nsHash.put("http://www.w3.org/TR/xhtml1", sp);
        this.nsHash.put("http://www.w3.org/1999/xhtml", sp);
        this.nsHash.put("http://www.w3.org/Profiles/XHTML-transitional", sp);
        this.nsHash.put("http://www/w3/org/TR/xhtml1", sp);
        this.nsArray[this.numNamespaces++] = sp;
        this.numTags = 96;
        this.numAttrs = 124;
        sp = new Namespace("http://www.w3.org/1999/XSL/Transform", 4);
        this.nsHash.put(sp.name, sp);
        this.nsHash.put("http://www.w3.org/TR/WD-xsl", sp);
        this.nsArray[this.numNamespaces++] = sp;
        sp = new Namespace("nowhere:nothing", 5);
        this.nsHash.put(sp.name, sp);
        this.nsArray[this.numNamespaces++] = sp;
    }

    public int getNumTags() {
        return this.numTags;
    }

    public int getNamespace(String namespace) {
        Namespace sp = (Namespace)this.nsHash.get(namespace);
        if (sp == null) {
            sp = new Namespace(namespace, this.numNamespaces);
            this.nsHash.put(namespace, sp);
            this.nsArray[this.numNamespaces++] = sp;
        }
        return sp.id;
    }

    public int getNamespace(char[] ch, int offset, int length) {
        return this.getNamespace(new String(ch, offset, length));
    }

    public String getNamespace(int id) {
        return this.nsArray[id].name;
    }

    public int getTagId(int namespaceId, String name) {
        if (namespaceId == 3) {
            char[] cc = name.toCharArray();
            return HTMLTagMatcher.matchAttrIdForTag(cc, 0, cc.length);
        }
        Namespace sp = this.nsArray[namespaceId];
        Integer i = (Integer)sp.tagsHash.get(name);
        if (i == null) {
            i = new Integer(this.numTags);
            sp.tagsHash.put(name, i);
            if (this.numTags - 96 == this.tagNS.length) {
                int[] t1 = new int[this.tagNS.length * 2];
                String[] t2 = new String[tagName.length * 2];
                System.arraycopy(this.tagNS, 0, t1, 0, this.tagNS.length);
                System.arraycopy(tagName, 0, t2, 0, tagName.length);
                this.tagNS = t1;
                tagName = t2;
            }
            this.tagNS[this.numTags - 96] = sp.id;
            Names.tagName[this.numTags - 96] = name;
            ++this.numTags;
        }
        return i;
    }

    public int getTagId(int namespaceId, char[] ch, int offset, int length) {
        if (namespaceId == 3) {
            return HTMLTagMatcher.matchAttrIdForTag(ch, offset, length);
        }
        return this.getTagId(namespaceId, new String(ch, offset, length));
    }

    public static String getTagName(int tagId) {
        if (tagId < 96) {
            return tagsPre[tagId];
        }
        return tagName[tagId - 96];
    }

    public int getTagNamespaceId(int tagId) {
        if (tagId < 96) {
            return 3;
        }
        return this.tagNS[tagId - 96];
    }

    public String getTagNamespaceURI(int tagId) {
        if (tagId < 96) {
            return this.getNamespace(3);
        }
        int i = this.tagNS[tagId - 96];
        return this.getNamespace(i);
    }

    public int getAttrId(int namespaceId, String name) {
        int id;
        Namespace sp = this.nsArray[namespaceId];
        if (namespaceId == 3 && (id = Names.getAttrIdHTML(name = CharKit.toLowerCase((String)name))) != 0) {
            return id;
        }
        Integer i = (Integer)sp.attrsHash.get(name);
        if (i == null) {
            i = new Integer(this.numAttrs);
            sp.attrsHash.put(name, i);
            if (this.numAttrs - 124 == this.attrNS.length) {
                int[] t1 = new int[this.attrNS.length * 2];
                String[] t2 = new String[this.attrName.length * 2];
                System.arraycopy(this.attrNS, 0, t1, 0, this.attrNS.length);
                System.arraycopy(this.attrName, 0, t2, 0, this.attrName.length);
                this.attrNS = t1;
                this.attrName = t2;
            }
            this.attrNS[this.numAttrs - 124] = sp.id;
            this.attrName[this.numAttrs - 124] = name;
            ++this.numAttrs;
        }
        return i;
    }

    public int getAttrId(int namespaceId, char[] ch, int offset, int length) {
        return this.getAttrId(namespaceId, new String(ch, offset, length));
    }

    private String do_getAttrName(int attrId) {
        switch (attrId) {
            case 1: {
                return "abbr";
            }
            case 2: {
                return "accept-charset";
            }
            case 3: {
                return "accept";
            }
            case 4: {
                return "accesskey";
            }
            case 5: {
                return "action";
            }
            case 6: {
                return "align";
            }
            case 7: {
                return "alink";
            }
            case 8: {
                return "alt";
            }
            case 9: {
                return "archive";
            }
            case 10: {
                return "axis";
            }
            case 11: {
                return "background";
            }
            case 12: {
                return "bgcolor";
            }
            case 13: {
                return "border";
            }
            case 14: {
                return "cellpadding";
            }
            case 15: {
                return "cellspacing";
            }
            case 16: {
                return "char";
            }
            case 17: {
                return "charoff";
            }
            case 18: {
                return "charset";
            }
            case 19: {
                return "checked";
            }
            case 20: {
                return "cite";
            }
            case 21: {
                return "class";
            }
            case 22: {
                return "classid";
            }
            case 23: {
                return "clear";
            }
            case 24: {
                return "code";
            }
            case 25: {
                return "codebase";
            }
            case 26: {
                return "codetype";
            }
            case 27: {
                return "color";
            }
            case 28: {
                return "cols";
            }
            case 29: {
                return "colspan";
            }
            case 30: {
                return "compact";
            }
            case 31: {
                return "content";
            }
            case 32: {
                return "coords";
            }
            case 33: {
                return "data";
            }
            case 34: {
                return "datetime";
            }
            case 35: {
                return "declare";
            }
            case 36: {
                return "defer";
            }
            case 37: {
                return "dir";
            }
            case 38: {
                return "disabled";
            }
            case 39: {
                return "enctype";
            }
            case 40: {
                return "face";
            }
            case 41: {
                return "for";
            }
            case 42: {
                return "frame";
            }
            case 43: {
                return "frameborder";
            }
            case 44: {
                return "headers";
            }
            case 45: {
                return "height";
            }
            case 46: {
                return "href";
            }
            case 47: {
                return "hreflang";
            }
            case 48: {
                return "hspace";
            }
            case 49: {
                return "http-equiv";
            }
            case 50: {
                return "id";
            }
            case 51: {
                return "ismap";
            }
            case 52: {
                return "label";
            }
            case 53: {
                return "lang";
            }
            case 54: {
                return "language";
            }
            case 55: {
                return "link";
            }
            case 56: {
                return "longdesc";
            }
            case 57: {
                return "marginheight";
            }
            case 58: {
                return "marginwidth";
            }
            case 59: {
                return "maxlength";
            }
            case 60: {
                return "media";
            }
            case 61: {
                return "method";
            }
            case 62: {
                return "multiple";
            }
            case 63: {
                return "name";
            }
            case 64: {
                return "nohref";
            }
            case 65: {
                return "noresize";
            }
            case 66: {
                return "noshade";
            }
            case 67: {
                return "nowrap";
            }
            case 68: {
                return "object";
            }
            case 69: {
                return "onblur";
            }
            case 70: {
                return "onchange";
            }
            case 71: {
                return "onclick";
            }
            case 72: {
                return "ondblclick";
            }
            case 73: {
                return "onfocus";
            }
            case 74: {
                return "onkeydown";
            }
            case 75: {
                return "onkeypress";
            }
            case 76: {
                return "onkeyup";
            }
            case 77: {
                return "onload";
            }
            case 78: {
                return "onmousedown";
            }
            case 79: {
                return "onmousemove";
            }
            case 80: {
                return "onmouseout";
            }
            case 81: {
                return "onmouseover";
            }
            case 82: {
                return "onmouseup";
            }
            case 83: {
                return "onreset";
            }
            case 84: {
                return "onselect";
            }
            case 85: {
                return "onsubmit";
            }
            case 86: {
                return "onunload";
            }
            case 87: {
                return "profile";
            }
            case 88: {
                return "prompt";
            }
            case 89: {
                return "readonly";
            }
            case 90: {
                return "rel";
            }
            case 91: {
                return "rev";
            }
            case 92: {
                return "rows";
            }
            case 93: {
                return "rowspan";
            }
            case 94: {
                return "rules";
            }
            case 95: {
                return "scheme";
            }
            case 96: {
                return "scope";
            }
            case 97: {
                return "scrolling";
            }
            case 98: {
                return "selected";
            }
            case 99: {
                return "shape";
            }
            case 100: {
                return "size";
            }
            case 101: {
                return "span";
            }
            case 102: {
                return "src";
            }
            case 103: {
                return "standby";
            }
            case 104: {
                return "start";
            }
            case 105: {
                return "style";
            }
            case 106: {
                return "summary";
            }
            case 107: {
                return "tabindex";
            }
            case 108: {
                return "target";
            }
            case 109: {
                return "text";
            }
            case 110: {
                return "title";
            }
            case 111: {
                return "type";
            }
            case 112: {
                return "usemap";
            }
            case 113: {
                return "valign";
            }
            case 114: {
                return "value";
            }
            case 115: {
                return "valuetype";
            }
            case 116: {
                return "version";
            }
            case 117: {
                return "vlink";
            }
            case 118: {
                return "vspace";
            }
            case 119: {
                return "width";
            }
            case 120: {
                return "event";
            }
            case 121: {
                return "onhelp";
            }
            case 122: {
                return "oncontextmenu";
            }
            case 123: {
                return "onresize";
            }
        }
        return null;
    }

    public String getAttrName(int attrId) {
        String s = this.do_getAttrName(attrId);
        return s == null ? this.attrName[attrId - 124] : s;
    }

    public String getAttrNamespaceURI(int attrId) {
        if (attrId < 124) {
            return this.nsArray[3].name;
        }
        int i = this.attrNS[attrId - 124];
        return this.getNamespace(i);
    }

    public int getAttrNamespaceId(int attrId) {
        if (attrId < 124) {
            return 3;
        }
        int i = this.attrNS[attrId - 124];
        return i;
    }

    public static Names getInstance(StormBase storm) {
        return StormData.get((StormBase)storm).names;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getAttrIdHTML(String s) {
        boolean Id_ABBR = true;
        int Id_ACCEPT_CHARSET = 2;
        int Id_ACCEPT = 3;
        int Id_ACCESSKEY = 4;
        int Id_ACTION = 5;
        int Id_ALIGN = 6;
        int Id_ALINK = 7;
        int Id_ALT = 8;
        int Id_ARCHIVE = 9;
        int Id_AXIS = 10;
        int Id_BACKGROUND = 11;
        int Id_BGCOLOR = 12;
        int Id_BORDER = 13;
        int Id_CELLPADDING = 14;
        int Id_CELLSPACING = 15;
        int Id_CHAR = 16;
        int Id_CHAROFF = 17;
        int Id_CHARSET = 18;
        int Id_CHECKED = 19;
        int Id_CITE = 20;
        int Id_CLASS = 21;
        int Id_CLASSID = 22;
        int Id_CLEAR = 23;
        int Id_CODE = 24;
        int Id_CODEBASE = 25;
        int Id_CODETYPE = 26;
        int Id_COLOR = 27;
        int Id_COLS = 28;
        int Id_COLSPAN = 29;
        int Id_COMPACT = 30;
        int Id_CONTENT = 31;
        int Id_COORDS = 32;
        int Id_DATA = 33;
        int Id_DATETIME = 34;
        int Id_DECLARE = 35;
        int Id_DEFER = 36;
        int Id_DIR = 37;
        int Id_DISABLED = 38;
        int Id_ENCTYPE = 39;
        int Id_FACE = 40;
        int Id_FOR = 41;
        int Id_FRAME = 42;
        int Id_FRAMEBORDER = 43;
        int Id_HEADERS = 44;
        int Id_HEIGHT = 45;
        int Id_HREF = 46;
        int Id_HREFLANG = 47;
        int Id_HSPACE = 48;
        int Id_HTTP_EQUIV = 49;
        int Id_ID = 50;
        int Id_ISMAP = 51;
        int Id_LABEL = 52;
        int Id_LANG = 53;
        int Id_LANGUAGE = 54;
        int Id_LINK = 55;
        int Id_LONGDESC = 56;
        int Id_MARGINHEIGHT = 57;
        int Id_MARGINWIDTH = 58;
        int Id_MAXLENGTH = 59;
        int Id_MEDIA = 60;
        int Id_METHOD = 61;
        int Id_MULTIPLE = 62;
        int Id_NAME = 63;
        int Id_NOHREF = 64;
        int Id_NORESIZE = 65;
        int Id_NOSHADE = 66;
        int Id_NOWRAP = 67;
        int Id_OBJECT = 68;
        int Id_ONBLUR = 69;
        int Id_ONCHANGE = 70;
        int Id_ONCLICK = 71;
        int Id_ONDBLCLICK = 72;
        int Id_ONFOCUS = 73;
        int Id_ONKEYDOWN = 74;
        int Id_ONKEYPRESS = 75;
        int Id_ONKEYUP = 76;
        int Id_ONLOAD = 77;
        int Id_ONMOUSEDOWN = 78;
        int Id_ONMOUSEMOVE = 79;
        int Id_ONMOUSEOUT = 80;
        int Id_ONMOUSEOVER = 81;
        int Id_ONMOUSEUP = 82;
        int Id_ONRESET = 83;
        int Id_ONSELECT = 84;
        int Id_ONSUBMIT = 85;
        int Id_ONUNLOAD = 86;
        int Id_PROFILE = 87;
        int Id_PROMPT = 88;
        int Id_READONLY = 89;
        int Id_REL = 90;
        int Id_REV = 91;
        int Id_ROWS = 92;
        int Id_ROWSPAN = 93;
        int Id_RULES = 94;
        int Id_SCHEME = 95;
        int Id_SCOPE = 96;
        int Id_SCROLLING = 97;
        int Id_SELECTED = 98;
        int Id_SHAPE = 99;
        int Id_SIZE = 100;
        int Id_SPAN = 101;
        int Id_SRC = 102;
        int Id_STANDBY = 103;
        int Id_START = 104;
        int Id_STYLE = 105;
        int Id_SUMMARY = 106;
        int Id_TABINDEX = 107;
        int Id_TARGET = 108;
        int Id_TEXT = 109;
        int Id_TITLE = 110;
        int Id_TYPE = 111;
        int Id_USEMAP = 112;
        int Id_VALIGN = 113;
        int Id_VALUE = 114;
        int Id_VALUETYPE = 115;
        int Id_VERSION = 116;
        int Id_VLINK = 117;
        int Id_VSPACE = 118;
        int Id_WIDTH = 119;
        int Id_EVENT = 120;
        int Id_ONHELP = 121;
        int Id_ONCONTEXTMENU = 122;
        int Id_ONRESIZE = 123;
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 2: {
                if (s.charAt(0) != 'i' || s.charAt(1) != 'd') break;
                return 50;
            }
            case 3: {
                switch (s.charAt(0)) {
                    case 'a': {
                        if (s.charAt(2) != 't' || s.charAt(1) != 'l') break;
                        return 8;
                    }
                    case 'd': {
                        if (s.charAt(2) != 'r' || s.charAt(1) != 'i') break;
                        return 37;
                    }
                    case 'f': {
                        if (s.charAt(2) != 'r' || s.charAt(1) != 'o') break;
                        return 41;
                    }
                    case 'r': {
                        char c = s.charAt(2);
                        if (c == 'l') {
                            if (s.charAt(1) != 'e') break;
                            return 90;
                        }
                        if (c != 'v' || s.charAt(1) != 'e') break;
                        return 91;
                    }
                    case 's': {
                        if (s.charAt(2) != 'c' || s.charAt(1) != 'r') break;
                        return 102;
                    }
                }
                break;
            }
            case 4: {
                switch (s.charAt(2)) {
                    case 'a': {
                        char c = s.charAt(0);
                        if (c == 'c') {
                            if (s.charAt(3) != 'r' || s.charAt(1) != 'h') break;
                            return 16;
                        }
                        if (c != 's' || s.charAt(3) != 'n' || s.charAt(1) != 'p') break;
                        return 101;
                    }
                    case 'b': {
                        X = "abbr";
                        id = 1;
                        break;
                    }
                    case 'c': {
                        X = "face";
                        id = 40;
                        break;
                    }
                    case 'd': {
                        X = "code";
                        id = 24;
                        break;
                    }
                    case 'e': {
                        X = "href";
                        id = 46;
                        break;
                    }
                    case 'i': {
                        X = "axis";
                        id = 10;
                        break;
                    }
                    case 'l': {
                        X = "cols";
                        id = 28;
                        break;
                    }
                    case 'm': {
                        X = "name";
                        id = 63;
                        break;
                    }
                    case 'n': {
                        char c = s.charAt(1);
                        if (c == 'a') {
                            if (s.charAt(0) != 'l' || s.charAt(3) != 'g') break;
                            return 53;
                        }
                        if (c != 'i' || s.charAt(0) != 'l' || s.charAt(3) != 'k') break;
                        return 55;
                    }
                    case 'p': {
                        X = "type";
                        id = 111;
                        break;
                    }
                    case 't': {
                        char c = s.charAt(0);
                        if (c == 'c') {
                            if (s.charAt(3) != 'e' || s.charAt(1) != 'i') break;
                            return 20;
                        }
                        if (c != 'd' || s.charAt(3) != 'a' || s.charAt(1) != 'a') break;
                        return 33;
                    }
                    case 'w': {
                        X = "rows";
                        id = 92;
                        break;
                    }
                    case 'x': {
                        X = "text";
                        id = 109;
                        break;
                    }
                    case 'z': {
                        X = "size";
                        id = 100;
                        break;
                    }
                }
                break;
            }
            case 5: {
                switch (s.charAt(0)) {
                    case 'a': {
                        char c = s.charAt(4);
                        if (c == 'k') {
                            X = "alink";
                            id = 7;
                            break;
                        }
                        if (c != 'n') break;
                        X = "align";
                        id = 6;
                        break;
                    }
                    case 'c': {
                        char c = s.charAt(2);
                        if (c == 'a') {
                            X = "class";
                            id = 21;
                            break;
                        }
                        if (c == 'e') {
                            X = "clear";
                            id = 23;
                            break;
                        }
                        if (c != 'l') break;
                        X = "color";
                        id = 27;
                        break;
                    }
                    case 'd': {
                        X = "defer";
                        id = 36;
                        break;
                    }
                    case 'e': {
                        X = "event";
                        id = 120;
                        break;
                    }
                    case 'f': {
                        X = "frame";
                        id = 42;
                        break;
                    }
                    case 'i': {
                        X = "ismap";
                        id = 51;
                        break;
                    }
                    case 'l': {
                        X = "label";
                        id = 52;
                        break;
                    }
                    case 'm': {
                        X = "media";
                        id = 60;
                        break;
                    }
                    case 'r': {
                        X = "rules";
                        id = 94;
                        break;
                    }
                    case 's': {
                        char c = s.charAt(1);
                        if (c == 'c') {
                            X = "scope";
                            id = 96;
                            break;
                        }
                        if (c == 'h') {
                            X = "shape";
                            id = 99;
                            break;
                        }
                        if (c != 't') break;
                        c = s.charAt(4);
                        if (c == 'e') {
                            if (s.charAt(2) != 'y' || s.charAt(3) != 'l') break;
                            return 105;
                        }
                        if (c != 't' || s.charAt(2) != 'a' || s.charAt(3) != 'r') break;
                        return 104;
                    }
                    case 't': {
                        X = "title";
                        id = 110;
                        break;
                    }
                    case 'v': {
                        char c = s.charAt(4);
                        if (c == 'e') {
                            X = "value";
                            id = 114;
                            break;
                        }
                        if (c != 'k') break;
                        X = "vlink";
                        id = 117;
                        break;
                    }
                    case 'w': {
                        X = "width";
                        id = 119;
                        break;
                    }
                }
                break;
            }
            case 6: {
                block53 : switch (s.charAt(0)) {
                    case 'a': {
                        char c = s.charAt(5);
                        if (c == 'n') {
                            X = "action";
                            id = 5;
                            break;
                        }
                        if (c != 't') break;
                        X = "accept";
                        id = 3;
                        break;
                    }
                    case 'b': {
                        X = "border";
                        id = 13;
                        break;
                    }
                    case 'c': {
                        X = "coords";
                        id = 32;
                        break;
                    }
                    case 'h': {
                        char c = s.charAt(5);
                        if (c == 'e') {
                            X = "hspace";
                            id = 48;
                            break;
                        }
                        if (c != 't') break;
                        X = "height";
                        id = 45;
                        break;
                    }
                    case 'm': {
                        X = "method";
                        id = 61;
                        break;
                    }
                    case 'n': {
                        char c = s.charAt(5);
                        if (c == 'f') {
                            X = "nohref";
                            id = 64;
                            break;
                        }
                        if (c != 'p') break;
                        X = "nowrap";
                        id = 67;
                        break;
                    }
                    case 'o': {
                        switch (s.charAt(5)) {
                            case 'd': {
                                X = "onload";
                                id = 77;
                                break block53;
                            }
                            case 'p': {
                                X = "onhelp";
                                id = 121;
                                break block53;
                            }
                            case 'r': {
                                X = "onblur";
                                id = 69;
                                break block53;
                            }
                            case 't': {
                                X = "object";
                                id = 68;
                                break block53;
                            }
                        }
                        break;
                    }
                    case 'p': {
                        X = "prompt";
                        id = 88;
                        break;
                    }
                    case 's': {
                        X = "scheme";
                        id = 95;
                        break;
                    }
                    case 't': {
                        X = "target";
                        id = 108;
                        break;
                    }
                    case 'u': {
                        X = "usemap";
                        id = 112;
                        break;
                    }
                    case 'v': {
                        char c = s.charAt(5);
                        if (c == 'e') {
                            X = "vspace";
                            id = 118;
                            break;
                        }
                        if (c != 'n') break;
                        X = "valign";
                        id = 113;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(5)) {
                    case 'a': {
                        char c = s.charAt(0);
                        if (c == 'c') {
                            X = "colspan";
                            id = 29;
                            break;
                        }
                        if (c != 'r') break;
                        X = "rowspan";
                        id = 93;
                        break;
                    }
                    case 'b': {
                        X = "standby";
                        id = 103;
                        break;
                    }
                    case 'c': {
                        char c = s.charAt(0);
                        if (c == 'c') {
                            X = "compact";
                            id = 30;
                            break;
                        }
                        if (c != 'o') break;
                        X = "onclick";
                        id = 71;
                        break;
                    }
                    case 'd': {
                        X = "noshade";
                        id = 66;
                        break;
                    }
                    case 'e': {
                        char c = s.charAt(2);
                        if (c == 'a') {
                            X = "charset";
                            id = 18;
                            break;
                        }
                        if (c == 'e') {
                            X = "checked";
                            id = 19;
                            break;
                        }
                        if (c != 'r') break;
                        X = "onreset";
                        id = 83;
                        break;
                    }
                    case 'f': {
                        X = "charoff";
                        id = 17;
                        break;
                    }
                    case 'i': {
                        X = "classid";
                        id = 22;
                        break;
                    }
                    case 'l': {
                        X = "profile";
                        id = 87;
                        break;
                    }
                    case 'n': {
                        X = "content";
                        id = 31;
                        break;
                    }
                    case 'o': {
                        char c = s.charAt(0);
                        if (c == 'b') {
                            X = "bgcolor";
                            id = 12;
                            break;
                        }
                        if (c != 'v') break;
                        X = "version";
                        id = 116;
                        break;
                    }
                    case 'p': {
                        X = "enctype";
                        id = 39;
                        break;
                    }
                    case 'r': {
                        char c = s.charAt(0);
                        if (c == 'd') {
                            X = "declare";
                            id = 35;
                            break;
                        }
                        if (c == 'h') {
                            X = "headers";
                            id = 44;
                            break;
                        }
                        if (c != 's') break;
                        X = "summary";
                        id = 106;
                        break;
                    }
                    case 'u': {
                        char c = s.charAt(2);
                        if (c == 'f') {
                            X = "onfocus";
                            id = 73;
                            break;
                        }
                        if (c != 'k') break;
                        X = "onkeyup";
                        id = 76;
                        break;
                    }
                    case 'v': {
                        X = "archive";
                        id = 9;
                        break;
                    }
                }
                break;
            }
            case 8: {
                switch (s.charAt(2)) {
                    case 'a': {
                        X = "readonly";
                        id = 89;
                        break;
                    }
                    case 'b': {
                        X = "tabindex";
                        id = 107;
                        break;
                    }
                    case 'c': {
                        X = "onchange";
                        id = 70;
                        break;
                    }
                    case 'd': {
                        char c = s.charAt(4);
                        if (c == 'b') {
                            X = "codebase";
                            id = 25;
                            break;
                        }
                        if (c != 't') break;
                        X = "codetype";
                        id = 26;
                        break;
                    }
                    case 'e': {
                        X = "hreflang";
                        id = 47;
                        break;
                    }
                    case 'l': {
                        char c = s.charAt(0);
                        if (c == 'm') {
                            X = "multiple";
                            id = 62;
                            break;
                        }
                        if (c != 's') break;
                        X = "selected";
                        id = 98;
                        break;
                    }
                    case 'n': {
                        char c = s.charAt(1);
                        if (c == 'a') {
                            X = "language";
                            id = 54;
                            break;
                        }
                        if (c != 'o') break;
                        X = "longdesc";
                        id = 56;
                        break;
                    }
                    case 'r': {
                        char c = s.charAt(1);
                        if (c == 'o') {
                            X = "noresize";
                            id = 65;
                            break;
                        }
                        if (c != 'n') break;
                        X = "onresize";
                        id = 123;
                        break;
                    }
                    case 's': {
                        char c = s.charAt(3);
                        if (c == 'a') {
                            X = "disabled";
                            id = 38;
                            break;
                        }
                        if (c == 'e') {
                            X = "onselect";
                            id = 84;
                            break;
                        }
                        if (c != 'u') break;
                        X = "onsubmit";
                        id = 85;
                        break;
                    }
                    case 't': {
                        X = "datetime";
                        id = 34;
                        break;
                    }
                    case 'u': {
                        X = "onunload";
                        id = 86;
                        break;
                    }
                }
                break;
            }
            case 9: {
                switch (s.charAt(2)) {
                    case 'c': {
                        X = "accesskey";
                        id = 4;
                        break block0;
                    }
                    case 'k': {
                        X = "onkeydown";
                        id = 74;
                        break block0;
                    }
                    case 'l': {
                        X = "valuetype";
                        id = 115;
                        break block0;
                    }
                    case 'm': {
                        X = "onmouseup";
                        id = 82;
                        break block0;
                    }
                    case 'r': {
                        X = "scrolling";
                        id = 97;
                        break block0;
                    }
                    case 'x': {
                        X = "maxlength";
                        id = 59;
                        break block0;
                    }
                }
                break;
            }
            case 10: {
                switch (s.charAt(2)) {
                    case 'c': {
                        X = "background";
                        id = 11;
                        break block0;
                    }
                    case 'd': {
                        X = "ondblclick";
                        id = 72;
                        break block0;
                    }
                    case 'k': {
                        X = "onkeypress";
                        id = 75;
                        break block0;
                    }
                    case 'm': {
                        X = "onmouseout";
                        id = 80;
                        break block0;
                    }
                    case 't': {
                        X = "http-equiv";
                        id = 49;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                switch (s.charAt(7)) {
                    case 'c': {
                        X = "cellspacing";
                        id = 15;
                        break;
                    }
                    case 'd': {
                        char c = s.charAt(0);
                        if (c == 'c') {
                            X = "cellpadding";
                            id = 14;
                            break;
                        }
                        if (c != 'o') break;
                        X = "onmousedown";
                        id = 78;
                        break;
                    }
                    case 'i': {
                        X = "marginwidth";
                        id = 58;
                        break;
                    }
                    case 'm': {
                        X = "onmousemove";
                        id = 79;
                        break;
                    }
                    case 'o': {
                        X = "onmouseover";
                        id = 81;
                        break;
                    }
                    case 'r': {
                        X = "frameborder";
                        id = 43;
                        break;
                    }
                }
                break;
            }
            case 12: {
                X = "marginheight";
                id = 57;
                break;
            }
            case 13: {
                X = "oncontextmenu";
                id = 122;
                break;
            }
            case 14: {
                X = "accept-charset";
                id = 2;
            }
        }
        if (X == null) return id;
        if (X == s) return id;
        if (X.equals(s)) return id;
        return 0;
    }

    private static class Namespace {
        String name;
        int id;
        Hashtable tagsHash = new Hashtable();
        Hashtable attrsHash = new Hashtable();

        Namespace(String name, int id) {
            this.name = name;
            this.id = id;
        }
    }

    private static final class HTMLTagMatcher {
        private static final int MAX_TAG_LENGTH = 10;
        private static int[][] tagIndexesByLen;
        private static int[] tagCountByLen;
        private static char[][] tags;
        private static int[] htmlAttrId;
        private static int tagCount;

        private HTMLTagMatcher() {
        }

        private static void printTagNameArrays() {
            for (int lenCtr = 1; lenCtr < 11; ++lenCtr) {
                int numTags = tagCountByLen[lenCtr];
                for (int tagCtr = 0; tagCtr < numTags; ++tagCtr) {
                    int attrIdx = tagIndexesByLen[lenCtr][tagCtr];
                    char[] attrChars = tags[attrIdx];
                    int attrId = htmlAttrId[attrIdx];
                }
            }
        }

        private static final void addTag(char[] tagChars, int anHtmlAttrId) {
            for (int i = 0; i < tagChars.length; ++i) {
                if (tagChars[i] <= '`' || tagChars[i] >= '{') continue;
                int n = i;
                tagChars[n] = (char)(tagChars[n] - 32);
            }
            if (HTMLTagMatcher.matchAttrIdForTag(tagChars, 0, tagChars.length) != -1) {
                return;
            }
            int length = tagChars.length;
            HTMLTagMatcher.tags[HTMLTagMatcher.tagCount] = tagChars;
            HTMLTagMatcher.tagIndexesByLen[length][HTMLTagMatcher.tagCountByLen[length]] = tagCount;
            HTMLTagMatcher.htmlAttrId[HTMLTagMatcher.tagCount] = anHtmlAttrId;
            int n = length;
            tagCountByLen[n] = tagCountByLen[n] + 1;
            ++tagCount;
        }

        public static final int matchAttrIdForTag(char[] tagChars, int offset, int length) {
            boolean isMatch = true;
            if (length < 1 || length > 10) {
                return -1;
            }
            for (int attrCtr = 0; attrCtr < tagCountByLen[length]; ++attrCtr) {
                int attrIdx = tagIndexesByLen[length][attrCtr];
                char[] attrChars = tags[attrIdx];
                isMatch = true;
                for (int i = 0; i < length; ++i) {
                    char c = tagChars[offset + i];
                    if (c > '`' && c < '{') {
                        c = (char)(c - 32);
                    }
                    if (c == attrChars[i]) continue;
                    isMatch = false;
                    break;
                }
                if (!isMatch) continue;
                return htmlAttrId[attrIdx];
            }
            return -1;
        }

        static {
            char[] tagChars;
            String tagName;
            int i;
            tagIndexesByLen = new int[11][19];
            tagCountByLen = new int[11];
            tags = new char[100][10];
            htmlAttrId = new int[100];
            tagCount = 1;
            int[] highVolumeTags = new int[]{1, 81, 14, 26, 79, 31, 73, 46};
            for (i = 0; i < highVolumeTags.length; ++i) {
                tagName = Names.getTagName(highVolumeTags[i]);
                tagChars = tagName.toCharArray();
                HTMLTagMatcher.addTag(tagChars, highVolumeTags[i]);
            }
            for (i = 1; i < 96; ++i) {
                if (i == 92) continue;
                tagName = Names.getTagName(i);
                tagChars = tagName.toCharArray();
                HTMLTagMatcher.addTag(tagChars, i);
            }
            tagChars = new char[]{'E', 'M', 'B', 'E', 'D'};
            HTMLTagMatcher.addTag(tagChars, 45);
            tagChars = new char[]{'C', 'O', 'M', 'M', 'E', 'N', 'T'};
            HTMLTagMatcher.addTag(tagChars, 58);
            tagChars = new char[]{'N', 'O', 'E', 'M', 'B', 'E', 'D'};
            HTMLTagMatcher.addTag(tagChars, 58);
            tagChars = new char[]{'X', 'M', 'P'};
            HTMLTagMatcher.addTag(tagChars, 58);
        }
    }
}

