/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.LineBox;
import ice.pilots.html4.PositionedBox;
import ice.pilots.html4.TableCellBox;
import java.awt.Point;

class FloatBox
extends CSSBox {
    private CSSBox block;

    FloatBox(DElement e, CSSBox box) {
        super(e, new CSSAttribs(box.cssLayout.getFontCache(), box.css), box.cssLayout);
        if (box.getType() == 1) {
            this.block = box;
        } else {
            this.block = new BlockBox(e, box.css, box.cssLayout, 0);
            this.block = this.block.addChild(box);
        }
        this.block.setParentBox(this);
        this.height = 0;
        this.width = 0;
        this.maxWidth = 0;
        this.minWidth = 0;
        this.numBreaks = 0;
        this.totalWidth = 0;
        this.totalWidth = 1;
    }

    void propagateVisibility(short b, boolean self) {
        this.block.propagateVisibility(b, self);
    }

    void findAbsolutePosition(Point p) {
        CSSBox b = this.parentBox;
        while (b != null) {
            if (b instanceof TableCellBox) {
                p.x += b.ox;
                p.y += b.oy + ((TableCellBox)b).vadd;
                if (b.parentBox == null) break;
                b.parentBox.findAbsolutePosition(p);
                break;
            }
            if (b instanceof PositionedBox) {
                b.findAbsolutePosition(p);
                break;
            }
            b = b.parentBox;
        }
    }

    void findBoundingBoxForPrinting(Point p) {
        CSSBox b = this.parentBox;
        while (b != null) {
            if (b instanceof TableCellBox) {
                p.x += b.ox;
                p.y += b.oy + ((TableCellBox)b).vadd;
                if (b.parentBox == null) break;
                b.parentBox.findBoundingBoxForPrinting(p);
                break;
            }
            if (b instanceof PositionedBox) {
                b.findBoundingBoxForPrinting(p);
                break;
            }
            b = b.parentBox;
        }
    }

    void dispose() {
        super.dispose();
        this.element = null;
        if (this.block != null) {
            this.block.dispose();
            this.block = null;
        }
    }

    CSSBox getBlock() {
        return this.block;
    }

    CSSBox getFirstChild() {
        return this.block;
    }

    DNode getDomNode() {
        return this.element;
    }

    int getType() {
        return 2;
    }

    long getChunkDescentAscent(int x, int w, LineBox aLineBox) {
        CSSBox b = this.parentBox;
        while (b != null && b.getType() != 1) {
            b = b.parentBox;
        }
        if (b != null) {
            ((BlockBox)b).addFloater(this.block);
        }
        return 0L;
    }

    public String toString() {
        DNode n = this.getDomNode();
        String s = "NoNode";
        if (n != null) {
            s = n.toString();
        }
        return "floatbox[" + s + "]";
    }

    CSSBox findChildByIndex_r(int aType, int aIndex, Point p) {
        return this.block.findChildByIndex_r(aType, aIndex, p);
    }

    int getCount(int aType, Point p) {
        int returnVal = this.block.getCount(aType, p);
        return returnVal;
    }
}

