/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.BlockBox;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.EmbeddedObject;
import ice.pilots.html4.FramesetData;
import ice.pilots.html4.ICEDropClient;
import ice.pilots.html4.KeyEventCallback;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollPositionChangeCallback;
import ice.pilots.html4.ThePilot;
import ice.storm.DocPane;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.Emulation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import org.w3c.dom.events.EventListener;

public abstract class DocPaneXml
extends DocPane
implements ICEDropClient {
    private ThePilot _pilot;
    private CSSLayout _cssLayout;
    private boolean _ieEmulation;
    private int _documentId;
    private String cachedHyperlinkValue;
    private KeyEventCallback keyEventCallback;
    private ScrollPositionChangeCallback scrollPositionCallback;
    public boolean enableTextSelection = Defs.booleanProperty((String)"ice.pilots.html4.enableTextSelection", (boolean)true);
    private boolean installDefaultDropClient = Defs.booleanProperty((String)"ice.pilots.html4.useDefaultDropClient", (boolean)false);
    private boolean keyPressedCancelled = false;

    final void bind(ThePilot pilot, CSSLayout cssLayout) {
        this._pilot = pilot;
        this._cssLayout = cssLayout;
        this._ieEmulation = Emulation.getEmulationMode().startsWith("ie");
        this._documentId = pilot.getPilotViewport().getDocumentId();
        this._cssLayout.docPane = this;
        if (this.installDefaultDropClient) {
            this.setDropClient(this);
        }
    }

    final void do_clear() {
        Viewport viewport = this._pilot.getPilotViewport();
        if (viewport != null) {
            this._documentId = viewport.getDocumentId();
            this.setCursor(0);
            this.reqClear();
        }
    }

    public void revalidate(int x, int y, int w, int h) {
        FramesetData fd = this._pilot.framesetData;
        if (fd != null) {
            fd.layout(x, y, w, h);
        } else {
            this.setPaneBounds(x, y, w, h);
        }
        this.revalidate();
    }

    protected abstract void setPaneBounds(int var1, int var2, int var3, int var4);

    protected abstract void revalidate();

    protected abstract void init(int var1);

    protected abstract Component getPaneComponent();

    public abstract Color getSelectionColor();

    public abstract Color getSelectionBackground();

    public void postSelectedToClipboard() {
        this._cssLayout.postSelectedToClipboard();
    }

    protected abstract ObjectPainter createFormControl(DElement var1);

    protected abstract ObjectPainter createScroller();

    protected abstract Container createEmbeddedContainer(EmbeddedObject var1, Component var2);

    protected abstract Component createFramesDividerComponent();

    protected abstract void checkAwtTree(ObjectBox var1, Component var2);

    protected final boolean processAwtKeyEvent(Component c, KeyEvent awtEvent, EventListener action) {
        int dom_code;
        char dom_char;
        int dom_id;
        if (this.keyEventCallback != null && !this.doCustomKeyAction(awtEvent)) {
            return false;
        }
        int awt_id = awtEvent.getID();
        if (awt_id == 401) {
            this.keyPressedCancelled = false;
            dom_id = 9;
        } else if (awt_id == 402) {
            dom_id = 10;
            if (this.keyPressedCancelled && this.is_msie_event_emulation()) {
                return true;
            }
        } else {
            dom_id = 8;
            if (this.keyPressedCancelled && this.is_msie_event_emulation()) {
                return true;
            }
        }
        DOMUIEvent addEvent = null;
        int awt_code = awtEvent.getKeyCode();
        if (awt_id == 400) {
            dom_char = awtEvent.getKeyChar();
            dom_code = dom_char;
        } else {
            dom_code = awt_code;
            dom_char = awtEvent.getKeyChar();
        }
        if (this.is_msie_event_emulation()) {
            switch (awt_code) {
                case 112: {
                    if (awt_code != 112) break;
                    addEvent = this.createDomUIEvent(23);
                    break;
                }
                case 10: {
                    dom_code = 13;
                    break;
                }
                case 127: {
                    dom_code = 46;
                    break;
                }
                case 155: {
                    dom_code = 45;
                    break;
                }
                case 45: {
                    dom_code = 189;
                }
            }
        }
        DOMUIEvent uie = this.createDomUIEvent(dom_id);
        uie.setKeyCode(dom_code);
        uie.setCharCode(dom_char);
        boolean result = this.uiEvent(uie, awtEvent, action);
        if (awt_id == 401 && uie.isDefaultCancelled()) {
            this.keyPressedCancelled = true;
        }
        if (!uie.isDefaultCancelled() && addEvent != null) {
            this._cssLayout.handleEvent(addEvent);
        }
        return result;
    }

    private boolean doCustomKeyAction(KeyEvent keyEvent) {
        boolean allowDefaultAction = true;
        switch (keyEvent.getID()) {
            case 401: {
                allowDefaultAction = this.keyEventCallback.onKeyPressed(keyEvent);
                break;
            }
            case 402: {
                allowDefaultAction = this.keyEventCallback.onKeyReleased(keyEvent);
                break;
            }
            case 400: {
                allowDefaultAction = this.keyEventCallback.onKeyTyped(keyEvent);
            }
        }
        return allowDefaultAction;
    }

    final void setKeyEventCallback(KeyEventCallback keyEventCallback) {
        this.keyEventCallback = keyEventCallback;
    }

    public void setScrollPositionChangeCallback(ScrollPositionChangeCallback scrollPositionCallback) {
        this.scrollPositionCallback = scrollPositionCallback;
    }

    public ScrollPositionChangeCallback getScrollPositionChangeCallback() {
        return this.scrollPositionCallback;
    }

    public final boolean uiEvent(DOMUIEvent uie, InputEvent awtEvent, EventListener action) {
        if (action != null) {
            uie.setAction(action);
        }
        uie.setSystemEvent(awtEvent);
        uie.setAltKey(awtEvent.isAltDown());
        uie.setCtrlKey(awtEvent.isControlDown());
        uie.setShiftKey(awtEvent.isShiftDown());
        uie.setMetaKey(awtEvent.isMetaDown());
        uie.setModifiers(awtEvent.getModifiers());
        int m = awtEvent.getModifiers();
        int buttons = 0;
        if ((m & 0x10) != 0) {
            buttons = (m & 8) != 0 ? ((m & 4) != 0 ? 7 : 5) : ((m & 4) != 0 ? 3 : 1);
        } else if ((m & 8) != 0) {
            buttons = (m & 4) != 0 ? 6 : 4;
        } else if ((m & 4) != 0) {
            buttons = 2;
        }
        uie.setMouseButtons((short)buttons);
        Component source = awtEvent.getComponent();
        if (source instanceof ObjectPainter) {
            uie.setObjectPainter((ObjectPainter)((Object)source));
        }
        this._cssLayout.handleEvent(uie);
        switch (uie.typeId) {
            case 8: {
                KeyEvent keyEvent = (KeyEvent)awtEvent;
                keyEvent.setKeyChar((char)uie.getCharCode());
                break;
            }
        }
        if (uie.isDefaultCancelled()) {
            awtEvent.consume();
            return false;
        }
        return !uie.isDefaultDone();
    }

    protected abstract void onNodeSelectCall(DNode var1);

    protected abstract void onNodeBlurEvent(DOMUIEvent var1, DNode var2);

    protected abstract void onNodeFocusEvent(DOMUIEvent var1, DNode var2);

    public void packageDropped(String payload) {
        String url = payload;
        if (url.startsWith("#") || url.startsWith("file:")) {
            url = this._pilot.getDDocument().resolveUrl(url);
        }
        if (url.startsWith("http:") || url.startsWith("file:")) {
            String name = this._pilot.getPilotViewport().getName();
            this._pilot.getStorm().stopLoading(name);
            this._pilot.getStorm().renderContent(payload, "text/html", name);
        }
    }

    public boolean isGestureListeningEnabled(int xPos, int yPos) {
        this.cachedHyperlinkValue = this._cssLayout.getHyperlinkAt(xPos, yPos, this.getScrollX(), this.getScrollY());
        if (this.cachedHyperlinkValue != null) {
            return true;
        }
        return this._cssLayout.isInSelection(xPos, yPos, this.getScrollX(), this.getScrollY());
    }

    public String getDragPayload() {
        if (this.cachedHyperlinkValue != null) {
            return this.cachedHyperlinkValue;
        }
        return this._cssLayout.getSelectedText();
    }

    public abstract void setDropClient(ICEDropClient var1);

    public boolean docIsSelectionActive() {
        return this._cssLayout.isSelection();
    }

    public final boolean checkDocumentId() {
        Viewport viewport = this._pilot.getPilotViewport();
        if (this._pilot.getDocument() == null) {
            return false;
        }
        return viewport != null && this._documentId == viewport.getDocumentId();
    }

    public boolean is_msie_event_emulation() {
        return this._ieEmulation;
    }

    public final ThePilot getPilot() {
        return this._pilot;
    }

    public final boolean isPilotDisposed() {
        return this._pilot.isDisposed();
    }

    public final int getDocWidth() {
        return this._cssLayout.getWidth();
    }

    public final int getDocHeight() {
        return this._cssLayout.getHeight();
    }

    public final int getBodyWidth() {
        CSSBox bodyBox = this._cssLayout.topBox.getFirstChild();
        if (this.isBodyBox(bodyBox)) {
            return bodyBox.width;
        }
        return this.getDocWidth();
    }

    public final int getBodyHeight() {
        CSSBox bodyBox = this._cssLayout.topBox.getFirstChild();
        if (this.isBodyBox(bodyBox)) {
            return bodyBox.height;
        }
        return this.getDocHeight();
    }

    private boolean isBodyBox(CSSBox box) {
        return box != null && box instanceof BlockBox && box.getDomNode().getNameId() == 13;
    }

    public final void docLayout(int viewportWidth, int viewportHeight) {
        block2: {
            try {
                this._cssLayout.layout(viewportWidth, viewportHeight);
            }
            catch (RuntimeException ex) {
                if (!Debug.ex) break block2;
                Debug.ex((Throwable)ex);
            }
        }
    }

    public final void docPostLayout() {
        this._cssLayout.postLayout();
    }

    public final void docClearSelection() {
        this._cssLayout.clearSelection();
        this.cachedHyperlinkValue = null;
    }

    public final void docScrollChanged(int x, int y) {
        this._cssLayout.setScrollToFocus(false);
    }

    public final void docMarkDocument(int xPos, int yPos) {
        this._cssLayout.markDocument(xPos, yPos, this.getScrollX(), this.getScrollY());
    }

    public final void docSetSelection(int x1, int y1, int x2, int y2) {
        int sx = this.getScrollX();
        int sy = this.getScrollY();
        this._cssLayout.setSelection(x1, y1, x2, y2, sx, sy);
    }

    public void docHighlightRange(int startPosition, int endPosition) {
        this._cssLayout.defineHighlight(startPosition, endPosition);
    }

    public void docClearHighlights() {
        this._cssLayout.clearHighlights();
    }

    public final boolean docContainsFixedBoxes() {
        return this._cssLayout.containsFixedBoxes();
    }

    public final void docPaint(Graphics g) {
        this._cssLayout.paint(g);
    }

    public final void docPaintFixed(Graphics g) {
        this._cssLayout.paintFixed(g);
    }

    public final DOMUIEvent createDomUIEvent(int id) {
        return (DOMUIEvent)this._pilot.getDDocument().createDOMEvent(id);
    }

    public final ObjectPainter getNodePainter(DNode node) {
        return this._pilot.getView().getNodePainter(node);
    }

    protected final void notifyFocusGain() {
        this._pilot.viewportBecameActive();
        this._cssLayout.getFocusManager().setFrameFocused(true);
    }

    protected final void notifyFocusLost() {
        this._cssLayout.getFocusManager().setFrameFocused(false);
    }
}

