/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DHrefElement;
import ice.pilots.html4.DImageElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.DefaultEventHandler;
import ice.pilots.html4.DirectionFocusManager;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.FocusExitHandler;
import ice.pilots.html4.FocusManager;
import ice.pilots.html4.ScrollHandler;
import ice.pilots.html4.SmoothScrollHandler;
import ice.pilots.html4.ThePilot;
import ice.storm.DocPane;
import ice.util.Defs;
import ice.util.JavaVersion;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.lang.reflect.Method;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class DefaultActionHandler
implements DefaultEventHandler {
    static final int KEY_TAB = 9;
    static final int KEY_SHIFTTAB = 411;
    static final int KEY_HELP = 112;
    static final int KEY_ACTION = 32;
    static final int KEY_SUBMIT = 10;
    static final int KEY_SUBMIT2 = 13;
    static final int KEY_UP = 38;
    static final int KEY_DOWN = 40;
    static final int KEY_LEFT = 37;
    static final int KEY_RIGHT = 39;
    static final int KEY_PGDOWN = 34;
    static final int KEY_PGUP = 33;
    static final int KEY_END = 35;
    static final int KEY_HOME = 36;
    static final int ZOOM_FACTOR = 16;
    ThePilot pilot;
    FocusManager focusManager;
    FocusExitHandler focusExitHandler = null;
    ScrollHandler scrollHandler;
    private static boolean applicationClipboardPresent;
    private DNode lastNode;
    private boolean shouldScrollOnly = false;
    private boolean shouldFocusOnly = false;
    private long previousTabAction = -1L;
    public static final String ACCESSIBILTIY_NONE = "none";
    public static final String ACCESSIBILTIY_JAVA = "java";
    public static final String ACCESSIBILTIY_JAWS = "jaws";
    static String accessibility;
    static boolean isAccessible;
    static /* synthetic */ Class class$java$awt$Toolkit;

    DefaultActionHandler(ThePilot pilot) {
        this.pilot = pilot;
        CSSLayout cssLayout = pilot.getCSSLayout();
        String focusMode = Defs.sysProperty((String)"ice.browser.directionFocus");
        this.focusManager = focusMode != null && focusMode.equalsIgnoreCase("true") ? new DirectionFocusManager(pilot.getDDocument(), cssLayout, pilot) : new FocusManager(pilot.getDDocument(), cssLayout, pilot);
        cssLayout.setFocusManager(this.focusManager);
        String scrollMode = Defs.sysProperty((String)"ice.browser.scroll");
        this.scrollHandler = scrollMode != null && scrollMode.equalsIgnoreCase("smooth") ? new SmoothScrollHandler(pilot) : new ScrollHandler(pilot);
    }

    private void copySelectedToClipboard() {
        String str = this.pilot.getSelectedText();
        if (str != null && str.length() > 0) {
            Clipboard cl = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection sel = new StringSelection(str);
            cl.setContents(sel, sel);
        }
    }

    protected boolean isTabKey(long key) {
        return key == 9L;
    }

    protected boolean isActionKey(long key) {
        return key == 32L;
    }

    protected boolean isFormSubmitKey(long key) {
        return key == 10L || key == 13L;
    }

    protected boolean isDirectionKey(long key) {
        return key == 38L || key == 40L || key == 37L || key == 39L;
    }

    protected boolean isZoomKey(long key) {
        return key == 48L || key == 96L || key == 107L || key == 61L || key == 109L || key == 45L;
    }

    protected boolean scrollOnly() {
        return this.shouldScrollOnly;
    }

    protected boolean focusOnly() {
        return this.shouldFocusOnly;
    }

    private void changeZoom(int factor) {
        CSSLayout cssLayout = this.pilot.getCSSLayout();
        cssLayout.setLayoutZoom(cssLayout.getLayoutZoom() + factor);
    }

    private void resetZoom() {
        this.pilot.getCSSLayout().setLayoutZoom(256);
    }

    public void handleEvent(Event domEvent) {
        DOMEvent de = (DOMEvent)domEvent;
        if (de.isDefaultDone()) {
            return;
        }
        EventListener eventAction = de.getAction();
        if (eventAction != null) {
            eventAction.handleEvent(de);
            if (de.isDefaultDone()) {
                return;
            }
        }
        if (de instanceof DOMUIEvent) {
            this.shouldScrollOnly = ((DOMUIEvent)de).isShortcutKey();
        }
        DNode target = de.target;
        block0 : switch (de.typeId) {
            case 5: {
                this.updateCursor(target);
            }
            case 1: 
            case 6: 
            case 7: {
                DOMUIEvent deu = (DOMUIEvent)de;
                if (deu.isPopupTrigger) {
                    DDocument doc = this.pilot.getDDocument();
                    DOMUIEvent popup = (DOMUIEvent)doc.createDOMEvent(24);
                    popup.copyUIDataFrom(de);
                    de.stopPropagation();
                    de.preventDefault();
                    target.dispatchEvent(popup);
                    break;
                }
                while (target != null) {
                    int tag = target.tagId;
                    if (tag == 1 || tag == 6) {
                        this.handleDefaultActionOnLinks(deu, (DElement)target);
                        break block0;
                    }
                    if (!(deu.isMousePressPopupTrigger || deu.typeId != 1 || tag != 15 && tag != 47)) {
                        target.dispatchEvent(deu);
                        break block0;
                    }
                    target = DDocument.getEventChainParent(target, de);
                }
                break;
            }
            case 3: {
                DInputElement dei;
                String type;
                DNode tmp;
                for (tmp = target; tmp != null; tmp = (DNode)tmp.getParentNode()) {
                    if (tmp.getNameId() != 15) continue;
                    target = tmp;
                    break;
                }
                tmp = target;
                while (!(tmp == null || tmp instanceof DElement && ((DElement)tmp).isFocusable())) {
                    tmp = DDocument.getEventChainParent(tmp, de);
                }
                this.focusManager.setFocusedBox(tmp);
                DOMUIEvent deu = (DOMUIEvent)de;
                if (target != null && deu.isPopupTrigger) {
                    DDocument doc = this.pilot.getDDocument();
                    DOMUIEvent popup = (DOMUIEvent)doc.createDOMEvent(24);
                    popup.copyUIDataFrom(de);
                    de.stopPropagation();
                    de.preventDefault();
                    target.dispatchEvent(popup);
                }
                if (target == null) break;
                boolean isDeselectionTarget = false;
                if (target.getNameId() == 82) {
                    isDeselectionTarget = true;
                } else if (target.getNameId() == 47 && ((type = (dei = (DInputElement)target).getType()).equals("text") || type.equals("password"))) {
                    isDeselectionTarget = true;
                }
                if (!isDeselectionTarget || applicationClipboardPresent) break;
                this.pilot.getCSSLayout().clearSelection();
                break;
            }
            case 4: {
                DOMUIEvent deu = (DOMUIEvent)de;
                if (!deu.isPopupTrigger && (deu.isMousePressPopupTrigger || deu.getMouseButtons() == 4)) break;
                DNode relatedNode = (DNode)deu.getRelatedNode();
                DNode body = this.convertTargetToBody(target, relatedNode);
                if (body != null) {
                    target = relatedNode = body;
                }
                for (DNode tmp = target; tmp != null; tmp = (DNode)tmp.getParentNode()) {
                    if (tmp.getNameId() != 15) continue;
                    relatedNode = target = tmp;
                    break;
                }
                if (relatedNode != target) break;
                int clickId = 1;
                int clickCounter = deu.getDetail();
                if ((clickCounter & 1) == 0) {
                    clickId = 2;
                }
                DDocument doc = this.pilot.getDDocument();
                DOMUIEvent click = (DOMUIEvent)doc.createDOMEvent(clickId);
                click.copyUIDataFrom(de);
                target.dispatchEvent(click);
                break;
            }
            case 9: {
                this.onKeyDown((DOMUIEvent)de);
                break;
            }
            case 10: {
                this.onKeyUp((DOMUIEvent)de);
                break;
            }
            case 8: {
                this.onKeyPress((DOMUIEvent)de);
                break;
            }
            case 21: {
                this.onFocus((DOMUIEvent)de);
                break;
            }
            case 22: {
                this.onBlur((DOMUIEvent)de);
            }
        }
    }

    private DNode convertTargetToBody(DNode target, DNode relatedNode) {
        if (relatedNode != null && relatedNode.getNameId() == 43) {
            DNode child = relatedNode.first;
            while (child != null) {
                if (child.getNameId() == 13) {
                    return child;
                }
                child = child.next;
            }
        }
        return null;
    }

    private void updateCursor(DNode node) {
        DAreaElement area;
        if (this.lastNode == node) {
            return;
        }
        DocPane pane = this.pilot.getDocPane();
        if (pane == null) {
            return;
        }
        this.lastNode = node;
        CSSLayout layout = this.pilot.getCSSLayout();
        CSSBox cssBox = layout.findCSSBox(node);
        if (cssBox != null && cssBox.css.cursor > -1) {
            return;
        }
        if (node instanceof DTextNode) {
            while (node != null && !(node instanceof DDocument)) {
                DHrefElement hrefNode;
                if ((node = node.getParentDNode()) instanceof DHrefElement && (hrefNode = (DHrefElement)node).getAttribute(46) != null) {
                    pane.setCursor(12);
                    return;
                }
                if (!(node instanceof DInputElement)) continue;
                DInputElement inputElement = (DInputElement)node;
                if (inputElement.getType().equals("button")) {
                    pane.setCursor(0);
                }
                return;
            }
            if (((DocPaneXml)pane).enableTextSelection) {
                pane.setCursor(2);
            }
            return;
        }
        if (node != null && node instanceof DAreaElement && (area = (DAreaElement)node).getHref() != null) {
            pane.setCursor(12);
            return;
        }
        pane.setCursor(0);
    }

    private DNode getButtonBox(DNode n) {
        while (n != null && n.getNameId() != 13) {
            if (n.getNameId() == 15) {
                return n;
            }
            n = (DNode)n.getParentNode();
        }
        return null;
    }

    private void onKeyDown(DOMUIEvent de) {
        if (de.isDefaultCancelled()) {
            return;
        }
        long chr = de.getKeyCode();
        if (this.isTabKey(chr)) {
            DInputElement focusElement;
            String type;
            if (this.previousTabAction == chr + (long)(de.getShiftKey() ? 1 : 0) && this.focusManager.getFocusedElement() == null) {
                this.previousTabAction = -1L;
                if (JavaVersion.isV14orGreater()) {
                    if (de.getShiftKey()) {
                        this.focusManager.previousExternalFocus();
                    } else {
                        this.focusManager.nextExternalFocus();
                    }
                }
                return;
            }
            this.previousTabAction = chr + (long)(de.getShiftKey() ? 1 : 0);
            int itmp = de.getShiftKey() ? this.focusManager.previousFocus() : this.focusManager.nextFocus();
            if (itmp != -1) {
                this.pilot.getCSSLayout().clearSelection();
            }
            boolean handled = false;
            if (this.focusExitHandler != null && itmp == -1) {
                handled = de.getShiftKey() ? this.focusExitHandler.focusExit(411) : this.focusExitHandler.focusExit(9);
            }
            if (handled) {
                this.focusManager.setFocusedBox(null);
                de.preventDefault();
            } else {
                this.focusManager.setFocusedBox(itmp);
                de.preventDefault();
            }
            DNode focusNode = this.focusManager.getFocusedElement();
            if (focusNode != null && focusNode instanceof DInputElement && (type = (focusElement = (DInputElement)focusNode).getType()).equals("text")) {
                focusElement.select();
            }
            return;
        }
        if (this.isActionKey(chr)) {
            String tt;
            DNode dnode = this.focusManager.getFocusedElement();
            if (dnode == null) {
                this.scrollHandler.scrollRequest(34);
                return;
            }
            int tmp = dnode.getNameId();
            if (tmp == 1) {
                this.scrollHandler.scrollRequest(34);
                return;
            }
            if (tmp == 71) {
                return;
            }
            if (tmp == 82) {
                return;
            }
            if (tmp == 47 && ((tt = ((DInputElement)dnode).getType()) == null || tt.equalsIgnoreCase("text") || tt.equalsIgnoreCase("password"))) {
                return;
            }
            this.doAction(dnode);
            de.preventDefault();
        }
        if (this.isDirectionKey(chr) && !de.getShiftKey()) {
            if (this.doDirectionKey((int)chr)) {
                de.preventDefault();
            }
            return;
        }
        if (this.isZoomKey(chr)) {
            if (!Defs.booleanProperty((String)"ice.pilots.html4.disableZoomKeys", (boolean)false)) {
                switch ((int)chr) {
                    case 48: 
                    case 96: {
                        if (!de.isShortcutKey()) break;
                        this.resetZoom();
                        de.preventDefault();
                        break;
                    }
                    case 107: {
                        if (!de.isShortcutKey()) break;
                        this.changeZoom(16);
                        de.preventDefault();
                        break;
                    }
                    case 61: {
                        if (!de.isShortcutKey()) break;
                        this.changeZoom(16);
                        de.preventDefault();
                        break;
                    }
                    case 109: {
                        if (!de.isShortcutKey()) break;
                        this.changeZoom(-16);
                        de.preventDefault();
                        break;
                    }
                    case 45: {
                        if (!de.isShortcutKey()) break;
                        this.changeZoom(-16);
                        de.preventDefault();
                    }
                }
            }
            return;
        }
        if (de.getObjectPainter() != null) {
            return;
        }
        if (!this.scrollAction((int)chr)) {
            switch ((int)chr) {
                case 67: 
                case 88: 
                case 155: {
                    if (!de.isShortcutKey()) break;
                    this.copySelectedToClipboard();
                    de.preventDefault();
                    break;
                }
                case 65: {
                    if (!((DocPaneXml)this.pilot.getDocPane()).enableTextSelection || !de.isShortcutKey()) break;
                    this.pilot.getCSSLayout().selectAll();
                    de.preventDefault();
                    break;
                }
                case 39: {
                    if (!((DocPaneXml)this.pilot.getDocPane()).enableTextSelection) break;
                    if (de.getCtrlKey() && de.getShiftKey()) {
                        this.pilot.getCSSLayout().selectWordRight();
                        this.pilot.getCSSLayout().postSelectedToClipboard();
                        de.preventDefault();
                        break;
                    }
                    if (!de.getShiftKey()) break;
                    this.pilot.getCSSLayout().selectCharRight();
                    this.pilot.getCSSLayout().postSelectedToClipboard();
                    de.preventDefault();
                    break;
                }
                case 37: {
                    if (!((DocPaneXml)this.pilot.getDocPane()).enableTextSelection) break;
                    if (de.getCtrlKey() && de.getShiftKey()) {
                        this.pilot.getCSSLayout().selectWordLeft();
                        this.pilot.getCSSLayout().postSelectedToClipboard();
                        de.preventDefault();
                        break;
                    }
                    if (!de.getShiftKey()) break;
                    this.pilot.getCSSLayout().selectCharLeft();
                    this.pilot.getCSSLayout().postSelectedToClipboard();
                    de.preventDefault();
                    break;
                }
                case 38: {
                    if (((DocPaneXml)this.pilot.getDocPane()).enableTextSelection) {
                        if (!de.getShiftKey()) break;
                        this.pilot.getCSSLayout().selectSentenceLeft();
                        this.pilot.getCSSLayout().postSelectedToClipboard();
                        de.preventDefault();
                        break;
                    }
                }
                case 40: {
                    if (!((DocPaneXml)this.pilot.getDocPane()).enableTextSelection || !de.getShiftKey()) break;
                    this.pilot.getCSSLayout().selectSentenceRight();
                    this.pilot.getCSSLayout().postSelectedToClipboard();
                    de.preventDefault();
                }
            }
        } else {
            de.preventDefault();
        }
    }

    protected boolean doDirectionKey(int dir) {
        if (isAccessible) {
            return false;
        }
        if (!this.scrollOnly() && this.focusManager.localDFM(dir)) {
            return true;
        }
        if (!this.focusOnly() && this.scrollHandler.scrollRequest(dir)) {
            return true;
        }
        if (this.focusExitHandler != null) {
            boolean retval = this.focusExitHandler.focusExit(dir);
            if (retval) {
                this.focusManager.setFocusedBox(null);
            }
            return retval;
        }
        return !this.scrollOnly() && this.focusManager.globalDFM(dir);
    }

    private void processFormSubmitKey(DOMUIEvent de) {
        DNode dnode = this.focusManager.getFocusedElement();
        if (dnode == null) {
            return;
        }
        if (dnode instanceof DInputElement) {
            DInputElement in = (DInputElement)dnode;
            String tt = in.getType();
            if (tt.equalsIgnoreCase("text") || tt.equalsIgnoreCase("password")) {
                DFormElement form = in.getDForm();
                if (form != null && form.submitUsingSubmitkey()) {
                    de.preventDefault();
                }
            } else if (tt.equalsIgnoreCase("button") || tt.equalsIgnoreCase("submit") || tt.equalsIgnoreCase("image") || tt.equalsIgnoreCase("reset")) {
                this.doAction(dnode);
                de.preventDefault();
            }
        } else if (dnode instanceof DHrefElement) {
            this.doAction(dnode);
            de.preventDefault();
        }
    }

    private void onKeyPress(DOMUIEvent de) {
        if (de.isDefaultCancelled()) {
            return;
        }
        long chr = de.getKeyCode();
        if (JavaVersion.isV12orGreater() && this.isFormSubmitKey(chr)) {
            this.processFormSubmitKey(de);
            return;
        }
        if (de.getAltKey()) {
            chr = de.getCharCode();
            if (!de.getShiftKey() && chr >= 65L && chr <= 93L) {
                chr -= 32L;
            }
            if (this.focusManager.processAccessKey(chr)) {
                de.preventDefault();
            }
        }
    }

    private void onKeyUp(DOMUIEvent de) {
        if (de.isDefaultCancelled()) {
            return;
        }
        long chr = de.getKeyCode();
        if (!JavaVersion.isV12orGreater() && this.isFormSubmitKey(chr)) {
            this.processFormSubmitKey(de);
            return;
        }
    }

    private void onFocus(DOMUIEvent de) {
        DocPane dp = this.pilot.getDocPane();
        Rectangle box = new Rectangle();
        this.pilot.getView().findBoundingBox((DNode)de.getTarget(), box);
        Point p = new Point();
        this.pilot.getView().findPosition((DNode)de.getTarget(), p);
        int sx = dp.getScrollX();
        int sy = dp.getScrollY();
        int pw = dp.getPaneWidth();
        int ph = dp.getPaneHeight();
        int newX = sx;
        int newY = sy;
        if (p.x < sx || p.x > sx + pw) {
            newX = p.x < sx ? p.x : 5 + p.x - pw;
        }
        if (p.y < sy || p.y > sy + ph) {
            newY = p.y < sy ? p.y : box.height + p.y - ph;
        }
        if (newX != sx || newY != sy) {
            this.scrollHandler.scrollRequest(newX, newY);
            this.pilot.getCSSLayout().setScrollToFocus(true);
        }
    }

    private void onBlur(DOMUIEvent de) {
    }

    protected void doAction(DNode node) {
        DDocument doc = (DDocument)this.pilot.getDocument();
        if (doc == null) {
            return;
        }
        DOMEvent clickevent = doc.createDOMEvent(1);
        node.dispatchEvent(clickevent);
    }

    private boolean scrollAction(int keycode) {
        if (keycode == 34 || keycode == 33 || keycode == 35 || keycode == 36) {
            return this.scrollHandler.scrollRequest(keycode);
        }
        return false;
    }

    private void handleDefaultActionOnLinks(DOMUIEvent domEvent, DElement elem) {
        String loc = elem.getAttribute(46);
        if (loc != null) {
            boolean hash = loc.equals("#");
            boolean mouseMoveUpdate = false;
            if (elem.tagId == 1 && domEvent.target instanceof DImageElement && !hash && ((DImageElement)domEvent.target).getIsMap()) {
                loc = loc + "?" + domEvent.posX + "," + domEvent.posY;
                mouseMoveUpdate = true;
            }
            DDocument doc = this.pilot.getDDocument();
            loc = doc.resolveUrl(loc);
            switch (domEvent.typeId) {
                case 6: {
                    if (!mouseMoveUpdate) break;
                    this.pilot.firePropertyChange("statusLine", null, loc);
                    break;
                }
                case 5: {
                    this.pilot.firePropertyChange("statusLine", null, loc);
                    break;
                }
                case 7: {
                    this.pilot.firePropertyChange("statusLine", null, "");
                    break;
                }
                case 1: {
                    short button;
                    if (hash || domEvent.isMousePressPopupTrigger || (button = domEvent.getButton()) != 0) break;
                    String target = elem.getAttribute(108);
                    if (target == null || target.length() == 0) {
                        target = doc.getBaseTarget();
                    }
                    this.pilot.renderContent(loc, null, target);
                }
            }
        }
    }

    public FocusExitHandler getFocusExitHandler() {
        return this.focusExitHandler;
    }

    public void setFocusExitHandler(FocusExitHandler feh) {
        this.focusExitHandler = feh;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Toolkit t = Toolkit.getDefaultToolkit();
        Class toolkitClass = class$java$awt$Toolkit == null ? (class$java$awt$Toolkit = DefaultActionHandler.class$("java.awt.Toolkit")) : class$java$awt$Toolkit;
        Object[] mArgs = new Class[]{};
        try {
            Method clipMethod = toolkitClass.getMethod("getSystemSelection", (Class<?>[])mArgs);
            Clipboard clippy = (Clipboard)clipMethod.invoke((Object)t, mArgs);
            if (clippy != null) {
                applicationClipboardPresent = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        accessibility = ACCESSIBILTIY_NONE;
        isAccessible = false;
        accessibility = Defs.sysProperty((String)"ice.pilots.html4.swing.accessible", (String)ACCESSIBILTIY_NONE);
        if (accessibility.equalsIgnoreCase(ACCESSIBILTIY_JAVA) || accessibility.equalsIgnoreCase(ACCESSIBILTIY_JAWS)) {
            isAccessible = true;
        }
    }
}

