/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.dombase.LexBase;
import ice.pilots.html4.CSSBuilder;
import ice.pilots.html4.DAppletElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.DXmlElement;
import ice.pilots.html4.HtmlDOMFixer;
import ice.pilots.html4.Lex2;
import ice.pilots.html4.LexCallback;
import ice.pilots.html4.Names;
import ice.pilots.html4.ProgressDetail;
import ice.pilots.html4.StormData;
import ice.pilots.html4.ThePilot;
import ice.storm.StormBase;
import ice.util.Defs;
import ice.util.alg.CharKit;
import ice.util.encoding.CharIO;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import java.util.Vector;

public final class DOMBuilder
implements LexCallback {
    private static final int MAX_TEXTNODE_LEN = 8192;
    private boolean titleEventFired;
    private DDocument doc;
    private ThePilot pilot;
    private DNode startNode;
    private DNode curNode = null;
    private HtmlDOMFixer fixer;
    private boolean encodingChanged = false;
    private String totalLengthString = null;
    private boolean spaceAdded = false;
    private boolean isPre = false;
    private boolean preJustStarted = false;
    private boolean isTextArea = false;
    private String xmlBody;
    private String scriptBody = null;
    private String scriptLanguage = null;
    private int[] attrIds = new int[50];
    private String[] attrNames = new String[50];
    private String[] attrValues = new String[50];
    private int numAttrs = 0;
    private boolean isXmlnsPending = false;
    private Stack prefixDefs = new Stack();
    private Stack nsDefs = new Stack();
    private int defaultNamespace = 0;
    private DFormElement curHackForm;
    private Vector eventScripts = new Vector();
    private int iframeNesting;
    boolean noJS = false;
    private int cdataStartLine;
    boolean loadSingleOnly = false;
    private char[] textBuffer = new char[2048];
    private int textBufferPos = 0;

    public static void setLoadSingleOnly(StormBase sb) {
        StormData sdata = StormData.get(sb);
        sdata.setLoadSingleOnly(true);
    }

    public DOMBuilder(DDocument doc, ThePilot pilot) {
        this(doc, doc, pilot);
    }

    public DOMBuilder(DDocument doc, DNode startNode, ThePilot pilot) {
        this.doc = doc;
        this.startNode = startNode;
        this.pilot = pilot;
        if (pilot != null) {
            StormData st = StormData.get(pilot.getStorm());
            this.loadSingleOnly = st.getLoadSingleOnly();
        }
    }

    public DOMBuilder(DDocument doc) {
        this(doc, doc, null);
    }

    public boolean isStopRequested() {
        if (this.pilot == null) {
            return false;
        }
        return this.pilot.isStopRequested();
    }

    public void progress(int bytesRead, ProgressDetail pd) {
        if (this.startNode != this.doc) {
            return;
        }
        if (this.pilot == null) {
            return;
        }
        String loc = this.pilot.getPilotViewport().getLocation();
        if (loc == null) {
            return;
        }
        if (this.totalLengthString == null) {
            this.totalLengthString = this.pilot.getPageInfo("content-length");
            if (this.totalLengthString == null) {
                this.totalLengthString = "-1";
            }
        }
        this.pilot.firePropertyChange("contentLoadingProgress", pd, loc + " " + bytesRead + " " + this.totalLengthString);
    }

    public void startDocument() {
        this.fixer = new HtmlDOMFixer(this.doc);
        this.numAttrs = 0;
        this.titleEventFired = false;
        this.curNode = this.startNode;
        this.defaultNamespace = this.doc.defaultNamespace;
    }

    public void endDocument() {
        if (this.textBufferPos > 0) {
            this.addTextNode();
        }
        this.curNode = null;
        this.curHackForm = null;
        this.fixer.moveIsIndexElements();
        this.fixer = null;
        this.prefixDefs.removeAllElements();
        this.nsDefs.removeAllElements();
        for (int i = 0; i < this.eventScripts.size(); i += 3) {
            String id = (String)this.eventScripts.elementAt(i);
            String event = (String)this.eventScripts.elementAt(i + 1);
            String script = (String)this.eventScripts.elementAt(i + 2);
            DNode n = null;
            n = id.equals("document") || id.equals("window") ? this.doc.getDBody() : (DNode)((Object)this.doc.getElementById(id));
            if (n == null) continue;
            int attrId = this.doc.names.getAttrId(3, event);
            n.setDAttr(attrId, script, false);
        }
        this.eventScripts.removeAllElements();
        if (this.pilot != null) {
            this.pilot.moveToBodyTmpBodyEventHandlers();
        }
        this.doc.applyXSLT();
    }

    public void documentCharset(String charset) {
        this.doc.setDefaultCharset(charset);
        this.encodingChanged = true;
    }

    public void cdataBody(char[] ch, int offset, int length) {
        this.appendChars(ch, offset, length);
    }

    public void textCharacters(char[] ch, int text_start, int length) {
        if (this.isPre) {
            this.appendPreText(ch, text_start, length);
        } else {
            this.appendDefaultText(ch, text_start, length);
        }
    }

    public void startElement(LexBase lex, char[] ch, int offset, int length, int prefixLength, boolean isEmpty) {
        try {
            int i;
            int id;
            if (this.textBufferPos > 0) {
                this.addTextNode();
            }
            if (ch[offset] == '!') {
                this.numAttrs = 0;
                return;
            }
            if (ch[offset] == '?') {
                String s = new String(ch, offset + 1, length - 1);
                if (s.equalsIgnoreCase("xml-stylesheet")) {
                    String href = null;
                    String type = null;
                    String media = null;
                    for (int i2 = 0; i2 < this.numAttrs; ++i2) {
                        if (this.attrNames[i2].equals("href")) {
                            href = this.attrValues[i2];
                            continue;
                        }
                        if (this.attrNames[i2].equals("type")) {
                            type = this.attrValues[i2];
                            continue;
                        }
                        if (!this.attrNames[i2].equals("media")) continue;
                        media = this.attrValues[i2];
                    }
                    if (href != null) {
                        this.doc.linkStyleSheet(href, type, media, null, this.doc);
                    }
                }
                this.numAttrs = 0;
                return;
            }
            if (this.isXmlnsPending) {
                for (int i3 = 0; i3 < this.numAttrs; ++i3) {
                    String qname = this.attrNames[i3];
                    if (!CharKit.startsWithIgnoreAsciiCase((String)qname, (String)"xmlns")) continue;
                    String value = this.attrValues[i3];
                    int namespaceId = "".equals(value) || "null".equals(value) ? (this.doc.defaultNamespace == 3 ? 3 : 5) : this.doc.names.getNamespace(value);
                    int p = qname.indexOf(58);
                    if (p < 0) {
                        this.defaultNamespace = namespaceId;
                        NSEntry nse = new NSEntry(null, namespaceId, null);
                        this.nsDefs.push(nse);
                        continue;
                    }
                    String ns_prefix = qname.substring(p + 1);
                    NSEntry nse = new NSEntry(null, namespaceId, ns_prefix);
                    this.prefixDefs.push(nse);
                }
            }
            int nsId = this.defaultNamespace;
            if (prefixLength > 0) {
                String prefix = new String(ch, offset, prefixLength - 1);
                int i4 = this.getNamespaceFromPrefix(prefix);
                if (i4 >= 0) {
                    nsId = i4;
                } else {
                    this.isXmlnsPending = false;
                    this.numAttrs = 0;
                    return;
                }
            }
            if (length >= 8 && CharKit.startsWith((char[])ch, (int)offset, (int)(offset + length), (String)"itemtb")) {
                CharKit.asciiToUpperCase((char[])ch, (int)offset, (int)(offset + length));
                nsId = 5;
            }
            if ((id = this.doc.names.getTagId(nsId, ch, offset + prefixLength, length - prefixLength)) < 0) {
                this.isXmlnsPending = false;
                this.numAttrs = 0;
                return;
            }
            if (id == 14) {
                this.spaceAdded = true;
            }
            if (id == 32 && this.curHackForm != null) {
                this.isXmlnsPending = false;
                this.numAttrs = 0;
                return;
            }
            DElement e = this.doc.createElement(id);
            if (prefixLength > 0) {
                e.qname = new String(ch, offset, length);
            }
            if (this.numAttrs > this.attrIds.length) {
                this.attrIds = new int[this.attrNames.length];
            }
            if (this.isXmlnsPending) {
                this.isXmlnsPending = false;
                for (i = this.nsDefs.size() - 1; i >= 0; --i) {
                    NSEntry nse = (NSEntry)this.nsDefs.elementAt(i);
                    if (nse.node != null) break;
                    nse.node = e;
                }
                for (i = this.prefixDefs.size() - 1; i >= 0; --i) {
                    NSEntry nse = (NSEntry)this.prefixDefs.elementAt(i);
                    if (nse.node != null) break;
                    nse.node = e;
                }
                Names names = this.doc.names;
                for (int i5 = 0; i5 < this.numAttrs; ++i5) {
                    String qname = this.attrNames[i5];
                    int p = qname.indexOf(58);
                    if (p < 0) {
                        this.attrIds[i5] = names.getAttrId(nsId, qname);
                        continue;
                    }
                    int attrNsId = 0;
                    String prefix = qname.substring(0, p);
                    int aa = this.getNamespaceFromPrefix(prefix);
                    if (aa >= 0) {
                        attrNsId = aa;
                    }
                    this.attrIds[i5] = names.getAttrId(attrNsId, qname);
                }
            } else {
                for (i = 0; i < this.numAttrs; ++i) {
                    this.attrIds[i] = this.doc.names.getAttrId(nsId, this.attrNames[i]);
                }
            }
            e.setAttributes(this.attrIds, this.attrValues, this.numAttrs);
            this.numAttrs = 0;
            this.curNode = this.fixer.addChildNode(this.curNode, e);
            if (isEmpty && this.curNode != null && this.curNode.getNameId() == id) {
                this.curNode = this.curNode.getParentDNode();
            }
            if (this.curNode != e) {
                this.closeNamespaces(e, this.curNode);
            }
            switch (id) {
                case 94: {
                    if (isEmpty) {
                        this.loadIfGivenExternalXML((DXmlElement)e);
                        break;
                    }
                    lex.reqEmbeddedXml();
                    break;
                }
                case 76: {
                    lex.reqCdata();
                    break;
                }
                case 70: {
                    if (!this.shouldIgnoreScripts()) {
                        this.scriptLanguage = DOMBuilder.extractScriptLanguage(e);
                        boolean vbscript = this.scriptLanguage != null && this.scriptLanguage.equalsIgnoreCase("vbscript");
                        this.fixer.setAllowNoScript(vbscript);
                        if (isEmpty) {
                            this.loadIfGivenExternalScript(e);
                        }
                    }
                    if (isEmpty) break;
                    this.cdataStartLine = lex.lineNumber;
                    lex.reqScriptCdata();
                    break;
                }
                case 54: {
                    this.doc.handleLinkTag(e);
                    break;
                }
                case 57: {
                    String enc = e.getAttribute("charset");
                    if (enc != null && !this.encodingChanged) {
                        this.encodingChanged = true;
                        if (this.applyEncodingChange(enc, (Lex2)lex)) {
                            return;
                        }
                    }
                    String equiv = e.getAttribute(49);
                    String cont = e.getAttribute(31);
                    if (equiv == null || cont == null) break;
                    if (equiv.equalsIgnoreCase("content-type")) {
                        int a = cont.toLowerCase().indexOf("charset");
                        if (a > 0 && !this.encodingChanged) {
                            this.encodingChanged = true;
                            if ((a = cont.indexOf(61, a)) > 0 && this.applyEncodingChange(cont = cont.substring(a + 1).trim(), (Lex2)lex)) {
                                return;
                            }
                        }
                        break;
                    }
                    if (!equiv.equalsIgnoreCase("set-cookie")) break;
                    this.doc.setCookie(cont);
                    break;
                }
                case 66: {
                    this.isPre = true;
                    this.preJustStarted = true;
                    break;
                }
                case 34: {
                    this.doc.isFrameset = true;
                    break;
                }
                case 8: {
                    String href = e.getAttribute(46);
                    String target = e.getAttribute(108);
                    if (href != null) {
                        this.doc.setBaseUrl(this.doc.resolveUrl(href));
                    }
                    if (target == null) break;
                    this.doc.setBaseTarget(target);
                    break;
                }
                case 13: {
                    this.doc.validateBodyAttrs();
                    break;
                }
                case 32: {
                    this.curHackForm = (DFormElement)e;
                    break;
                }
                case 15: 
                case 47: {
                    if (this.curHackForm == null) break;
                    this.curHackForm.addHackElement(e);
                    if (this.curHackForm.getParentNode() != null || e.getParentNode() == null) break;
                    e.getParentNode().insertBefore(this.curHackForm, e);
                    break;
                }
                case 82: {
                    lex.reqTextareaCdata();
                    this.isTextArea = true;
                    if (this.curHackForm == null) break;
                    this.curHackForm.addHackElement(e);
                    if (this.curHackForm.getParentNode() != null || e.getParentNode() == null) break;
                    e.getParentNode().insertBefore(this.curHackForm, e);
                    break;
                }
                case 71: {
                    if (this.curHackForm == null) break;
                    this.curHackForm.addHackElement(e);
                    if (this.curHackForm.getParentNode() != null || e.getParentNode() == null) break;
                    e.getParentNode().insertBefore(this.curHackForm, e);
                    break;
                }
                case 45: {
                    if (ch[offset] == 'e' || ch[offset] == 'E') {
                        if (this.curNode != e) break;
                        this.curNode = e.getParentDNode();
                        break;
                    }
                    if (isEmpty) break;
                    ++this.iframeNesting;
                    break;
                }
                case 46: {
                    this.spaceAdded = false;
                }
            }
        }
        catch (Throwable t) {
            Debug.ex((Throwable)t);
        }
    }

    private boolean applyEncodingChange(String enc, Lex2 lex) {
        if (lex.applyEncodingChange(enc)) {
            this.doc.clear();
            this.doc.setUnresolvedCharset(enc);
            this.doc.setDefaultCharset(enc);
            this.startDocument();
            return true;
        }
        return false;
    }

    public void elementAttribute(char[] ch, int nameOffset, int nameLength, int prefixLength, int valueOffset, int valueLength) {
        String value;
        if (prefixLength > 0) {
            this.isXmlnsPending = true;
        } else if (CharKit.startsWithIgnoreAsciiCase((char[])ch, (int)nameOffset, (int)(nameOffset + nameLength), (String)"xml")) {
            this.isXmlnsPending = true;
        }
        String name = new String(ch, nameOffset, nameLength);
        if (nameOffset != valueOffset) {
            value = new String(ch, valueOffset, valueLength);
        } else if (this.defaultNamespace == 3 && prefixLength == 0) {
            if (name.equalsIgnoreCase("value")) {
                return;
            }
            value = name;
        } else {
            value = "";
        }
        switch (this.doc.names.getAttrId(3, name)) {
            case 5: 
            case 9: 
            case 11: 
            case 20: 
            case 22: 
            case 25: 
            case 33: 
            case 46: 
            case 56: 
            case 87: 
            case 102: 
            case 112: {
                String _encoding = null;
                String _defaultEncoding = this.doc.getDefaultCharset();
                try {
                    _encoding = Defs.property((String)"ice.pilots.html4.defaultUrlEncoding", (String)CharIO.getDefaultEncoding());
                    value = new String(_defaultEncoding != null ? value.getBytes(_defaultEncoding) : value.getBytes(), _encoding);
                    break;
                }
                catch (UnsupportedEncodingException exception) {
                    Debug.trace((String)("Unsupported encoding: " + (_encoding == null ? _defaultEncoding : _encoding) + "\r\n" + "Revert to system's default encoding: " + CharIO.getDefaultEncoding()));
                    try {
                        value = new String(value.getBytes(), CharIO.getDefaultEncoding());
                    }
                    catch (UnsupportedEncodingException e) {
                        Debug.ex((Throwable)e);
                    }
                    break;
                }
                catch (RuntimeException rtException) {
                    String className = rtException.getClass().getName();
                    if (className.equals("java.lang.UnsupportedOperationException")) {
                        Debug.trace((String)("UnsupportedOperationException because of unsupported encoding: " + (_encoding == null ? _defaultEncoding : _encoding) + "\r\n " + "Revert to system's default encoding: " + CharIO.getDefaultEncoding()));
                        try {
                            value = new String(value.getBytes(), CharIO.getDefaultEncoding());
                        }
                        catch (UnsupportedEncodingException e) {
                            Debug.ex((Throwable)e);
                        }
                        break;
                    }
                    throw rtException;
                }
            }
        }
        int capacity = this.attrNames.length;
        if (this.numAttrs == capacity) {
            String[] tmp = new String[capacity * 2];
            System.arraycopy(this.attrNames, 0, tmp, 0, capacity);
            this.attrNames = tmp;
            tmp = new String[capacity * 2];
            System.arraycopy(this.attrValues, 0, tmp, 0, capacity);
            this.attrValues = tmp;
        }
        this.attrNames[this.numAttrs] = name;
        this.attrValues[this.numAttrs] = value;
        ++this.numAttrs;
    }

    public void endElement(LexBase lex, char[] ch, int offset, int length, int prefixLength) {
        String script;
        int id;
        if (this.textBufferPos > 0) {
            this.addTextNode();
        }
        int nsId = this.defaultNamespace;
        if (prefixLength > 0) {
            String prefix = new String(ch, offset, prefixLength - 1);
            int i = this.getNamespaceFromPrefix(prefix);
            if (i >= 0) {
                nsId = i;
            } else {
                return;
            }
        }
        if ((id = this.doc.names.getTagId(nsId, ch, offset + prefixLength, length - prefixLength)) == 86 && this.fixer.parentOfIllegalTitleNode != null) {
            this.fixer.parentOfIllegalTitleNode = null;
            return;
        }
        if (id < 0) {
            return;
        }
        String cdata_txt = null;
        DElement script_elem = null;
        DElement iframeToLoad = null;
        switch (id) {
            case 87: {
                if (this.curNode.getNameId() != 87) break;
                this.fixer.onClosingTR(this.curNode);
                break;
            }
            case 81: {
                this.fixer.closeLastBreakNode();
                break;
            }
            case 79: {
                if (!this.fixer.hasHackTable()) break;
                this.curNode = this.fixer.closeHackTable(false);
                break;
            }
            case 66: {
                this.isPre = false;
                break;
            }
            case 82: {
                this.isTextArea = false;
                break;
            }
            case 86: {
                if (this.pilot == null || this.titleEventFired) break;
                this.pilot.firePropertyChange("title", null, this.doc.getTitle());
                this.titleEventFired = true;
                break;
            }
            case 70: {
                if (!this.shouldIgnoreScripts() && this.curNode != null && this.curNode.tagId == 70) {
                    script_elem = (DElement)this.curNode;
                    cdata_txt = this.scriptBody;
                }
                this.scriptBody = null;
                break;
            }
            case 94: {
                DDocument genDoc;
                DXmlElement e;
                if (this.curNode != null && this.curNode.tagId == 94 && !this.loadIfGivenExternalXML(e = (DXmlElement)this.curNode) && this.xmlBody != null && (genDoc = this.doc.getDom().parseEmbeddedDocumentFromString(this.xmlBody)) != null) {
                    e.setGeneratedDocument(genDoc);
                }
                this.xmlBody = null;
                break;
            }
            case 32: {
                this.curHackForm = null;
                break;
            }
            case 5: {
                if (this.curNode == null || !(this.curNode instanceof DAppletElement)) break;
                DAppletElement a = (DAppletElement)this.curNode;
                a.setLoaded();
                this.doc.mutate();
                break;
            }
            case 43: {
                if (this.doc.defaultNamespace != 3) break;
                return;
            }
            case 45: {
                iframeToLoad = (DElement)this.curNode;
            }
        }
        DNode p = this.checkClosing(true, id);
        if (p == null) {
            this.checkClosing(false, id);
        }
        if (script_elem != null && this.pilot != null && !this.loadIfGivenExternalScript(script_elem) && cdata_txt != null && !this.checkScriptEventHandler(script_elem, script = DOMBuilder.cleanupScript(cdata_txt))) {
            String src = this.doc.getBaseUrl();
            this.pilot.doScriptEval(this.scriptLanguage, script, src, this.cdataStartLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadIfGivenExternalXML(DXmlElement e) {
        Object str = null;
        String src = e.getAttribute(102);
        if (src == null) {
            src = e.getAttribute(90);
        }
        if (src != null) {
            String srcUrl = this.doc.resolveUrl(src);
            if (srcUrl != null) {
                DDocument genDoc;
                block11: {
                    genDoc = null;
                    if (this.loadSingleOnly) {
                        return true;
                    }
                    if (Debug.trace) {
                        Debug.trace((String)("External XML: url=" + srcUrl));
                    }
                    try {
                        Reader reader = this.doc.openUrlReader(srcUrl);
                        try {
                            genDoc = this.doc.getDom().parseEmbeddedDocumentFromReader(reader);
                        }
                        finally {
                            reader.close();
                        }
                    }
                    catch (IOException ex) {
                        if (!Debug.ex) break block11;
                        Debug.ex((Throwable)ex);
                    }
                }
                if (genDoc != null) {
                    e.setGeneratedDocument(genDoc);
                }
            }
            return true;
        }
        return false;
    }

    private boolean loadIfGivenExternalScript(DElement e) {
        String src = e.getAttribute(102);
        if (src != null) {
            if (this.loadSingleOnly) {
                return true;
            }
            String srcUrl = this.doc.resolveUrl(src);
            if (srcUrl != null) {
                String script;
                if (Debug.trace) {
                    Debug.trace((String)("External script: url=" + srcUrl));
                }
                if ((script = this.loadDataOrNull(srcUrl)) != null && this.pilot != null && !this.checkScriptEventHandler(e, script)) {
                    this.pilot.doScriptEval(this.scriptLanguage, script, srcUrl.toString(), 0);
                }
            }
            return true;
        }
        return false;
    }

    static String extractScriptLanguage(DElement e) {
        String s = e.getAttribute(54);
        if (s == null || s.length() == 0 || s.equals("language") || s.equals("liveScript")) {
            s = "ECMAScript";
        }
        return s;
    }

    static String cleanupScript(String script) {
        String s = script.trim();
        if (s.endsWith("-->")) {
            script = s.substring(0, s.length() - 3);
        }
        return script;
    }

    private boolean checkScriptEventHandler(DElement e, String script) {
        String scriptEvent = e.getAttribute(120);
        String scriptFor = e.getAttribute(41);
        if (scriptFor != null && scriptEvent != null) {
            this.eventScripts.addElement(scriptFor);
            this.eventScripts.addElement(scriptEvent);
            this.eventScripts.addElement(script);
            return true;
        }
        return false;
    }

    DNode checkClosing(boolean leaveOutSynthetic, int id) {
        DNode p;
        for (p = this.curNode; p != null; p = p.getParentDNode()) {
            if (!(p instanceof DElement)) continue;
            DElement pe = (DElement)p;
            if (leaveOutSynthetic && pe.getSynthetic()) continue;
            if (pe.tagId == id || this.fixer.tagsAreSynonymous(pe, id)) {
                DNode temp = this.curNode;
                this.curNode = pe.getParentDNode();
                this.closeNamespaces(temp, this.curNode);
                if (id != 45 || this.iframeNesting == 0) break;
                --this.iframeNesting;
                break;
            }
            if (this.fixer.canCloseNodeWith(p, id)) continue;
            p = null;
            break;
        }
        return p;
    }

    String removeBufferedChars() {
        String removedText = new String(this.textBuffer, 0, this.textBufferPos);
        this.textBufferPos = 0;
        return removedText;
    }

    private final void addTextNode() {
        DTextNode tn = null;
        if (this.textBufferPos <= 8192 || this.curNode.tagId == 70 || this.curNode.tagId == 76 || this.curNode.tagId == 86 || this.curNode.tagId == 57 || this.curNode.tagId == 63 || this.curNode.tagId == 47 || this.curNode.tagId == 15 || this.curNode.tagId == 82 || this.curNode.tagId == 94) {
            tn = this.doc.createDTextNode(this.textBuffer, 0, this.textBufferPos, this.isPre || this.isTextArea);
            this.curNode = this.fixer.addChildNode(this.curNode, tn);
            if (this.curNode instanceof DTextAreaElement) {
                ((DTextAreaElement)this.curNode).getValue();
            }
        } else {
            int numNodes = this.textBufferPos / 8192;
            if (this.textBufferPos % 8192 > 0) {
                ++numNodes;
            }
            int textBufferOffset = 0;
            int remainingLen = this.textBufferPos;
            int textNodeLen = 0;
            for (int i = 0; i < numNodes; ++i) {
                textNodeLen = remainingLen < 8192 ? remainingLen : 8192;
                tn = this.doc.createDTextNode(this.textBuffer, textBufferOffset, textNodeLen, this.isPre || this.isTextArea);
                this.curNode = this.fixer.addChildNode(this.curNode, tn);
                textBufferOffset += textNodeLen;
                remainingLen -= textNodeLen;
            }
        }
        this.textBufferPos = 0;
        if (this.curNode instanceof DElement) {
            DElement e = (DElement)this.curNode;
            if (e.tagId == 76) {
                try {
                    DStyleSheet ss = this.doc.getDom().createDStyleSheet(this.doc.defaultNamespace, e, null, null);
                    CSSBuilder b = new CSSBuilder(this.doc);
                    b.build(ss, new CharArrayReader(tn.text), this.doc.getBaseUrl());
                    this.doc.addStyleSheet(ss);
                }
                catch (IOException ex) {
                    if (Debug.ex) {
                        Debug.ex((Throwable)ex);
                    }
                }
            } else if (e.tagId == 70) {
                if (!this.shouldIgnoreScripts()) {
                    this.scriptBody = tn.getNodeValue();
                }
            } else if (e.tagId == 94) {
                this.xmlBody = tn.getNodeValue();
            }
        }
    }

    private void ensureTextBufferAppend(int add_size) {
        int new_pos = this.textBufferPos + add_size;
        int capacity = this.textBuffer.length;
        if (new_pos > capacity) {
            if (new_pos > (capacity *= 2)) {
                capacity = new_pos;
            }
            char[] tmp = new char[capacity];
            if (this.textBufferPos != 0) {
                System.arraycopy(this.textBuffer, 0, tmp, 0, this.textBufferPos);
            }
            this.textBuffer = tmp;
        }
    }

    private void appendChars(char[] buf, int offset, int length) {
        this.ensureTextBufferAppend(length);
        System.arraycopy(buf, offset, this.textBuffer, this.textBufferPos, length);
        this.textBufferPos += length;
    }

    private void appendPreText(char[] buf, int offset, int length) {
        this.ensureTextBufferAppend(length);
        int src_pos = offset;
        int dest_pos = this.textBufferPos;
        while (src_pos < offset + length) {
            int c = buf[src_pos];
            if (c == 12) {
                c = 10;
            } else if (c == 10) {
                if (src_pos < offset + length - 1 && buf[src_pos + 1] == '\r') {
                    ++src_pos;
                }
            } else if (c == 13) {
                if (src_pos < offset + length - 1 && buf[src_pos + 1] == '\n') {
                    ++src_pos;
                }
                c = 10;
            } else if (c == 9) {
                c = 32;
            }
            ++src_pos;
            if (!this.preJustStarted || dest_pos != this.textBufferPos || c != 10) {
                this.textBuffer[dest_pos++] = c;
            }
            this.preJustStarted = false;
        }
        this.textBufferPos = dest_pos;
    }

    private void appendDefaultText(char[] buf, int offset, int length) {
        int src_pos;
        this.ensureTextBufferAppend(length);
        char[] dest = this.textBuffer;
        int c = 0;
        int dest_pos = this.textBufferPos;
        int end = offset + length;
        for (src_pos = offset; src_pos != end && DOMBuilder.isWhiteSpace(c = buf[src_pos]); ++src_pos) {
        }
        if (src_pos != offset && !this.spaceAdded) {
            if (this.fixer.isFirstWhitespaceAllowed(this.curNode)) {
                dest[dest_pos++] = 32;
            }
            this.spaceAdded = true;
        }
        if (src_pos != end) {
            dest[dest_pos++] = c;
            ++src_pos;
            boolean inside_word = true;
            while (src_pos != end) {
                c = buf[src_pos];
                if (inside_word) {
                    if (DOMBuilder.isWhiteSpace(c)) {
                        inside_word = false;
                        c = 32;
                    }
                    dest[dest_pos++] = c;
                } else if (!DOMBuilder.isWhiteSpace(c)) {
                    dest[dest_pos++] = c;
                    inside_word = true;
                }
                ++src_pos;
            }
            this.spaceAdded = !inside_word;
        }
        this.textBufferPos = dest_pos;
    }

    private static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13 || c == 12 || c == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadDataOrNull(String url) {
        String string;
        Reader reader = this.doc.openUrlReader(url);
        try {
            int r;
            int pos = 0;
            char[] buffer = new char[2048];
            while ((r = reader.read(buffer, pos, buffer.length - pos)) >= 0) {
                if ((pos += r) != buffer.length) continue;
                char[] tmp = new char[pos * 2];
                System.arraycopy(buffer, 0, tmp, 0, pos);
                buffer = tmp;
            }
            string = new String(buffer, 0, pos);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (Throwable ex) {
                if (Debug.ex) {
                    Debug.ex((Throwable)ex);
                }
                return null;
            }
        }
        reader.close();
        return string;
    }

    private final void closeNamespaces(DNode child, DNode parent) {
        NSEntry nse;
        while (child != null && child != parent) {
            while (!this.prefixDefs.empty()) {
                nse = (NSEntry)this.prefixDefs.peek();
                if (nse.node != child) break;
                this.prefixDefs.pop();
            }
            while (!this.nsDefs.empty()) {
                nse = (NSEntry)this.nsDefs.peek();
                if (nse.node != child) break;
                this.nsDefs.pop();
            }
            child = child.getParentDNode();
        }
        if (this.nsDefs.empty()) {
            this.defaultNamespace = this.doc.defaultNamespace;
        } else {
            nse = (NSEntry)this.nsDefs.peek();
            this.defaultNamespace = nse.nsId;
        }
    }

    private final int getNamespaceFromPrefix(String prefix) {
        if ("xmlns".equals(prefix)) {
            return 2;
        }
        for (int i = this.prefixDefs.size() - 1; i >= 0; --i) {
            NSEntry nse = (NSEntry)this.prefixDefs.elementAt(i);
            if (!nse.prefix.equals(prefix)) continue;
            return nse.nsId;
        }
        return -1;
    }

    boolean shouldIgnoreScripts() {
        int id;
        if (this.noJS) {
            return true;
        }
        boolean result = false;
        if (this.curNode != null && ((id = this.curNode.tagId) == 58 || id == 59 || this.iframeNesting != 0)) {
            result = true;
        }
        return result;
    }

    static class NSEntry {
        DNode node;
        int nsId;
        String prefix;

        NSEntry(DNode n, int ns, String pr) {
            this.node = n;
            this.nsId = ns;
            this.prefix = pr;
        }
    }
}

