/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormList;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DNodeList;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.DocAction;
import ice.pilots.html4.FormSubmitData;
import ice.pilots.html4.FormTypeElement;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.DynEnv;
import ice.storm.Viewport;
import ice.util.alg.HashArray;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLFormElement;

public class DFormElement
extends DElement
implements HTMLFormElement {
    private int mutation = 0;
    private DFormList formList;
    Vector hackedControls = null;
    private static final int Field_acceptCharset = 1;
    private static final int Field_action = 2;
    private static final int Field_elements = 3;
    private static final int Field_enctype = 4;
    private static final int Field_length = 5;
    private static final int Field_method = 6;
    private static final int Field_target = 7;
    private static final int Method_reset = -1;
    private static final int Method_submit = -2;

    protected DFormElement(DDocument doc, int id) {
        super(doc, id);
    }

    static DFormElement parentForm(DNode n) {
        while (n != null) {
            if (n.tagId == 32 && n instanceof DFormElement) {
                return (DFormElement)n;
            }
            n = n.parent;
        }
        return null;
    }

    void addHackElement(DElement e) {
        if (this.hackedControls == null) {
            this.hackedControls = new Vector();
        }
        if (!this.hackedControls.contains(e)) {
            this.hackedControls.addElement(e);
        }
        if (e instanceof FormTypeElement) {
            ((FormTypeElement)e).setHackForm(this);
        }
    }

    private DFormList getFormList() {
        if (this.formList == null) {
            this.formList = new DFormList(this);
        }
        return this.formList;
    }

    public HTMLCollection getElements() {
        return this.getFormList();
    }

    public int getLength() {
        return this.getFormList().getLength();
    }

    void recordHackedControls(HashArray named, Vector v) {
        if (this.hackedControls == null) {
            return;
        }
        for (int i = 0; i < this.hackedControls.size(); ++i) {
            DNode n;
            DNode p;
            for (p = n = (DNode)this.hackedControls.elementAt(i); p != this.doc && p != null; p = p.getParentDNode()) {
            }
            if (p == null) {
                this.hackedControls.removeElementAt(i);
                --i;
                continue;
            }
            this.getFormList().recordFormControl(n, named, v);
        }
    }

    public String getAcceptCharset() {
        return null;
    }

    public void setAcceptCharset(String acceptCharset) {
    }

    public String getAction() {
        return this.getAttribute(5);
    }

    public void setAction(String action) {
        this.setAttribute(5, action);
    }

    public String getEnctype() {
        String enctype = this.getAttribute(39);
        if (enctype != null) {
            return enctype;
        }
        return "application/x-www-form-urlencoded";
    }

    public void setEnctype(String enctype) {
    }

    public String getMethod() {
        return this.getAttribute(61);
    }

    public void setMethod(String method) {
        this.setAttribute(61, method);
    }

    public String getTarget() {
        return this.getAttribute(108);
    }

    public void setTarget(String target) {
        this.setAttribute(108, target);
    }

    boolean isFilePost() {
        DFormList list = this.getFormList();
        for (int i = 0; i < list.getLength(); ++i) {
            FormTypeElement e = (FormTypeElement)list.item(i);
            if (!"file".equalsIgnoreCase(e.getAttribute(111))) continue;
            return true;
        }
        return false;
    }

    boolean submitUsingSubmitkey() {
        DNode p;
        int i;
        HTMLCollection list = this.getElements();
        if (list == null) {
            return false;
        }
        if (list.getLength() == 0) {
            return false;
        }
        int textelm = 0;
        for (i = 0; i < list.getLength() && ((p = (DNode)list.item(i)).getNameId() != 47 || !"text".equalsIgnoreCase(((DInputElement)p).getType()) && !"password".equalsIgnoreCase(((DInputElement)p).getType()) || ++textelm <= 1); ++i) {
        }
        if (textelm == 0) {
            return false;
        }
        if (textelm == 1) {
            this.submit(true);
            return true;
        }
        for (i = 0; i < list.getLength(); ++i) {
            p = (DNode)list.item(i);
            if (p.getNameId() != 47 || !"image".equalsIgnoreCase(((DInputElement)p).getType()) && !"submit".equalsIgnoreCase(((DInputElement)p).getType()) || ((DInputElement)p).getDisabled()) continue;
            ((DInputElement)p).click();
            return true;
        }
        return false;
    }

    public void submit() {
        this.submit(null);
    }

    public void submit(boolean sendEvent) {
        if (sendEvent) {
            this.submitWithEvent();
        } else {
            this.submit();
        }
    }

    public void submitWithEvent() {
        this.submitWithEvent(null);
    }

    void submitWithEvent(Object submitSource) {
        DOMEvent de = this.doc.createDOMEvent(19, this);
        this.doc.processEvent(de);
        if (!de.isDefaultCancelled()) {
            this.submit(submitSource);
        }
    }

    void submit(final Object submitSource) {
        DocAction action = new DocAction(this.doc){

            protected void doit(DDocument doc) {
                DFormElement.this.do_submit(submitSource);
            }
        };
        action.postToEventThread(0L);
    }

    void do_submit(Object submitSource) {
        String target;
        int queston_pos;
        boolean doPost;
        String enctype;
        ThePilot pilot = this.getPilot();
        if (pilot == null) {
            return;
        }
        boolean form_multipart = this.isFilePost();
        if (!form_multipart && "multipart/form-data".equalsIgnoreCase(enctype = this.getEnctype())) {
            form_multipart = true;
        }
        String loc = this.getAttribute(5);
        String method = this.getAttribute(61);
        boolean bl = doPost = method != null && method.equalsIgnoreCase("POST");
        if (loc == null) {
            loc = "";
        }
        loc = this.doc.resolveUrl(loc);
        if (!doPost && (queston_pos = loc.indexOf(63)) >= 0) {
            loc = loc.substring(0, queston_pos);
        }
        if ((target = this.getAttribute(108)) == null) {
            target = this.doc.getBaseTarget();
        }
        if (null != pilot.getStorm().getScripterForCodeLocation(loc)) {
            pilot.renderContent(loc, null, target);
            return;
        }
        FormSubmitData outputData = new FormSubmitData(form_multipart, doPost, this);
        this.fillSubmitData(outputData, submitSource);
        if (doPost) {
            ContentLoader cl = pilot.getStorm().getContentLoaderFactory().createContentLoader(loc, null);
            outputData.prepareContentLoader(cl);
            cl.setReferer(this.doc.getCurrentLocation());
            Viewport view = pilot.findOrCreateViewport(target, loc);
            pilot.getStorm().renderViewportContent(cl, view);
        } else {
            loc = loc + "?" + outputData.toLocationSearchPart();
            pilot.renderContent(loc, null, target);
        }
    }

    public void reset() {
        DocAction action = new DocAction(this.doc){

            protected void doit(DDocument doc) {
                DFormElement.this.do_reset();
            }
        };
        action.postToEventThread(0L);
    }

    public void do_reset() {
        DOMEvent de = this.doc.createDOMEvent(20, this);
        this.doc.processEvent(de);
        if (de.isDefaultCancelled()) {
            return;
        }
        HTMLCollection list = this.getElements();
        block5: for (int i = 0; i < list.getLength(); ++i) {
            DNode p = (DNode)list.item(i);
            switch (p.getNameId()) {
                case 15: 
                case 47: {
                    if (!(p instanceof DInputElement)) continue block5;
                    ((DInputElement)p).reset();
                    continue block5;
                }
                case 71: {
                    if (!(p instanceof DSelectElement)) continue block5;
                    ((DSelectElement)p).reset();
                    continue block5;
                }
                case 82: {
                    if (!(p instanceof DTextAreaElement)) continue block5;
                    ((DTextAreaElement)p).reset();
                }
            }
        }
    }

    private void fillSubmitData(FormSubmitData data, Object submitSource) {
        DFormList list = this.getFormList();
        if (this.hackedControls != null && list.getLength() < this.hackedControls.size()) {
            list.record();
        }
        for (int i = 0; i < list.getLength(); ++i) {
            FormTypeElement control = (FormTypeElement)list.item(i);
            control.recordData(data, submitSource);
        }
    }

    public Object getSlot(int index, DynEnv env) {
        Node result = this.getFormList().item(index);
        if (result != null) {
            return result;
        }
        return super.getSlot(index, env);
    }

    public Object getDynamicValue(String name, DynEnv env) {
        Object result = this.getFormList().script_namedItem(name, env);
        if (result == null) {
            DNodeList imgList = new DNodeList(this, "img");
            result = imgList.namedItem(name);
        }
        if (result != null) {
            return result;
        }
        int id = DFormElement.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DFormElement.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DFormElement.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.getAcceptCharset();
            }
            case 2: {
                return this.getAction();
            }
            case 3: {
                return this.getElements();
            }
            case 4: {
                return this.getEnctype();
            }
            case 5: {
                return env.wrapInt(this.getLength());
            }
            case 6: {
                return this.getMethod();
            }
            case 7: {
                return this.getTarget();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 1: {
                this.setAcceptCharset(env.toStr(value));
                return 1;
            }
            case 2: {
                this.setAction(env.toStr(value));
                return 1;
            }
            case 4: {
                this.setEnctype(env.toStr(value));
                return 1;
            }
            case 6: {
                this.setMethod(env.toStr(value));
                return 1;
            }
            case 7: {
                this.setTarget(env.toStr(value));
                return 1;
            }
        }
        return 2;
    }

    Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                this.reset();
                break;
            }
            case -2: {
                this.submit();
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 5: {
                X = "reset";
                id = -1;
                break;
            }
            case 6: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "action";
                        id = 2;
                        break block0;
                    }
                    case 'l': {
                        X = "length";
                        id = 5;
                        break block0;
                    }
                    case 'm': {
                        X = "method";
                        id = 6;
                        break block0;
                    }
                    case 's': {
                        X = "submit";
                        id = -2;
                        break block0;
                    }
                    case 't': {
                        X = "target";
                        id = 7;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                X = "enctype";
                id = 4;
                break;
            }
            case 8: {
                X = "elements";
                id = 3;
                break;
            }
            case 13: {
                X = "acceptCharset";
                id = 1;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

