/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSBuilder;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DAllList;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DAppletElement;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DFormElement;
import ice.pilots.html4.DFragment;
import ice.pilots.html4.DIFrameElement;
import ice.pilots.html4.DImageElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DIsIndexElement;
import ice.pilots.html4.DMapElement;
import ice.pilots.html4.DMutationEvent;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DNodeList;
import ice.pilots.html4.DNodeListeners;
import ice.pilots.html4.DOM;
import ice.pilots.html4.DOMBuilder;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DRange;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.DStyleSheet;
import ice.pilots.html4.DStyleSheetList;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.DXmlElement;
import ice.pilots.html4.DefaultEventHandler;
import ice.pilots.html4.DomEventItem;
import ice.pilots.html4.Lex2;
import ice.pilots.html4.Names;
import ice.pilots.html4.StormData;
import ice.pilots.html4.ThePilot;
import ice.pilots.html4.TheView;
import ice.pilots.html4.TransformXml;
import ice.pilots.html4.Transformer;
import ice.pilots.html4.TransformerFactory;
import ice.storm.ContentLoader;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.alg.HashArray;
import ice.util.encoding.CharIO;
import ice.util.net.CookieSet;
import ice.util.net.URLResolver;
import ice.util.security.BoxedCode;
import ice.util.security.ProxyException;
import ice.util.security.SecurityKit;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.BreakIterator;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLDocument;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.stylesheets.DocumentStyle;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class DDocument
extends DNode
implements Document,
HTMLDocument,
DocumentStyle,
DocumentEvent,
DocumentView {
    public static boolean STRICT = false;
    private String xsltSheet;
    private String _baseUrl;
    private String baseTarget = "_self";
    int defaultNamespace = 3;
    ThePilot pilot;
    boolean isFrameset = false;
    private DElement rootElement;
    private int mutation = 0;
    private DAllList all;
    private DNodeList images;
    private DNodeList forms;
    private DNodeList links;
    private DNodeList maps;
    private DNodeList iframes;
    private DRange selection;
    private String defaultCharset;
    private BreakIterator wordIterator;
    private DStyleSheetList styleSheetList;
    private String linkColor;
    private String vlinkColor;
    private String alinkColor;
    private HashArray httpProperties;
    protected Names names;
    private boolean async = false;
    private String lang;
    private DOM _domImplementation;
    private DOMImplementation theDomImplementation;
    private DDocument _parentDocument;
    CookieSet cookieSet;
    private static final String sysLanguage = Defs.sysProperty((String)"user.language");
    DOMEvent currentEvent;
    private final DMutationEvent aMutationEvent = new DMutationEvent(this, 25);
    int charsetId = 0;
    private static final int Field_async = 1;
    private static final int Field_alinkColor = 2;
    private static final int Field_all = 3;
    private static final int Field_anchors = 4;
    private static final int Field_applets = 5;
    private static final int Field_bgColor = 6;
    private static final int Field_body = 7;
    private static final int Field_cookie = 8;
    private static final int Field_defaultCharset = 9;
    private static final int Field_defaultView = 10;
    private static final int Field_dir = 11;
    private static final int Field_doctype = 12;
    private static final int Field_documentElement = 13;
    private static final int Field_domain = 14;
    private static final int Field_errorCode = 15;
    private static final int Field_fgColor = 16;
    private static final int Field_forms = 17;
    private static final int Field_frames = 18;
    private static final int Field_head = 19;
    private static final int Field_height = 20;
    private static final int Field_images = 21;
    private static final int Field_implementation = 22;
    private static final int Field_lastModified = 23;
    private static final int Field_linkColor = 24;
    private static final int Field_links = 25;
    private static final int Field_location = 26;
    private static final int Field_maps = 27;
    private static final int Field_nodeName = 28;
    private static final int Field_nodeType = 29;
    private static final int Field_parseError = 30;
    private static final int Field_reason = 31;
    private static final int Field_referrer = 32;
    private static final int Field_selection = 33;
    private static final int Field_SRC = 34;
    private static final int Field_styleSheets = 35;
    private static final int Field_title = 36;
    private static final int Field_URL = 37;
    private static final int Field_vlinkColor = 38;
    private static final int Field_width = 39;
    private static final int Method_addStyleSheet = -1;
    private static final int Method_clear = -2;
    private static final int Method_close = -3;
    private static final int Method_createAttribute = -4;
    private static final int Method_createAttributeNS = -5;
    private static final int Method_createCDATASection = -6;
    private static final int Method_createComment = -7;
    private static final int Method_createDocumentFragment = -8;
    private static final int Method_createElement = -9;
    private static final int Method_createElementNS = -10;
    private static final int Method_createElementWithNameSpace = -11;
    private static final int Method_createEntityReference = -12;
    private static final int Method_createEvent = -13;
    private static final int Method_createProcessingInstruction = -14;
    private static final int Method_createTextNode = -15;
    private static final int Method_getElementById = -16;
    private static final int Method_getElementsByName = -17;
    private static final int Method_getElementsByTagName = -18;
    private static final int Method_getElementsByTagNameNS = -19;
    private static final int Method_importNode = -20;
    private static final int Method_load = -21;
    private static final int Method_loadXML = -22;
    private static final int Method_open = -23;
    private static final int Method_removeStyleSheet = -24;
    private static final int Method_resolveURL = -25;
    private static final int Method_transformNode = -26;
    private static final int Method_transformNodeToObject = -27;
    private static final int Method_write = -28;
    private static final int Method_writeln = -29;
    private static final int Method_getBGColor = -30;
    private static final int Method_setBGColor = -31;

    public final int getMutation() {
        return this.mutation;
    }

    public final void mutate() {
        ++this.mutation;
    }

    protected DDocument(DOMImplementation impl) {
        super(null, 0);
        this.theDomImplementation = impl;
        this.doc = this;
        this.styleSheetList = new DStyleSheetList();
        this.lang = sysLanguage;
    }

    protected DDocument(ThePilot pilot, DOM implementation) {
        this(implementation);
        this.pilot = pilot;
        this._domImplementation = implementation.createDocumentSlave(this);
        this._parentDocument = implementation.getMasterDocument();
        this.names = this._domImplementation.sdata.names;
    }

    private final void parseSpecialElements() {
        if (this.first != null) {
            this.parseSpecial_r(this.first);
        }
        this.applyXSLT();
    }

    private final void parseSpecial_r(DNode n) {
        DElement e;
        String txt;
        int id = n.getNameId();
        if (id == 70) {
            txt = null;
            if (n.first instanceof DTextNode) {
                txt = ((DTextNode)n.first).getData();
            }
            if (txt != null && this.pilot != null) {
                txt = DOMBuilder.cleanupScript(txt);
                e = (DElement)n;
                String lang = DOMBuilder.extractScriptLanguage(e);
                this.pilot.doScriptEval(lang, txt, this.getBaseUrl(), 0);
            }
        } else if (id == 76) {
            txt = null;
            if (n.first instanceof DTextNode) {
                txt = ((DTextNode)n.first).getData();
            }
            e = (DElement)n;
            try {
                DStyleSheet ss = this.getDom().createDStyleSheet(this.defaultNamespace, e, null, null);
                CSSBuilder b = new CSSBuilder(this);
                b.build(ss, new StringReader(txt), this.getBaseUrl());
                this.addStyleSheet(ss);
            }
            catch (IOException ex) {
                if (Debug.ex) {
                    Debug.ex((Throwable)ex);
                }
            }
        } else if (id == 54) {
            this.handleLinkTag((DElement)n);
        }
        n = n.first;
        while (n != null) {
            this.parseSpecial_r(n);
            n = n.next;
        }
    }

    void applyXSLT() {
        block9: {
            TransformerFactory xsltFactory = this.getDom().getTransformFactory();
            if ((this.styleSheetList.getLength() == 0 && this.xsltSheet == null || xsltFactory == null) && this.defaultNamespace != 3 && this.defaultNamespace != 5 && Defs.sysPropertyBoolean((String)"ice.pilots.html4.viewXmlAsTree")) {
                block8: {
                    String htmlStr = TransformXml.toHtml(this);
                    this.removeChild(this.rootElement);
                    this.defaultNamespace = 3;
                    try {
                        DOMBuilder b = new DOMBuilder(this, this.pilot);
                        b.noJS = false;
                        Lex2 l = new Lex2(b);
                        l.setReader(new StringReader(htmlStr));
                        l.parse(true, false);
                    }
                    catch (Exception ex) {
                        if (!Debug.ex) break block8;
                        Debug.ex((Throwable)ex);
                    }
                }
                return;
            }
            if (this.xsltSheet != null && xsltFactory != null) {
                try {
                    String url = this.resolveUrl(this.xsltSheet);
                    this.xsltSheet = null;
                    if (Debug.trace) {
                        Debug.trace((String)("External XSL: url=" + url));
                    }
                    Reader reader = this.openUrlReader(url);
                    DDocument sheet = this.getDom().createDDocument(this.pilot, false);
                    DOMBuilder builder = new DOMBuilder(sheet, null);
                    Lex2 lexer = new Lex2(builder);
                    lexer.setReader(reader);
                    lexer.parse(true, false);
                    reader.close();
                    Transformer xsltr = xsltFactory.createTransformer();
                    DElement docroot = (DElement)this.getDocumentElement();
                    this.removeChild(docroot);
                    DNode df = (DNode)((Object)this.createDocumentFragment());
                    df.appendChild(docroot);
                    this.defaultNamespace = 3;
                    xsltr.transform((Node)df, (Node)sheet, this);
                    this.parseSpecialElements();
                    if (this.pilot != null) {
                        this.pilot.refresh();
                    }
                }
                catch (Exception ex) {
                    if (!Debug.ex) break block9;
                    Debug.ex((Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void linkStyleSheet(String href, String type, String media, String title, DNode e) {
        StormData st;
        if (type != null) {
            if (type.equalsIgnoreCase("text/xsl")) {
                this.xsltSheet = href;
                return;
            }
            if (!type.equalsIgnoreCase("text/css")) {
                return;
            }
        }
        if (this.pilot != null && (st = StormData.get(this.pilot.getStorm())).getLoadSingleOnly()) {
            return;
        }
        String url = this.resolveUrl(href);
        if (url != null) {
            boolean ok;
            DStyleSheet ss;
            block14: {
                ss = this.getDom().createDStyleSheet(this.defaultNamespace, e, null, null);
                ss.setHref(url);
                if (e != null) {
                    ss.setTitle(title);
                }
                if (media != null) {
                    ss.getMedia().setMediaText(media);
                }
                CSSBuilder b = new CSSBuilder(this);
                ok = false;
                if (Debug.trace) {
                    Debug.trace((String)("External style: url=" + url + " type=" + type));
                }
                try {
                    Reader reader = this.openUrlReader(url);
                    try {
                        b.build(ss, reader, url);
                        ok = true;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException ex) {
                    if (!Debug.ex) break block14;
                    Debug.ex((Throwable)ex);
                }
            }
            if (ok) {
                this.addStyleSheet(ss);
            }
        }
    }

    void handleLinkTag(DElement e) {
        String rel = e.getAttribute(90);
        String href = e.getAttribute(46);
        String type = e.getAttribute(111);
        if (rel != null && href != null && rel.equalsIgnoreCase("stylesheet")) {
            this.linkStyleSheet(href, type, e.getAttribute(60), e.getAttribute(110), e);
        }
    }

    Names getNames() {
        return this.names;
    }

    public boolean isRTL() {
        CSSBox b;
        CSSLayout cssLayout;
        DElement body = this.getDBody();
        return body != null && (cssLayout = this.pilot.getCSSLayout()) != null && (b = cssLayout.findCSSBox(body)) != null && b.css.directionFlag == 1;
    }

    public void setHtmlMode(boolean flag) {
        this.defaultNamespace = flag ? 3 : 0;
    }

    protected void clear() {
        this.unlinkAllSlots();
        this.removeAllDAttrs();
        this._baseUrl = null;
        this.baseTarget = "_self";
        this.httpProperties = null;
        DElement n = this.rootElement;
        if (n != null) {
            this.removeDChild(n);
            n.dispose();
        }
        this.isFrameset = false;
        this.styleSheetList.clear();
        if (this.selection != null) {
            this.selection.empty();
        }
        this.linkColor = null;
        this.mutation = 0;
        this.all = null;
        this.images = null;
        this.forms = null;
        this.iframes = null;
        this.links = null;
        this.maps = null;
    }

    public final ThePilot getPilot() {
        return this.pilot;
    }

    public final Viewport getDocumentVieport() {
        return this.getDocumentViewport();
    }

    public final Viewport getDocumentViewport() {
        ThePilot pilot = this.getPilot();
        if (pilot != null) {
            return pilot.getPilotViewport();
        }
        return null;
    }

    DRange createRange() {
        return new DRange();
    }

    public Event createEvent(String eventType) {
        int id = DOMEvent.mapEventTypeToId(eventType);
        if (id <= 0) {
            throw new DOMException(9, eventType);
        }
        return this.createDOMEvent(id);
    }

    public DOMEvent createDOMEvent(int id) {
        switch (id) {
            case 29: {
                return new DMutationEvent(this, id);
            }
            case 28: {
                this.aMutationEvent.typeId = 28;
                return this.aMutationEvent;
            }
            case 26: {
                this.aMutationEvent.typeId = 26;
                return this.aMutationEvent;
            }
            case 27: {
                this.aMutationEvent.typeId = 27;
                return this.aMutationEvent;
            }
            case 25: {
                this.aMutationEvent.typeId = 25;
                return this.aMutationEvent;
            }
        }
        return new DOMUIEvent(this, id);
    }

    public final DOMEvent createDOMEvent(int id, DNode target) {
        DOMEvent de = this.createDOMEvent(id);
        de.setTarget(target);
        return de;
    }

    public void processEvent(int id, DNode target) {
        DOMEvent de = this.createDOMEvent(id, target);
        this.processEvent(de);
    }

    void processEventLater(DOMEvent de, long delay) {
        new DomEventItem(this.doc, de).postToEventThread(delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void processEvent(DOMEvent de) {
        DOMEvent old = this.currentEvent;
        this.currentEvent = de;
        try {
            this.processEventImpl(de);
        }
        finally {
            this.currentEvent = old;
        }
    }

    private void processEventImpl(DOMEvent de) {
        DefaultEventHandler deafultAction;
        ThePilot pilot = this.getPilot();
        Object[] persistentDomListeners = null;
        if (pilot != null) {
            persistentDomListeners = pilot.persistentDomListeners;
        }
        de.setEventPhase((short)1);
        DNodeListeners.handleEvent(persistentDomListeners, de, true);
        DNode n = de.target;
        if (n != null && n.getNameId() == 43) {
            DNode child = n.first;
            while (child != null) {
                if (child.getNameId() == 13) {
                    de.target = n = child;
                    break;
                }
                child = child.next;
            }
        }
        if (n != null) {
            this.do_event_capture_r(n.parent, de);
        }
        de.setEventPhase((short)3);
        boolean shouldBubble = de.getBubbles();
        int eventAttrId = DDocument.getEventHandlerAttr(de);
        while (n != null && !de.cancel) {
            Object handler;
            DAttr eventAttr;
            de.currentNode = n;
            Object[] listeners = n.eventListeners;
            if (listeners != null) {
                DNodeListeners.handleEvent(listeners, de, false);
            }
            if (eventAttrId > 0 && (eventAttr = n.getDAttr(eventAttrId)) != null && pilot != null && (handler = eventAttr.getObjectValue()) != null) {
                this.evalScriptHandlerListeners(n, de, handler);
            }
            if (!shouldBubble) break;
            n = DDocument.getEventChainParent(n, de);
        }
        if (!de.getCancelable() || !de.cancel) {
            DNodeListeners.handleEvent(persistentDomListeners, de, false);
        }
        if (!de.isDefaultCancelled() && pilot != null && (deafultAction = pilot.getDefaultEventHandler()) != null) {
            deafultAction.handleEvent(de);
        }
    }

    protected void evalScriptHandlerListeners(DNode n, DOMEvent de, Object handler) {
        this.pilot.evalScriptHandlerListeners(n, de, handler);
    }

    private void do_event_capture_r(DNode n, DOMEvent de) {
        if (n != null) {
            Object[] listeners = n.eventListeners;
            while (listeners == null) {
                if ((n = DDocument.getEventChainParent(n, de)) == null) {
                    return;
                }
                listeners = n.eventListeners;
            }
            this.do_event_capture_r(DDocument.getEventChainParent(n, de), de);
            if (!de.getCancelable() || !de.cancel) {
                de.currentNode = n;
                DNodeListeners.handleEvent(listeners, de, true);
            }
        }
    }

    static DNode getEventChainParent(DNode n, DOMEvent de) {
        if (n.tagId == 55 && de.nodeAfterMap != null) {
            return de.nodeAfterMap;
        }
        return n.parent;
    }

    /*
     * WARNING - void declaration
     */
    private static int getEventHandlerAttr(DOMEvent de) {
        void var1_1;
        switch (de.getTypeId()) {
            case 22: {
                int attrId = 69;
                break;
            }
            case 18: {
                int attrId = 70;
                break;
            }
            case 1: {
                int attrId = 71;
                break;
            }
            case 2: {
                int attrId = 72;
                break;
            }
            case 21: {
                int attrId = 73;
                break;
            }
            case 9: {
                int attrId = 74;
                break;
            }
            case 8: {
                int attrId = 75;
                break;
            }
            case 10: {
                int attrId = 76;
                break;
            }
            case 13: {
                int attrId = 77;
                break;
            }
            case 3: {
                int attrId = 78;
                break;
            }
            case 6: {
                int attrId = 79;
                break;
            }
            case 7: {
                int attrId = 80;
                break;
            }
            case 5: {
                int attrId = 81;
                break;
            }
            case 4: {
                int attrId = 82;
                break;
            }
            case 20: {
                int attrId = 83;
                break;
            }
            case 17: {
                int attrId = 84;
                break;
            }
            case 19: {
                int attrId = 85;
                break;
            }
            case 14: {
                int attrId = 86;
                break;
            }
            case 23: {
                int attrId = 121;
                break;
            }
            case 24: {
                int attrId = 122;
                break;
            }
            case 11: {
                int attrId = 123;
                break;
            }
            default: {
                return -1;
            }
        }
        if (!DDocument.isEventHandlerAttr((int)var1_1)) {
            Debug.bug();
        }
        return (int)var1_1;
    }

    static boolean isEventHandlerAttr(int attrId) {
        switch (attrId) {
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 121: 
            case 122: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    protected DElement createElement(int tagId) {
        switch (tagId) {
            case 94: {
                return new DXmlElement(this, tagId);
            }
            case 49: {
                return new DIsIndexElement(this, tagId);
            }
            case 46: {
                return new DImageElement(this, tagId);
            }
            case 45: {
                return new DIFrameElement(this, tagId);
            }
            case 1: {
                return new DAnchorElement(this, tagId);
            }
            case 32: {
                return new DFormElement(this, tagId);
            }
            case 15: 
            case 47: {
                return new DInputElement(this, tagId);
            }
            case 82: {
                return new DTextAreaElement(this, tagId);
            }
            case 71: {
                return new DSelectElement(this, tagId);
            }
            case 63: {
                return new DOptionElement(this, tagId);
            }
            case 55: {
                return new DMapElement(this, tagId);
            }
            case 6: {
                return new DAreaElement(this, tagId);
            }
            case 5: {
                return new DAppletElement(this, tagId);
            }
        }
        return new DElement(this, tagId);
    }

    protected DTextNode createDTextNode(char[] buf, int offset, int length, boolean isPre) {
        return new DTextNode(this, buf, offset, length, isPre);
    }

    protected DTextNode createDTextNode(String data, boolean isPre) {
        return new DTextNode(this, data, isPre);
    }

    protected final DTextNode createDTextNode(String data) {
        return this.createDTextNode(data, false);
    }

    protected DAttr createAttribute(int attrNameId) {
        return new DAttr(attrNameId);
    }

    protected DNode appendDChild(DNode node) {
        if (this.rootElement != null) {
            if (Debug.trace) {
                Debug.trace((String)("WARNING: Document already has root element " + this.rootElement));
            }
            return null;
        }
        if (!(node instanceof DElement)) {
            if (Debug.trace) {
                Debug.trace((String)"WARNING: Document cannot have root that is not an Element");
            }
            return null;
        }
        this.rootElement = (DElement)node;
        this.first = this.last = node;
        node.setParent(this);
        this.mutate();
        DMutationEvent evt = (DMutationEvent)this.createDOMEvent(26);
        evt.target = node;
        evt.relatedNode = this;
        this.processEvent(evt);
        return node;
    }

    protected DNode removeDChild(DNode node) {
        if (node != null && this.rootElement == node) {
            DMutationEvent evt = (DMutationEvent)this.createDOMEvent(27);
            evt.target = node;
            evt.relatedNode = this;
            this.processEvent(evt);
            this.rootElement.setParent(null);
            this.rootElement = null;
            this.last = null;
            this.first = null;
            this.mutate();
            return node;
        }
        return null;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public DocumentType getDoctype() {
        return null;
    }

    public final DOMImplementation getImplementation() {
        return this.theDomImplementation;
    }

    public DOM getDom() {
        if (this._domImplementation != null) {
            return this._domImplementation;
        }
        return (DOM)this.theDomImplementation;
    }

    public final Element getDocumentElement() {
        return this.getDocumentDElement();
    }

    public DElement getDocumentDElement() {
        return this.rootElement;
    }

    public Element createElement(String tagName) {
        int id = this.names.getTagId(this.defaultNamespace, tagName);
        if (id < 0) {
            return null;
        }
        return this.createElement(id);
    }

    public DocumentFragment createDocumentFragment() {
        return new DFragment(this);
    }

    public final Text createTextNode(String data) {
        return this.createDTextNode(data);
    }

    public Comment createComment(String data) {
        return null;
    }

    public CDATASection createCDATASection(String data) {
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return null;
    }

    public Attr createAttribute(String name) {
        int id = this.names.getAttrId(this.defaultNamespace, name);
        if (id < 0) {
            return null;
        }
        return this.createAttribute(id);
    }

    public EntityReference createEntityReference(String name) {
        return null;
    }

    public NodeList getElementsByTagName(String tagName) {
        return new DNodeList(this, tagName);
    }

    private DNode getTitleNode() {
        DNode n = this.getHead();
        if (n == null) {
            return null;
        }
        n = n.getFirstDChild();
        while (n != null) {
            if (n.getNameId() == 86) {
                return n;
            }
            n = n.next;
        }
        return null;
    }

    public String getTitle() {
        String s = "";
        DNode titleNode = this.getTitleNode();
        if (titleNode != null) {
            DNode n = titleNode.getFirstDChild();
            while (n != null) {
                s = s.length() == 0 ? n.getNodeValue() : s + n.getNodeValue();
                n = n.next;
            }
        }
        return s;
    }

    public void setTitle(String text) {
        DNode node = this.getTitleNode();
        ((DElement)node).setInnerHTML(text);
        this.pilot.firePropertyChange("title", null, this.getTitle());
    }

    public String getReferrer() {
        String s = this.getHttpProperty("_http_referer");
        if (s == null) {
            s = "";
        }
        return s;
    }

    public URL getBaseURL() {
        String base = this.pilot.getPilotViewport().getBaseUrl();
        if (base != null) {
            try {
                return new URL(base);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getDomain() {
        String base = this.getBaseUrl();
        if (base != null) {
            return URLResolver.getHost((String)base);
        }
        return null;
    }

    public final String getURL() {
        ThePilot p = this.getPilot();
        if (p != null) {
            return p.getPilotViewport().getLocation();
        }
        return null;
    }

    public final HTMLElement getBody() {
        return this.getDBody();
    }

    public DElement getDBody() {
        DNode n = this.rootElement;
        if (n != null) {
            n = n.getFirstDChild();
            while (n != null && n.getNameId() != 13 && n.getNameId() != 34) {
                n = n.next;
            }
        }
        return n;
    }

    public void setBody(HTMLElement e) {
    }

    public HTMLCollection getImages() {
        if (this.images == null) {
            this.images = new DNodeList(this, "img");
        }
        return this.images;
    }

    public HTMLCollection getApplets() {
        return new DNodeList(this, "applet");
    }

    public HTMLCollection getLinks() {
        if (this.links == null) {
            this.links = new DNodeList(this, "_links_", "href");
        }
        return this.links;
    }

    public HTMLCollection getForms() {
        if (this.forms == null) {
            this.forms = new DNodeList(this, "form");
        }
        return this.forms;
    }

    HTMLCollection getIFrames() {
        if (this.iframes == null) {
            this.iframes = new DNodeList(this, "iframe");
        }
        return this.iframes;
    }

    public HTMLCollection getAnchors() {
        return new DNodeList(this, "a", "name");
    }

    public HTMLCollection getMaps() {
        if (this.maps == null) {
            this.maps = new DNodeList(this, "map");
        }
        return this.maps;
    }

    public String getCookie() {
        String str = "";
        if (this.cookieSet != null && (str = this.cookieSet.getCookieStr(this.getBaseUrl())) == null) {
            str = "";
        }
        return str;
    }

    public void setCookie(String text) {
        if (this.cookieSet != null) {
            this.cookieSet.addCookie(this.getBaseUrl(), text);
        }
    }

    public String getLastModified() {
        String c = this.getHttpProperty("_http_last-modified");
        if (c == null) {
            return "0";
        }
        return c;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    void setUnresolvedCharset(String s) {
        if (s != null) {
            this.charsetId = CharIO.getCharsetId((String)s);
        }
    }

    void setDefaultCharset(String s) {
        this.defaultCharset = s;
        Locale locale = null;
        if (this.defaultCharset != null) {
            locale = CharIO.getEncodingLocale((String)this.defaultCharset);
        }
        if (locale == null && this.lang != null) {
            locale = new Locale(this.lang.toLowerCase(), this.lang.toUpperCase());
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.wordIterator = CharIO.getBreakIterator((Locale)locale);
    }

    BreakIterator getWordIterator() {
        return this.wordIterator;
    }

    public BreakIterator getWordIteratorForLanguage(char[] text) {
        Locale locale = CharIO.getLocaleFromTextSample((char[])text);
        if (locale != null) {
            return CharIO.getBreakIterator((Locale)locale);
        }
        return this.wordIterator;
    }

    public void open() {
    }

    public void close() {
        this.pilot.do_document_close();
    }

    public void write(final String str) {
        SecurityKit.doPrivileged((BoxedCode)new BoxedCode(){

            public Object run() {
                DDocument.this.pilot.do_document_write(str);
                return null;
            }
        });
    }

    public void writeln(String str) {
        this.write(str + '\n');
    }

    public Element getElementById(String elementId) {
        if (elementId == null || this.rootElement == null) {
            return null;
        }
        return this.getAll().getElementById(elementId);
    }

    public NodeList getElementsByName(String elementName) {
        return this.getAll().getElementsByName(elementName);
    }

    public StyleSheetList getStyleSheets() {
        return this.styleSheetList;
    }

    public final AbstractView getDefaultView() {
        return this.getDomView();
    }

    public TheView getDomView() {
        return this.pilot.getView();
    }

    public Element createElementWithNameSpace(String localName, String namespace) {
        int nsId = this.names.getNamespace(namespace);
        int id = this.names.getTagId(nsId, localName);
        if (id < 0) {
            return null;
        }
        return this.createElement(id);
    }

    public int getWidth() {
        int vw;
        TheView v = this.getDomView();
        if (v == null) {
            return 0;
        }
        int dw = v.getWidth();
        if (dw < (vw = v.getDocPane().getPaneWidth())) {
            dw = vw;
        }
        return dw;
    }

    public int getHeight() {
        int vh;
        TheView v = this.getDomView();
        if (v == null) {
            return 0;
        }
        int dh = v.getHeight();
        if (dh < (vh = v.getDocPane().getPaneHeight())) {
            dh = vh;
        }
        return dh;
    }

    public DAllList getAll() {
        if (this.all == null) {
            this.all = new DAllList(this, true);
        }
        return this.all;
    }

    public DRange getSelection() {
        if (this.selection == null) {
            this.selection = this.createRange();
        }
        return this.selection;
    }

    public boolean getAsync() {
        return this.async;
    }

    public void setAsync(boolean asyncstat) {
        this.async = asyncstat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void script_load(DynEnv env, String urlFragment) throws IOException {
        if (urlFragment != null) {
            final String url = this.resolveUrl(urlFragment);
            Reader reader = (Reader)SecurityKit.doPrivileged((BoxedCode)new BoxedCode(){

                public Object run() {
                    try {
                        return DDocument.this.openUrlReader(url);
                    }
                    catch (IOException ex) {
                        throw new ProxyException((Exception)ex);
                    }
                }
            });
            try {
                DElement docroot = (DElement)this.doc.getDocumentElement();
                this.removeChild(docroot);
                DOMBuilder builder = new DOMBuilder(this, null);
                Lex2 lexer = new Lex2(builder);
                lexer.setReader(reader);
                lexer.parse();
            }
            finally {
                reader.close();
            }
        }
    }

    protected void script_loadXML(String xmltext) throws IOException {
        StringReader reader = new StringReader(xmltext);
        DElement docroot = (DElement)this.doc.getDocumentElement();
        this.removeChild(docroot);
        DOMBuilder builder = new DOMBuilder(this, null);
        Lex2 lexer = new Lex2(builder);
        lexer.setReader(reader);
        lexer.parse();
    }

    protected String transformNode(Document stylesheet) throws IOException {
        TransformerFactory xsltFactory = this.getDom().getTransformFactory();
        StringBuffer buff = null;
        if (xsltFactory != null) {
            Transformer xsltr = xsltFactory.createTransformer();
            DElement docroot = (DElement)this.doc.getDocumentElement();
            DNode df = (DNode)((Object)this.doc.createDocumentFragment());
            df.appendChild(docroot);
            StringWriter writer = new StringWriter();
            xsltr.transform((Node)df, (Node)stylesheet, writer);
            buff = writer.getBuffer();
            return buff.toString();
        }
        return null;
    }

    protected void transformNodeToObject(Document stylesheet, Document result) throws IOException {
        TransformerFactory xsltFactory = this.getDom().getTransformFactory();
        if (xsltFactory != null) {
            Transformer xsltr = xsltFactory.createTransformer();
            result.removeChild(result.getDocumentElement());
            DElement docroot = (DElement)this.doc.getDocumentElement();
            DNode df = (DNode)((Object)this.doc.createDocumentFragment());
            df.appendChild(docroot);
            DDocument d = (DDocument)result;
            d.defaultNamespace = 3;
            xsltr.transform((Node)df, (Node)stylesheet, result);
            d.parseSpecialElements();
            if (d.pilot != null) {
                d.pilot.refresh();
            }
        }
    }

    String getCurrentLocation() {
        if (this.pilot != null) {
            return this.pilot.getPilotViewport().getLocation();
        }
        return null;
    }

    void setHttpProperty(String name, String value) {
        if (this.httpProperties == null) {
            this.httpProperties = new HashArray();
        }
        this.httpProperties.put((Object)name, (Object)value);
    }

    String getHttpProperty(String name) {
        HashArray hash = this.httpProperties;
        if (hash != null) {
            return (String)hash.get((Object)name);
        }
        return null;
    }

    public Object getSlot(String name, DynEnv env) {
        Object result = super.getSlot(name, env);
        if (result == NOT_FOUND && this.rootElement != null) {
            result = this.getAll().getSlot(name, env);
        }
        return result;
    }

    public void addStyleSheet(DStyleSheet s) {
        this.styleSheetList.addStyleSheet(s);
        this.mutate();
        this.processEvent(25, this);
    }

    public void removeStyleSheet(DStyleSheet s) {
        this.styleSheetList.removeStyleSheet(s);
        this.mutate();
        this.processEvent(25, this);
    }

    public URL resolveURL(String loc) {
        loc = this.resolveUrl(loc);
        try {
            return new URL(loc);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    Reader openUrlReader(String url) throws IOException {
        InputStream is;
        ContentLoader loader = null;
        if (this.pilot != null) {
            loader = this.pilot.getStorm().getContentLoaderFactory().createContentLoader(url, null);
        } else {
            URL javaUrl;
            if (Debug.trace) {
                Debug.trace((String)"Does not have pilot associated with it, default ContentLoader is used");
            }
            loader = (javaUrl = URLResolver.newURL((String)url)) != null ? new ContentLoader(javaUrl, null) : new ContentLoader(url, null);
        }
        Viewport viewport = null;
        if (this.pilot != null) {
            viewport = this.pilot.getPilotViewport();
            while (viewport.getParent() != null) {
                viewport = viewport.getParent();
            }
        }
        loader.setReferer(this.getBaseUrl());
        String charset = loader.getContentCharset();
        if (charset == null) {
            charset = this.getDefaultCharset();
        }
        if ((is = loader.getInputStream()) == null) {
            IOException ex = loader.getException();
            throw ex != null ? ex : new IOException();
        }
        return CharIO.createInputStreamReader((InputStream)is, (String)charset, (boolean)true);
    }

    public String resolveUrl(String urlFragment) {
        return this.resolveUrl(this.getBaseUrl(), urlFragment);
    }

    String resolveUrl(String base, String urlFragment) {
        return URLResolver.resolve((String)base, (String)urlFragment);
    }

    String getBaseUrl() {
        DDocument doc = this;
        do {
            if (doc._baseUrl == null) continue;
            return doc._baseUrl;
        } while ((doc = doc._parentDocument) != null);
        ThePilot p = this.getPilot();
        if (this.pilot != null) {
            return p.getPilotViewport().getBaseUrl();
        }
        return this._baseUrl;
    }

    public void setBaseUrl(String url) {
        if (url == null) {
            Debug.bug();
        }
        this._baseUrl = url;
        if (this.pilot != null) {
            this.pilot.putBaseUrl(url);
        }
    }

    void setBaseTarget(String t) {
        this.baseTarget = t;
    }

    public String getBaseTarget() {
        return this.baseTarget;
    }

    public DElement getHead() {
        if (this.rootElement == null) {
            return null;
        }
        DNode n = this.rootElement;
        n = n.getFirstDChild();
        while (n != null && n.getNameId() != 41) {
            n = n.next;
        }
        return (DElement)n;
    }

    void validateBodyAttrs() {
        DElement e = this.getDBody();
        if (e == null) {
            return;
        }
        this.setLinkColor(e.getAttribute(55));
        this.setVlinkColor(e.getAttribute(117));
        this.setAlinkColor(e.getAttribute(7));
        String attribute = e.getAttribute(12);
        if (attribute != null) {
            this.setBgColor(attribute);
        }
        if ((attribute = e.getAttribute(109)) != null) {
            this.setFgColor(attribute);
        }
    }

    void notifyLayoutBegin() {
        if (this.pilot != null) {
            this.pilot.firePropertyChange("contentRendering", null, "begin");
        }
    }

    void notifyLayoutBuilt() {
    }

    void notifyLayoutEnd() {
        if (this.pilot != null) {
            this.pilot.onLayoutEnd();
        }
    }

    void parseHtmlSubtree(DNode startNode, String htmlText) {
        block2: {
            try {
                DOMBuilder b = new DOMBuilder(this, startNode, this.pilot);
                b.noJS = false;
                Lex2 l = new Lex2(b);
                l.setReader(new StringReader(htmlText));
                l.parse();
            }
            catch (Exception ex) {
                if (!Debug.ex) break block2;
                Debug.ex((Throwable)ex);
            }
        }
    }

    public String getFgColor() {
        DElement e = (DElement)this.getBody();
        if (e != null) {
            return e.getAttribute(109);
        }
        return null;
    }

    public void setFgColor(String v) {
        DElement e;
        if (v != null) {
            v = CSSUtil.convertColorNameToRGB(v);
        }
        if ((e = (DElement)this.getBody()) != null) {
            e.setAttribute(109, v);
        }
        this.mutate();
    }

    public String getBgColor() {
        DElement e = (DElement)this.getBody();
        if (e != null) {
            return e.getAttribute(12);
        }
        return null;
    }

    public void setBgColor(String v) {
        DElement e;
        if (v != null) {
            v = CSSUtil.convertColorNameToRGB(v);
        }
        if ((e = (DElement)this.getBody()) != null) {
            e.setAttribute(12, v);
        }
        this.mutate();
    }

    public String getLinkColor() {
        return this.linkColor;
    }

    public void setLinkColor(String v) {
        if (v != null) {
            v = CSSUtil.convertColorNameToRGB(v);
        }
        this.linkColor = v;
        this.mutate();
    }

    public String getAlinkColor() {
        return this.alinkColor;
    }

    public void setAlinkColor(String v) {
        if (v != null) {
            v = CSSUtil.convertColorNameToRGB(v);
        }
        this.alinkColor = v;
        this.mutate();
    }

    public String getVlinkColor() {
        return this.vlinkColor;
    }

    public void setVlinkColor(String v) {
        if (v != null) {
            v = CSSUtil.convertColorNameToRGB(v);
        }
        this.vlinkColor = v;
        this.mutate();
    }

    public Node importNode(Node importedNode, boolean deep) {
        return null;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) {
        Element retval;
        if (namespaceURI == null) {
            namespaceURI = this.names.getNamespace(this.defaultNamespace);
        }
        if ((retval = this.createElementWithNameSpace(qualifiedName, namespaceURI)) != null && qualifiedName.indexOf(":") >= 0) {
            ((DElement)retval).qname = qualifiedName;
        }
        return retval;
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        if (!DDocument.isNullOrEmpty(namespaceURI)) {
            if (Debug.trace) {
                Debug.trace((String)("namespaces are not supported: " + namespaceURI));
            }
            return null;
        }
        if (Debug.trace) {
            Debug.trace((String)"namespaces are not supported but namespace is null");
        }
        return this.createAttribute(qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (!DDocument.isNullOrEmpty(namespaceURI)) {
            if (Debug.trace) {
                Debug.trace((String)("namespaces are not supported: " + namespaceURI));
            }
            return null;
        }
        if (Debug.trace) {
            Debug.trace((String)"namespaces are not supported but namespace is null");
        }
        return this.getElementsByTagName(localName);
    }

    private DynamicObject script_getWindow() {
        Viewport v = this.pilot.getPilotViewport();
        return v != null ? v.getWindowObj() : null;
    }

    private Object script_open(Object[] args, DynEnv env) {
        if (args.length == 0) {
            this.open();
        } else {
            DynamicObject window = this.script_getWindow();
            if (window != null) {
                return window.execDynamicMethod("openDocument", args, env);
            }
        }
        return env.wrapVoid();
    }

    public Object getDynamicScopeParent() {
        return this.getDocumentViewport();
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DDocument.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(name, id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DDocument.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(name, id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DDocument.toDynamicId(name);
        if (id < 0) {
            try {
                return this.execDynamicMethod(id, args, env);
            }
            catch (ProxyException ex) {
                throw env.wrapException(ex.getTarget());
            }
            catch (IOException ex) {
                throw env.wrapException(ex);
            }
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(String name, int key_id, DynEnv env) {
        DynamicObject window;
        boolean passToWindow = false;
        switch (key_id) {
            case 1: {
                return env.wrapBoolean(this.getAsync());
            }
            case 2: {
                return this.getAlinkColor();
            }
            case 3: {
                return this.getAll();
            }
            case 4: {
                return this.getAnchors();
            }
            case 5: {
                return this.getApplets();
            }
            case 6: {
                return this.getBgColor();
            }
            case 7: {
                return this.getBody();
            }
            case 8: {
                return this.getCookie();
            }
            case 9: {
                return this.getDefaultCharset();
            }
            case 10: {
                return this.getDefaultView();
            }
            case 11: {
                return "ltr";
            }
            case 12: {
                return this.getDoctype();
            }
            case 13: {
                return this.getDocumentElement();
            }
            case 14: {
                return this.getDomain();
            }
            case 15: {
                return env.wrapInt(0);
            }
            case 16: {
                return this.getFgColor();
            }
            case 17: {
                return this.getForms();
            }
            case 18: {
                passToWindow = true;
                break;
            }
            case 19: {
                return this.getHead();
            }
            case 20: {
                return env.wrapInt(this.getHeight());
            }
            case 21: {
                return this.getImages();
            }
            case 22: {
                return this.getImplementation();
            }
            case 23: {
                return this.getLastModified();
            }
            case 24: {
                return this.getLinkColor();
            }
            case 25: {
                return this.getLinks();
            }
            case 26: {
                passToWindow = true;
                break;
            }
            case 27: {
                return this.getMaps();
            }
            case 28: {
                return this.getNodeName();
            }
            case 29: {
                return env.wrapInt(this.getNodeType());
            }
            case 30: {
                return this;
            }
            case 31: {
                return "Parseerror reason not supported";
            }
            case 32: {
                return this.getReferrer();
            }
            case 33: {
                return this.getSelection();
            }
            case 34: {
                return "Document src listing not implemented";
            }
            case 35: {
                return this.getStyleSheets();
            }
            case 36: {
                return this.getTitle();
            }
            case 37: {
                return this.getURL();
            }
            case 38: {
                return this.getVlinkColor();
            }
            case 39: {
                return env.wrapInt(this.getWidth());
            }
        }
        if (passToWindow && (window = this.script_getWindow()) != null) {
            return window.getDynamicValue(name, env);
        }
        return null;
    }

    private int setDynamicValue(String name, int key_id, Object value, DynEnv env) {
        DynamicObject window;
        boolean passToWindow = false;
        switch (key_id) {
            case 1: {
                this.setAsync(env.toBoolean(value));
                return 1;
            }
            case 2: {
                this.setAlinkColor(env.toStr(value));
                return 1;
            }
            case 6: {
                this.setBgColor(env.toStr(value));
                return 1;
            }
            case 7: {
                this.setBody((HTMLElement)env.toNative(value));
                return 1;
            }
            case 8: {
                this.setCookie(env.toStr(value));
                return 1;
            }
            case 15: {
                return 1;
            }
            case 16: {
                this.setFgColor(env.toStr(value));
                return 1;
            }
            case 18: {
                passToWindow = true;
                break;
            }
            case 24: {
                this.setLinkColor(env.toStr(value));
                return 1;
            }
            case 26: {
                passToWindow = true;
                break;
            }
            case 36: {
                this.setTitle(env.toStr(value));
                return 1;
            }
            case 38: {
                this.setVlinkColor(env.toStr(value));
                return 1;
            }
        }
        if (passToWindow && (window = this.script_getWindow()) != null) {
            return window.setDynamicValue(name, value, env);
        }
        return 2;
    }

    protected void clearRootElement() {
        this.rootElement = null;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) throws IOException {
        switch (key_id) {
            case -1: {
                this.addStyleSheet((DStyleSheet)env.toNative(args, 0));
                break;
            }
            case -2: {
                this.open();
                break;
            }
            case -3: {
                this.close();
                break;
            }
            case -4: {
                return this.createAttribute(env.toStr(args, 0));
            }
            case -5: {
                return this.createAttributeNS(env.toStr(args, 0), env.toStr(args, 1));
            }
            case -6: {
                return this.createCDATASection(env.toStr(args, 0));
            }
            case -7: {
                return this.createComment(env.toStr(args, 0));
            }
            case -8: {
                return this.createDocumentFragment();
            }
            case -9: {
                return this.createElement(env.toStr(args, 0));
            }
            case -10: {
                return this.createElementNS(env.toStr(args, 0), env.toStr(args, 1));
            }
            case -11: {
                return this.createElementWithNameSpace(env.toStr(args, 0), env.toStr(args, 1));
            }
            case -12: {
                return this.createEntityReference(env.toStr(args, 0));
            }
            case -13: {
                return this.createEvent(env.toStr(args, 0));
            }
            case -14: {
                return this.createProcessingInstruction(env.toStr(args, 0), env.toStr(args, 1));
            }
            case -15: {
                return this.createTextNode(env.toStr(args, 0));
            }
            case -16: {
                return this.getElementById(env.toStr(args, 0));
            }
            case -17: {
                return this.getElementsByName(env.toStr(args, 0));
            }
            case -18: {
                return this.getElementsByTagName(env.toStr(args, 0));
            }
            case -19: {
                return this.getElementsByTagNameNS(env.toStr(args, 0), env.toStr(args, 1));
            }
            case -20: {
                boolean deep = env.toBoolean(args, 1);
                return this.importNode((Node)env.toNative(args, 0), deep);
            }
            case -21: {
                this.script_load(env, env.toStr(args, 0));
                break;
            }
            case -22: {
                this.script_loadXML(env.toStr(args, 0));
                break;
            }
            case -23: {
                return this.script_open(args, env);
            }
            case -24: {
                this.removeStyleSheet((DStyleSheet)env.toNative(args, 0));
                break;
            }
            case -25: {
                return this.resolveUrl(env.toStr(args, 0));
            }
            case -26: {
                return this.transformNode((Document)env.toNative(args, 0));
            }
            case -27: {
                this.transformNodeToObject((Document)env.toNative(args, 0), (Document)env.toNative(args, 0));
                break;
            }
            case -28: {
                this.write(env.fuseArgsToString(args));
                break;
            }
            case -29: {
                this.writeln(env.fuseArgsToString(args));
                break;
            }
            case -30: {
                return this.getBgColor();
            }
            case -31: {
                this.setBgColor(env.toStr(args, 0));
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 3: {
                switch (s.charAt(0)) {
                    case 'S': {
                        X = "SRC";
                        id = 34;
                        break block0;
                    }
                    case 'U': {
                        X = "URL";
                        id = 37;
                        break block0;
                    }
                    case 'a': {
                        X = "all";
                        id = 3;
                        break block0;
                    }
                    case 'd': {
                        X = "dir";
                        id = 11;
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                switch (s.charAt(0)) {
                    case 'b': {
                        X = "body";
                        id = 7;
                        break block0;
                    }
                    case 'h': {
                        X = "head";
                        id = 19;
                        break block0;
                    }
                    case 'l': {
                        X = "load";
                        id = -21;
                        break block0;
                    }
                    case 'm': {
                        X = "maps";
                        id = 27;
                        break block0;
                    }
                    case 'o': {
                        X = "open";
                        id = -23;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (s.charAt(2)) {
                    case 'd': {
                        X = "width";
                        id = 39;
                        break block0;
                    }
                    case 'e': {
                        X = "clear";
                        id = -2;
                        break block0;
                    }
                    case 'i': {
                        X = "write";
                        id = -28;
                        break block0;
                    }
                    case 'n': {
                        X = "links";
                        id = 25;
                        break block0;
                    }
                    case 'o': {
                        X = "close";
                        id = -3;
                        break block0;
                    }
                    case 'r': {
                        X = "forms";
                        id = 17;
                        break block0;
                    }
                    case 't': {
                        X = "title";
                        id = 36;
                        break block0;
                    }
                    case 'y': {
                        X = "async";
                        id = 1;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(0)) {
                    case 'c': {
                        X = "cookie";
                        id = 8;
                        break block0;
                    }
                    case 'd': {
                        X = "domain";
                        id = 14;
                        break block0;
                    }
                    case 'f': {
                        X = "frames";
                        id = 18;
                        break block0;
                    }
                    case 'h': {
                        X = "height";
                        id = 20;
                        break block0;
                    }
                    case 'i': {
                        X = "images";
                        id = 21;
                        break block0;
                    }
                    case 'r': {
                        X = "reason";
                        id = 31;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                switch (s.charAt(0)) {
                    case 'a': {
                        char c = s.charAt(1);
                        if (c == 'n') {
                            X = "anchors";
                            id = 4;
                            break block0;
                        }
                        if (c != 'p') break block0;
                        X = "applets";
                        id = 5;
                        break block0;
                    }
                    case 'b': {
                        X = "bgColor";
                        id = 6;
                        break block0;
                    }
                    case 'd': {
                        X = "doctype";
                        id = 12;
                        break block0;
                    }
                    case 'f': {
                        X = "fgColor";
                        id = 16;
                        break block0;
                    }
                    case 'l': {
                        X = "loadXML";
                        id = -22;
                        break block0;
                    }
                    case 'w': {
                        X = "writeln";
                        id = -29;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (s.charAt(4)) {
                    case 'N': {
                        X = "nodeName";
                        id = 28;
                        break block0;
                    }
                    case 'T': {
                        X = "nodeType";
                        id = 29;
                        break block0;
                    }
                    case 'r': {
                        X = "referrer";
                        id = 32;
                        break block0;
                    }
                    case 't': {
                        X = "location";
                        id = 26;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                char c = s.charAt(0);
                if (c == 'e') {
                    X = "errorCode";
                    id = 15;
                    break;
                }
                if (c == 'l') {
                    X = "linkColor";
                    id = 24;
                    break;
                }
                if (c != 's') break;
                X = "selection";
                id = 33;
                break;
            }
            case 10: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "alinkColor";
                        id = 2;
                        break block0;
                    }
                    case 'g': {
                        X = "getBGColor";
                        id = -30;
                        break block0;
                    }
                    case 'i': {
                        X = "importNode";
                        id = -20;
                        break block0;
                    }
                    case 'p': {
                        X = "parseError";
                        id = 30;
                        break block0;
                    }
                    case 'r': {
                        X = "resolveURL";
                        id = -25;
                        break block0;
                    }
                    case 's': {
                        X = "setBGColor";
                        id = -31;
                        break block0;
                    }
                    case 'v': {
                        X = "vlinkColor";
                        id = 38;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "createEvent";
                    id = -13;
                    break;
                }
                if (c == 'd') {
                    X = "defaultView";
                    id = 10;
                    break;
                }
                if (c != 's') break;
                X = "styleSheets";
                id = 35;
                break;
            }
            case 12: {
                X = "lastModified";
                id = 23;
                break;
            }
            case 13: {
                switch (s.charAt(6)) {
                    case 'C': {
                        X = "createComment";
                        id = -7;
                        break block0;
                    }
                    case 'E': {
                        X = "createElement";
                        id = -9;
                        break block0;
                    }
                    case 'l': {
                        X = "addStyleSheet";
                        id = -1;
                        break block0;
                    }
                    case 'o': {
                        X = "transformNode";
                        id = -26;
                        break block0;
                    }
                }
                break;
            }
            case 14: {
                switch (s.charAt(0)) {
                    case 'c': {
                        X = "createTextNode";
                        id = -15;
                        break block0;
                    }
                    case 'd': {
                        X = "defaultCharset";
                        id = 9;
                        break block0;
                    }
                    case 'g': {
                        X = "getElementById";
                        id = -16;
                        break block0;
                    }
                    case 'i': {
                        X = "implementation";
                        id = 22;
                        break block0;
                    }
                }
                break;
            }
            case 15: {
                char c = s.charAt(6);
                if (c == 'A') {
                    X = "createAttribute";
                    id = -4;
                    break;
                }
                if (c == 'E') {
                    X = "createElementNS";
                    id = -10;
                    break;
                }
                if (c != 'n') break;
                X = "documentElement";
                id = 13;
                break;
            }
            case 16: {
                X = "removeStyleSheet";
                id = -24;
                break;
            }
            case 17: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "createAttributeNS";
                    id = -5;
                    break;
                }
                if (c != 'g') break;
                X = "getElementsByName";
                id = -17;
                break;
            }
            case 18: {
                X = "createCDATASection";
                id = -6;
                break;
            }
            case 20: {
                X = "getElementsByTagName";
                id = -18;
                break;
            }
            case 21: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "createEntityReference";
                    id = -12;
                    break;
                }
                if (c != 't') break;
                X = "transformNodeToObject";
                id = -27;
                break;
            }
            case 22: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "createDocumentFragment";
                    id = -8;
                    break;
                }
                if (c != 'g') break;
                X = "getElementsByTagNameNS";
                id = -19;
                break;
            }
            case 26: {
                X = "createElementWithNameSpace";
                id = -11;
                break;
            }
            case 27: {
                X = "createProcessingInstruction";
                id = -14;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

