/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DAttrMap;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DNodeList;
import ice.pilots.html4.DStyleDeclaration;
import ice.pilots.html4.FormTypeElement;
import ice.pilots.html4.Names;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.TheView;
import ice.storm.DynEnv;
import ice.storm.DynamicList;
import ice.storm.DynamicObject;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.alg.CharKit;
import java.awt.Rectangle;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ElementCSSInlineStyle;
import org.w3c.dom.html.HTMLElement;

public class DElement
extends DNode
implements Element,
HTMLElement,
ElementCSSInlineStyle {
    private static final Object EMBEDDED_HOLDER_PROPERTY = new Object();
    private static final boolean verbose_DElement_toString = Debug.extra && Defs.booleanProperty("ice.debug.verbose_DElement_toString");
    String qname = null;
    private boolean synthetic = false;
    int sourceIndex = 0;
    DStyleDeclaration inlineStyle = null;
    CSSBox hack_box;
    private String nameValue = null;
    private static final int Field_attributes = 1;
    private static final int Field_bgColor = 2;
    private static final int Field_className = 3;
    private static final int Field_clientHeight = 4;
    private static final int Field_clientLeft = 5;
    private static final int Field_clientTop = 6;
    private static final int Field_clientWidth = 7;
    private static final int Field_color = 8;
    private static final int Field_cols = 9;
    private static final int Field_dir = 10;
    private static final int Field_filters = 11;
    private static final int Field_id = 12;
    private static final int Field_innerHTML = 13;
    private static final int Field_lang = 14;
    private static final int Field_name = 15;
    private static final int Field_outerHTML = 16;
    private static final int Field_offsetParent = 17;
    private static final int Field_offsetLeft = 18;
    private static final int Field_offsetTop = 19;
    private static final int Field_offsetWidth = 20;
    private static final int Field_offsetHeight = 21;
    private static final int Field_rows = 22;
    private static final int Field_scrollWidth = 23;
    private static final int Field_scrollHeight = 24;
    private static final int Field_scrollLeft = 25;
    private static final int Field_scrollTop = 26;
    private static final int Field_sourceIndex = 27;
    private static final int Field_style = 28;
    private static final int Field_synthetic = 29;
    private static final int Field_tagName = 30;
    private static final int Field_title = 31;
    private static final int Field___ice_childWindow = 32;
    private static final int Method_addBehavior = -1;
    private static final int Method_getAttribute = -2;
    private static final int Method_getAttributeAsInt = -3;
    private static final int Method_getAttributeNode = -4;
    private static final int Method_getAttributeNodeNS = -5;
    private static final int Method_getAttributeNS = -6;
    private static final int Method_getElementsByTagName = -7;
    private static final int Method_getElementsByTagNameNS = -8;
    private static final int Method_hasAttribute = -9;
    private static final int Method_hasAttributeNS = -10;
    private static final int Method_insertAdjacentHTML = -11;
    private static final int Method_isHomePage = -12;
    private static final int Method_load = -13;
    private static final int Method_removeAttribute = -14;
    private static final int Method_removeAttributeNode = -15;
    private static final int Method_removeAttributeNS = -16;
    private static final int Method_removeNode = -17;
    private static final int Method_setAttribute = -18;
    private static final int Method_setAttributeNode = -19;
    private static final int Method_setAttributeNodeNS = -20;
    private static final int Method_setAttributeNS = -21;
    private static final int Method_startDownload = -22;
    private static final int Method_swapNode = -23;
    private static final int Field_NAME = 15;

    protected DElement(DDocument doc, int id) {
        super(doc, id);
    }

    protected void afterClone(boolean deep) {
        super.afterClone(deep);
        this.synthetic = false;
        this.sourceIndex = 0;
        this.inlineStyle = null;
        this.nameValue = null;
    }

    protected void onDAttrValueChange(DAttr attr) {
        ObjectPainter painter;
        DDocument doc_ref = this.doc;
        if (doc_ref != null && doc_ref.pilot != null && (painter = doc_ref.pilot.objectPool.getNodePainter(this)) != null) {
            painter.onElementAttrChange(this, attr);
        }
    }

    void copyAttrsFrom(DElement from) {
        this.copyAttrsFrom(from, true);
    }

    void copyAttrsFrom(DElement from, boolean replace) {
        DAttr cursor = from.getDAttrListHead();
        while (cursor != null) {
            if (replace || this.getDAttr(cursor.getNameId()) == null) {
                DAttr cloned = (DAttr)cursor.clone(true);
                this.setDAttr(cloned, false);
            }
            cursor = cursor.next;
        }
    }

    void setAttributes(int[] names, String[] values, int num) {
        while (num-- != 0) {
            this.setDAttr(names[num], values[num], false);
        }
    }

    public final String getAttribute(int attrNameId) {
        DAttr attr = this.getDAttr(attrNameId);
        return attr != null ? attr.getValue() : null;
    }

    protected void setAttribute(int attrNameId, String value) {
        this.setDAttr(attrNameId, value, true);
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        return this.getTagName();
    }

    public String getTagName() {
        if (this.qname != null) {
            return this.qname;
        }
        Names cfr_ignored_0 = this.doc.names;
        return Names.getTagName(this.tagId);
    }

    protected int attrNameToId(String name) {
        Names names = this.doc.names;
        return names.getAttrId(names.getTagNamespaceId(this.tagId), name);
    }

    public String getAttribute(String name) {
        return this.getAttribute(this.attrNameToId(name));
    }

    public void setAttribute(String name, String value) {
        this.setDAttr(this.attrNameToId(name), value, true);
    }

    public void removeAttribute(String name) {
        this.removeDAttr(this.attrNameToId(name), true);
    }

    public Attr getAttributeNode(String name) {
        return this.getDAttr(this.attrNameToId(name));
    }

    public Attr setAttributeNode(Attr newAttr) {
        if (newAttr instanceof DAttr) {
            return this.setDAttr((DAttr)newAttr, true);
        }
        return null;
    }

    public Attr removeAttributeNode(Attr oldAttr) {
        if (oldAttr instanceof DAttr) {
            return this.removeDAttr((DAttr)oldAttr, true);
        }
        return null;
    }

    public NodeList getElementsByTagName(String name) {
        return new DNodeList(this, name);
    }

    public NamedNodeMap getAttributes() {
        return new DAttrMap(this);
    }

    public String getLocalName() {
        Names cfr_ignored_0 = this.doc.names;
        return Names.getTagName(this.tagId);
    }

    public String getPrefix() {
        if (this.qname != null) {
            return this.qname.substring(0, this.qname.indexOf(58));
        }
        return null;
    }

    public String getNamespaceURI() {
        String namespace = this.doc.names.getTagNamespaceURI(this.tagId);
        return "".equals(namespace) ? null : namespace;
    }

    public String getBgColor() {
        return this.getAttribute(12);
    }

    public void setBgColor(String value) {
        this.setAttribute(12, value);
        this.getStyle().setProperty("background-color", value, "");
    }

    public String getColor() {
        return this.getAttribute(27);
    }

    public void setColor(String value) {
        this.setAttribute(27, value);
        this.getStyle().setProperty("color", value, "");
    }

    public String getId() {
        return this.getAttribute(50);
    }

    private Object script_getId() {
        String result = this.getId();
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void setId(String value) {
        this.setAttribute(50, value);
    }

    public void setRows(String value) {
        this.setAttribute(92, value);
    }

    public void setCols(String value) {
        this.setAttribute(28, value);
    }

    public String getName() {
        String result = this.nameValue;
        if (result == null) {
            result = this.getAttribute(63);
        }
        return result;
    }

    private Object script_getName() {
        Object result = this.getName();
        if (this instanceof FormTypeElement) {
            if (result == null) {
                result = "";
            }
        } else if (result == null) {
            result = NOT_FOUND;
        }
        return result;
    }

    public void setName(String value) {
        String currentName = this.getAttribute(63);
        boolean setNameAttribute = currentName == null;
        this.nameValue = value != null ? value : "";
        if (setNameAttribute) {
            this.setAttribute(63, this.nameValue);
        }
    }

    public String getClassName() {
        return this.getAttribute(21);
    }

    private String script_getClassName() {
        String result = this.getClassName();
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void setClassName(String value) {
        this.setAttribute(21, value);
        this.doc.mutate();
    }

    public String getTitle() {
        return this.getAttribute(110);
    }

    public void setTitle(String value) {
        this.setAttribute(110, value);
    }

    public String getLang() {
        return this.getAttribute(53);
    }

    public void setLang(String value) {
        this.setAttribute(53, value);
    }

    public String getDir() {
        return this.getAttribute(37);
    }

    public void setDir(String value) {
        this.setAttribute(37, value);
    }

    public CSSStyleDeclaration getStyle() {
        if (this.inlineStyle == null) {
            this.inlineStyle = this.doc.getDom().createDStyleDeclaration(null, this);
        }
        return this.inlineStyle;
    }

    private DynamicObject script_getFilters(DynEnv env) {
        class HackList
        extends DynamicList {
            HackList() {
            }

            protected int getLength() {
                return 0;
            }

            protected Object script_item(int index, DynEnv env) {
                return new DynamicObject();
            }

            protected Object script_namedItem(String name, DynEnv env) {
                return new DynamicObject();
            }
        }
        return new HackList();
    }

    public String toString() {
        String name;
        String id;
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append('[');
        sb.append(this.tagId);
        sb.append(' ');
        sb.append(this.getTagName());
        String className = this.getClassName();
        if (className != null) {
            sb.append(" class=");
            sb.append(className);
        }
        if ((id = this.getId()) != null) {
            sb.append(" id=");
            sb.append(id);
        }
        if ((name = this.getAttribute(63)) != null) {
            sb.append(" name=");
            sb.append(name);
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean getSynthetic() {
        return this.synthetic;
    }

    void setSynthetic(boolean flag) {
        this.synthetic = flag;
    }

    boolean isFormControl() {
        return false;
    }

    boolean isReplacedElement() {
        if (this.tagId == 46 || this.tagId == 5 || this.tagId == 60 || this.tagId == 93 || this.tagId == 45) {
            return true;
        }
        if (this.tagId == 15) {
            return false;
        }
        return this.isFormControl();
    }

    boolean isFocusable() {
        String s;
        return this.tagId == 47 ? (s = this.getAttribute(111)) == null || !s.equalsIgnoreCase("hidden") : (this.tagId == 1 ? (s = this.getAttribute(46)) != null : this.tagId == 15 || this.tagId == 82 || this.tagId == 71);
    }

    public int getAttributeAsInt(String name) {
        long value;
        String s = this.getAttribute(name);
        if (s != null && (value = CharKit.parseInt(s, 0, s.length())) >= 0L) {
            return (int)value;
        }
        return -1;
    }

    Hashtable getAttributesAsHashtable() {
        DAttr attr_cursor = this.getDAttrListHead();
        if (attr_cursor == null) {
            return null;
        }
        Hashtable<String, String> hash = new Hashtable<String, String>();
        do {
            hash.put(attr_cursor.getName(), attr_cursor.getValue());
        } while ((attr_cursor = attr_cursor.next) != null);
        return hash;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        if (!DElement.isNullOrEmpty(namespaceURI)) {
            if (Debug.trace) {
                Debug.trace("namespaces are not supported: " + namespaceURI);
            }
            return null;
        }
        if (Debug.trace) {
            Debug.trace("namespaces are not supported but namespace is null");
        }
        return this.getAttribute(localName);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        if (!DElement.isNullOrEmpty(namespaceURI)) {
            if (Debug.trace) {
                Debug.trace("namespaces are not supported: " + namespaceURI);
            }
            return;
        }
        if (Debug.trace) {
            Debug.trace("namespaces are not supported but namespace is null");
        }
        this.setAttribute(qualifiedName, value);
    }

    public void removeAttributeNS(String namespaceURI, String localName) {
        if (!DElement.isNullOrEmpty(namespaceURI)) {
            if (Debug.trace) {
                Debug.trace("namespaces are not supported: " + namespaceURI);
            }
            return;
        }
        if (Debug.trace) {
            Debug.trace("namespaces are not supported but namespace is null");
        }
        this.removeAttribute(localName);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        if (!DElement.isNullOrEmpty(namespaceURI)) {
            if (Debug.trace) {
                Debug.trace("namespaces are not supported: " + namespaceURI);
            }
            return null;
        }
        if (Debug.trace) {
            Debug.trace("namespaces are not supported but namespace is null");
        }
        return this.getAttributeNode(localName);
    }

    public Attr setAttributeNodeNS(Attr newAttr) {
        if (!DElement.isNullOrEmpty(newAttr.getNamespaceURI())) {
            if (Debug.trace) {
                Debug.trace("namespaces are not supported: " + newAttr.getNamespaceURI());
            }
            return null;
        }
        if (Debug.trace) {
            Debug.trace("namespaces are not supported but namespace is null");
        }
        return this.setAttributeNode(newAttr);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (!DElement.isNullOrEmpty(namespaceURI)) {
            if (Debug.trace) {
                Debug.trace("namespaces are not supported: " + namespaceURI);
            }
            return null;
        }
        if (Debug.trace) {
            Debug.trace("namespaces are not supported but namespace is null");
        }
        return this.getElementsByTagName(localName);
    }

    public boolean hasAttribute(String name) {
        return true;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        if (!DElement.isNullOrEmpty(namespaceURI)) {
            if (Debug.trace) {
                Debug.trace("namespaces are not supported: " + namespaceURI);
            }
            return false;
        }
        if (Debug.trace) {
            Debug.trace("namespaces are not supported but namespace is null");
        }
        return this.hasAttribute(localName);
    }

    private ScrollBox getPotentialScrollBox() {
        TheView view = (TheView)this.doc.getDefaultView();
        return view.getScroller(this);
    }

    public int getClientTop() {
        TheView view = (TheView)this.doc.getDefaultView();
        if (view != null && view.getDocPane() != null) {
            return view.getDocPane().getScrollY();
        }
        return 0;
    }

    public int getClientLeft() {
        TheView view = (TheView)this.doc.getDefaultView();
        if (view != null && view.getDocPane() != null) {
            return view.getDocPane().getScrollX();
        }
        return 0;
    }

    public int getClientWidth() {
        TheView view = (TheView)this.doc.getDefaultView();
        if (this.tagId == 13) {
            if (view != null) {
                return view.getDocPane().getPaneWidth();
            }
            return 0;
        }
        ObjectPainter op = view.getNodePainter(this);
        if (op != null) {
            return op.getClientWidth();
        }
        return this.getOffsetWidth();
    }

    private int getClientHeight() {
        TheView view = (TheView)this.doc.getDefaultView();
        if (this.tagId == 13) {
            if (view != null) {
                return view.getDocPane().getPaneHeight();
            }
            return 0;
        }
        ObjectPainter op = view.getNodePainter(this);
        if (op != null) {
            return op.getClientHeight();
        }
        return this.getOffsetHeight();
    }

    private DElement getOffsetParent() {
        TheView view = (TheView)this.doc.getDefaultView();
        if (view != null) {
            return view.getOffsetParent(this);
        }
        return null;
    }

    int getOffsetLeft() {
        TheView view = (TheView)this.doc.getDefaultView();
        if (view != null) {
            return view.getOffsetLeft(this);
        }
        return 0;
    }

    int getOffsetTop() {
        TheView view = (TheView)this.doc.getDefaultView();
        if (view != null) {
            return view.getOffsetTop(this);
        }
        return 0;
    }

    private int getOffsetWidth() {
        TheView view = (TheView)this.doc.getDefaultView();
        Rectangle r = new Rectangle();
        view.findBoundingBox2(this, r);
        return r.width;
    }

    private int getOffsetHeight() {
        TheView view = (TheView)this.doc.getDefaultView();
        Rectangle r = new Rectangle();
        view.findBoundingBox2(this, r);
        return r.height;
    }

    private int getScrollLeft() {
        TheView view = (TheView)this.doc.getDefaultView();
        if (view != null) {
            if (this.tagId == 13 || this.tagId == 43) {
                return view.getDocPane().getScrollX();
            }
            ScrollBox sc = this.getPotentialScrollBox();
            if (sc != null) {
                return sc.getScrollX();
            }
        }
        return 0;
    }

    private int getScrollTop() {
        TheView view = (TheView)this.doc.getDefaultView();
        if (view != null) {
            if (this.tagId == 13 || this.tagId == 43) {
                return view.getDocPane().getScrollY();
            }
            ScrollBox sc = this.getPotentialScrollBox();
            if (sc != null) {
                return sc.getScrollY();
            }
        }
        return 0;
    }

    private int getScrollWidth() {
        TheView view = (TheView)this.doc.getDefaultView();
        if (view != null) {
            Rectangle r = new Rectangle();
            if (this.tagId == 13) {
                r.width = view.getWidth();
                if (r.width == 0) {
                    r.width = view.getDocPane().getPaneWidth();
                    return r.width;
                }
            } else {
                ScrollBox sc = this.getPotentialScrollBox();
                if (sc != null) {
                    return sc.getScrollableWidth();
                }
                return this.getOffsetWidth();
            }
        }
        return 0;
    }

    private int getScrollHeight() {
        TheView view = (TheView)this.doc.getDefaultView();
        if (view != null) {
            if (this.tagId == 13) {
                int vh;
                int dh = view.getHeight();
                if (dh < (vh = view.getDocPane().getPaneHeight())) {
                    dh = vh;
                }
                return dh;
            }
            ScrollBox sc = this.getPotentialScrollBox();
            if (sc != null) {
                return sc.getScrollableHeight();
            }
            return this.getOffsetHeight();
        }
        return 0;
    }

    private Object addBehavior(Object[] args, DynEnv env) {
        return null;
    }

    private boolean isHomePage(String s) {
        return false;
    }

    private void do_subtreeParsing(String s) {
        DNode dummy = (DNode)this.parent.cloneNode(false);
        this.doc.parseHtmlSubtree(dummy, s);
        DNode n = dummy.getFirstDChild();
        while (n != null) {
            DNode nextNode = n.getNextDSibling();
            this.parent.insertDChildBefore(n, this);
            n = nextNode;
        }
    }

    public void insertAdjacentHTML(String where, String what) {
        if ((where = where.toLowerCase()).equals("beforebegin")) {
            this.do_subtreeParsing(what);
        } else if (where.equals("afterbegin")) {
            DNode dummy = (DNode)this.cloneNode(false);
            this.doc.parseHtmlSubtree(dummy, what);
            DNode f = this.getFirstDChild();
            DNode n = dummy.getFirstDChild();
            while (n != null) {
                DNode nextNode = n.getNextDSibling();
                this.insertDChildBefore(n, f);
                n = nextNode;
            }
        } else if (where.equals("beforeend")) {
            this.doc.parseHtmlSubtree(this, what);
        } else if (where.equals("afterend")) {
            this.doc.parseHtmlSubtree(this.getParentDNode(), what);
        }
    }

    public void setInnerHTML(String html) {
        while (this.first != null) {
            this.removeDChild(this.first);
        }
        this.doc.parseHtmlSubtree(this, html);
    }

    public String getInnerHTML() {
        String result;
        if (this.first != null) {
            StringBuffer sb = new StringBuffer();
            DNode n = this.first;
            while (n != null) {
                DNode.appendOuterHTML(n, sb);
                n = n.next;
            }
            result = sb.toString();
        } else {
            result = "";
        }
        return result;
    }

    public void setOuterHTML(String html) {
        this.do_subtreeParsing(html);
        this.parent.removeDChild(this);
    }

    public String getOuterHTML() {
        StringBuffer sb = new StringBuffer();
        DNode.appendOuterHTML(this, sb);
        return sb.toString();
    }

    public Node removeNode(boolean detachChildren) {
        if (detachChildren) {
            DNode n = this.getFirstDChild();
            while (n != null) {
                DNode nextNode = n.getNextDSibling();
                if (n instanceof DElement) {
                    ((DElement)n).removeNode(detachChildren);
                } else {
                    this.removeDChild(n);
                }
                n = nextNode;
            }
        }
        this.parent.removeDChild(this);
        return this;
    }

    public final Node swapNode(Node other) {
        if (other instanceof DNode) {
            return this.swapDNode((DNode)other);
        }
        return null;
    }

    protected DNode swapDNode(DNode other) {
        if (other == this || other.getParentDNode() != this.parent) {
            return null;
        }
        DElement clone = (DElement)this.cloneNode(true);
        this.parent.insertDChildBefore(clone, other);
        this.parent.insertDChildBefore(other, this);
        this.parent.removeDChild(this);
        return clone;
    }

    public static DElement getEmbeddedViewHolder(Viewport view) {
        return (DElement)view.getProperty(EMBEDDED_HOLDER_PROPERTY);
    }

    void setAsEmbeddedViewHolder(Viewport view) {
        view.setProperty(EMBEDDED_HOLDER_PROPERTY, this);
    }

    public Viewport getChildViewport() {
        Viewport result = null;
        Viewport parentView = this.doc.pilot.getPilotViewport();
        if (parentView != null) {
            result = parentView.getImmediateChildWithProperty(EMBEDDED_HOLDER_PROPERTY, this);
        }
        return result;
    }

    protected DynamicObject getEmbeddedDocument() {
        DynamicObject result = null;
        Viewport view = this.getChildViewport();
        if (view != null) {
            result = view.getDocumentObject();
        }
        return result;
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DElement.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DElement.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DElement.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return this.getAttributes();
            }
            case 2: {
                return this.getBgColor();
            }
            case 3: {
                return this.script_getClassName();
            }
            case 4: {
                return env.wrapInt(this.getClientHeight());
            }
            case 5: {
                return env.wrapInt(this.getClientLeft());
            }
            case 6: {
                return env.wrapInt(this.getClientTop());
            }
            case 7: {
                return env.wrapInt(this.getClientWidth());
            }
            case 8: {
                return this.getColor();
            }
            case 10: {
                return this.getDir();
            }
            case 11: {
                return this.script_getFilters(env);
            }
            case 12: {
                return this.script_getId();
            }
            case 13: {
                return this.getInnerHTML();
            }
            case 14: {
                return this.getLang();
            }
            case 15: {
                return this.script_getName();
            }
            case 16: {
                return this.getOuterHTML();
            }
            case 17: {
                return this.getOffsetParent();
            }
            case 18: {
                return env.wrapInt(this.getOffsetLeft());
            }
            case 19: {
                return env.wrapInt(this.getOffsetTop());
            }
            case 20: {
                return env.wrapInt(this.getOffsetWidth());
            }
            case 21: {
                return env.wrapInt(this.getOffsetHeight());
            }
            case 23: {
                return env.wrapInt(this.getScrollWidth());
            }
            case 24: {
                return env.wrapInt(this.getScrollHeight());
            }
            case 25: {
                return env.wrapInt(this.getScrollLeft());
            }
            case 26: {
                return env.wrapInt(this.getScrollTop());
            }
            case 27: {
                return env.wrapInt(this.sourceIndex);
            }
            case 28: {
                return this.getStyle();
            }
            case 29: {
                return env.wrapBoolean(this.getSynthetic());
            }
            case 30: {
                return this.getTagName();
            }
            case 31: {
                return this.getTitle();
            }
            case 32: {
                Viewport v = this.getChildViewport();
                return v == null ? null : v.getWindowObj();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 2: {
                this.setBgColor(env.toStr(value));
                return 1;
            }
            case 3: {
                this.setClassName(env.toStr(value));
                return 1;
            }
            case 8: {
                this.setColor(env.toStr(value));
                return 1;
            }
            case 9: {
                this.setCols(env.toStr(value));
                return 1;
            }
            case 10: {
                this.setDir(env.toStr(value));
                return 1;
            }
            case 12: {
                this.setId(env.toStr(value));
                return 1;
            }
            case 13: {
                this.setInnerHTML(env.toStr(value));
                return 1;
            }
            case 14: {
                this.setLang(env.toStr(value));
                return 1;
            }
            case 15: {
                this.setName(env.toStr(value));
                return 1;
            }
            case 16: {
                this.setOuterHTML(env.toStr(value));
                return 1;
            }
            case 22: {
                this.setRows(env.toStr(value));
                return 1;
            }
            case 29: {
                this.setSynthetic(env.toBoolean(value));
                return 1;
            }
            case 31: {
                this.setTitle(env.toStr(value));
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                return this.addBehavior(args, env);
            }
            case -2: {
                boolean case_sensitive;
                String name = env.toStr(args, 0);
                if (args.length > 1 && !(case_sensitive = env.toBoolean(args, 1))) {
                    name = name.toLowerCase();
                }
                if (name.length() == 4 && name.equalsIgnoreCase("name")) {
                    return this.script_getName();
                }
                return this.getAttribute(name);
            }
            case -3: {
                String name = env.toStr(args, 0);
                return env.wrapInt(this.getAttributeAsInt(name));
            }
            case -4: {
                return this.getAttributeNode(env.toStr(args, 0));
            }
            case -5: {
                return this.getAttributeNodeNS(env.toStr(args, 0), env.toStr(args, 1));
            }
            case -6: {
                return this.getAttributeNS(env.toStr(args, 0), env.toStr(args, 1));
            }
            case -7: {
                return this.getElementsByTagName(env.toStr(args, 0));
            }
            case -8: {
                return this.getElementsByTagNameNS(env.toStr(args, 0), env.toStr(args, 1));
            }
            case -9: {
                return env.wrapBoolean(this.hasAttribute(env.toStr(args, 0)));
            }
            case -10: {
                return env.wrapBoolean(this.hasAttributeNS(env.toStr(args, 0), env.toStr(args, 1)));
            }
            case -11: {
                this.insertAdjacentHTML(env.toStr(args, 0), env.toStr(args, 1));
                break;
            }
            case -12: {
                return env.wrapBoolean(this.isHomePage(env.toStr(args, 0)));
            }
            case -13: {
                break;
            }
            case -14: {
                this.removeAttribute(env.toStr(args, 0));
                break;
            }
            case -15: {
                return this.removeAttributeNode((Attr)env.toNative(args, 0));
            }
            case -16: {
                this.removeAttributeNS(env.toStr(args, 0), env.toStr(args, 1));
                break;
            }
            case -17: {
                boolean detachChildren = env.toBoolean(args, 0);
                return this.removeNode(detachChildren);
            }
            case -18: {
                boolean case_sensitive;
                String name = env.toStr(args, 0);
                String value = env.toStr(args, 1);
                if (args.length > 2 && !(case_sensitive = env.toBoolean(args, 2))) {
                    name = name.toLowerCase();
                }
                if (name.length() == 4 && name.equalsIgnoreCase("name")) {
                    this.setName(value);
                    break;
                }
                this.setAttribute(name, value);
                break;
            }
            case -19: {
                return this.setAttributeNode((Attr)env.toNative(args, 0));
            }
            case -20: {
                return this.setAttributeNodeNS((Attr)env.toNative(args, 0));
            }
            case -21: {
                String namespaceURI = env.toStr(args, 0);
                String qualifiedName = env.toStr(args, 1);
                String value = env.toStr(args, 2);
                this.setAttributeNS(namespaceURI, qualifiedName, value);
                break;
            }
            case -22: {
                String url = env.toStr(args, 0);
                Object callback = env.getRawObject(args, 1);
                this.doc.getPilot().startDownload(url, callback, env.getScripter());
                return env.wrapVoid();
            }
            case -23: {
                return this.swapNode((Node)env.toNative(args, 0));
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 2: {
                X = "id";
                id = 12;
                break;
            }
            case 3: {
                X = "dir";
                id = 10;
                break;
            }
            case 4: {
                switch (s.charAt(2)) {
                    case 'M': {
                        X = "NAME";
                        id = 15;
                        break block0;
                    }
                    case 'a': {
                        X = "load";
                        id = -13;
                        break block0;
                    }
                    case 'l': {
                        X = "cols";
                        id = 9;
                        break block0;
                    }
                    case 'm': {
                        X = "name";
                        id = 15;
                        break block0;
                    }
                    case 'n': {
                        X = "lang";
                        id = 14;
                        break block0;
                    }
                    case 'w': {
                        X = "rows";
                        id = 22;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                char c = s.charAt(0);
                if (c == 'c') {
                    X = "color";
                    id = 8;
                    break;
                }
                if (c == 's') {
                    X = "style";
                    id = 28;
                    break;
                }
                if (c != 't') break;
                X = "title";
                id = 31;
                break;
            }
            case 7: {
                char c = s.charAt(0);
                if (c == 'b') {
                    X = "bgColor";
                    id = 2;
                    break;
                }
                if (c == 'f') {
                    X = "filters";
                    id = 11;
                    break;
                }
                if (c != 't') break;
                X = "tagName";
                id = 30;
                break;
            }
            case 8: {
                X = "swapNode";
                id = -23;
                break;
            }
            case 9: {
                switch (s.charAt(1)) {
                    case 'c': {
                        X = "scrollTop";
                        id = 26;
                        break block0;
                    }
                    case 'f': {
                        X = "offsetTop";
                        id = 19;
                        break block0;
                    }
                    case 'l': {
                        char c = s.charAt(8);
                        if (c == 'e') {
                            X = "className";
                            id = 3;
                            break block0;
                        }
                        if (c != 'p') break block0;
                        X = "clientTop";
                        id = 6;
                        break block0;
                    }
                    case 'n': {
                        X = "innerHTML";
                        id = 13;
                        break block0;
                    }
                    case 'u': {
                        X = "outerHTML";
                        id = 16;
                        break block0;
                    }
                    case 'y': {
                        X = "synthetic";
                        id = 29;
                        break block0;
                    }
                }
                break;
            }
            case 10: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "attributes";
                        id = 1;
                        break block0;
                    }
                    case 'c': {
                        X = "clientLeft";
                        id = 5;
                        break block0;
                    }
                    case 'i': {
                        X = "isHomePage";
                        id = -12;
                        break block0;
                    }
                    case 'o': {
                        X = "offsetLeft";
                        id = 18;
                        break block0;
                    }
                    case 'r': {
                        X = "removeNode";
                        id = -17;
                        break block0;
                    }
                    case 's': {
                        X = "scrollLeft";
                        id = 25;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                switch (s.charAt(1)) {
                    case 'c': {
                        X = "scrollWidth";
                        id = 23;
                        break block0;
                    }
                    case 'd': {
                        X = "addBehavior";
                        id = -1;
                        break block0;
                    }
                    case 'f': {
                        X = "offsetWidth";
                        id = 20;
                        break block0;
                    }
                    case 'l': {
                        X = "clientWidth";
                        id = 7;
                        break block0;
                    }
                    case 'o': {
                        X = "sourceIndex";
                        id = 27;
                        break block0;
                    }
                }
                break;
            }
            case 12: {
                switch (s.charAt(0)) {
                    case 'c': {
                        X = "clientHeight";
                        id = 4;
                        break block0;
                    }
                    case 'g': {
                        X = "getAttribute";
                        id = -2;
                        break block0;
                    }
                    case 'h': {
                        X = "hasAttribute";
                        id = -9;
                        break block0;
                    }
                    case 'o': {
                        char c = s.charAt(6);
                        if (c == 'H') {
                            X = "offsetHeight";
                            id = 21;
                            break block0;
                        }
                        if (c != 'P') break block0;
                        X = "offsetParent";
                        id = 17;
                        break block0;
                    }
                    case 's': {
                        char c = s.charAt(11);
                        if (c == 'e') {
                            X = "setAttribute";
                            id = -18;
                            break block0;
                        }
                        if (c != 't') break block0;
                        X = "scrollHeight";
                        id = 24;
                        break block0;
                    }
                }
                break;
            }
            case 13: {
                X = "startDownload";
                id = -22;
                break;
            }
            case 14: {
                char c = s.charAt(0);
                if (c == 'g') {
                    X = "getAttributeNS";
                    id = -6;
                    break;
                }
                if (c == 'h') {
                    X = "hasAttributeNS";
                    id = -10;
                    break;
                }
                if (c != 's') break;
                X = "setAttributeNS";
                id = -21;
                break;
            }
            case 15: {
                X = "removeAttribute";
                id = -14;
                break;
            }
            case 16: {
                char c = s.charAt(0);
                if (c == 'g') {
                    X = "getAttributeNode";
                    id = -4;
                    break;
                }
                if (c != 's') break;
                X = "setAttributeNode";
                id = -19;
                break;
            }
            case 17: {
                char c = s.charAt(0);
                if (c == '_') {
                    X = "__ice_childWindow";
                    id = 32;
                    break;
                }
                if (c == 'g') {
                    X = "getAttributeAsInt";
                    id = -3;
                    break;
                }
                if (c != 'r') break;
                X = "removeAttributeNS";
                id = -16;
                break;
            }
            case 18: {
                char c = s.charAt(0);
                if (c == 'g') {
                    X = "getAttributeNodeNS";
                    id = -5;
                    break;
                }
                if (c == 'i') {
                    X = "insertAdjacentHTML";
                    id = -11;
                    break;
                }
                if (c != 's') break;
                X = "setAttributeNodeNS";
                id = -20;
                break;
            }
            case 19: {
                X = "removeAttributeNode";
                id = -15;
                break;
            }
            case 20: {
                X = "getElementsByTagName";
                id = -7;
                break;
            }
            case 22: {
                X = "getElementsByTagNameNS";
                id = -8;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        return id;
    }
}

