/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.report.Report;
import coldfusion.server.ServiceFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRResourcesUtil;

public class JRLoader {
    public static Object loadObject(String fileName) throws JRException {
        return JRLoader.loadObject(new File(fileName));
    }

    public static Object loadObject(File file) throws JRException {
        if (!file.exists() || !file.isFile()) {
            throw new JRException(new FileNotFoundException(String.valueOf(file)));
        }
        Object obj = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(file);
            BufferedInputStream bufferedIn = new BufferedInputStream(fis);
            ois = new ObjectInputStream(bufferedIn);
            obj = ois.readObject();
        }
        catch (IOException e) {
            throw new JRException("Error loading object from file : " + file, e);
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Class not found when loading object from file : " + file, e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return obj;
    }

    public static Object loadObject(URL url) throws JRException {
        Object obj = null;
        InputStream is = null;
        ObjectInputStream ois = null;
        try {
            is = url.openStream();
            ois = new ObjectInputStream(is);
            obj = ois.readObject();
        }
        catch (IOException e) {
            throw new JRException("Error loading object from URL : " + url, e);
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Class not found when loading object from URL : " + url, e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return obj;
    }

    public static Object loadObject(InputStream is) throws JRException {
        Object obj = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(is);
            obj = ois.readObject();
        }
        catch (IOException e) {
            throw new JRException("Error loading object from InputStream", e);
        }
        catch (ClassNotFoundException e) {
            throw new JRException("Class not found when loading object from InputStream", e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
        return obj;
    }

    public static Object loadObjectFromLocation(String location) throws JRException {
        return JRLoader.loadObjectFromLocation(location, null, null);
    }

    public static Object loadObjectFromLocation(String location, ClassLoader classLoader) throws JRException {
        return JRLoader.loadObjectFromLocation(location, classLoader, null);
    }

    public static String resolveSubReportPath(String location, NeoPageContext pageContext) {
        String filepath = null;
        String CFR_PARENT_PATH = (String)pageContext.findAttribute("CFR_PATH");
        boolean _absolute_path = false;
        if (location.length() > 1 && location.charAt(1) == ':') {
            filepath = location;
            _absolute_path = true;
        } else {
            filepath = CFR_PARENT_PATH + File.separatorChar + location;
        }
        File file = new File(filepath);
        if (!(file.exists() && file.isFile() || _absolute_path)) {
            try {
                file = ServiceFactory.getRuntimeService().resolveTemplatePath(location);
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (file != null && file.exists() && file.isFile()) {
            filepath = file.getAbsolutePath();
        }
        return filepath;
    }

    public static Object loadObjectFromLocation(String location, ClassLoader classLoader, URLStreamHandlerFactory urlHandlerFactory) throws JRException {
        URL url = JRResourcesUtil.createURL(location, urlHandlerFactory);
        if (url != null) {
            return JRLoader.loadObject(url);
        }
        File file = new File(location);
        if (file.exists() && file.isFile()) {
            return JRLoader.loadObject(file);
        }
        url = JRResourcesUtil.findClassLoaderResource(location, classLoader, JRLoader.class);
        if (url != null) {
            return JRLoader.loadObject(url);
        }
        FusionContext context = FusionContext.getCurrent();
        NeoPageContext pageContext = context.pageContext;
        String subReportLocation = JRLoader.resolveSubReportPath(location, pageContext);
        if (!subReportLocation.equals("")) {
            Report report = new Report(subReportLocation, pageContext);
            return report.compileReport(null);
        }
        throw new JRException("Could not load object from location : " + location);
    }

    public static byte[] loadBytes(File file) throws JRException {
        ByteArrayOutputStream baos = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = fis.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        catch (IOException e) {
            throw new JRException("Error loading byte data : " + file, e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return baos.toByteArray();
    }

    public static byte[] loadBytes(URL url) throws JRException {
        ByteArrayOutputStream baos = null;
        InputStream is = null;
        try {
            is = url.openStream();
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        catch (IOException e) {
            throw new JRException("Error loading byte data : " + url, e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return baos.toByteArray();
    }

    public static byte[] loadBytes(InputStream is) throws JRException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        catch (IOException e) {
            throw new JRException("Error loading byte data from input stream.", e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.reset();
                }
                catch (IOException iOException) {}
            }
        }
        return baos.toByteArray();
    }

    public static byte[] loadBytesFromLocation(String location) throws JRException {
        return JRLoader.loadBytesFromLocation(location, null, null);
    }

    public static byte[] loadBytesFromLocation(String location, ClassLoader classLoader) throws JRException {
        return JRLoader.loadBytesFromLocation(location, classLoader, null);
    }

    public static byte[] loadBytesFromLocation(String location, ClassLoader classLoader, URLStreamHandlerFactory urlHandlerFactory) throws JRException {
        URL url = JRResourcesUtil.createURL(location, urlHandlerFactory);
        if (url != null) {
            return JRLoader.loadBytes(url);
        }
        File file = new File(location);
        if (file.exists() && file.isFile()) {
            return JRLoader.loadBytes(file);
        }
        url = JRResourcesUtil.findClassLoaderResource(location, classLoader, JRLoader.class);
        if (url != null) {
            return JRLoader.loadBytes(url);
        }
        throw new JRException("Byte data not found at location : " + location);
    }

    public static InputStream getLocationInputStream(String location) throws JRException {
        InputStream is = null;
        is = JRLoader.getFileInputStream(location);
        if (is == null) {
            is = JRLoader.getResourceInputStream(location);
        }
        if (is == null) {
            is = JRLoader.getURLInputStream(location);
        }
        return is;
    }

    public static InputStream getFileInputStream(String filename) throws JRException {
        FileInputStream is = null;
        File file = new File(filename);
        if (file.exists() && file.isFile()) {
            try {
                is = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new JRException("Error opening file " + filename);
            }
        }
        return is;
    }

    public static InputStream getResourceInputStream(String resource) {
        InputStream is = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            is = classLoader.getResourceAsStream(resource);
        }
        if (is == null) {
            classLoader = JRLoader.class.getClassLoader();
            if (classLoader != null) {
                is = classLoader.getResourceAsStream(resource);
            }
            if (is == null) {
                is = JRProperties.class.getResourceAsStream("/" + resource);
            }
        }
        return is;
    }

    public static InputStream getURLInputStream(String spec) throws JRException {
        InputStream is = null;
        try {
            URL url = new URL(spec);
            is = url.openStream();
        }
        catch (MalformedURLException url) {
        }
        catch (IOException e) {
            throw new JRException("Error opening URL " + spec);
        }
        return is;
    }
}

