/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.htmltopdf;

import coldfusion.document.DefaultPageNoCallbackHandler;
import coldfusion.document.DocumentScope;
import coldfusion.document.spi.PageNoCallbackHandler;
import coldfusion.document.webkit.PDFgHFContentProviderImpl;
import coldfusion.document.webkit.PDfgHFStaticContentProvider;
import coldfusion.document.webkit.core.HeaderFooterObject;
import coldfusion.document.webkit.core.PDFgHFContentProvider;
import coldfusion.pdf.core.PDFDocException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFOutput;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.FunctionGeneratorTag;
import coldfusion.tagext.htmltopdf.HtmlToPdfTag;
import java.io.IOException;
import java.util.Map;
import javax.servlet.jsp.tagext.Tag;

public class HtmlToPdfItemTag
extends ChildTag
implements FunctionGeneratorTag {
    private static final long serialVersionUID = 1L;
    private static final String COMMA = ",";
    private static final String ALIGN2 = "align";
    private static final String IMAGENAME = "image";
    private static final double INCH_TO_CM = 2.54;
    private String type = null;
    private Object image;
    private boolean isBase64 = false;
    private boolean showOnPrint;
    private String align = "CENTER";
    private String numberFormat = "NUMERIC";
    private double marginLeft = 1.0;
    private double marginRight = 1.0;
    private double marginTop = 0.5;
    private double marginBottom = 0.5;
    private int opacity = 10;
    private boolean evalAtPrint = false;
    private String funcName;
    private Map extraAttributes = null;
    private Tag parentTag = null;
    public static final String PAGENUMBER = "_PAGENUMBER";
    public static final String PAGENUMBER2 = "_CURRENTPAGENUMBER";
    public static final String LAST_PAGENUMBER = "_LASTPAGENUMBER";
    public static final String LAST_PAGENUMBER2 = "_TOTALPAGECOUNT";
    public static final String ALIGN_LEFT = "LEFT";
    public static final String ALIGN_CENTER = "CENTER";
    public static final String ALIGN_RIGHT = "RIGHT";
    public static final String FORMAT_ROMAN_UCASE = "UPPERCASEROMAN";
    public static final String FORMAT_ROMAN_LCASE = "LOWERCASEROMAN";
    public static final String FORMAT_NUMERIC = "NUMERIC";

    public HtmlToPdfItemTag() {
        super(HtmlToPdfTag.class);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        if (!(type.equalsIgnoreCase("pagebreak") || type.equalsIgnoreCase("header") || type.equalsIgnoreCase("footer"))) {
            throw new HtmlToPdfItemInvalidType(type);
        }
    }

    public void setImage(Object image) {
        if (!(ServiceFactory.getImageService() != null && ServiceFactory.getImageService().isImage(image) || image instanceof String && !"".equals(((String)image).trim()) || image.getClass().isArray() || image instanceof byte[])) {
            throw new EmptyAttributeException(IMAGENAME);
        }
        this.image = image;
    }

    public void setIsBase64(boolean base64) {
        this.isBase64 = base64;
    }

    public void setShowOnPrint(boolean showOnPrint) {
        this.showOnPrint = showOnPrint;
    }

    public void setOpacity(int opacity) {
        if (opacity < 0 || 10 < opacity) {
            throw new HtmlToPdfInvalidOpacityException("" + opacity);
        }
        this.opacity = opacity;
    }

    public void setMarginBottom(double marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setMarginTop(double marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginRight(double marginRight) {
        this.marginRight = marginRight;
    }

    public void setMarginLeft(double marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setAlign(String align) {
        if ("".equals(align) || !ALIGN_CENTER.equalsIgnoreCase(align) && !ALIGN_LEFT.equalsIgnoreCase(align) && !ALIGN_RIGHT.equalsIgnoreCase(align)) {
            throw new InvalidValueException(ALIGN2, align, new StringBuffer().append(ALIGN_CENTER).append(COMMA).append(ALIGN_LEFT).append(COMMA).append(ALIGN_RIGHT).toString());
        }
        this.align = align;
    }

    public void setNumberFormat(String numberFormat) {
        if ("".equals(numberFormat) || !FORMAT_NUMERIC.equalsIgnoreCase(numberFormat) && !FORMAT_ROMAN_LCASE.equalsIgnoreCase(numberFormat) && !FORMAT_ROMAN_UCASE.equalsIgnoreCase(numberFormat)) {
            throw new InvalidValueException("numberformat", numberFormat, new StringBuffer().append(FORMAT_NUMERIC).append(COMMA).append(FORMAT_ROMAN_LCASE).append(COMMA).append(FORMAT_ROMAN_UCASE).toString());
        }
        this.numberFormat = numberFormat;
    }

    public void setEvalAtPrint(boolean evalAtPrint) {
        this.evalAtPrint = evalAtPrint;
    }

    public void setAttributecollection(Map map) {
        this.extraAttributes = map;
    }

    public void setAncestor(Tag t) {
        this.parentTag = t;
    }

    public int doStartTag() throws HtmlToPdfTag.HtmlToPdfTagException {
        this.onTagStart();
        boolean bHasDocParent = false;
        if (this.parentTag == null) {
            this.parentTag = this.getParent();
        }
        while (this.parentTag != null) {
            if (this.parentTag instanceof HtmlToPdfTag) {
                bHasDocParent = true;
                break;
            }
            this.parentTag = this.parentTag.getParent();
        }
        if (!bHasDocParent) {
            throw new HtmlToPdfMissingParentTagException();
        }
        if (this.type.equalsIgnoreCase("pagebreak")) {
            try {
                if (this.out instanceof CFOutput) {
                    ((CFOutput)this.out).cfoutput(true);
                }
                this.out.write("\n<br><p STYLE=\"page-break-before:always\"></p>\n");
                if (this.out instanceof CFOutput) {
                    ((CFOutput)this.out).cfoutput(false);
                }
            }
            catch (IOException e) {
                throw new HtmlToPdfItemPageBreakException(e);
            }
            return 0;
        }
        if (this.evalAtPrint && !this.numberFormat.equalsIgnoreCase(FORMAT_NUMERIC)) {
            throw new HtmlToPdfItemEvalAtPrintValidationException();
        }
        if (!this.evalAtPrint && this.fContext != null) {
            DocumentScope docScope = (DocumentScope)this.fContext.hiddenScope.get((Object)"CFHTMLTOPDF");
            docScope.put((Object)"CURRENTPAGENUMBER", (Object)PAGENUMBER);
            docScope.put((Object)"TOTALPAGECOUNT", (Object)LAST_PAGENUMBER);
        }
        return 2;
    }

    public int doAfterBody() throws HtmlToPdfTag.HtmlToPdfTagException {
        return 0;
    }

    public int doEndTag() throws HtmlToPdfTag.HtmlToPdfTagException {
        this.onTagEnd();
        if (!this.type.equalsIgnoreCase("pagebreak")) {
            this.handleHFRequestForWebKit();
        }
        return 6;
    }

    private void handleHFRequestForWebKit() {
        Object contentProvider = null;
        if (this.funcName != null) {
            if (this.evalAtPrint && this.fContext != null) {
                DocumentScope docScope = (DocumentScope)this.fContext.hiddenScope.get((Object)"CFHTMLTOPDF");
                DefaultPageNoCallbackHandler callbackHandler = new DefaultPageNoCallbackHandler(docScope);
                contentProvider = new PDFgHFContentProviderImpl(this.pageContext, this.funcName, this.extraAttributes, (PageNoCallbackHandler)callbackHandler);
            } else {
                try {
                    contentProvider = new PDfgHFStaticContentProvider(this.pageContext, this.funcName, this.extraAttributes);
                }
                catch (Throwable th) {
                    throw new HeaderFooterContentException(this.type);
                }
            }
        }
        HeaderFooterObject hf = new HeaderFooterObject();
        hf.setHeader(this.type.equalsIgnoreCase("header"));
        hf.setBase64(this.isBase64);
        hf.setAlign(this.align);
        boolean bInch = ((HtmlToPdfTag)this.parentTag).getUnit().equalsIgnoreCase("in");
        if (!bInch) {
            this.marginTop /= 2.54;
            this.marginBottom /= 2.54;
            this.marginLeft /= 2.54;
            this.marginRight /= 2.54;
        }
        hf.setBottomMargin(this.marginBottom);
        hf.setLeftMargin(this.marginLeft);
        hf.setRightMargin(this.marginRight);
        hf.setTopMargin(this.marginTop);
        hf.setNumberFormat(this.numberFormat);
        hf.setOpacity(this.opacity);
        hf.setShowOnPrint(this.showOnPrint);
        if (this.image != null) {
            this.convertImage(this.image);
            hf.setImage(this.image);
        } else {
            hf.setContentProvider((PDFgHFContentProvider)contentProvider);
        }
        if (this.parentTag instanceof HtmlToPdfTag) {
            if (this.type.equalsIgnoreCase("header")) {
                ((HtmlToPdfTag)this.parentTag).setHeader(hf);
            } else {
                ((HtmlToPdfTag)this.parentTag).setFooter(hf);
            }
        }
        if (!this.evalAtPrint && this.fContext != null) {
            DocumentScope docScope = (DocumentScope)this.fContext.hiddenScope.get((Object)"CFHTMLTOPDF");
            docScope.clear();
        }
    }

    private void convertImage(Object image) {
        try {
            this.image = ServiceFactory.getImageService().convertImage(image, this.isBase64, this.pageContext);
        }
        catch (Exception e) {
            throw new EmptyAttributeException(IMAGENAME);
        }
    }

    public void setFunctionName(String funcName) {
        this.funcName = funcName;
    }

    public void release() {
        this.parentTag = null;
        this.type = null;
        this.image = null;
        this.isBase64 = false;
        this.showOnPrint = false;
        this.align = ALIGN_CENTER;
        this.numberFormat = FORMAT_NUMERIC;
        this.marginLeft = 1.0;
        this.marginRight = 1.0;
        this.marginTop = 0.5;
        this.marginBottom = 0.5;
        this.opacity = 10;
        this.evalAtPrint = false;
        this.funcName = null;
        super.release();
    }

    public class HtmlToPdfItemEvalAtPrintValidationException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class HtmlToPdfItemPageBreakException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        HtmlToPdfItemPageBreakException(Throwable ex) {
            super(ex);
        }
    }

    public class HtmlToPdfItemEmptyContentException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class HtmlToPdfItemAttributeValidationException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class HeaderFooterContentException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String content = null;

        public HeaderFooterContentException(String content) {
            this.content = content;
        }
    }

    public class InvalidValueException
    extends PDFDocException {
        private static final long serialVersionUID = 1L;
        public String attrName = null;
        public String attrValue = null;
        public String valueList = null;

        public InvalidValueException(String name, String value, String list) {
            this.attrName = name;
            this.attrValue = value;
            this.valueList = list;
        }
    }

    public class HtmlToPdfInvalidOpacityException
    extends PDFDocException {
        private static final long serialVersionUID = 1L;
        public String attrVal = null;

        public HtmlToPdfInvalidOpacityException(String op) {
            this.attrVal = op;
        }
    }

    public class HtmlToPdfMissingParentTagException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class HtmlToPdfItemInvalidType
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String type = "";

        public HtmlToPdfItemInvalidType(String type) {
            this.type = type;
        }
    }

    public class EmptyAttributeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String attrName = null;

        public EmptyAttributeException(String attrName) {
            this.attrName = attrName;
        }
    }
}

