/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbcx.slbase;

import com.ddtek.jdbc.extensions.ExtEmbeddedConnection;
import com.merant.SlExtensionInterface;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import macromedia.jdbc.extensions.ExtConnection;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbcx.slbase.BaseCallableStatementWrapper;
import macromedia.jdbcx.slbase.BaseDatabaseMetaDataWrapper;
import macromedia.jdbcx.slbase.BaseDependents;
import macromedia.jdbcx.slbase.BasePooledConnection;
import macromedia.jdbcx.slbase.BasePreparedStatementWrapper;
import macromedia.jdbcx.slbase.BaseResultSetWrapper;
import macromedia.jdbcx.slbase.BaseStatementWrapper;

public class BaseConnectionWrapper
implements Connection,
com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection,
ExtEmbeddedConnection,
ExtConnection,
com.ddtek.jdbc.extensions.SlExtensionInterface,
SlExtensionInterface {
    protected BasePooledConnection pooledConnection;
    protected SQLWarning warnings;
    protected BaseDependents statementDependents;
    protected BaseDependents resultSetDependents;
    protected BaseDependents databaseMetaDataDependents;
    BaseExceptions exceptions;

    public final void abortConnection() throws SQLException {
        this.pooledConnection.abortConnection();
        this.pooledConnection.connectionErrorOccurred(this.exceptions.getException(6112));
    }

    public synchronized void close() throws SQLException {
        try {
            this.warnings = this.pooledConnection.getWarnings();
            this.databaseMetaDataDependents.doClose();
            this.pooledConnection.reset(this.statementDependents.getRealObjects(), this.resultSetDependents.getRealObjects());
            this.pooledConnection.clearWarnings();
            this.pooledConnection = null;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    protected BaseConnectionWrapper(BasePooledConnection basePooledConnection, BaseExceptions baseExceptions) {
        this.pooledConnection = basePooledConnection;
        this.exceptions = baseExceptions;
        this.statementDependents = new BaseDependents();
        this.resultSetDependents = new BaseDependents();
        this.databaseMetaDataDependents = new BaseDependents();
    }

    public Statement createStatement() throws SQLException {
        try {
            Statement statement = this.pooledConnection.createStatement();
            BaseStatementWrapper baseStatementWrapper = new BaseStatementWrapper(this, statement);
            this.statementDependents.add(baseStatementWrapper);
            return baseStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.pooledConnection.prepareStatement(string);
            BasePreparedStatementWrapper basePreparedStatementWrapper = new BasePreparedStatementWrapper(this, preparedStatement);
            this.statementDependents.add(basePreparedStatementWrapper);
            return basePreparedStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            CallableStatement callableStatement = this.pooledConnection.prepareCall(string);
            BaseCallableStatementWrapper baseCallableStatementWrapper = new BaseCallableStatementWrapper(this, callableStatement);
            this.statementDependents.add(baseCallableStatementWrapper);
            return baseCallableStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        try {
            return this.pooledConnection.nativeSQL(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setAutoCommit(boolean bl2) throws SQLException {
        try {
            this.pooledConnection.setAutoCommit(bl2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.pooledConnection.getAutoCommit();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void commit() throws SQLException {
        try {
            this.pooledConnection.commit();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void rollback() throws SQLException {
        try {
            this.pooledConnection.rollback();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            return this.pooledConnection.isClosed();
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            DatabaseMetaData databaseMetaData = this.pooledConnection.getMetaData();
            BaseDatabaseMetaDataWrapper baseDatabaseMetaDataWrapper = (BaseDatabaseMetaDataWrapper)this.databaseMetaDataDependents.getDependent(databaseMetaData);
            if (baseDatabaseMetaDataWrapper == null) {
                baseDatabaseMetaDataWrapper = new BaseDatabaseMetaDataWrapper(databaseMetaData, this);
                this.databaseMetaDataDependents.add(baseDatabaseMetaDataWrapper);
            }
            return baseDatabaseMetaDataWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setReadOnly(boolean bl2) throws SQLException {
        try {
            this.pooledConnection.setReadOnly(bl2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.pooledConnection.isReadOnly();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setCatalog(String string) throws SQLException {
        try {
            this.pooledConnection.setCatalog(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        try {
            return this.pooledConnection.getCatalog();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setTransactionIsolation(int n2) throws SQLException {
        try {
            this.pooledConnection.setTransactionIsolation(n2);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.pooledConnection.getTransactionIsolation();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.pooledConnection.getWarnings();
        }
        catch (NullPointerException nullPointerException) {
            return this.warnings;
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.pooledConnection.clearWarnings();
        }
        catch (NullPointerException nullPointerException) {
            this.warnings = null;
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Statement createStatement(int n2, int n3) throws SQLException {
        try {
            Statement statement = this.pooledConnection.createStatement(n2, n3);
            BaseStatementWrapper baseStatementWrapper = new BaseStatementWrapper(this, statement);
            this.statementDependents.add(baseStatementWrapper);
            return baseStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n2, int n3) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.pooledConnection.prepareStatement(string, n2, n3);
            BasePreparedStatementWrapper basePreparedStatementWrapper = new BasePreparedStatementWrapper(this, preparedStatement);
            this.statementDependents.add(basePreparedStatementWrapper);
            return basePreparedStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n2, int n3) throws SQLException {
        try {
            CallableStatement callableStatement = this.pooledConnection.prepareCall(string, n2, n3);
            BaseCallableStatementWrapper baseCallableStatementWrapper = new BaseCallableStatementWrapper(this, callableStatement);
            this.statementDependents.add(baseCallableStatementWrapper);
            return baseCallableStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.pooledConnection.getTypeMap();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.pooledConnection.setTypeMap(map);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    protected SQLException closedException() {
        return this.exceptions.getException(6009);
    }

    public void setHoldability(int n2) throws SQLException {
        try {
            this.pooledConnection.setHoldability(n2);
        }
        catch (NullPointerException nullPointerException) {
            this.warnings = null;
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getHoldability() throws SQLException {
        try {
            return this.pooledConnection.getHoldability();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.pooledConnection.setSavepoint();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        try {
            return this.pooledConnection.setSavepoint(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.pooledConnection.rollback(savepoint);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.pooledConnection.releaseSavepoint(savepoint);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Statement createStatement(int n2, int n3, int n4) throws SQLException {
        try {
            Statement statement = this.pooledConnection.createStatement(n2, n3, n4);
            BaseStatementWrapper baseStatementWrapper = new BaseStatementWrapper(this, statement);
            this.statementDependents.add(baseStatementWrapper);
            return baseStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n2, int n3, int n4) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.pooledConnection.prepareStatement(string, n2, n3, n4);
            BasePreparedStatementWrapper basePreparedStatementWrapper = new BasePreparedStatementWrapper(this, preparedStatement);
            this.statementDependents.add(basePreparedStatementWrapper);
            return basePreparedStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n2, int n3, int n4) throws SQLException {
        try {
            CallableStatement callableStatement = this.pooledConnection.prepareCall(string, n2, n3, n4);
            BaseCallableStatementWrapper baseCallableStatementWrapper = new BaseCallableStatementWrapper(this, callableStatement);
            this.statementDependents.add(baseCallableStatementWrapper);
            return baseCallableStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n2) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.pooledConnection.prepareStatement(string, n2);
            BasePreparedStatementWrapper basePreparedStatementWrapper = new BasePreparedStatementWrapper(this, preparedStatement);
            this.statementDependents.add(basePreparedStatementWrapper);
            return basePreparedStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.pooledConnection.prepareStatement(string, nArray);
            BasePreparedStatementWrapper basePreparedStatementWrapper = new BasePreparedStatementWrapper(this, preparedStatement);
            this.statementDependents.add(basePreparedStatementWrapper);
            return basePreparedStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.pooledConnection.prepareStatement(string, stringArray);
            BasePreparedStatementWrapper basePreparedStatementWrapper = new BasePreparedStatementWrapper(this, preparedStatement);
            this.statementDependents.add(basePreparedStatementWrapper);
            return basePreparedStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean unlock(String string) throws SQLException {
        try {
            return this.pooledConnection.unlock(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setOemId(String string) throws SQLException {
        try {
            this.pooledConnection.setOemId(string);
            return;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setApplicationId(String string) throws SQLException {
        try {
            this.pooledConnection.setApplicationId(string);
            return;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
    }

    public void setClientApplicationName(String string) throws SQLException {
        try {
            this.pooledConnection.setClientApplicationName(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String getClientApplicationName() throws SQLException {
        try {
            return this.pooledConnection.getClientApplicationName();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setClientHostName(String string) throws SQLException {
        try {
            this.pooledConnection.setClientHostName(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String getClientHostName() throws SQLException {
        try {
            return this.pooledConnection.getClientHostName();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setClientUser(String string) throws SQLException {
        try {
            this.pooledConnection.setClientUser(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String getClientUser() throws SQLException {
        try {
            return this.pooledConnection.getClientUser();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setClientAccountingInfo(String string) throws SQLException {
        try {
            this.pooledConnection.setClientAccountingInfo(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String getClientAccountingInfo() throws SQLException {
        try {
            return this.pooledConnection.getClientAccountingInfo();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    void addDependent(BaseResultSetWrapper baseResultSetWrapper) {
        this.resultSetDependents.add(baseResultSetWrapper);
    }

    void notifyStatementGarbage() {
        this.statementDependents.notifyGarbage();
    }

    void notifyResultSetGarbage() {
        this.resultSetDependents.notifyGarbage();
    }

    void notifyMetaDataGarbage() {
        this.databaseMetaDataDependents.notifyGarbage();
    }

    void removeFromDependents(BaseStatementWrapper baseStatementWrapper) {
        this.statementDependents.remove(baseStatementWrapper);
    }

    void removeFromDependents(BaseResultSetWrapper baseResultSetWrapper) {
        this.resultSetDependents.remove(baseResultSetWrapper);
    }

    void removeFromDependents(BaseDatabaseMetaDataWrapper baseDatabaseMetaDataWrapper) {
        this.databaseMetaDataDependents.remove(baseDatabaseMetaDataWrapper);
    }
}

