/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.org.objectweb.asm;

import macromedia.jdbc.sqlserver.externals.org.objectweb.asm.AnnotationVisitor;
import macromedia.jdbc.sqlserver.externals.org.objectweb.asm.AnnotationWriter;
import macromedia.jdbc.sqlserver.externals.org.objectweb.asm.Attribute;
import macromedia.jdbc.sqlserver.externals.org.objectweb.asm.ByteVector;
import macromedia.jdbc.sqlserver.externals.org.objectweb.asm.FieldVisitor;
import macromedia.jdbc.sqlserver.externals.org.objectweb.asm.SymbolTable;
import macromedia.jdbc.sqlserver.externals.org.objectweb.asm.TypePath;

final class FieldWriter
extends FieldVisitor {
    private final SymbolTable symbolTable;
    private final int accessFlags;
    private final int nameIndex;
    private final int descriptorIndex;
    private int signatureIndex;
    private int constantValueIndex;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private Attribute firstAttribute;

    FieldWriter(SymbolTable symbolTable, int n2, String string, String string2, String string3, Object object) {
        super(589824);
        this.symbolTable = symbolTable;
        this.accessFlags = n2;
        this.nameIndex = symbolTable.addConstantUtf8(string);
        this.descriptorIndex = symbolTable.addConstantUtf8(string2);
        if (string3 != null) {
            this.signatureIndex = symbolTable.addConstantUtf8(string3);
        }
        if (object != null) {
            this.constantValueIndex = symbolTable.addConstant((Object)object).index;
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
        if (bl2) {
            this.lastRuntimeVisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl2) {
        if (bl2) {
            this.lastRuntimeVisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2, typePath, string, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2, typePath, string, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = attribute;
    }

    @Override
    public void visitEnd() {
    }

    int computeFieldInfoSize() {
        int n2 = 8;
        if (this.constantValueIndex != 0) {
            this.symbolTable.addConstantUtf8("ConstantValue");
            n2 += 8;
        }
        n2 += Attribute.computeAttributesSize(this.symbolTable, this.accessFlags, this.signatureIndex);
        n2 += AnnotationWriter.computeAnnotationsSize(this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation);
        if (this.firstAttribute != null) {
            n2 += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        return n2;
    }

    void putFieldInfo(ByteVector byteVector) {
        boolean bl2 = this.symbolTable.getMajorVersion() < 49;
        int n2 = bl2 ? 4096 : 0;
        byteVector.putShort(this.accessFlags & ~n2).putShort(this.nameIndex).putShort(this.descriptorIndex);
        int n3 = 0;
        if (this.constantValueIndex != 0) {
            ++n3;
        }
        if ((this.accessFlags & 0x1000) != 0 && bl2) {
            ++n3;
        }
        if (this.signatureIndex != 0) {
            ++n3;
        }
        if ((this.accessFlags & 0x20000) != 0) {
            ++n3;
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++n3;
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++n3;
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++n3;
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++n3;
        }
        if (this.firstAttribute != null) {
            n3 += this.firstAttribute.getAttributeCount();
        }
        byteVector.putShort(n3);
        if (this.constantValueIndex != 0) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("ConstantValue")).putInt(2).putShort(this.constantValueIndex);
        }
        Attribute.putAttributes(this.symbolTable, this.accessFlags, this.signatureIndex, byteVector);
        AnnotationWriter.putAnnotations(this.symbolTable, this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation, byteVector);
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, byteVector);
        }
    }

    final void collectAttributePrototypes(Attribute.Set set) {
        set.addAttributes(this.firstAttribute);
    }
}

