/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.net.minidev.json.writer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.net.minidev.asm.BeansAccess;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONUtil;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.JsonReader;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.JsonReaderI;

public class CollectionMapper {

    public static class ListClass<T>
    extends JsonReaderI<T> {
        final Class<?> type;
        final Class<?> instance;
        final BeansAccess<?> ba;
        JsonReaderI<?> subMapper;

        public ListClass(JsonReader jsonReader, Class<?> clazz) {
            super(jsonReader);
            this.type = clazz;
            this.instance = clazz.isInterface() ? JSONArray.class : clazz;
            this.ba = BeansAccess.get(this.instance, JSONUtil.JSON_SMART_FIELD_FILTER);
        }

        @Override
        public Object createArray() {
            return this.ba.newInstance();
        }

        @Override
        public JsonReaderI<?> startArray(String string) {
            return this.base.DEFAULT;
        }

        @Override
        public JsonReaderI<?> startObject(String string) {
            return this.base.DEFAULT;
        }

        @Override
        public void addValue(Object object, Object object2) {
            ((List)object).add(object2);
        }
    }

    public static class ListType<T>
    extends JsonReaderI<T> {
        final ParameterizedType type;
        final Class<?> rawClass;
        final Class<?> instance;
        final BeansAccess<?> ba;
        final Type valueType;
        final Class<?> valueClass;
        JsonReaderI<?> subMapper;

        public ListType(JsonReader jsonReader, ParameterizedType parameterizedType) {
            super(jsonReader);
            this.type = parameterizedType;
            this.rawClass = (Class)parameterizedType.getRawType();
            this.instance = this.rawClass.isInterface() ? JSONArray.class : this.rawClass;
            this.ba = BeansAccess.get(this.instance, JSONUtil.JSON_SMART_FIELD_FILTER);
            this.valueType = parameterizedType.getActualTypeArguments()[0];
            this.valueClass = this.valueType instanceof Class ? (Class)this.valueType : (Class)((ParameterizedType)this.valueType).getRawType();
        }

        @Override
        public Object createArray() {
            return this.ba.newInstance();
        }

        @Override
        public JsonReaderI<?> startArray(String string) {
            if (this.subMapper == null) {
                this.subMapper = this.base.getMapper(this.type.getActualTypeArguments()[0]);
            }
            return this.subMapper;
        }

        @Override
        public JsonReaderI<?> startObject(String string) {
            if (this.subMapper == null) {
                this.subMapper = this.base.getMapper(this.type.getActualTypeArguments()[0]);
            }
            return this.subMapper;
        }

        @Override
        public void addValue(Object object, Object object2) {
            ((List)object).add(JSONUtil.convertToX(object2, this.valueClass));
        }
    }

    public static class MapClass<T>
    extends JsonReaderI<T> {
        final Class<?> type;
        final Class<?> instance;
        final BeansAccess<?> ba;
        JsonReaderI<?> subMapper;

        public MapClass(JsonReader jsonReader, Class<?> clazz) {
            super(jsonReader);
            this.type = clazz;
            this.instance = clazz.isInterface() ? JSONObject.class : clazz;
            this.ba = BeansAccess.get(this.instance, JSONUtil.JSON_SMART_FIELD_FILTER);
        }

        @Override
        public Object createObject() {
            return this.ba.newInstance();
        }

        @Override
        public JsonReaderI<?> startArray(String string) {
            return this.base.DEFAULT;
        }

        @Override
        public JsonReaderI<?> startObject(String string) {
            return this.base.DEFAULT;
        }

        @Override
        public void setValue(Object object, String string, Object object2) {
            ((Map)object).put(string, object2);
        }

        @Override
        public Object getValue(Object object, String string) {
            return ((Map)object).get(string);
        }

        @Override
        public Type getType(String string) {
            return this.type;
        }
    }

    public static class MapType<T>
    extends JsonReaderI<T> {
        final ParameterizedType type;
        final Class<?> rawClass;
        final Class<?> instance;
        final BeansAccess<?> ba;
        final Type keyType;
        final Type valueType;
        final Class<?> keyClass;
        final Class<?> valueClass;
        JsonReaderI<?> subMapper;

        public MapType(JsonReader jsonReader, ParameterizedType parameterizedType) {
            super(jsonReader);
            this.type = parameterizedType;
            this.rawClass = (Class)parameterizedType.getRawType();
            this.instance = this.rawClass.isInterface() ? JSONObject.class : this.rawClass;
            this.ba = BeansAccess.get(this.instance, JSONUtil.JSON_SMART_FIELD_FILTER);
            this.keyType = parameterizedType.getActualTypeArguments()[0];
            this.valueType = parameterizedType.getActualTypeArguments()[1];
            this.keyClass = this.keyType instanceof Class ? (Class)this.keyType : (Class)((ParameterizedType)this.keyType).getRawType();
            this.valueClass = this.valueType instanceof Class ? (Class)this.valueType : (Class)((ParameterizedType)this.valueType).getRawType();
        }

        @Override
        public Object createObject() {
            try {
                return this.instance.newInstance();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }

        @Override
        public JsonReaderI<?> startArray(String string) {
            if (this.subMapper == null) {
                this.subMapper = this.base.getMapper(this.valueType);
            }
            return this.subMapper;
        }

        @Override
        public JsonReaderI<?> startObject(String string) {
            if (this.subMapper == null) {
                this.subMapper = this.base.getMapper(this.valueType);
            }
            return this.subMapper;
        }

        @Override
        public void setValue(Object object, String string, Object object2) {
            ((Map)object).put(JSONUtil.convertToX(string, this.keyClass), JSONUtil.convertToX(object2, this.valueClass));
        }

        @Override
        public Object getValue(Object object, String string) {
            return ((Map)object).get(JSONUtil.convertToX(string, this.keyClass));
        }

        @Override
        public Type getType(String string) {
            return this.type;
        }
    }
}

