/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.net.minidev.asm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.sqlserver.externals.net.minidev.asm.ASMUtil;
import macromedia.jdbc.sqlserver.externals.net.minidev.asm.Accessor;
import macromedia.jdbc.sqlserver.externals.net.minidev.asm.BeansAccessBuilder;
import macromedia.jdbc.sqlserver.externals.net.minidev.asm.BeansAccessConfig;
import macromedia.jdbc.sqlserver.externals.net.minidev.asm.DynamicClassLoader;
import macromedia.jdbc.sqlserver.externals.net.minidev.asm.FieldFilter;
import macromedia.jdbc.sqlserver.externals.net.minidev.asm.ex.NoSuchFieldException;

public abstract class BeansAccess<T> {
    private HashMap<String, Accessor> map;
    private Accessor[] accs;
    private static ConcurrentHashMap<Class<?>, BeansAccess<?>> cache = new ConcurrentHashMap();

    protected void setAccessor(Accessor[] accessorArray) {
        int n2 = 0;
        this.accs = accessorArray;
        this.map = new HashMap();
        for (Accessor accessor : accessorArray) {
            accessor.index = n2++;
            this.map.put(accessor.getName(), accessor);
        }
    }

    public HashMap<String, Accessor> getMap() {
        return this.map;
    }

    public Accessor[] getAccessors() {
        return this.accs;
    }

    public static <P> BeansAccess<P> get(Class<P> clazz) {
        return BeansAccess.get(clazz, null);
    }

    public static <P> BeansAccess<P> get(Class<P> clazz, FieldFilter fieldFilter) {
        Object object;
        Accessor[] accessorArray = cache.get(clazz);
        if (accessorArray != null) {
            return accessorArray;
        }
        accessorArray = ASMUtil.getAccessors(clazz, fieldFilter);
        String string = clazz.getName();
        String string2 = string.startsWith("java.util.") ? "macromedia.jdbc.sqlserver.externals.net.minidev.asm." + string + "AccAccess" : string.concat("AccAccess");
        DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(clazz.getClassLoader());
        Class<?> clazz2 = null;
        try {
            clazz2 = dynamicClassLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        LinkedList<Class<P>> linkedList = BeansAccess.getParents(clazz);
        if (clazz2 == null) {
            object = new BeansAccessBuilder(clazz, accessorArray, dynamicClassLoader);
            for (Class clazz3 : linkedList) {
                ((BeansAccessBuilder)object).addConversion((Iterable)BeansAccessConfig.classMapper.get(clazz3));
            }
            clazz2 = ((BeansAccessBuilder)object).bulid();
        }
        try {
            object = (BeansAccess)clazz2.newInstance();
            ((BeansAccess)object).setAccessor(accessorArray);
            cache.putIfAbsent(clazz, (BeansAccess<?>)object);
            for (Class clazz3 : linkedList) {
                BeansAccess.addAlias(object, BeansAccessConfig.classFiledNameMapper.get(clazz3));
            }
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error constructing accessor class: " + string2, exception);
        }
    }

    private static LinkedList<Class<?>> getParents(Class<?> clazz) {
        LinkedList linkedList = new LinkedList();
        while (clazz != null && !clazz.equals(Object.class)) {
            linkedList.addLast(clazz);
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                linkedList.addLast(clazz2);
            }
            clazz = clazz.getSuperclass();
        }
        linkedList.addLast(Object.class);
        return linkedList;
    }

    private static void addAlias(BeansAccess<?> beansAccess, HashMap<String, String> hashMap) {
        if (hashMap == null) {
            return;
        }
        HashMap<String, Accessor> hashMap2 = new HashMap<String, Accessor>();
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            Accessor accessor = beansAccess.map.get(entry.getValue());
            if (accessor == null) continue;
            hashMap2.put(entry.getValue(), accessor);
        }
        beansAccess.map.putAll(hashMap2);
    }

    public abstract void set(T var1, int var2, Object var3);

    public abstract Object get(T var1, int var2);

    public abstract T newInstance();

    public void set(T t2, String string, Object object) {
        int n2 = this.getIndex(string);
        if (n2 == -1) {
            throw new NoSuchFieldException(string + " in " + t2.getClass() + " to put value : " + object);
        }
        this.set(t2, n2, object);
    }

    public Object get(T t2, String string) {
        return this.get(t2, this.getIndex(string));
    }

    public int getIndex(String string) {
        Accessor accessor = this.map.get(string);
        if (accessor == null) {
            return -1;
        }
        return accessor.index;
    }
}

