/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GeneralException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.CIBARequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ACR;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class ACRRequest {
    private final List<ACR> essentialACRs;
    private final List<ACR> voluntaryACRs;

    public ACRRequest(List<ACR> list, List<ACR> list2) {
        this.essentialACRs = list;
        this.voluntaryACRs = list2;
    }

    public List<ACR> getEssentialACRs() {
        return this.essentialACRs;
    }

    public List<ACR> getVoluntaryACRs() {
        return this.voluntaryACRs;
    }

    public boolean isEmpty() {
        return !(this.essentialACRs != null && !this.essentialACRs.isEmpty() || this.voluntaryACRs != null && !this.voluntaryACRs.isEmpty());
    }

    public ACRRequest applyDefaultACRs(OIDCClientInformation oIDCClientInformation) {
        if (this.isEmpty() && oIDCClientInformation.getOIDCMetadata().getDefaultACRs() != null) {
            LinkedList<ACR> linkedList = new LinkedList<ACR>(oIDCClientInformation.getOIDCMetadata().getDefaultACRs());
            return new ACRRequest(null, linkedList);
        }
        return this;
    }

    public void ensureACRSupport(AuthorizationRequest authorizationRequest, List<ACR> list) throws GeneralException {
        if (this.getEssentialACRs() != null) {
            boolean bl2 = false;
            for (ACR aCR : this.getEssentialACRs()) {
                if (list == null || !list.contains(aCR)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                String string = "Requested essential ACR(s) not supported";
                throw new GeneralException(string, OAuth2Error.ACCESS_DENIED.appendDescription(": " + (String)string), authorizationRequest.getClientID(), authorizationRequest.getRedirectionURI(), authorizationRequest.impliedResponseMode(), authorizationRequest.getState());
            }
        }
    }

    @Deprecated
    public void ensureACRSupport(AuthenticationRequest authenticationRequest, OIDCProviderMetadata oIDCProviderMetadata) throws GeneralException {
        this.ensureACRSupport((AuthorizationRequest)authenticationRequest, oIDCProviderMetadata.getACRs());
    }

    public static ACRRequest resolve(AuthorizationRequest authorizationRequest) {
        if (!(authorizationRequest instanceof AuthenticationRequest)) {
            return new ACRRequest(null, null);
        }
        AuthenticationRequest authenticationRequest = (AuthenticationRequest)authorizationRequest;
        return ACRRequest.resolve(authenticationRequest.getACRValues(), authenticationRequest.getOIDCClaims());
    }

    public static ACRRequest resolve(CIBARequest cIBARequest) {
        if (cIBARequest.isSigned()) {
            throw new IllegalArgumentException("The CIBA request must be resolved (not signed)");
        }
        if (cIBARequest.getScope() != null && !cIBARequest.getScope().contains(OIDCScopeValue.OPENID)) {
            return new ACRRequest(null, null);
        }
        return ACRRequest.resolve(cIBARequest.getACRValues(), cIBARequest.getOIDCClaims());
    }

    private static ClaimsSetRequest.Entry getACRClaimRequest(OIDCClaimsRequest oIDCClaimsRequest) {
        if (oIDCClaimsRequest == null) {
            return null;
        }
        ClaimsSetRequest claimsSetRequest = oIDCClaimsRequest.getIDTokenClaimsRequest();
        if (claimsSetRequest == null) {
            return null;
        }
        for (ClaimsSetRequest.Entry entry : claimsSetRequest.getEntries()) {
            if (!"acr".equals(entry.getClaimName())) continue;
            return entry;
        }
        return null;
    }

    public static ACRRequest resolve(List<ACR> list, OIDCClaimsRequest oIDCClaimsRequest) {
        ArrayList<ACR> arrayList = null;
        ArrayList<ACR> arrayList2 = null;
        ClaimsSetRequest.Entry entry = ACRRequest.getACRClaimRequest(oIDCClaimsRequest);
        if (entry != null) {
            if (entry.getClaimRequirement().equals((Object)ClaimRequirement.ESSENTIAL)) {
                arrayList = new ArrayList<ACR>();
                if (entry.getValueAsString() != null) {
                    arrayList.add(new ACR(entry.getValueAsString()));
                }
                if (entry.getValuesAsListOfStrings() != null) {
                    for (String string : entry.getValuesAsListOfStrings()) {
                        arrayList.add(new ACR(string));
                    }
                }
            } else {
                arrayList2 = new ArrayList();
                if (entry.getValueAsString() != null) {
                    arrayList2.add(new ACR(entry.getValueAsString()));
                }
                if (entry.getValuesAsListOfStrings() != null) {
                    for (String string : entry.getValuesAsListOfStrings()) {
                        arrayList2.add(new ACR(string));
                    }
                }
            }
        }
        if (list != null) {
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<ACR>();
            }
            arrayList2.addAll(list);
        }
        return new ACRRequest(arrayList, (List<ACR>)arrayList2);
    }
}

