/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.constraints;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.constraints.EntityIDConstraint;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public final class TrustChainConstraints
implements JSONAware {
    public static final TrustChainConstraints NO_CONSTRAINTS = new TrustChainConstraints();
    private final int maxPathLength;
    private final List<EntityIDConstraint> permittedEntities;
    private final List<EntityIDConstraint> excludedEntities;

    public TrustChainConstraints() {
        this(-1, null, null);
    }

    public TrustChainConstraints(int n2) {
        this(n2, null, null);
    }

    public TrustChainConstraints(int n2, List<EntityIDConstraint> list, List<EntityIDConstraint> list2) {
        this.maxPathLength = n2;
        this.permittedEntities = list != null ? list : Collections.emptyList();
        this.excludedEntities = list2 != null ? list2 : Collections.emptyList();
    }

    public boolean isPermitted(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The path length must not be negative");
        }
        return this.getMaxPathLength() <= -1 || n2 <= this.getMaxPathLength();
    }

    public boolean isPermitted(EntityID entityID) {
        if (this.getExcludedEntities().isEmpty() && this.getPermittedEntities().isEmpty()) {
            return true;
        }
        if (!this.getExcludedEntities().isEmpty()) {
            for (EntityIDConstraint entityIDConstraint : this.getExcludedEntities()) {
                if (!entityIDConstraint.matches(entityID)) continue;
                return false;
            }
        }
        if (!this.getPermittedEntities().isEmpty()) {
            for (EntityIDConstraint entityIDConstraint : this.getPermittedEntities()) {
                if (!entityIDConstraint.matches(entityID)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean isPermitted(int n2, EntityID entityID) {
        return this.isPermitted(n2) && this.isPermitted(entityID);
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public List<EntityIDConstraint> getPermittedEntities() {
        return this.permittedEntities;
    }

    public List<EntityIDConstraint> getExcludedEntities() {
        return this.excludedEntities;
    }

    public JSONObject toJSONObject() {
        LinkedList<String> linkedList;
        JSONObject jSONObject = new JSONObject();
        if (this.maxPathLength > -1) {
            jSONObject.put("max_path_length", this.maxPathLength);
        }
        JSONObject jSONObject2 = new JSONObject();
        if (CollectionUtils.isNotEmpty(this.permittedEntities)) {
            linkedList = new LinkedList<String>();
            for (EntityIDConstraint entityIDConstraint : this.permittedEntities) {
                linkedList.add(entityIDConstraint.toString());
            }
            jSONObject2.put("permitted", linkedList);
        }
        if (CollectionUtils.isNotEmpty(this.excludedEntities)) {
            linkedList = new LinkedList();
            for (EntityIDConstraint entityIDConstraint : this.excludedEntities) {
                linkedList.add(entityIDConstraint.toString());
            }
            jSONObject2.put("excluded", linkedList);
        }
        if (!jSONObject2.isEmpty()) {
            jSONObject.put("naming_constraints", jSONObject2);
        }
        return jSONObject;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TrustChainConstraints)) {
            return false;
        }
        TrustChainConstraints trustChainConstraints = (TrustChainConstraints)object;
        return this.getMaxPathLength() == trustChainConstraints.getMaxPathLength() && Objects.equals(this.getPermittedEntities(), trustChainConstraints.getPermittedEntities()) && Objects.equals(this.getExcludedEntities(), trustChainConstraints.getExcludedEntities());
    }

    public int hashCode() {
        return Objects.hash(this.getMaxPathLength(), this.getPermittedEntities(), this.getExcludedEntities());
    }

    public static TrustChainConstraints parse(JSONObject jSONObject) throws ParseException {
        int n2 = JSONObjectUtils.getInt(jSONObject, "max_path_length", -1);
        JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, "naming_constraints", new JSONObject());
        LinkedList<EntityIDConstraint> linkedList = null;
        List<String> list = JSONObjectUtils.getStringList(jSONObject2, "permitted", null);
        if (list != null) {
            linkedList = new LinkedList<EntityIDConstraint>();
            for (String object : list) {
                if (object == null) continue;
                linkedList.add(EntityIDConstraint.parse(object));
            }
        }
        Object object = null;
        list = JSONObjectUtils.getStringList(jSONObject2, "excluded", null);
        if (list != null) {
            object = new LinkedList();
            for (String string : list) {
                if (string == null) continue;
                object.add(EntityIDConstraint.parse(string));
            }
        }
        return new TrustChainConstraints(n2, linkedList, (List<EntityIDConstraint>)object);
    }
}

