/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.registration;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AbstractRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class ExplicitClientRegistrationRequest
extends AbstractRequest {
    private final EntityStatement entityStatement;

    public ExplicitClientRegistrationRequest(URI uRI, EntityStatement entityStatement) {
        super(uRI);
        this.entityStatement = entityStatement;
    }

    public EntityStatement getEntityStatement() {
        return this.entityStatement;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_JOSE);
        hTTPRequest.setQuery(this.getEntityStatement().getSignedStatement().serialize());
        return hTTPRequest;
    }

    public static ExplicitClientRegistrationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        SignedJWT signedJWT;
        URI uRI = hTTPRequest.getURI();
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_JOSE);
        String string = hTTPRequest.getQuery();
        if (StringUtils.isBlank(string)) {
            throw new ParseException("Missing entity body");
        }
        try {
            signedJWT = SignedJWT.parse(string);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException("Invalid entity statement: " + parseException.getMessage(), parseException);
        }
        return new ExplicitClientRegistrationRequest(uRI, EntityStatement.parse(signedJWT));
    }
}

