/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations;

import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.OperationName;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.DefaultOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.EssentialOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.OneOfOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.PolicyOperationCombinationValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.SubsetOfOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.SupersetOfOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.Utils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.ValueOperation;

public class DefaultPolicyOperationCombinationValidator
implements PolicyOperationCombinationValidator {
    @Override
    public List<PolicyOperation> validate(List<PolicyOperation> list) throws PolicyViolationException {
        if (CollectionUtils.isEmpty(list) || list.size() == 1) {
            return list;
        }
        List<PolicyOperation> list2 = new LinkedList<PolicyOperation>(list);
        list2 = DefaultPolicyOperationCombinationValidator.validateCombinationsOfEssential(list2);
        list2 = DefaultPolicyOperationCombinationValidator.validateCombinationsOfAdd(list2);
        list2 = DefaultPolicyOperationCombinationValidator.validateCombinationsOfDefault(list2);
        list2 = DefaultPolicyOperationCombinationValidator.validateCombinationsOfSupersetOf(list2);
        list2 = DefaultPolicyOperationCombinationValidator.validateCombinationsOfSubsetOf(list2);
        list2 = DefaultPolicyOperationCombinationValidator.validateCombinationsOfValue(list2);
        return list2;
    }

    private static List<PolicyOperation> validateCombinationsOfEssential(List<PolicyOperation> list) {
        return list;
    }

    private static List<PolicyOperation> validateCombinationsOfAdd(List<PolicyOperation> list) {
        return list;
    }

    private static List<PolicyOperation> validateCombinationsOfDefault(List<PolicyOperation> list) throws PolicyViolationException {
        DefaultOperation defaultOperation = Utils.getPolicyOperationByType(list, DefaultOperation.class);
        if (defaultOperation == null) {
            return list;
        }
        if (defaultOperation.getStringListConfiguration() != null) {
            DefaultPolicyOperationCombinationValidator.ensureSatisfiedBySubsetOf(list, defaultOperation.getStringListConfiguration());
            DefaultPolicyOperationCombinationValidator.ensureSatisfiedBySupersetOf(list, defaultOperation.getStringListConfiguration());
        } else if (defaultOperation.getStringConfiguration() != null) {
            DefaultPolicyOperationCombinationValidator.ensureSatisfiedByOneOf(list, defaultOperation.getStringConfiguration());
        }
        if (Utils.getPolicyOperationByType(list, ValueOperation.class) != null) {
            throw new PolicyViolationException("Policies default and value cannot be combined");
        }
        return list;
    }

    private static List<PolicyOperation> validateCombinationsOfSupersetOf(List<PolicyOperation> list) throws PolicyViolationException {
        SupersetOfOperation supersetOfOperation = Utils.getPolicyOperationByType(list, SupersetOfOperation.class);
        if (supersetOfOperation == null) {
            return list;
        }
        SubsetOfOperation subsetOfOperation = Utils.getPolicyOperationByType(list, SubsetOfOperation.class);
        if (subsetOfOperation != null) {
            DefaultPolicyOperationCombinationValidator.ensureSatisfied(supersetOfOperation, (List<String>)subsetOfOperation.getStringListConfiguration());
        }
        return list;
    }

    private static List<PolicyOperation> validateCombinationsOfSubsetOf(List<PolicyOperation> list) throws PolicyViolationException {
        SubsetOfOperation subsetOfOperation = Utils.getPolicyOperationByType(list, SubsetOfOperation.class);
        if (subsetOfOperation == null) {
            return list;
        }
        SupersetOfOperation supersetOfOperation = Utils.getPolicyOperationByType(list, SupersetOfOperation.class);
        if (supersetOfOperation != null) {
            DefaultPolicyOperationCombinationValidator.ensureSatisfied(supersetOfOperation, (List<String>)subsetOfOperation.getStringListConfiguration());
        }
        return list;
    }

    private static List<PolicyOperation> validateCombinationsOfValue(List<PolicyOperation> list) throws PolicyViolationException {
        ValueOperation valueOperation = Utils.getPolicyOperationByType(list, ValueOperation.class);
        if (valueOperation == null) {
            return list;
        }
        LinkedList<OperationName> linkedList = new LinkedList<OperationName>();
        for (PolicyOperation policyOperation : list) {
            if (policyOperation instanceof ValueOperation || policyOperation instanceof EssentialOperation) continue;
            linkedList.add(policyOperation.getOperationName());
        }
        if (!linkedList.isEmpty()) {
            throw new PolicyViolationException("Policy operation " + ValueOperation.NAME + " must not be combined with: " + linkedList);
        }
        return list;
    }

    private static void ensureSatisfied(SubsetOfOperation subsetOfOperation, List<String> list) throws PolicyViolationException {
        if (!subsetOfOperation.getStringListConfiguration().containsAll(list)) {
            throw new PolicyViolationException("Not in " + SubsetOfOperation.NAME + " " + subsetOfOperation.getStringListConfiguration() + ": " + list);
        }
    }

    private static void ensureSatisfiedBySubsetOf(List<PolicyOperation> list, List<String> list2) throws PolicyViolationException {
        SubsetOfOperation subsetOfOperation = Utils.getPolicyOperationByType(list, SubsetOfOperation.class);
        if (subsetOfOperation != null) {
            DefaultPolicyOperationCombinationValidator.ensureSatisfied(subsetOfOperation, list2);
        }
    }

    private static void ensureSatisfied(SupersetOfOperation supersetOfOperation, List<String> list) throws PolicyViolationException {
        if (!list.containsAll(supersetOfOperation.getStringListConfiguration())) {
            throw new PolicyViolationException("Not in " + SupersetOfOperation.NAME + " " + supersetOfOperation.getStringListConfiguration() + ": " + list);
        }
    }

    private static void ensureSatisfiedBySupersetOf(List<PolicyOperation> list, List<String> list2) throws PolicyViolationException {
        SupersetOfOperation supersetOfOperation = Utils.getPolicyOperationByType(list, SupersetOfOperation.class);
        if (supersetOfOperation != null) {
            DefaultPolicyOperationCombinationValidator.ensureSatisfied(supersetOfOperation, list2);
        }
    }

    private static void ensureSatisfiedByOneOf(List<PolicyOperation> list, String string) throws PolicyViolationException {
        OneOfOperation oneOfOperation = Utils.getPolicyOperationByType(list, OneOfOperation.class);
        if (oneOfOperation == null) {
            return;
        }
        if (!oneOfOperation.getStringListConfiguration().contains(string)) {
            throw new PolicyViolationException("Not in " + OneOfOperation.NAME + " " + oneOfOperation.getStringListConfiguration() + ": " + string);
        }
    }
}

