/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.claims.CountryCode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.Jurisdiction;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.Name;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.Address;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

class CommonOriginatorAttributes {
    private final Name name;
    private final Address address;
    private final CountryCode countryCode;
    private final Jurisdiction jurisdiction;

    public CommonOriginatorAttributes(Name name, Address address, CountryCode countryCode, Jurisdiction jurisdiction) {
        this.name = name;
        this.address = address;
        this.countryCode = countryCode;
        this.jurisdiction = jurisdiction;
    }

    public Name getName() {
        return this.name;
    }

    public Address getAddress() {
        return this.address;
    }

    public CountryCode getCountryCode() {
        return this.countryCode;
    }

    public Jurisdiction getJurisdiction() {
        return this.jurisdiction;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        if (this.getName() != null) {
            jSONObject.put("name", this.getName().getValue());
        }
        if (this.getAddress() != null) {
            jSONObject.putAll(this.getAddress().toJSONObject());
        }
        if (this.getCountryCode() != null) {
            jSONObject.put("country_code", this.getCountryCode().getValue());
        }
        if (this.getJurisdiction() != null) {
            jSONObject.put("jurisdiction", this.getJurisdiction().getValue());
        }
        return jSONObject;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getAddress(), this.getCountryCode(), this.getJurisdiction());
    }

    static CommonOriginatorAttributes parse(JSONObject jSONObject) throws ParseException {
        try {
            Name name = null;
            if (jSONObject.get("name") != null) {
                name = new Name(JSONObjectUtils.getString(jSONObject, "name"));
            }
            CountryCode countryCode = null;
            if (jSONObject.get("country_code") != null) {
                countryCode = CountryCode.parse(JSONObjectUtils.getString(jSONObject, "country_code"));
            }
            Jurisdiction jurisdiction = null;
            if (jSONObject.get("jurisdiction") != null) {
                jurisdiction = new Jurisdiction(JSONObjectUtils.getString(jSONObject, "jurisdiction"));
            }
            Address address = null;
            if (CollectionUtils.intersect(Address.getStandardClaimNames(), jSONObject.keySet())) {
                JSONObject jSONObject2 = new JSONObject(jSONObject);
                jSONObject2.remove("name");
                jSONObject2.remove("country_code");
                jSONObject2.remove("jurisdiction");
                address = new Address(jSONObject2);
            }
            return new CommonOriginatorAttributes(name, address, countryCode, jurisdiction);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }
}

