/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONValue;

public class Identifier
implements JSONAware,
Serializable,
Comparable<Identifier> {
    private static final long serialVersionUID = 365052911829193101L;
    public static final int DEFAULT_BYTE_LENGTH = 32;
    protected static final SecureRandom secureRandom = new SecureRandom();
    private final String value;

    public static List<String> toStringList(Collection<? extends Identifier> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (Identifier identifier : collection) {
            arrayList.add(identifier.getValue());
        }
        return arrayList;
    }

    public Identifier(String string) {
        if (StringUtils.isBlank(string)) {
            throw new IllegalArgumentException("The value must not be null or empty string");
        }
        this.value = string;
    }

    public Identifier(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("The byte length must be a positive integer");
        }
        byte[] byArray = new byte[n2];
        secureRandom.nextBytes(byArray);
        this.value = Base64URL.encode(byArray).toString();
    }

    public Identifier() {
        this(32);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toJSONString() {
        return "\"" + JSONValue.escape(this.value) + '\"';
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public int compareTo(Identifier identifier) {
        return this.getValue().compareTo(identifier.getValue());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Identifier identifier = (Identifier)object;
        return this.getValue() != null ? this.getValue().equals(identifier.getValue()) : identifier.getValue() == null;
    }

    public int hashCode() {
        return this.getValue() != null ? this.getValue().hashCode() : 0;
    }
}

