/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id;

import java.io.Serializable;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public final class Actor
implements JSONAware,
Serializable,
Comparable<Actor> {
    private static final long serialVersionUID = 4171395610729169757L;
    private final Subject subject;
    private final Issuer issuer;
    private final Actor parent;

    public Actor(Subject subject) {
        this(subject, null, null);
    }

    public Actor(Subject subject, Issuer issuer, Actor actor) {
        if (subject == null) {
            throw new IllegalArgumentException("The subject must not be null");
        }
        this.subject = subject;
        this.issuer = issuer;
        this.parent = actor;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public Actor getParent() {
        return this.parent;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("sub", this.subject.getValue());
        if (this.issuer != null) {
            jSONObject.put("iss", this.issuer.getValue());
        }
        if (this.parent != null) {
            jSONObject.put("act", this.parent.toJSONObject());
        }
        return jSONObject;
    }

    @Override
    public int compareTo(Actor actor) {
        return this.toJSONString().compareTo(actor.toJSONString());
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public String toString() {
        return this.toJSONString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Actor)) {
            return false;
        }
        Actor actor = (Actor)object;
        return this.getSubject().equals(actor.getSubject()) && Objects.equals(this.getIssuer(), actor.getIssuer()) && Objects.equals(this.getParent(), actor.getParent());
    }

    public int hashCode() {
        return Objects.hash(this.getSubject(), this.getIssuer(), this.getParent());
    }

    public static Actor parse(JSONObject jSONObject) throws ParseException {
        Subject subject = new Subject(JSONObjectUtils.getString(jSONObject, "sub"));
        Issuer issuer = null;
        if (jSONObject.containsKey("iss")) {
            issuer = new Issuer(JSONObjectUtils.getString(jSONObject, "iss"));
        }
        Actor actor = Actor.parseTopLevel(jSONObject);
        return new Actor(subject, issuer, actor);
    }

    public static Actor parseTopLevel(JSONObject jSONObject) throws ParseException {
        JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, "act", null);
        if (jSONObject2 == null) {
            return null;
        }
        return Actor.parse(jSONObject2);
    }
}

