/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@ThreadSafe
public class HTTPRequest
extends HTTPMessage {
    private final Method method;
    private final URL url;
    private String query = null;
    private String fragment = null;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private Proxy proxy = null;
    private boolean followRedirects = true;
    private X509Certificate clientX509Certificate = null;
    private String clientX509CertificateSubjectDN = null;
    private String clientX509CertificateRootDN = null;
    private HostnameVerifier hostnameVerifier = null;
    private SSLSocketFactory sslSocketFactory = null;
    private static HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
    private static SSLSocketFactory defaultSSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();

    public HTTPRequest(Method method, URL uRL) {
        if (method == null) {
            throw new IllegalArgumentException("The HTTP method must not be null");
        }
        this.method = method;
        if (uRL == null) {
            throw new IllegalArgumentException("The HTTP URL must not be null");
        }
        this.url = uRL;
    }

    public HTTPRequest(Method method, URI uRI) {
        this(method, HTTPRequest.toURLWithUncheckedException(uRI));
    }

    private static URL toURLWithUncheckedException(URI uRI) {
        try {
            return uRI.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            throw new SerializeException(exception.getMessage(), exception);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public URL getURL() {
        return this.url;
    }

    public URI getURI() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public void ensureMethod(Method method) throws ParseException {
        if (this.method != method) {
            throw new ParseException("The HTTP request method must be " + (Object)((Object)method));
        }
    }

    public String getAuthorization() {
        return this.getHeaderValue("Authorization");
    }

    public void setAuthorization(String string) {
        this.setHeader("Authorization", new String[]{string});
    }

    public SignedJWT getDPoP() {
        try {
            return this.getPoPWithException();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public SignedJWT getPoPWithException() throws ParseException {
        String string = this.getHeaderValue("DPoP");
        if (string == null) {
            return null;
        }
        try {
            return SignedJWT.parse(string);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException.getMessage(), parseException);
        }
    }

    public void setDPoP(SignedJWT signedJWT) {
        if (signedJWT != null) {
            this.setHeader("DPoP", new String[]{signedJWT.serialize()});
        } else {
            this.setHeader("DPoP", null);
        }
    }

    public String getAccept() {
        return this.getHeaderValue("Accept");
    }

    public void setAccept(String string) {
        this.setHeader("Accept", new String[]{string});
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    private void ensureQuery() throws ParseException {
        if (this.query == null || this.query.trim().isEmpty()) {
            throw new ParseException("Missing or empty HTTP query string / entity body");
        }
    }

    public Map<String, List<String>> getQueryParameters() {
        return URLUtils.parseParameters(this.query);
    }

    public JSONObject getQueryAsJSONObject() throws ParseException {
        this.ensureEntityContentType(ContentType.APPLICATION_JSON);
        this.ensureQuery();
        return JSONObjectUtils.parse(this.query);
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String string) {
        this.fragment = string;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The HTTP connect timeout must be zero or positive");
        }
        this.connectTimeout = n2;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The HTTP response read timeout must be zero or positive");
        }
        this.readTimeout = n2;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean bl2) {
        this.followRedirects = bl2;
    }

    public X509Certificate getClientX509Certificate() {
        return this.clientX509Certificate;
    }

    public void setClientX509Certificate(X509Certificate x509Certificate) {
        this.clientX509Certificate = x509Certificate;
    }

    public String getClientX509CertificateSubjectDN() {
        return this.clientX509CertificateSubjectDN;
    }

    public void setClientX509CertificateSubjectDN(String string) {
        this.clientX509CertificateSubjectDN = string;
    }

    public String getClientX509CertificateRootDN() {
        return this.clientX509CertificateRootDN;
    }

    public void setClientX509CertificateRootDN(String string) {
        this.clientX509CertificateRootDN = string;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerifier;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("The hostname verifier must not be null");
        }
        defaultHostnameVerifier = hostnameVerifier;
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        return defaultSSLSocketFactory;
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        if (sSLSocketFactory == null) {
            throw new IllegalArgumentException("The SSL socket factory must not be null");
        }
        defaultSSLSocketFactory = sSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HttpURLConnection toHttpURLConnection(HostnameVerifier hostnameVerifier, SSLSocketFactory sSLSocketFactory) throws IOException {
        HostnameVerifier hostnameVerifier2 = this.getHostnameVerifier();
        SSLSocketFactory sSLSocketFactory2 = this.getSSLSocketFactory();
        try {
            this.setHostnameVerifier(hostnameVerifier);
            this.setSSLSocketFactory(sSLSocketFactory);
            HttpURLConnection httpURLConnection = this.toHttpURLConnection();
            return httpURLConnection;
        }
        finally {
            this.setHostnameVerifier(hostnameVerifier2);
            this.setSSLSocketFactory(sSLSocketFactory2);
        }
    }

    public HttpURLConnection toHttpURLConnection() throws IOException {
        Object object;
        Object object2;
        URL uRL = this.url;
        if (this.query != null && (this.method.equals((Object)Method.GET) || this.method.equals((Object)Method.DELETE))) {
            object2 = new StringBuilder(this.url.toString());
            ((StringBuilder)object2).append('?');
            ((StringBuilder)object2).append(this.query);
            try {
                uRL = new URL(((StringBuilder)object2).toString());
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException("Couldn't append query string: " + malformedURLException.getMessage(), malformedURLException);
            }
        }
        if (this.fragment != null) {
            object2 = new StringBuilder(uRL.toString());
            ((StringBuilder)object2).append('#');
            ((StringBuilder)object2).append(this.fragment);
            try {
                uRL = new URL(((StringBuilder)object2).toString());
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException("Couldn't append raw fragment: " + malformedURLException.getMessage(), malformedURLException);
            }
        }
        if ((object2 = (HttpURLConnection)(this.proxy == null ? uRL.openConnection() : uRL.openConnection(this.proxy))) instanceof HttpsURLConnection) {
            object = (HttpsURLConnection)object2;
            ((HttpsURLConnection)object).setHostnameVerifier(this.hostnameVerifier != null ? this.hostnameVerifier : HTTPRequest.getDefaultHostnameVerifier());
            ((HttpsURLConnection)object).setSSLSocketFactory(this.sslSocketFactory != null ? this.sslSocketFactory : HTTPRequest.getDefaultSSLSocketFactory());
        }
        for (Map.Entry entry : this.getHeaderMap().entrySet()) {
            for (String string : (List)entry.getValue()) {
                ((URLConnection)object2).addRequestProperty((String)entry.getKey(), string);
            }
        }
        ((HttpURLConnection)object2).setRequestMethod(this.method.name());
        ((URLConnection)object2).setConnectTimeout(this.connectTimeout);
        ((URLConnection)object2).setReadTimeout(this.readTimeout);
        ((HttpURLConnection)object2).setInstanceFollowRedirects(this.followRedirects);
        if (this.method.equals((Object)Method.POST) || this.method.equals((Object)Method.PUT)) {
            ((URLConnection)object2).setDoOutput(true);
            if (this.getEntityContentType() != null) {
                ((URLConnection)object2).setRequestProperty("Content-Type", this.getEntityContentType().toString());
            }
            if (this.query != null) {
                try {
                    object = new OutputStreamWriter(((URLConnection)object2).getOutputStream());
                    ((Writer)object).write(this.query);
                    ((OutputStreamWriter)object).close();
                }
                catch (IOException iOException) {
                    HTTPRequest.closeStreams((HttpURLConnection)object2);
                    throw iOException;
                }
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public HTTPResponse send(HostnameVerifier hostnameVerifier, SSLSocketFactory sSLSocketFactory) throws IOException {
        HostnameVerifier hostnameVerifier2 = this.getHostnameVerifier();
        SSLSocketFactory sSLSocketFactory2 = this.getSSLSocketFactory();
        try {
            this.setHostnameVerifier(hostnameVerifier);
            this.setSSLSocketFactory(sSLSocketFactory);
            HTTPResponse hTTPResponse = this.send();
            return hTTPResponse;
        }
        finally {
            this.setHostnameVerifier(hostnameVerifier2);
            this.setSSLSocketFactory(sSLSocketFactory2);
        }
    }

    public HTTPResponse send() throws IOException {
        Object object;
        int n2;
        BufferedReader bufferedReader;
        HttpURLConnection httpURLConnection = this.toHttpURLConnection();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));
            n2 = httpURLConnection.getResponseCode();
        }
        catch (IOException iOException) {
            n2 = httpURLConnection.getResponseCode();
            if (n2 == -1) {
                throw iOException;
            }
            object = httpURLConnection.getErrorStream();
            bufferedReader = object != null ? new BufferedReader(new InputStreamReader((InputStream)object)) : new BufferedReader(new StringReader(""));
        }
        StringBuilder stringBuilder = new StringBuilder();
        while ((object = bufferedReader.readLine()) != null) {
            stringBuilder.append((String)object);
            stringBuilder.append(System.getProperty("line.separator"));
        }
        bufferedReader.close();
        HTTPResponse hTTPResponse = new HTTPResponse(n2);
        hTTPResponse.setStatusMessage(httpURLConnection.getResponseMessage());
        for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
            List<String> list;
            if (entry.getKey() == null || (list = entry.getValue()) == null || list.isEmpty() || list.get(0) == null) continue;
            hTTPResponse.setHeader(entry.getKey(), list.toArray(new String[0]));
        }
        HTTPRequest.closeStreams(httpURLConnection);
        String string = stringBuilder.toString();
        if (!string.isEmpty()) {
            hTTPResponse.setContent(string);
        }
        return hTTPResponse;
    }

    private static void closeStreams(HttpURLConnection httpURLConnection) {
        if (httpURLConnection == null) {
            return;
        }
        try {
            if (httpURLConnection.getInputStream() != null) {
                httpURLConnection.getInputStream().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (httpURLConnection.getOutputStream() != null) {
                httpURLConnection.getOutputStream().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (httpURLConnection.getErrorStream() != null) {
                httpURLConnection.getOutputStream().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

