/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba;

import java.net.URI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.AuthRequestID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.CIBAPushCallback;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.Tokens;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class CIBATokenDelivery
extends CIBAPushCallback {
    private final Tokens tokens;

    public CIBATokenDelivery(URI uRI, BearerAccessToken bearerAccessToken, AuthRequestID authRequestID, Tokens tokens) {
        super(uRI, bearerAccessToken, authRequestID);
        if (tokens == null) {
            throw new IllegalArgumentException("The tokens must not be null");
        }
        this.tokens = tokens;
    }

    public CIBATokenDelivery(URI uRI, BearerAccessToken bearerAccessToken, AuthRequestID authRequestID, OIDCTokens oIDCTokens) {
        super(uRI, bearerAccessToken, authRequestID);
        if (oIDCTokens == null) {
            throw new IllegalArgumentException("The OpenID Connect tokens must not be null");
        }
        this.tokens = oIDCTokens;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    public Tokens getTokens() {
        return this.tokens;
    }

    public OIDCTokens getOIDCTokens() {
        return this.getTokens() instanceof OIDCTokens ? this.getTokens().toOIDCTokens() : null;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        hTTPRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_JSON);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("auth_req_id", this.getAuthRequestID().getValue());
        jSONObject.putAll(this.getTokens().toJSONObject());
        hTTPRequest.setQuery(jSONObject.toJSONString());
        return hTTPRequest;
    }

    public static CIBATokenDelivery parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI = hTTPRequest.getURI();
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_JSON);
        BearerAccessToken bearerAccessToken = BearerAccessToken.parse(hTTPRequest);
        AuthRequestID authRequestID = new AuthRequestID(JSONObjectUtils.getString(hTTPRequest.getQueryAsJSONObject(), "auth_req_id"));
        JSONObject jSONObject = hTTPRequest.getQueryAsJSONObject();
        if (jSONObject.get("id_token") != null) {
            return new CIBATokenDelivery(uRI, bearerAccessToken, authRequestID, OIDCTokens.parse(jSONObject));
        }
        return new CIBATokenDelivery(uRI, bearerAccessToken, authRequestID, Tokens.parse(jSONObject));
    }
}

