/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.CIBARequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.JWTID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimsSet;

public class CIBASignedRequestClaimsSet
extends ClaimsSet {
    public static final String REQUEST_CLAIM_NAME = "request";
    public static final String IAT_CLAIM_NAME = "iat";
    public static final String NBF_CLAIM_NAME = "nbf";
    public static final String EXP_CLAIM_NAME = "exp";
    public static final String JTI_CLAIM_NAME = "jti";
    private static final Set<String> STD_CLAIM_NAMES;

    public static Set<String> getStandardClaimNames() {
        return STD_CLAIM_NAMES;
    }

    public CIBASignedRequestClaimsSet(CIBARequest cIBARequest, Issuer issuer, Audience audience, Date date, Date date2, Date date3, JWTID jWTID) {
        if (cIBARequest.isSigned()) {
            throw new IllegalArgumentException("The CIBA request must be plain");
        }
        for (Map.Entry<String, Object> entry : cIBARequest.toJWTClaimsSet().getClaims().entrySet()) {
            this.setClaim(entry.getKey(), entry.getValue());
        }
        this.setIssuer(Objects.requireNonNull(issuer));
        this.setAudience(Objects.requireNonNull(audience));
        this.setDateClaim(IAT_CLAIM_NAME, Objects.requireNonNull(date));
        this.setDateClaim(NBF_CLAIM_NAME, Objects.requireNonNull(date2));
        this.setDateClaim(EXP_CLAIM_NAME, Objects.requireNonNull(date3));
        this.setClaim(JTI_CLAIM_NAME, jWTID.getValue());
    }

    static {
        HashSet<String> hashSet = new HashSet<String>(ClaimsSet.getStandardClaimNames());
        hashSet.add(REQUEST_CLAIM_NAME);
        hashSet.add("iss");
        hashSet.add("aud");
        hashSet.add(IAT_CLAIM_NAME);
        hashSet.add(NBF_CLAIM_NAME);
        hashSet.add(EXP_CLAIM_NAME);
        hashSet.add(JTI_CLAIM_NAME);
        STD_CLAIM_NAMES = Collections.unmodifiableSet(hashSet);
    }
}

