/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.util.Date;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SuccessResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.TokenIntrospectionResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.X509CertificateConfirmation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.JWTID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class TokenIntrospectionSuccessResponse
extends TokenIntrospectionResponse
implements SuccessResponse {
    private final JSONObject params;

    public TokenIntrospectionSuccessResponse(JSONObject jSONObject) {
        if (!(jSONObject.get("active") instanceof Boolean)) {
            throw new IllegalArgumentException("Missing / invalid boolean active parameter");
        }
        this.params = jSONObject;
    }

    public boolean isActive() {
        try {
            return JSONObjectUtils.getBoolean(this.params, "active", false);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public Scope getScope() {
        try {
            return Scope.parse(JSONObjectUtils.getString(this.params, "scope"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public ClientID getClientID() {
        try {
            return new ClientID(JSONObjectUtils.getString(this.params, "client_id"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String getUsername() {
        try {
            return JSONObjectUtils.getString(this.params, "username", null);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public AccessTokenType getTokenType() {
        try {
            return new AccessTokenType(JSONObjectUtils.getString(this.params, "token_type"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Date getExpirationTime() {
        try {
            return DateUtils.fromSecondsSinceEpoch(JSONObjectUtils.getLong(this.params, "exp"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Date getIssueTime() {
        try {
            return DateUtils.fromSecondsSinceEpoch(JSONObjectUtils.getLong(this.params, "iat"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Date getNotBeforeTime() {
        try {
            return DateUtils.fromSecondsSinceEpoch(JSONObjectUtils.getLong(this.params, "nbf"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Subject getSubject() {
        try {
            return new Subject(JSONObjectUtils.getString(this.params, "sub"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public List<Audience> getAudience() {
        try {
            return Audience.create(JSONObjectUtils.getStringList(this.params, "aud"));
        }
        catch (ParseException parseException) {
            try {
                return new Audience(JSONObjectUtils.getString(this.params, "aud")).toSingleAudienceList();
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
    }

    public Issuer getIssuer() {
        try {
            return new Issuer(JSONObjectUtils.getString(this.params, "iss"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public JWTID getJWTID() {
        try {
            return new JWTID(JSONObjectUtils.getString(this.params, "jti"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Deprecated
    public Base64URL getX509CertificateSHA256Thumbprint() {
        try {
            JSONObject jSONObject = JSONObjectUtils.getJSONObject(this.params, "cnf", null);
            if (jSONObject == null) {
                return null;
            }
            String string = JSONObjectUtils.getString(jSONObject, "x5t#S256", null);
            if (string == null) {
                return null;
            }
            return new Base64URL(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public X509CertificateConfirmation getX509CertificateConfirmation() {
        return X509CertificateConfirmation.parse(this.params);
    }

    public JWKThumbprintConfirmation getJWKThumbprintConfirmation() {
        return JWKThumbprintConfirmation.parse(this.params);
    }

    public String getStringParameter(String string) {
        try {
            return JSONObjectUtils.getString(this.params, string, null);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public boolean getBooleanParameter(String string) throws ParseException {
        return JSONObjectUtils.getBoolean(this.params, string);
    }

    public Number getNumberParameter(String string) {
        try {
            return JSONObjectUtils.getNumber(this.params, string, null);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public List<String> getStringListParameter(String string) {
        try {
            return JSONObjectUtils.getStringList(this.params, string, null);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public JSONObject getJSONObjectParameter(String string) {
        try {
            return JSONObjectUtils.getJSONObject(this.params, string, null);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public JSONObject getParameters() {
        return this.params;
    }

    public JSONObject toJSONObject() {
        return new JSONObject(this.params);
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = new HTTPResponse(200);
        hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
        hTTPResponse.setContent(this.params.toJSONString());
        return hTTPResponse;
    }

    public static TokenIntrospectionSuccessResponse parse(JSONObject jSONObject) throws ParseException {
        try {
            return new TokenIntrospectionSuccessResponse(jSONObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public static TokenIntrospectionSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCode(200);
        JSONObject jSONObject = hTTPResponse.getContentAsJSONObject();
        return TokenIntrospectionSuccessResponse.parse(jSONObject);
    }

    public static class Builder {
        private final JSONObject params = new JSONObject();

        public Builder(boolean bl2) {
            this.params.put("active", bl2);
        }

        public Builder(TokenIntrospectionSuccessResponse tokenIntrospectionSuccessResponse) {
            this.params.putAll(tokenIntrospectionSuccessResponse.params);
        }

        public Builder scope(Scope scope) {
            if (scope != null) {
                this.params.put("scope", scope.toString());
            } else {
                this.params.remove("scope");
            }
            return this;
        }

        public Builder clientID(ClientID clientID) {
            if (clientID != null) {
                this.params.put("client_id", clientID.getValue());
            } else {
                this.params.remove("client_id");
            }
            return this;
        }

        public Builder username(String string) {
            if (string != null) {
                this.params.put("username", string);
            } else {
                this.params.remove("username");
            }
            return this;
        }

        public Builder tokenType(AccessTokenType accessTokenType) {
            if (accessTokenType != null) {
                this.params.put("token_type", accessTokenType.getValue());
            } else {
                this.params.remove("token_type");
            }
            return this;
        }

        public Builder expirationTime(Date date) {
            if (date != null) {
                this.params.put("exp", DateUtils.toSecondsSinceEpoch(date));
            } else {
                this.params.remove("exp");
            }
            return this;
        }

        public Builder issueTime(Date date) {
            if (date != null) {
                this.params.put("iat", DateUtils.toSecondsSinceEpoch(date));
            } else {
                this.params.remove("iat");
            }
            return this;
        }

        public Builder notBeforeTime(Date date) {
            if (date != null) {
                this.params.put("nbf", DateUtils.toSecondsSinceEpoch(date));
            } else {
                this.params.remove("nbf");
            }
            return this;
        }

        public Builder subject(Subject subject) {
            if (subject != null) {
                this.params.put("sub", subject.getValue());
            } else {
                this.params.remove("sub");
            }
            return this;
        }

        public Builder audience(List<Audience> list) {
            if (list != null) {
                this.params.put("aud", Audience.toStringList(list));
            } else {
                this.params.remove("aud");
            }
            return this;
        }

        public Builder issuer(Issuer issuer) {
            if (issuer != null) {
                this.params.put("iss", issuer.getValue());
            } else {
                this.params.remove("iss");
            }
            return this;
        }

        public Builder jwtID(JWTID jWTID) {
            if (jWTID != null) {
                this.params.put("jti", jWTID.getValue());
            } else {
                this.params.remove("jti");
            }
            return this;
        }

        @Deprecated
        public Builder x509CertificateSHA256Thumbprint(Base64URL base64URL) {
            if (base64URL != null) {
                JSONObject jSONObject;
                if (this.params.containsKey("cnf")) {
                    jSONObject = (JSONObject)this.params.get("cnf");
                } else {
                    jSONObject = new JSONObject();
                    this.params.put("cnf", jSONObject);
                }
                jSONObject.put("x5t#S256", base64URL.toString());
            } else if (this.params.containsKey("cnf")) {
                JSONObject jSONObject = (JSONObject)this.params.get("cnf");
                jSONObject.remove("x5t#S256");
                if (jSONObject.isEmpty()) {
                    this.params.remove("cnf");
                }
            }
            return this;
        }

        public Builder x509CertificateConfirmation(X509CertificateConfirmation x509CertificateConfirmation) {
            if (x509CertificateConfirmation != null) {
                Map.Entry<String, JSONObject> entry = x509CertificateConfirmation.toJWTClaim();
                this.params.put(entry.getKey(), entry.getValue());
            } else {
                this.params.remove("cnf");
            }
            return this;
        }

        public Builder jwkThumbprintConfirmation(JWKThumbprintConfirmation jWKThumbprintConfirmation) {
            if (jWKThumbprintConfirmation != null) {
                Map.Entry<String, JSONObject> entry = jWKThumbprintConfirmation.toJWTClaim();
                this.params.put(entry.getKey(), entry.getValue());
            } else {
                this.params.remove("cnf");
            }
            return this;
        }

        public Builder parameter(String string, Object object) {
            if (object != null) {
                this.params.put(string, object);
            } else {
                this.params.remove(string);
            }
            return this;
        }

        public TokenIntrospectionSuccessResponse build() {
            return new TokenIntrospectionSuccessResponse(this.params);
        }
    }
}

