/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.PlainObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.EncryptedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AssertionGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GrantType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class JWTBearerGrant
extends AssertionGrant {
    public static final GrantType GRANT_TYPE = GrantType.JWT_BEARER;
    private static final String PLAIN_ASSERTION_REJECTED_MESSAGE = "The JWT assertion must not be unsecured (plain)";
    private static final String JWT_PARSE_MESSAGE = "The assertion is not a JWT";
    private static final ParseException PLAIN_ASSERTION_REJECTED_EXCEPTION = new ParseException("The JWT assertion must not be unsecured (plain)", OAuth2Error.INVALID_REQUEST.appendDescription(": The JWT assertion must not be unsecured (plain)"));
    private static final ParseException JWT_PARSE_EXCEPTION = new ParseException("The assertion is not a JWT", OAuth2Error.INVALID_REQUEST.appendDescription(": The assertion is not a JWT"));
    private final JOSEObject assertion;

    public JWTBearerGrant(SignedJWT signedJWT) {
        super(GRANT_TYPE);
        if (signedJWT.getState().equals((Object)JWSObject.State.UNSIGNED)) {
            throw new IllegalArgumentException("The JWT assertion must not be in a unsigned state");
        }
        this.assertion = signedJWT;
    }

    public JWTBearerGrant(JWEObject jWEObject) {
        super(GRANT_TYPE);
        if (jWEObject.getState().equals((Object)JWEObject.State.UNENCRYPTED)) {
            throw new IllegalArgumentException("The JWT assertion must not be in a unencrypted state");
        }
        this.assertion = jWEObject;
    }

    public JWTBearerGrant(EncryptedJWT encryptedJWT) {
        this((JWEObject)encryptedJWT);
    }

    public JWT getJWTAssertion() {
        return this.assertion instanceof JWT ? (JWT)((Object)this.assertion) : null;
    }

    public JOSEObject getJOSEAssertion() {
        return this.assertion;
    }

    @Override
    public String getAssertion() {
        return this.assertion.serialize();
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("grant_type", Collections.singletonList(GRANT_TYPE.getValue()));
        linkedHashMap.put("assertion", Collections.singletonList(this.assertion.serialize()));
        return linkedHashMap;
    }

    public static JWTBearerGrant parse(Map<String, List<String>> map) throws ParseException {
        GrantType.ensure(GRANT_TYPE, map);
        String string = MultivaluedMapUtils.getFirstValue(map, "assertion");
        if (string == null || string.trim().isEmpty()) {
            throw MISSING_ASSERTION_PARAM_EXCEPTION;
        }
        try {
            JOSEObject jOSEObject = JOSEObject.parse(string);
            if (jOSEObject instanceof PlainObject) {
                throw PLAIN_ASSERTION_REJECTED_EXCEPTION;
            }
            if (jOSEObject instanceof JWSObject) {
                return new JWTBearerGrant(new SignedJWT(jOSEObject.getParsedParts()[0], jOSEObject.getParsedParts()[1], jOSEObject.getParsedParts()[2]));
            }
            if ("JWT".equalsIgnoreCase(jOSEObject.getHeader().getContentType())) {
                return new JWTBearerGrant((JWEObject)jOSEObject);
            }
            return new JWTBearerGrant(new EncryptedJWT(jOSEObject.getParsedParts()[0], jOSEObject.getParsedParts()[1], jOSEObject.getParsedParts()[2], jOSEObject.getParsedParts()[3], jOSEObject.getParsedParts()[4]));
        }
        catch (java.text.ParseException parseException) {
            throw JWT_PARSE_EXCEPTION;
        }
    }
}

